/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.contacts.ContactsEntry;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.application.ResourceMap;

public class ContactsEntryTableModel
extends DefaultTableModel {
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_LASTNAME = 1;
    public static final int COLUMN_FIRSTNAME = 2;
    public static final int COLUMN_COMPANY = 3;
    public static final int COLUMN_STREET = 4;
    public static final int COLUMN_CITY = 5;
    public static final int COLUMN_MAIL = 6;
    public static final int COLUMN_PHONE = 7;
    public static final int COLUMN_MOBILE_PHONE = 8;
    public static final int COLUMN_DAY_OF_BIRTH = 9;
    public static final int COLUMN_GROUP = 10;
    public static final int COLUMN_STATUS = 11;
    public static final int COLUMN_CONTACT_ALLOWED = 12;
    private static final Map<Integer, String> COLUMN_NAMES = new HashMap<Integer, String>();
    private static final Map<Integer, Class> COLUMN_CLASSES;
    private final ResourceMap resourceMap;
    private final Map<Long, Long> groupIds = new HashMap<Long, Long>();

    public ContactsEntryTableModel() {
        this.resourceMap = ImmoToolUtils.getResourceMap(ContactsEntryTableModel.class);
        this.setColumnCount(COLUMN_NAMES.size());
    }

    public void addContactsEntry(ContactsEntry.Row row, String string) {
        this.addRow(this.buildRow(row, string));
        this.groupIds.put(row.id, row.group);
    }

    private Object[] buildRow(ContactsEntry.Row row, String string) {
        TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
        treeMap.put(0, row.id);
        treeMap.put(10, string);
        treeMap.put(5, row.writeAdressLine2WithCountry());
        treeMap.put(4, row.writeAdressLine1());
        treeMap.put(2, row.firstName);
        treeMap.put(1, row.lastName);
        treeMap.put(3, row.company);
        treeMap.put(7, row.phone);
        treeMap.put(8, row.mobilePhone);
        treeMap.put(6, row.mail);
        treeMap.put(9, row.dayOfBirth);
        treeMap.put(11, ContactsEntry.writeStatus(row.status));
        treeMap.put(12, row.contactAllowed);
        return treeMap.values().toArray(new Object[treeMap.size()]);
    }

    public void clear() {
        this.groupIds.clear();
        while (this.getRowCount() > 0) {
            this.removeRow(0);
        }
    }

    public Class getColumnClass(int n) {
        return COLUMN_CLASSES.containsKey(n) ? COLUMN_CLASSES.get(n) : null;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES.containsKey(n) ? this.resourceMap.getString(COLUMN_NAMES.get(n), new Object[0]) : null;
    }

    public Long getEntryIdAt(int n) {
        int n2 = n;
        return (Long)this.getValueAt(n2, 0);
    }

    public Long getGroupIdAt(int n) {
        return this.groupIds.get(this.getEntryIdAt(n));
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void setContactEntryAt(int n, ContactsEntry.Row row, String string) {
        Object[] objectArray = this.buildRow(row, string);
        for (int i = 0; i < objectArray.length; ++i) {
            this.setValueAt(objectArray[i], n, i);
        }
    }

    static {
        COLUMN_NAMES.put(0, "col.id");
        COLUMN_NAMES.put(10, "col.group");
        COLUMN_NAMES.put(1, "col.lastName");
        COLUMN_NAMES.put(2, "col.firstName");
        COLUMN_NAMES.put(3, "col.company");
        COLUMN_NAMES.put(4, "col.street");
        COLUMN_NAMES.put(5, "col.city");
        COLUMN_NAMES.put(6, "col.mail");
        COLUMN_NAMES.put(7, "col.phone");
        COLUMN_NAMES.put(8, "col.mobilePhone");
        COLUMN_NAMES.put(9, "col.dayOfBirth");
        COLUMN_NAMES.put(11, "col.status");
        COLUMN_NAMES.put(12, "col.contactAllowed");
        COLUMN_CLASSES = new HashMap<Integer, Class>();
        COLUMN_CLASSES.put(0, Long.class);
        COLUMN_CLASSES.put(10, String.class);
        COLUMN_CLASSES.put(1, String.class);
        COLUMN_CLASSES.put(2, String.class);
        COLUMN_CLASSES.put(3, String.class);
        COLUMN_CLASSES.put(4, String.class);
        COLUMN_CLASSES.put(5, String.class);
        COLUMN_CLASSES.put(6, String.class);
        COLUMN_CLASSES.put(7, String.class);
        COLUMN_CLASSES.put(8, String.class);
        COLUMN_CLASSES.put(9, Date.class);
        COLUMN_CLASSES.put(11, String.class);
        COLUMN_CLASSES.put(12, Boolean.class);
    }
}

