/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.openindex.openestate.tool.ImmoToolDbException;
import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolTabPanel;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolTaskDialog;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.contacts.ContactsEntry;
import com.openindex.openestate.tool.contacts.ContactsEntryExportCsvTask;
import com.openindex.openestate.tool.contacts.ContactsEntryExportDialog;
import com.openindex.openestate.tool.contacts.ContactsEntryExportVcardTask;
import com.openindex.openestate.tool.contacts.ContactsEntryExportXlsTask;
import com.openindex.openestate.tool.contacts.ContactsEntryTableModel;
import com.openindex.openestate.tool.contacts.ContactsEntryViewPanel;
import com.openindex.openestate.tool.contacts.ContactsGroup;
import com.openindex.openestate.tool.contacts.ContactsGroupItem;
import com.openindex.openestate.tool.contacts.ContactsPlugin;
import com.openindex.openestate.tool.contacts.ContactsPluginUtils;
import com.openindex.openestate.tool.utils.QuickTableExport;
import com.openindex.openestate.tool.utils.TabComponent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableModel;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledSeparator;
import org.xmldb.api.base.Collection;

public class ContactsEntryTablePanel
extends ImmoToolTabPanel {
    private static final Logger LOGGER = Logger.getLogger(ContactsEntryTablePanel.class);
    private ActionMap actionMap;
    private ResourceMap resourceMap;
    private JPopupMenu actionsMenu;
    private ContactsEntryTableModel resultTableModel;
    private JFormattedTextField idField;
    private JTextField adressField;
    private JTextField personNameField;
    private JTextField companyNameField;
    private JTextField contactField;
    private JComboBox groupBox;
    private JComboBox statusBox;
    private JMenu actionGroupMenu;
    private JMenu actionStatusMenu;
    private boolean isSearching = false;
    private JButton actionButton;
    private JButton addButton;
    private JButton closeButton;
    private JPanel formPanel;
    private JButton helpButton;
    private JXTitledSeparator resultLabel;
    private JXTable resultTable;
    private JScrollPane resultTableScroller;
    private JButton searchButton;
    private JXTitledSeparator titleLabel;

    public ContactsEntryTablePanel() {
        this.build();
    }

    private void build() {
        this.actionMap = ImmoToolUtils.getActionMap(ContactsEntryTablePanel.class, (Object)((Object)this));
        this.resourceMap = ImmoToolUtils.getResourceMap(ContactsEntryTablePanel.class);
        this.initComponents();
        this.buildFormPanel();
        this.resourceMap.injectComponents((Component)((Object)this));
        this.actionsMenu = new JPopupMenu();
        this.actionsMenu.add(new JMenuItem(this.actionMap.get("doView")));
        this.actionsMenu.add(new JMenuItem(this.actionMap.get("doRemove")));
        this.actionsMenu.add(new JMenuItem(this.actionMap.get("doExport")));
        this.actionsMenu.addSeparator();
        this.actionGroupMenu = new JMenu();
        this.actionGroupMenu.setName("actionGroupMenu");
        this.resourceMap.injectComponent((Component)this.actionGroupMenu);
        this.actionsMenu.add(this.actionGroupMenu);
        this.actionStatusMenu = new JMenu();
        this.actionStatusMenu.setName("actionStatusMenu");
        this.resourceMap.injectComponent((Component)this.actionStatusMenu);
        this.actionsMenu.add(this.actionStatusMenu);
        JMenuItem jMenuItem = new JMenuItem(ContactsEntry.writeStatus("active"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImmoToolTask immoToolTask = (ImmoToolTask)ContactsEntryTablePanel.this.doChangeStatus("active");
                if (immoToolTask == null) {
                    return;
                }
                ImmoToolTaskDialog immoToolTaskDialog = new ImmoToolTaskDialog();
                immoToolTaskDialog.addTask(immoToolTask);
                immoToolTaskDialog.execute();
            }
        });
        this.actionStatusMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(ContactsEntry.writeStatus("inactive"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImmoToolTask immoToolTask = (ImmoToolTask)ContactsEntryTablePanel.this.doChangeStatus("inactive");
                if (immoToolTask == null) {
                    return;
                }
                ImmoToolTaskDialog immoToolTaskDialog = new ImmoToolTaskDialog();
                immoToolTaskDialog.addTask(immoToolTask);
                immoToolTaskDialog.execute();
            }
        });
        this.actionStatusMenu.add(jMenuItem);
        this.resultTableModel = new ContactsEntryTableModel();
        this.resultTable.setModel((TableModel)this.resultTableModel);
        this.resultTable.setSortable(true);
        this.resultTable.getSelectionModel().setSelectionMode(2);
        this.resultTable.getColumn(0).setMaxWidth(75);
        this.resultTable.getColumnExt(12).setVisible(false);
        this.resultTable.getColumnExt(9).setVisible(false);
        this.resultTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                    ContactsEntryTablePanel.this.doView();
                } else if (mouseEvent.getButton() == 3 && mouseEvent.getClickCount() == 1) {
                    if (ContactsEntryTablePanel.this.resultTable.getSelectedRow() < 0) {
                        int n = ContactsEntryTablePanel.this.resultTable.rowAtPoint(mouseEvent.getPoint());
                        if (n < 0) {
                            return;
                        }
                        ContactsEntryTablePanel.this.resultTable.getSelectionModel().setSelectionInterval(n, n);
                    }
                    ContactsEntryTablePanel.this.actionsMenu.show((Component)ContactsEntryTablePanel.this.resultTable, ((ContactsEntryTablePanel)ContactsEntryTablePanel.this).resultTable.getMousePosition().x, ((ContactsEntryTablePanel)ContactsEntryTablePanel.this).resultTable.getMousePosition().y);
                }
            }
        });
        this.resultTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ContactsEntryTablePanel.this.actionButton.setEnabled(ContactsEntryTablePanel.this.resultTable.getSelectedRow() >= 0);
            }
        });
        this.resultTable.setColumnControl((JComponent)QuickTableExport.createColumnControl((JXTable)this.resultTable));
        ImmoToolUtils.configureTable((JXTable)this.resultTable);
        this.searchButton.setAction(this.actionMap.get(this.searchButton.getText()));
        this.addButton.setAction(this.actionMap.get(this.addButton.getText()));
        this.closeButton.setAction(this.actionMap.get(this.closeButton.getText()));
        this.helpButton.setAction(this.actionMap.get(this.helpButton.getText()));
        this.actionButton.setAction(this.actionMap.get(this.actionButton.getText()));
        this.actionButton.setEnabled(false);
    }

    private void buildFormPanel() {
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10 && !ContactsEntryTablePanel.this.isSearching) {
                    ImmoToolUtils.executeTask((Task)ContactsEntryTablePanel.this.doSearch());
                }
            }
        };
        this.idField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.idField.setName("idField");
        this.idField.addKeyListener(keyAdapter);
        this.idField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!ContactsEntryTablePanel.this.idField.isEditValid()) {
                    ContactsEntryTablePanel.this.idField.setValue(null);
                }
            }
        });
        this.statusBox = new JComboBox();
        this.statusBox.setName("statusBox");
        this.statusBox.setRenderer(new StatusRenderer());
        this.statusBox.addItem(null);
        this.statusBox.addItem("active");
        this.statusBox.addItem("inactive");
        this.statusBox.setSelectedItem("active");
        this.groupBox = new JComboBox();
        this.groupBox.setName("groupBox");
        this.adressField = new JTextField();
        this.adressField.setName("adressField");
        this.adressField.addKeyListener(keyAdapter);
        this.personNameField = new JTextField();
        this.personNameField.setName("personNameField");
        this.personNameField.addKeyListener(keyAdapter);
        this.companyNameField = new JTextField();
        this.companyNameField.setName("companyNameField");
        this.companyNameField.addKeyListener(keyAdapter);
        this.contactField = new JTextField();
        this.contactField.setName("contactField");
        this.contactField.addKeyListener(keyAdapter);
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:pref, 3dlu, 20dlu, 3dlu, right:pref, 3dlu, 20dlu:grow, 3dlu, right:pref, 3dlu, 20dlu:grow, 3dlu, right:pref, 3dlu, 10dlu:grow", (JPanel)this.formPanel);
        defaultFormBuilder.append(this.resourceMap.getString("label.id", new Object[0]), (Component)this.idField);
        defaultFormBuilder.append(this.resourceMap.getString("label.company", new Object[0]), (Component)this.companyNameField);
        defaultFormBuilder.append(this.resourceMap.getString("label.person", new Object[0]), (Component)this.personNameField);
        defaultFormBuilder.append(this.resourceMap.getString("label.status", new Object[0]), (Component)this.statusBox);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(" ", (Component)new JLabel(" "));
        defaultFormBuilder.append(this.resourceMap.getString("label.adress", new Object[0]), (Component)this.adressField);
        defaultFormBuilder.append(this.resourceMap.getString("label.contact", new Object[0]), (Component)this.contactField);
        defaultFormBuilder.append(this.resourceMap.getString("label.group", new Object[0]), (Component)this.groupBox);
        defaultFormBuilder.nextLine();
        this.formPanel.revalidate();
        this.formPanel.repaint();
    }

    @Action
    public void doAction() {
        this.actionsMenu.show(this.actionButton, 0, this.actionButton.getSize().height);
    }

    @Action
    public Task doAdd() {
        String string = ContactsEntryViewPanel.getInstanceTabTitle(0L);
        if (ImmoToolUtils.selectPanel((String)string)) {
            return null;
        }
        this.setButtonsEnabled(false);
        return new ImmoToolTask<ContactsEntryViewPanel>(){

            protected ContactsEntryViewPanel executeTask() throws Exception {
                ContactsEntryViewPanel contactsEntryViewPanel = new ContactsEntryViewPanel();
                contactsEntryViewPanel.setContact(null);
                return contactsEntryViewPanel;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)ContactsEntryTablePanel.this.resourceMap.getString("error.cantCreateContactForm", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                ContactsEntryTablePanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(ContactsEntryViewPanel contactsEntryViewPanel) {
                super.succeeded((Object)contactsEntryViewPanel);
                contactsEntryViewPanel.executeFormTasks();
                ImmoToolUtils.showPanel((TabComponent)contactsEntryViewPanel);
            }
        };
    }

    public Task doChangeGroup(final long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("invalid group-id!");
        }
        if (this.resultTable.getSelectedRowCount() < 1) {
            return null;
        }
        boolean bl = ImmoToolUtils.showQuestionDialog((String)this.resourceMap.getString("question.reallyChangeGroup", new Object[]{this.resultTable.getSelectedRowCount()}), (Component)((Object)this));
        if (!bl) {
            return null;
        }
        final ArrayList<Long[]> arrayList = new ArrayList<Long[]>();
        for (int n : this.resultTable.getSelectedRows()) {
            int n2 = this.resultTable.convertRowIndexToModel(n);
            long l2 = this.resultTableModel.getGroupIdAt(n2);
            long l3 = this.resultTableModel.getEntryIdAt(n2);
            arrayList.add(new Long[]{l2, l3});
        }
        this.setButtonsEnabled(false);
        return new ImmoToolTask<Integer>(this.actionGroupMenu.getText()){

            protected Integer executeTask() throws Exception {
                int n = 0;
                for (Long[] longArray : arrayList) {
                    if (longArray[0] == l) continue;
                    this.setMessage("#" + longArray[1]);
                    ContactsEntry contactsEntry = ContactsEntry.load(longArray[0], longArray[1]);
                    if (contactsEntry == null) {
                        throw new Exception("Can't load entry #" + longArray[1] + " from group #" + longArray[0]);
                    }
                    contactsEntry.remove();
                    contactsEntry.setGroupId(l);
                    contactsEntry.save();
                    ++n;
                }
                return n;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)ContactsEntryTablePanel.this.resourceMap.getString("error.cantChangeGroup", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                ContactsEntryTablePanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(Integer n) {
                super.succeeded((Object)n);
                ImmoToolUtils.executeTask((Task)ContactsEntryTablePanel.this.doSearch());
            }
        };
    }

    public Task doChangeStatus(final String string) {
        if (string == null) {
            throw new IllegalArgumentException("invalid status!");
        }
        if (this.resultTable.getSelectedRowCount() < 1) {
            return null;
        }
        boolean bl = ImmoToolUtils.showQuestionDialog((String)this.resourceMap.getString("question.reallyChangeStatus", new Object[]{this.resultTable.getSelectedRowCount()}), (Component)((Object)this));
        if (!bl) {
            return null;
        }
        final ArrayList<Long[]> arrayList = new ArrayList<Long[]>();
        for (int n : this.resultTable.getSelectedRows()) {
            int n2 = this.resultTable.convertRowIndexToModel(n);
            long l = this.resultTableModel.getGroupIdAt(n2);
            long l2 = this.resultTableModel.getEntryIdAt(n2);
            arrayList.add(new Long[]{l, l2});
        }
        this.setButtonsEnabled(false);
        return new ImmoToolTask<Integer>(this.actionStatusMenu.getText()){

            protected Integer executeTask() throws Exception {
                int n = 0;
                for (Long[] longArray : arrayList) {
                    this.setMessage("#" + longArray[1]);
                    ContactsEntry contactsEntry = ContactsEntry.load(longArray[0], longArray[1]);
                    if (contactsEntry == null) {
                        throw new Exception("Can't load entry #" + longArray[1] + " from group #" + longArray[0]);
                    }
                    contactsEntry.setStatus(string);
                    contactsEntry.save();
                    ++n;
                }
                return n;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)ContactsEntryTablePanel.this.resourceMap.getString("error.cantChangeStatus", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                ContactsEntryTablePanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(Integer n) {
                super.succeeded((Object)n);
                ImmoToolUtils.executeTask((Task)ContactsEntryTablePanel.this.doSearch());
            }
        };
    }

    @Action
    public void doClose() {
        ImmoToolUtils.removePanel((String)this.getTabTitle());
    }

    @Action
    public Task doExport() {
        if (this.resultTable.getSelectedRowCount() < 1) {
            return null;
        }
        File file = ContactsPlugin.getLastExportLocation();
        final ArrayList<Long[]> arrayList = new ArrayList<Long[]>();
        for (int bl2 : this.resultTable.getSelectedRows()) {
            int charset = this.resultTable.convertRowIndexToModel(bl2);
            long jFileChooser = this.resultTableModel.getGroupIdAt(charset);
            long n3 = this.resultTableModel.getEntryIdAt(charset);
            arrayList.add(new Long[]{jFileChooser, n3});
        }
        Object object = new ContactsEntryExportDialog();
        ((ContactsEntryExportDialog)object).setGroupSelectionVisible(false);
        ((Dialog)object).setVisible(true);
        if (((ContactsEntryExportDialog)object).getStatus() != 2) {
            return null;
        }
        int n = ((ContactsEntryExportDialog)object).isCsvSelected() ? 1 : 0;
        int n2 = ((ContactsEntryExportDialog)object).isXlsSelected() ? 1 : 0;
        boolean bl = ((ContactsEntryExportDialog)object).isVCardSelected();
        Charset charset = ((ContactsEntryExportDialog)object).getSelectedCharset();
        if (!(n || n2 || bl)) {
            LOGGER.error((Object)"invalid export-format!");
            return null;
        }
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(this.resourceMap.getString("label.export", new Object[0]));
        jFileChooser.setApproveButtonText(this.resourceMap.getString("label.export.approve", new Object[0]));
        String string = null;
        if (n) {
            string = this.resourceMap.getString("label.export.csvFile", new Object[]{System.currentTimeMillis()});
        } else if (bl) {
            string = this.resourceMap.getString("label.export.vcardFile", new Object[]{System.currentTimeMillis()});
        } else if (n2) {
            string = this.resourceMap.getString("label.export.xlsFile", new Object[]{System.currentTimeMillis()});
        }
        if (file == null) {
            jFileChooser.setSelectedFile(new File(string));
        } else {
            jFileChooser.setSelectedFile(new File(file.getAbsolutePath() + File.separator + string));
        }
        jFileChooser.setFileFilter(new FileFilter(n != 0, n2 != 0, bl){
            final /* synthetic */ boolean val$exportAsCsv;
            final /* synthetic */ boolean val$exportAsXls;
            final /* synthetic */ boolean val$exportAsVCard;
            {
                this.val$exportAsCsv = bl;
                this.val$exportAsXls = bl2;
                this.val$exportAsVCard = bl3;
            }

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || this.val$exportAsCsv && file.getName().toLowerCase().endsWith(".csv") || this.val$exportAsXls && file.getName().toLowerCase().endsWith(".xls") || this.val$exportAsVCard && file.getName().toLowerCase().endsWith(".vcf") || this.val$exportAsVCard && file.getName().toLowerCase().endsWith(".vcard");
            }

            @Override
            public String getDescription() {
                if (this.val$exportAsCsv) {
                    return ContactsEntryTablePanel.this.resourceMap.getString("label.filter.csv", new Object[]{"*.csv"});
                }
                if (this.val$exportAsXls) {
                    return ContactsEntryTablePanel.this.resourceMap.getString("label.filter.xls", new Object[]{"*.xls"});
                }
                if (this.val$exportAsVCard) {
                    return ContactsEntryTablePanel.this.resourceMap.getString("label.filter.vcard", new Object[]{"*.vcf, *.vcard"});
                }
                return null;
            }
        });
        int n3 = jFileChooser.showSaveDialog((Component)((Object)this));
        if (n3 != 0) {
            return null;
        }
        final File file2 = jFileChooser.getSelectedFile();
        ContactsPlugin.setLastExportLocation(file2.getAbsoluteFile().getParentFile());
        Object object2 = null;
        if (n) {
            object2 = new ContactsEntryExportCsvTask(file2, charset){

                @Override
                protected ContactsEntry[] loadCsvObjects() throws ImmoToolException {
                    return ContactsEntryTablePanel.loadContacts(arrayList);
                }

                protected void failed(Throwable throwable) {
                    super.failed(throwable);
                    ImmoToolUtils.showMessageErrorDialog((String)ContactsEntryTablePanel.this.resourceMap.getString("error.cantExportFile", new Object[0]), (Throwable)throwable);
                }

                protected void succeeded(Long l) {
                    super.succeeded((Object)l);
                    ImmoToolUtils.showMessageInfoDialog((String)ContactsEntryTablePanel.this.resourceMap.getString("message.exportSuccessful", new Object[]{arrayList.size(), file2.getAbsolutePath()}));
                }
            };
        } else if (n2) {
            object2 = new ContactsEntryExportXlsTask(file2, charset){

                @Override
                protected ContactsEntry[] loadXlsObjects() throws ImmoToolException {
                    return ContactsEntryTablePanel.loadContacts(arrayList);
                }

                protected void failed(Throwable throwable) {
                    super.failed(throwable);
                    ImmoToolUtils.showMessageErrorDialog((String)ContactsEntryTablePanel.this.resourceMap.getString("error.cantExportFile", new Object[0]), (Throwable)throwable);
                }

                protected void succeeded(Long l) {
                    super.succeeded((Object)l);
                    ImmoToolUtils.showMessageInfoDialog((String)ContactsEntryTablePanel.this.resourceMap.getString("message.exportSuccessful", new Object[]{arrayList.size(), file2.getAbsolutePath()}));
                }
            };
        } else if (bl) {
            object2 = new ContactsEntryExportVcardTask(file2, charset){

                @Override
                protected ContactsEntry[] loadContacts() throws ImmoToolException {
                    return ContactsEntryTablePanel.loadContacts(arrayList);
                }

                protected void failed(Throwable throwable) {
                    super.failed(throwable);
                    ImmoToolUtils.showMessageErrorDialog((String)ContactsEntryTablePanel.this.resourceMap.getString("error.cantExportFile", new Object[0]), (Throwable)throwable);
                }

                protected void succeeded(Long l) {
                    super.succeeded((Object)l);
                    ImmoToolUtils.showMessageInfoDialog((String)ContactsEntryTablePanel.this.resourceMap.getString("message.exportSuccessful", new Object[]{arrayList.size(), file2.getAbsolutePath()}));
                }
            };
        }
        return object2;
    }

    @Action
    public void doHelp() {
        ImmoToolUtils.showHelpDialog((String)"contacts.entries");
    }

    @Action
    public Task doSearch() {
        this.resultTableModel.clear();
        this.resultTable.setEnabled(false);
        this.setButtonsEnabled(false);
        return new ImmoToolTask<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Boolean executeTask() throws Exception {
                Collection collection = null;
                try {
                    Serializable serializable;
                    ContactsEntry.Row[] rowArray;
                    String string;
                    String string2;
                    String string3;
                    String string4;
                    Object object;
                    Serializable serializable2;
                    Long[] longArray = null;
                    if (ContactsEntryTablePanel.this.groupBox.getSelectedIndex() > 0) {
                        serializable2 = Long.valueOf(((ContactsGroupItem)ContactsEntryTablePanel.this.groupBox.getSelectedItem()).getGroupId());
                        longArray = new Long[]{serializable2};
                    }
                    serializable2 = new ArrayList();
                    Long[] longArray2 = null;
                    if (ContactsEntryTablePanel.this.idField.getValue() != null && ContactsEntryTablePanel.this.idField.isEditValid()) {
                        object = Long.valueOf(ContactsEntryTablePanel.this.idField.getValue().toString());
                        longArray2 = new Long[]{object};
                    }
                    if (((String)(object = ContactsEntryTablePanel.this.personNameField.getText().trim())).trim().length() > 0) {
                        ((ArrayList)serializable2).add("(contains(upper-case($x/@PersonFirstName),upper-case('" + StringEscapeUtils.escapeSql((String)object) + "')) " + "or contains(upper-case($x/@" + "PersonLastName" + "),upper-case('" + StringEscapeUtils.escapeSql((String)object) + "')) " + ")");
                    }
                    if ((string4 = ContactsEntryTablePanel.this.adressField.getText().trim()).trim().length() > 0) {
                        ((ArrayList)serializable2).add("(contains(upper-case($x/@Street),upper-case('" + StringEscapeUtils.escapeSql((String)string4) + "')) " + "or contains(upper-case($x/@" + "StreetNr" + "),upper-case('" + StringEscapeUtils.escapeSql((String)string4) + "')) " + ")");
                    }
                    if ((string3 = ContactsEntryTablePanel.this.companyNameField.getText().trim()).trim().length() > 0) {
                        ((ArrayList)serializable2).add("contains(upper-case($x/@CompanyName),upper-case('" + StringEscapeUtils.escapeSql((String)string3) + "'))");
                    }
                    if ((string2 = ContactsEntryTablePanel.this.contactField.getText().trim()).trim().length() > 0) {
                        ((ArrayList)serializable2).add("(contains(upper-case($x/@PersonFax),upper-case('" + StringEscapeUtils.escapeSql((String)string2) + "')) " + "or contains(upper-case($x/@" + "PersonMail" + "),upper-case('" + StringEscapeUtils.escapeSql((String)string2) + "')) " + "or contains(upper-case($x/@" + "PersonMobilePhone" + "),upper-case('" + StringEscapeUtils.escapeSql((String)string2) + "')) " + "or contains(upper-case($x/@" + "PersonPhone" + "),upper-case('" + StringEscapeUtils.escapeSql((String)string2) + "')) " + "or contains(upper-case($x/@" + "CompanyFax" + "),upper-case('" + StringEscapeUtils.escapeSql((String)string2) + "')) " + "or contains(upper-case($x/@" + "CompanyMail" + "),upper-case('" + StringEscapeUtils.escapeSql((String)string2) + "')) " + "or contains(upper-case($x/@" + "CompanyMobilePhone" + "),upper-case('" + StringEscapeUtils.escapeSql((String)string2) + "')) " + "or contains(upper-case($x/@" + "CompanyPhone" + "),upper-case('" + StringEscapeUtils.escapeSql((String)string2) + "')) " + ")");
                    }
                    if ("active".equals(string = (String)ContactsEntryTablePanel.this.statusBox.getSelectedItem())) {
                        ((ArrayList)serializable2).add("not($status) or $status='active'");
                    } else if ("inactive".equals(string)) {
                        ((ArrayList)serializable2).add("$status='inactive'");
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    if (!((ArrayList)serializable2).isEmpty()) {
                        for (int i = 0; i < ((ArrayList)serializable2).size(); ++i) {
                            if (i > 0) {
                                stringBuilder.append(" and ");
                            }
                            stringBuilder.append("(").append((String)((ArrayList)serializable2).get(i)).append(")");
                        }
                    }
                    if ((rowArray = ContactsEntry.loadRows(longArray2, longArray, stringBuilder.toString(), null)) != null && rowArray.length > 0) {
                        collection = ContactsPluginUtils.openPluginCollection("");
                        serializable = new HashMap();
                        for (ContactsEntry.Row row : rowArray) {
                            String string5 = null;
                            if (row.group <= 0L) {
                                string5 = ContactsEntryTablePanel.this.resourceMap.getString("label.unknown", new Object[0]);
                            } else if (serializable.containsKey(row.group)) {
                                string5 = (String)serializable.get(row.group);
                            } else {
                                ContactsGroup contactsGroup = ContactsGroup.load(row.group, collection);
                                string5 = contactsGroup.getName();
                                serializable.put(contactsGroup.getId(), string5);
                            }
                            ContactsEntryTablePanel.this.resultTableModel.addContactsEntry(row, string5);
                        }
                    }
                    serializable = Boolean.valueOf(true);
                    return serializable;
                }
                finally {
                    ImmoToolDbUtils.close(collection);
                }
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)ContactsEntryTablePanel.this.resourceMap.getString("error.cantSearchContacts", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                ContactsEntryTablePanel.this.resultTable.setEnabled(true);
                ContactsEntryTablePanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(Boolean bl) {
                super.succeeded((Object)bl);
                ContactsEntryTablePanel.this.resultLabel.setTitle(ContactsEntryTablePanel.this.resourceMap.getString("resultLabel.title", new Object[0]) + " / " + ContactsEntryTablePanel.this.resourceMap.getString("message.resultCount", new Object[]{NumberFormat.getIntegerInstance().format(ContactsEntryTablePanel.this.resultTable.getRowCount())}));
                ContactsEntryTablePanel.this.resultTable.packAll();
            }
        };
    }

    @Action
    public Task doRemove() {
        if (this.resultTable.getSelectedRowCount() < 1) {
            return null;
        }
        boolean bl = ImmoToolUtils.showQuestionDialog((String)this.resourceMap.getString("question.reallyDeleteContacts", new Object[]{this.resultTable.getSelectedRowCount()}), (Component)((Object)this));
        if (!bl) {
            return null;
        }
        final ArrayList<Long[]> arrayList = new ArrayList<Long[]>();
        for (int n : this.resultTable.getSelectedRows()) {
            int n2 = this.resultTable.convertRowIndexToModel(n);
            long l = this.resultTableModel.getGroupIdAt(n2);
            long l2 = this.resultTableModel.getEntryIdAt(n2);
            arrayList.add(new Long[]{l, l2});
        }
        this.setButtonsEnabled(false);
        return new ImmoToolTask<Boolean>(){

            protected Boolean executeTask() throws Exception {
                for (Long[] longArray : arrayList) {
                    ContactsEntry contactsEntry = ContactsEntry.load(longArray[0], longArray[1]);
                    if (contactsEntry == null) {
                        throw new Exception("could not load entry #" + longArray[1] + " from group #" + longArray[0]);
                    }
                    contactsEntry.remove();
                }
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)ContactsEntryTablePanel.this.resourceMap.getString("error.cantRemoveContacts", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                ContactsEntryTablePanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(Boolean bl) {
                super.succeeded((Object)bl);
                ImmoToolUtils.executeTask((Task)ContactsEntryTablePanel.this.doSearch());
            }
        };
    }

    @Action
    public void doView() {
        int n;
        int n2;
        if (this.resultTable.getSelectedRowCount() < 1) {
            return;
        }
        int n3 = n2 = this.resultTable.getSelectedRowCount() < 10 ? this.resultTable.getSelectedRowCount() : 10;
        if (n2 > 1 && (n = ImmoToolUtils.showQuestionDialog((String)this.resourceMap.getString("question.openMultipleObjects", new Object[]{n2}), (Component)((Object)this))) == 0) {
            return;
        }
        n = 0;
        for (int n4 : this.resultTable.getSelectedRows()) {
            int n5 = this.resultTable.convertRowIndexToModel(n4);
            final long l = this.resultTableModel.getGroupIdAt(n5);
            final long l2 = this.resultTableModel.getEntryIdAt(n5);
            String string = ContactsEntryViewPanel.getInstanceTabTitle(l2);
            if (n2 == 1 && ImmoToolUtils.selectPanel((String)string)) {
                return;
            }
            if (n2 > 1 && ImmoToolUtils.hasPanel((String)string)) continue;
            ImmoToolTask<ContactsEntryViewPanel> immoToolTask = new ImmoToolTask<ContactsEntryViewPanel>(){

                protected ContactsEntryViewPanel executeTask() throws Exception {
                    ContactsEntry contactsEntry = ContactsEntry.load(l, l2);
                    if (contactsEntry == null) {
                        throw new Exception("could not load entry #" + l2 + " from group #" + l);
                    }
                    ContactsEntryViewPanel contactsEntryViewPanel = new ContactsEntryViewPanel();
                    contactsEntryViewPanel.setContact(contactsEntry);
                    ImmoToolUtils.showPanel((TabComponent)contactsEntryViewPanel, (n2 == 1 ? 1 : 0) != 0);
                    return contactsEntryViewPanel;
                }

                protected void failed(Throwable throwable) {
                    super.failed(throwable);
                    ImmoToolUtils.showMessageErrorDialog((String)ContactsEntryTablePanel.this.resourceMap.getString("error.cantCreateContactForm", new Object[0]), (Throwable)throwable);
                }

                protected void succeeded(ContactsEntryViewPanel contactsEntryViewPanel) {
                    super.succeeded((Object)contactsEntryViewPanel);
                    if (contactsEntryViewPanel != null) {
                        contactsEntryViewPanel.executeFormTasks();
                    }
                }
            };
            ImmoToolUtils.executeTask((Task)immoToolTask);
            if (++n >= 10) break;
        }
    }

    public static String getInstanceTabTitle() {
        return ImmoToolUtils.getResourceMap(ContactsEntryTablePanel.class).getString("tabTitle", new Object[0]);
    }

    public String getTabInfo() {
        return this.resourceMap.getString("tabInfo", new Object[0]);
    }

    public String getTabTitle() {
        return ContactsEntryTablePanel.getInstanceTabTitle();
    }

    private static ContactsEntry[] loadContacts(List<Long[]> list) {
        ArrayList<ContactsEntry> arrayList = new ArrayList<ContactsEntry>();
        for (Long[] longArray : list) {
            try {
                arrayList.add(ContactsEntry.load(longArray[0], longArray[1]));
            }
            catch (Exception exception) {
                LOGGER.warn((Object)("Can't load contact #" + longArray[1] + " from group #" + longArray[0]));
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
        return arrayList.toArray(new ContactsEntry[arrayList.size()]);
    }

    public void loadGroups() throws ImmoToolDbException {
        this.groupBox.setSelectedIndex(-1);
        this.groupBox.removeAllItems();
        this.groupBox.addItem(" [ " + this.resourceMap.getString("label.group.all", new Object[0]) + " ] ");
        ContactsGroupItem.load(this.groupBox);
        this.actionGroupMenu.removeAll();
        for (int i = 1; i < this.groupBox.getItemCount(); ++i) {
            final ContactsGroupItem contactsGroupItem = (ContactsGroupItem)this.groupBox.getItemAt(i);
            JMenuItem jMenuItem = new JMenuItem(contactsGroupItem.getGroupName());
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ImmoToolTask immoToolTask = (ImmoToolTask)ContactsEntryTablePanel.this.doChangeGroup(contactsGroupItem.getGroupId());
                    if (immoToolTask == null) {
                        return;
                    }
                    ImmoToolTaskDialog immoToolTaskDialog = new ImmoToolTaskDialog();
                    immoToolTaskDialog.addTask(immoToolTask);
                    immoToolTaskDialog.execute();
                }
            });
            this.actionGroupMenu.add(jMenuItem);
        }
    }

    public void refreshTab() {
        ImmoToolUtils.executeTask((Task)this.doSearch());
    }

    private void setButtonsEnabled(boolean bl) {
        this.addButton.setEnabled(bl);
        this.searchButton.setEnabled(bl);
        if (!bl) {
            this.actionButton.setEnabled(false);
        } else {
            this.actionButton.setEnabled(this.resultTable.getSelectedRow() >= 0);
        }
    }

    private void initComponents() {
        this.titleLabel = ImmoToolUtils.createHead1Separator((String)"");
        this.searchButton = new JButton();
        this.addButton = new JButton();
        this.actionButton = new JButton();
        this.helpButton = new JButton();
        this.closeButton = new JButton();
        this.formPanel = new JPanel();
        this.resultLabel = ImmoToolUtils.createHead2Separator((String)"");
        this.resultTableScroller = new JScrollPane();
        this.resultTable = new JXTable();
        this.setName("Form");
        this.titleLabel.setName("titleLabel");
        this.titleLabel.setTitle("titleLabel");
        this.searchButton.setText("doSearch");
        this.searchButton.setName("searchButton");
        this.addButton.setText("doAdd");
        this.addButton.setName("addButton");
        this.actionButton.setText("doAction");
        this.actionButton.setName("actionButton");
        this.helpButton.setText("doHelp");
        this.helpButton.setName("helpButton");
        this.closeButton.setText("doClose");
        this.closeButton.setName("closeButton");
        this.formPanel.setName("formPanel");
        GroupLayout groupLayout = new GroupLayout(this.formPanel);
        this.formPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 706, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 41, Short.MAX_VALUE));
        this.resultLabel.setName("resultLabel");
        this.resultLabel.setTitle("resultLabel");
        this.resultTableScroller.setName("resultTableScroller");
        this.resultTable.setColumnControlVisible(true);
        this.resultTable.setName("resultTable");
        this.resultTableScroller.setViewportView((Component)this.resultTable);
        GroupLayout groupLayout2 = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.resultLabel, -1, 706, Short.MAX_VALUE).addComponent(this.formPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addComponent((Component)this.titleLabel, -1, 219, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.searchButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.actionButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.helpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton)).addComponent(this.resultTableScroller, -1, 706, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeButton).addComponent(this.helpButton).addComponent(this.actionButton).addComponent(this.addButton).addComponent(this.searchButton)).addComponent((Component)this.titleLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.formPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.resultLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resultTableScroller, -1, 274, Short.MAX_VALUE).addContainerGap()));
    }

    private final class StatusRenderer
    extends JLabel
    implements ListCellRenderer {
        public StatusRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof String) {
                this.setText(" " + ContactsEntry.writeStatus((String)object));
            } else {
                this.setText(" [ " + ContactsEntryTablePanel.this.resourceMap.getString("label.status.all", new Object[0]) + " ]");
            }
            return this;
        }
    }
}

