/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import com.openindex.openestate.impl.CompanyAdressImpl;
import com.openindex.openestate.impl.SimpleAdressImpl;
import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolTabPanel;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.contacts.ContactsEntry;
import com.openindex.openestate.tool.contacts.ContactsEntryExportVcardTask;
import com.openindex.openestate.tool.contacts.ContactsEntryViewAddonPanel;
import com.openindex.openestate.tool.contacts.ContactsGroupItem;
import com.openindex.openestate.tool.contacts.ContactsPlugin;
import com.openindex.openestate.tool.contacts.ContactsPluginUtils;
import com.openindex.openestate.tool.utils.JAdressPanel;
import com.openindex.openestate.tool.utils.ModificationHandler;
import com.openindex.openestate.tool.utils.NonEmptyComboBoxRule;
import com.openindex.openestate.tool.utils.ValidationHandler;
import com.openindex.openestate.tool.utils.ValidationRule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Printable;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.fife.ui.rtextarea.RTextArea;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.application.TaskEvent;
import org.jdesktop.application.TaskListener;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTitledSeparator;
import org.w3c.dom.Node;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.modules.XMLResource;

public class ContactsEntryViewPanel
extends ImmoToolTabPanel {
    private static final Logger LOGGER = Logger.getLogger(ContactsEntryViewPanel.class);
    private ActionMap actionMap;
    private ResourceMap resourceMap;
    private AdressPanel adressPanel;
    private DetailsPanel detailsPanel;
    private NotesPanel notesPanel;
    private JPopupMenu contactActionMenu;
    private List<ContactsEntryViewAddonPanel> entryAddonPanels;
    private long contactId = 0L;
    private long groupId = 0L;
    private String contactInfo = null;
    private long nextContactId = 0L;
    private long nextGroupId = 0L;
    private long prevContactId = 0L;
    private long prevGroupId = 0L;
    private JButton actionButton;
    private JButton closeButton;
    private JButton helpButton;
    private JButton nextButton;
    private JButton prevButton;
    private JButton submitButton;
    private JTabbedPane tabPanel;
    private JXTitledSeparator titleLabel;

    public ContactsEntryViewPanel() {
        this.build();
    }

    private void build() {
        this.actionMap = ImmoToolUtils.getActionMap(ContactsEntryViewPanel.class, (Object)((Object)this));
        this.resourceMap = ImmoToolUtils.getResourceMap(ContactsEntryViewPanel.class);
        this.initComponents();
        this.resourceMap.injectComponents((Component)((Object)this));
        this.adressPanel = new AdressPanel();
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.adressPanel));
        jScrollPane.setBorder(Borders.EMPTY);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(20);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.tabPanel.addTab(this.adressPanel.getTitle(), jScrollPane);
        this.resourceMap.injectComponents((Component)((Object)this.adressPanel));
        this.detailsPanel = new DetailsPanel();
        JScrollPane jScrollPane2 = new JScrollPane((Component)((Object)this.detailsPanel));
        jScrollPane2.setBorder(Borders.EMPTY);
        jScrollPane2.getHorizontalScrollBar().setUnitIncrement(20);
        jScrollPane2.getVerticalScrollBar().setUnitIncrement(20);
        this.tabPanel.addTab(this.detailsPanel.getTitle(), jScrollPane2);
        this.resourceMap.injectComponents((Component)((Object)this.detailsPanel));
        this.entryAddonPanels = new ArrayList<ContactsEntryViewAddonPanel>();
        try {
            for (ContactsEntryViewAddonPanel contactsEntryViewAddonPanel : ContactsEntryViewAddonPanel.getUsablePanels()) {
                this.entryAddonPanels.add(contactsEntryViewAddonPanel);
                this.tabPanel.addTab(contactsEntryViewAddonPanel.getTitle(), (Component)((Object)contactsEntryViewAddonPanel));
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"could not load addon-panels!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        this.notesPanel = new NotesPanel();
        this.tabPanel.addTab(this.notesPanel.getTitle(), (Component)((Object)this.notesPanel));
        this.resourceMap.injectComponents((Component)((Object)this.notesPanel));
        for (int i = 0; i < this.tabPanel.getTabCount(); ++i) {
            Component component = this.tabPanel.getComponentAt(i);
            if (component instanceof JScrollPane) {
                component = ((JScrollPane)component).getViewport().getView();
            }
            if (!(component instanceof ContactsEntryViewAddonPanel)) continue;
            this.tabPanel.setEnabledAt(i, false);
        }
        this.contactActionMenu = new JPopupMenu();
        this.contactActionMenu.setName("contactActionMenu");
        this.contactActionMenu.add(new JMenuItem(this.actionMap.get("doCopy")));
        this.contactActionMenu.add(new JMenuItem(this.actionMap.get("doRemove")));
        this.contactActionMenu.addSeparator();
        this.contactActionMenu.add(new JMenuItem(this.actionMap.get("doSaveVcard")));
        this.contactActionMenu.add(new JMenuItem(this.actionMap.get("doPrintNotes")));
        this.resourceMap.injectComponents((Component)this.contactActionMenu);
        this.getActionMap().put("doViewNext", this.actionMap.get("doViewNext"));
        this.getInputMap().put(KeyStroke.getKeyStroke("alt pressed PAGE_UP"), "doViewNext");
        this.getInputMap().put(KeyStroke.getKeyStroke("ctrl pressed RIGHT"), "doViewNext");
        this.getActionMap().put("doViewPrevious", this.actionMap.get("doViewPrevious"));
        this.getInputMap().put(KeyStroke.getKeyStroke("alt pressed PAGE_DOWN"), "doViewPrevious");
        this.getInputMap().put(KeyStroke.getKeyStroke("ctrl pressed LEFT"), "doViewPrevious");
        this.setButtonsEnabled(true);
        if (SystemUtils.IS_OS_MAC_OSX) {
            this.tabPanel.setTabPlacement(1);
        }
    }

    public void executeFormTasks() {
        for (int i = 0; i < this.tabPanel.getTabCount(); ++i) {
            ContactsEntryViewAddonPanel contactsEntryViewAddonPanel;
            Component component = this.tabPanel.getComponentAt(i);
            if (component instanceof JScrollPane) {
                component = ((JScrollPane)component).getViewport().getView();
            }
            if (!(component instanceof ContactsEntryViewAddonPanel) || !(contactsEntryViewAddonPanel = (ContactsEntryViewAddonPanel)((Object)component)).isLoadedInBackground()) continue;
            Task task = contactsEntryViewAddonPanel.doLoadInBackground();
            if (task == null) {
                this.tabPanel.setEnabledAt(i, contactsEntryViewAddonPanel.isFormEnabled());
                continue;
            }
            final int n = i;
            task.addTaskListener(new TaskListener(){

                public void doInBackground(TaskEvent taskEvent) {
                }

                public void process(TaskEvent taskEvent) {
                }

                public void succeeded(TaskEvent taskEvent) {
                    ContactsEntryViewPanel.this.tabPanel.setEnabledAt(n, contactsEntryViewAddonPanel.isFormEnabled());
                }

                public void failed(TaskEvent taskEvent) {
                }

                public void cancelled(TaskEvent taskEvent) {
                }

                public void interrupted(TaskEvent taskEvent) {
                }

                public void finished(TaskEvent taskEvent) {
                }
            });
            ImmoToolUtils.executeTask((Task)task);
        }
    }

    public static String getInstanceTabTitle(long l) {
        return l > 0L ? ImmoToolUtils.getResourceMap(ContactsEntryViewPanel.class).getString("tabTitle.edit", new Object[]{l}) : ImmoToolUtils.getResourceMap(ContactsEntryViewPanel.class).getString("tabTitle.new", new Object[0]);
    }

    public String getTabInfo() {
        if (this.contactId <= 0L) {
            return this.resourceMap.getString("tabInfo.new", new Object[0]);
        }
        return this.contactInfo;
    }

    public String getTabTitle() {
        return ContactsEntryViewPanel.getInstanceTabTitle(this.contactId);
    }

    public boolean isTabModified() {
        for (int i = 0; i < this.tabPanel.getTabCount(); ++i) {
            ContactsEntryViewAddonPanel contactsEntryViewAddonPanel;
            Component component = this.tabPanel.getComponentAt(i);
            if (component instanceof JScrollPane) {
                component = ((JScrollPane)component).getViewport().getView();
            }
            if (!(component instanceof ContactsEntryViewAddonPanel) || !(contactsEntryViewAddonPanel = (ContactsEntryViewAddonPanel)((Object)component)).isFormModified()) continue;
            return true;
        }
        return false;
    }

    public void refreshTab() {
        if (this.groupId <= 0L || this.contactId <= 0L) {
            return;
        }
        ImmoToolTask<Boolean> immoToolTask = new ImmoToolTask<Boolean>(){

            protected Boolean executeTask() throws Exception {
                ContactsEntryViewPanel.this.setContact(ContactsEntry.load(ContactsEntryViewPanel.this.groupId, ContactsEntryViewPanel.this.contactId));
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)ContactsEntryViewPanel.this.resourceMap.getString("error.cantRefresh", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                ContactsEntryViewPanel.this.setButtonsEnabled(true);
                ContactsEntryViewPanel.this.executeFormTasks();
            }
        };
        this.setButtonsEnabled(false);
        ImmoToolUtils.executeTask((Task)immoToolTask);
    }

    public ImmoToolTask saveModifications() {
        return (ImmoToolTask)this.doSubmit();
    }

    private void setButtonsEnabled(boolean bl) {
        this.submitButton.setEnabled(bl);
        this.closeButton.setEnabled(bl);
        this.actionButton.setEnabled(bl && this.contactId > 0L && this.groupId > 0L);
        this.nextButton.setEnabled(bl && this.contactId > 0L && this.groupId > 0L && this.nextContactId > 0L && this.nextGroupId > 0L);
        this.prevButton.setEnabled(bl && this.contactId > 0L && this.groupId > 0L && this.prevContactId > 0L && this.prevGroupId > 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContact(ContactsEntry contactsEntry) {
        ContactsEntryViewAddonPanel contactsEntryViewAddonPanel;
        this.nextContactId = 0L;
        this.nextGroupId = 0L;
        this.prevContactId = 0L;
        this.prevGroupId = 0L;
        this.contactId = contactsEntry != null ? contactsEntry.getId() : 0L;
        this.groupId = contactsEntry != null ? contactsEntry.getGroupId() : 0L;
        this.actionButton.setEnabled(contactsEntry != null);
        this.contactInfo = contactsEntry != null ? contactsEntry.getPersonAdress().writePersonFullName() + "<br>" + contactsEntry.getAdress().writeFullAdress("<br>") : null;
        for (int i = 0; i < this.tabPanel.getTabCount(); ++i) {
            Component component = this.tabPanel.getComponentAt(i);
            if (component instanceof JScrollPane) {
                component = ((JScrollPane)component).getViewport().getView();
            }
            if (!(component instanceof ContactsEntryViewAddonPanel)) continue;
            contactsEntryViewAddonPanel = (ContactsEntryViewAddonPanel)((Object)component);
            try {
                contactsEntryViewAddonPanel.load(contactsEntry);
                contactsEntryViewAddonPanel.getValidationHandler().init();
                this.tabPanel.setTitleAt(i, contactsEntryViewAddonPanel.getTitle());
                this.tabPanel.setEnabledAt(i, contactsEntryViewAddonPanel.isFormEnabled() && !contactsEntryViewAddonPanel.isLoadedInBackground());
                continue;
            }
            catch (Exception exception) {
                LOGGER.error((Object)"Can't load contact-form!");
                LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                this.tabPanel.setEnabledAt(i, false);
            }
        }
        if (this.groupId > 0L && this.contactId > 0L) {
            long l = this.contactId;
            contactsEntryViewAddonPanel = null;
            try {
                contactsEntryViewAddonPanel = ContactsPluginUtils.openPluginCollection("");
                String string = "declare namespace util=\"http://exist-db.org/xquery/util\";\ndeclare namespace openestate=\"http://www.openestate.org/1.0/\";\nfor $x in collection('ImmoTool/OpenEstate-Contacts')/openestate:CompanyAdress\nreturn <row doc=\"{util:document-name($x)}\" col=\"{util:collection-name($x)}\" />";
                ResourceSet resourceSet = ImmoToolDbUtils.executeXQuery((Collection)contactsEntryViewAddonPanel, (String)string);
                for (long i = 0L; i < resourceSet.getSize(); ++i) {
                    try {
                        XMLResource xMLResource = (XMLResource)resourceSet.getResource(i);
                        Node node = xMLResource.getContentAsDOM();
                        String[] stringArray = node.getAttributes().getNamedItem("col").getNodeValue().split("/");
                        String[] stringArray2 = node.getAttributes().getNamedItem("doc").getNodeValue().split("\\.");
                        Long l2 = Long.valueOf(stringArray2[1]);
                        if (l2 > l && (l2 < this.nextContactId || this.nextContactId <= 0L)) {
                            this.nextContactId = l2;
                            this.nextGroupId = Long.valueOf(stringArray[stringArray.length - 1]);
                        }
                        if (l2 >= l || l2 <= this.prevContactId && this.prevContactId > 0L) continue;
                        this.prevContactId = l2;
                        this.prevGroupId = Long.valueOf(stringArray[stringArray.length - 1]);
                        continue;
                    }
                    catch (Exception exception) {
                        LOGGER.warn((Object)"Can't extract id!");
                        LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    }
                }
            }
            catch (Exception exception) {
                this.nextContactId = 0L;
                this.nextGroupId = 0L;
                this.prevContactId = 0L;
                this.prevGroupId = 0L;
                LOGGER.warn((Object)"Can't load previous and next entry!");
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
            finally {
                ImmoToolDbUtils.close((Collection)contactsEntryViewAddonPanel);
            }
        }
        ImmoToolUtils.updateTabs();
        this.titleLabel.setTitle(this.getTabTitle());
        this.setButtonsEnabled(true);
    }

    private void initComponents() {
        this.titleLabel = ImmoToolUtils.createHead1Separator((String)"");
        this.prevButton = new JButton();
        this.nextButton = new JButton();
        this.submitButton = new JButton();
        this.actionButton = new JButton();
        this.helpButton = new JButton();
        this.closeButton = new JButton();
        this.tabPanel = new JTabbedPane();
        this.setName("Form");
        this.titleLabel.setName("titleLabel");
        ApplicationActionMap applicationActionMap = Application.getInstance().getContext().getActionMap(ContactsEntryViewPanel.class, (Object)this);
        this.prevButton.setAction(applicationActionMap.get("doViewPrevious"));
        this.prevButton.setName("prevButton");
        this.nextButton.setAction(applicationActionMap.get("doViewNext"));
        this.nextButton.setName("nextButton");
        this.submitButton.setAction(applicationActionMap.get("doSubmit"));
        this.submitButton.setName("submitButton");
        this.actionButton.setAction(applicationActionMap.get("doAction"));
        this.actionButton.setName("actionButton");
        this.helpButton.setAction(applicationActionMap.get("doHelp"));
        this.helpButton.setName("helpButton");
        this.closeButton.setAction(applicationActionMap.get("doClose"));
        this.closeButton.setName("closeButton");
        this.tabPanel.setTabPlacement(2);
        this.tabPanel.setName("tabPanel");
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.tabPanel, -1, 812, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent((Component)this.titleLabel, -1, 468, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.prevButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nextButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.submitButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.actionButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.helpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeButton).addComponent(this.helpButton).addComponent(this.actionButton).addComponent(this.submitButton).addComponent(this.nextButton).addComponent(this.prevButton)).addComponent((Component)this.titleLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tabPanel, -1, 382, Short.MAX_VALUE).addContainerGap()));
        ResourceMap resourceMap = Application.getInstance().getContext().getResourceMap(ContactsEntryViewPanel.class);
        resourceMap.injectComponents((Component)((Object)this));
    }

    @Action
    public void doAction() {
        this.contactActionMenu.show(this.actionButton, 0, this.actionButton.getSize().height);
    }

    @Action
    public void doClose() {
        ImmoToolUtils.removePanel((String)this.getTabTitle());
    }

    @Action
    public Task doCopy() {
        if (this.groupId <= 0L || this.contactId <= 0L) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.tabPanel.getTabCount(); ++i) {
            Component component = this.tabPanel.getComponentAt(i);
            if (component instanceof JScrollPane) {
                component = ((JScrollPane)component).getViewport().getView();
            }
            if (!(component instanceof ContactsEntryViewAddonPanel)) continue;
            ContactsEntryViewAddonPanel contactsEntryViewAddonPanel = (ContactsEntryViewAddonPanel)((Object)component);
            contactsEntryViewAddonPanel.validateForm();
            if (contactsEntryViewAddonPanel.isFormValid()) continue;
            arrayList.add(this.resourceMap.getString("error.invalidTab", new Object[]{contactsEntryViewAddonPanel.getTitle()}));
        }
        if (!arrayList.isEmpty()) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.invalidInput", new Object[0]), arrayList);
            return null;
        }
        this.setButtonsEnabled(false);
        return new ImmoToolTask<ContactsEntry>(this.resourceMap.getString("doCopy.Action.text", new Object[0])){

            protected ContactsEntry executeTask() throws Exception {
                ContactsEntryViewAddonPanel contactsEntryViewAddonPanel;
                Component component;
                int n;
                ContactsEntry contactsEntry = ContactsEntry.load(ContactsEntryViewPanel.this.groupId, ContactsEntryViewPanel.this.contactId);
                if (contactsEntry == null) {
                    throw new Exception("contact #" + ContactsEntryViewPanel.this.contactId + " in group #" + ContactsEntryViewPanel.this.groupId + " not found");
                }
                contactsEntry.setId(0L);
                for (n = 0; n < ContactsEntryViewPanel.this.tabPanel.getTabCount(); ++n) {
                    component = ContactsEntryViewPanel.this.tabPanel.getComponentAt(n);
                    if (component instanceof JScrollPane) {
                        component = ((JScrollPane)component).getViewport().getView();
                    }
                    if (!(component instanceof ContactsEntryViewAddonPanel)) continue;
                    contactsEntryViewAddonPanel = (ContactsEntryViewAddonPanel)((Object)component);
                    contactsEntryViewAddonPanel.save(contactsEntry);
                }
                contactsEntry.save();
                if (ContactsEntryViewPanel.this.groupId > 0L && ContactsEntryViewPanel.this.contactId > 0L && contactsEntry.getGroupId() != ContactsEntryViewPanel.this.groupId) {
                    ContactsEntry contactsEntry2 = ContactsEntry.load(ContactsEntryViewPanel.this.groupId, ContactsEntryViewPanel.this.contactId);
                    contactsEntry2.remove();
                }
                for (n = 0; n < ContactsEntryViewPanel.this.tabPanel.getTabCount(); ++n) {
                    component = ContactsEntryViewPanel.this.tabPanel.getComponentAt(n);
                    if (component instanceof JScrollPane) {
                        component = ((JScrollPane)component).getViewport().getView();
                    }
                    if (!(component instanceof ContactsEntryViewAddonPanel)) continue;
                    contactsEntryViewAddonPanel = (ContactsEntryViewAddonPanel)((Object)component);
                    contactsEntryViewAddonPanel.saveFinished(contactsEntry);
                }
                ContactsEntryViewPanel.this.setContact(contactsEntry);
                return contactsEntry;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)ContactsEntryViewPanel.this.resourceMap.getString("error.cantSaveContact", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                ContactsEntryViewPanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(ContactsEntry contactsEntry) {
                super.succeeded((Object)contactsEntry);
                ContactsEntryViewPanel.this.executeFormTasks();
                ImmoToolUtils.updateTabs();
            }
        };
    }

    @Action
    public void doHelp() {
        ImmoToolUtils.showHelpDialog((String)"contacts.entries.form");
    }

    @Action
    public void doPrintNotes() {
        try {
            ImmoToolUtils.print((Printable)this.notesPanel.notesField);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Printing failed!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)"Printing failed!", (Throwable)exception);
        }
    }

    @Action
    public Task doRemove() {
        if (this.groupId <= 0L || this.contactId <= 0L) {
            return null;
        }
        if (!ImmoToolUtils.showQuestionDialog((String)this.resourceMap.getString("question.reallyDeleteContact", new Object[0]))) {
            return null;
        }
        this.setButtonsEnabled(false);
        return new ImmoToolTask<Boolean>(this.resourceMap.getString("doRemove.Action.text", new Object[0])){

            protected Boolean executeTask() throws Exception {
                ContactsEntry contactsEntry = ContactsEntry.load(ContactsEntryViewPanel.this.groupId, ContactsEntryViewPanel.this.contactId);
                if (contactsEntry == null) {
                    throw new Exception("could not load entry #" + ContactsEntryViewPanel.this.contactId + " from group #" + ContactsEntryViewPanel.this.groupId);
                }
                contactsEntry.remove();
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)ContactsEntryViewPanel.this.resourceMap.getString("error.cantRemoveContacts", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                ContactsEntryViewPanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(Boolean bl) {
                super.succeeded((Object)bl);
                if (Boolean.TRUE.equals(bl)) {
                    ImmoToolUtils.removePanel((String)ContactsEntryViewPanel.this.getTabTitle(), (boolean)true);
                }
            }
        };
    }

    @Action
    public Task doSaveVcard() {
        if (this.groupId <= 0L || this.contactId <= 0L) {
            return null;
        }
        File file = ContactsPlugin.getLastExportLocation();
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(this.resourceMap.getString("label.export", new Object[0]));
        jFileChooser.setApproveButtonText(this.resourceMap.getString("label.export.approve", new Object[0]));
        String string = this.resourceMap.getString("label.export.vcardFile", new Object[]{System.currentTimeMillis()});
        if (file == null) {
            jFileChooser.setSelectedFile(new File(string));
        } else {
            jFileChooser.setSelectedFile(new File(file.getAbsolutePath() + File.separator + string));
        }
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(".vcf") || file.getName().toLowerCase().endsWith(".vcard");
            }

            @Override
            public String getDescription() {
                return ContactsEntryViewPanel.this.resourceMap.getString("label.filter.vcard", new Object[]{"*.vcf, *.vcard"});
            }
        });
        int n = jFileChooser.showSaveDialog((Component)((Object)this));
        if (n != 0) {
            return null;
        }
        final File file2 = jFileChooser.getSelectedFile();
        ContactsPlugin.setLastExportLocation(file2.getAbsoluteFile().getParentFile());
        return new ContactsEntryExportVcardTask(file2, Charset.defaultCharset()){

            @Override
            protected ContactsEntry[] loadContacts() throws ImmoToolException {
                return new ContactsEntry[]{ContactsEntry.load(ContactsEntryViewPanel.this.groupId, ContactsEntryViewPanel.this.contactId)};
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)ContactsEntryViewPanel.this.resourceMap.getString("error.cantExportFile", new Object[0]), (Throwable)throwable);
            }

            protected void succeeded(Long l) {
                super.succeeded((Object)l);
                ImmoToolUtils.showMessageInfoDialog((String)ContactsEntryViewPanel.this.resourceMap.getString("message.exportSuccessful", new Object[]{file2.getAbsolutePath()}));
            }
        };
    }

    @Action
    public void doSelectLanguage() {
        this.detailsPanel.showLanguageMenu();
    }

    @Action
    public Task doSubmit() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.tabPanel.getTabCount(); ++i) {
            Component component = this.tabPanel.getComponentAt(i);
            if (component instanceof JScrollPane) {
                component = ((JScrollPane)component).getViewport().getView();
            }
            if (!(component instanceof ContactsEntryViewAddonPanel)) continue;
            ContactsEntryViewAddonPanel contactsEntryViewAddonPanel = (ContactsEntryViewAddonPanel)((Object)component);
            contactsEntryViewAddonPanel.validateForm();
            if (contactsEntryViewAddonPanel.isFormValid()) continue;
            arrayList.add(this.resourceMap.getString("error.invalidTab", new Object[]{contactsEntryViewAddonPanel.getTitle()}));
        }
        if (!arrayList.isEmpty()) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.invalidInput", new Object[0]), arrayList);
            return null;
        }
        this.setButtonsEnabled(false);
        return new ImmoToolTask<ContactsEntry>(this.resourceMap.getString("doSubmit.Action.text", new Object[0])){

            protected ContactsEntry executeTask() throws Exception {
                ContactsEntryViewAddonPanel contactsEntryViewAddonPanel;
                Component component;
                int n;
                ContactsEntry contactsEntry = null;
                if (ContactsEntryViewPanel.this.contactId <= 0L) {
                    contactsEntry = new ContactsEntry();
                } else {
                    contactsEntry = ContactsEntry.load(ContactsEntryViewPanel.this.groupId, ContactsEntryViewPanel.this.contactId);
                    if (contactsEntry == null) {
                        throw new Exception("group #" + ContactsEntryViewPanel.this.groupId + " not found!");
                    }
                }
                for (n = 0; n < ContactsEntryViewPanel.this.tabPanel.getTabCount(); ++n) {
                    component = ContactsEntryViewPanel.this.tabPanel.getComponentAt(n);
                    if (component instanceof JScrollPane) {
                        component = ((JScrollPane)component).getViewport().getView();
                    }
                    if (!(component instanceof ContactsEntryViewAddonPanel)) continue;
                    contactsEntryViewAddonPanel = (ContactsEntryViewAddonPanel)((Object)component);
                    contactsEntryViewAddonPanel.save(contactsEntry);
                }
                contactsEntry.save();
                if (ContactsEntryViewPanel.this.groupId > 0L && ContactsEntryViewPanel.this.contactId > 0L && contactsEntry.getGroupId() != ContactsEntryViewPanel.this.groupId) {
                    ContactsEntry contactsEntry2 = ContactsEntry.load(ContactsEntryViewPanel.this.groupId, ContactsEntryViewPanel.this.contactId);
                    contactsEntry2.remove();
                }
                for (n = 0; n < ContactsEntryViewPanel.this.tabPanel.getTabCount(); ++n) {
                    component = ContactsEntryViewPanel.this.tabPanel.getComponentAt(n);
                    if (component instanceof JScrollPane) {
                        component = ((JScrollPane)component).getViewport().getView();
                    }
                    if (!(component instanceof ContactsEntryViewAddonPanel)) continue;
                    contactsEntryViewAddonPanel = (ContactsEntryViewAddonPanel)((Object)component);
                    contactsEntryViewAddonPanel.saveFinished(contactsEntry);
                }
                ContactsEntryViewPanel.this.setContact(contactsEntry);
                return contactsEntry;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)ContactsEntryViewPanel.this.resourceMap.getString("error.cantSaveContact", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                ContactsEntryViewPanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(ContactsEntry contactsEntry) {
                super.succeeded((Object)contactsEntry);
                ContactsEntryViewPanel.this.executeFormTasks();
                ImmoToolUtils.updateTabs();
            }
        };
    }

    @Action
    public Task doViewNext() {
        if (this.nextContactId <= 0L || this.nextGroupId <= 0L) {
            return null;
        }
        if (!this.checkForModifications()) {
            return null;
        }
        this.setButtonsEnabled(false);
        return new ImmoToolTask<ContactsEntry>(){

            protected ContactsEntry executeTask() throws Exception {
                ContactsEntry contactsEntry = ContactsEntry.load(ContactsEntryViewPanel.this.nextGroupId, ContactsEntryViewPanel.this.nextContactId);
                if (contactsEntry == null) {
                    throw new Exception("Contact #" + ContactsEntryViewPanel.this.nextContactId + " not found!");
                }
                ContactsEntryViewPanel.this.setContact(contactsEntry);
                return contactsEntry;
            }

            protected void finished() {
                super.finished();
                ContactsEntryViewPanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(ContactsEntry contactsEntry) {
                super.succeeded((Object)contactsEntry);
                ContactsEntryViewPanel.this.executeFormTasks();
                ImmoToolUtils.updateTabs();
                ContactsEntryViewPanel.this.requestFocus();
            }
        };
    }

    @Action
    public Task doViewPrevious() {
        if (this.prevContactId <= 0L || this.prevGroupId <= 0L) {
            return null;
        }
        if (!this.checkForModifications()) {
            return null;
        }
        this.setButtonsEnabled(false);
        return new ImmoToolTask<ContactsEntry>(){

            protected ContactsEntry executeTask() throws Exception {
                ContactsEntry contactsEntry = ContactsEntry.load(ContactsEntryViewPanel.this.prevGroupId, ContactsEntryViewPanel.this.prevContactId);
                if (contactsEntry == null) {
                    throw new Exception("Contact #" + ContactsEntryViewPanel.this.prevContactId + " not found!");
                }
                ContactsEntryViewPanel.this.setContact(contactsEntry);
                return contactsEntry;
            }

            protected void finished() {
                super.finished();
                ContactsEntryViewPanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(ContactsEntry contactsEntry) {
                super.succeeded((Object)contactsEntry);
                ContactsEntryViewPanel.this.executeFormTasks();
                ImmoToolUtils.updateTabs();
                ContactsEntryViewPanel.this.requestFocus();
            }
        };
    }

    private class AusweisArtRenderer
    extends JLabel
    implements ListCellRenderer {
        public AusweisArtRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if ("DRIVING_LICENSE".equals(object)) {
                this.setText(ContactsEntryViewPanel.this.resourceMap.getString("label.ausweisArt.fuehrerschein", new Object[0]));
            } else if ("IDENTIFICATION_CARD".equals(object)) {
                this.setText(ContactsEntryViewPanel.this.resourceMap.getString("label.ausweisArt.personalausweis", new Object[0]));
            } else if ("PASSPORT".equals(object)) {
                this.setText(ContactsEntryViewPanel.this.resourceMap.getString("label.ausweisArt.reisepass", new Object[0]));
            } else if (object instanceof String) {
                this.setText(StringUtils.trimToEmpty((String)((String)object)));
            } else {
                this.setText("");
            }
            return this;
        }
    }

    private class AusweisArtEditor
    extends JTextField
    implements ComboBoxEditor {
        @Override
        public Component getEditorComponent() {
            return this;
        }

        @Override
        public void setItem(Object object) {
            if ("DRIVING_LICENSE".equals(object)) {
                this.setText(ContactsEntryViewPanel.this.resourceMap.getString("label.ausweisArt.fuehrerschein", new Object[0]));
            } else if ("IDENTIFICATION_CARD".equals(object)) {
                this.setText(ContactsEntryViewPanel.this.resourceMap.getString("label.ausweisArt.personalausweis", new Object[0]));
            } else if ("PASSPORT".equals(object)) {
                this.setText(ContactsEntryViewPanel.this.resourceMap.getString("label.ausweisArt.reisepass", new Object[0]));
            } else if (object instanceof String) {
                this.setText(StringUtils.trimToEmpty((String)((String)object)));
            } else {
                this.setText("");
            }
        }

        @Override
        public Object getItem() {
            String string = StringUtils.trimToEmpty((String)this.getText());
            if (ContactsEntryViewPanel.this.resourceMap.getString("label.ausweisArt.fuehrerschein", new Object[0]).equalsIgnoreCase(string)) {
                return "DRIVING_LICENSE";
            }
            if (ContactsEntryViewPanel.this.resourceMap.getString("label.ausweisArt.personalausweis", new Object[0]).equalsIgnoreCase(string)) {
                return "IDENTIFICATION_CARD";
            }
            if (ContactsEntryViewPanel.this.resourceMap.getString("label.ausweisArt.reisepass", new Object[0]).equalsIgnoreCase(string)) {
                return "PASSPORT";
            }
            return string;
        }
    }

    private class StatusRenderer
    extends JLabel
    implements ListCellRenderer {
        public StatusRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof String) {
                this.setText(" " + ContactsEntry.writeStatus((String)object));
            } else {
                this.setText(" [ " + ContactsEntryViewPanel.this.resourceMap.getString("label.status.empty", new Object[0]) + " ]");
            }
            return this;
        }
    }

    private static class LocaleRenderer
    extends JLabel
    implements ListCellRenderer {
        public LocaleRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof Locale) {
                this.setText(" " + ((Locale)object).getDisplayLanguage());
            } else {
                this.setText("");
            }
            return this;
        }
    }

    private class NotesPanel
    extends ContactsEntryViewAddonPanel {
        private ModificationHandler modifications = ImmoToolUtils.createModificationHandler();
        private RTextArea notesField;

        public NotesPanel() {
            JXTitledSeparator jXTitledSeparator = ImmoToolUtils.createHead2Separator((String)ContactsEntryViewPanel.this.resourceMap.getString("notesTab.textTitle", new Object[0]));
            jXTitledSeparator.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
            this.notesField = new RTextArea();
            this.notesField.setName("notesField");
            this.notesField.setLineWrap(true);
            this.notesField.setWrapStyleWord(true);
            if (this.notesField.getPopupMenu() != null) {
                this.notesField.getPopupMenu().add(new JMenuItem(ContactsEntryViewPanel.this.actionMap.get("doPrintNotes")));
            }
            JScrollPane jScrollPane = new JScrollPane((Component)this.notesField);
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(11, 13, 11, 13));
            this.add((Component)jXTitledSeparator, "North");
            this.add(jScrollPane, "Center");
            this.revalidate();
            this.repaint();
        }

        @Override
        public String getTitle() {
            return ContactsEntryViewPanel.this.resourceMap.getString("notesTab.title", new Object[0]);
        }

        public boolean isFormModified() {
            return this.modifications.isModified();
        }

        @Override
        public void load(ContactsEntry contactsEntry) throws ImmoToolException {
            this.notesField.setText(contactsEntry != null ? contactsEntry.getText() : "");
            this.modifications.clear();
            this.modifications.putValue((JComponent)this.notesField);
        }

        @Override
        public void save(ContactsEntry contactsEntry) throws ImmoToolException {
            contactsEntry.setText(this.notesField.getText().trim());
        }

        @Override
        public void saveFinished(ContactsEntry contactsEntry) throws ImmoToolException {
        }

        public boolean isFormEnabled() {
            return true;
        }

        public boolean isFormUsable() {
            return true;
        }
    }

    private class DetailsPanel
    extends ContactsEntryViewAddonPanel {
        private ModificationHandler modifications = ImmoToolUtils.createModificationHandler();
        private JXDatePicker dayOfBirthField = new JXDatePicker();
        private JTextField placeOfBirthField;
        private JComboBox ausweisArtField;
        private JTextField ausweisBehoerdeField;
        private JTextField ausweisNrField;
        private JTextField citizenshipField;
        private JTextField steuerNrField;
        private JTextField steuerIdNrField;
        private JTextField steuerUmsatzIdNrField;
        private JTextField wirtschaftIdNrField;
        private JTextField kontoInhaberField;
        private JTextField kontoInstitutField;
        private JTextField kontoNrField;
        private JTextField kontoBlzField;
        private JTextField kontoIbanField;
        private JTextField kontoBicField;
        private JList languageList;
        private JButton setupLanguageButton;
        private JPopupMenu setupLanguageMenu;

        public DetailsPanel() {
            this.dayOfBirthField.setName("dayOfBirthField");
            this.placeOfBirthField = new JTextField();
            this.placeOfBirthField.setName("placeOfBirthField");
            this.ausweisArtField = new JComboBox();
            this.ausweisArtField.setName("ausweisArtField");
            this.ausweisArtField.addItem("");
            this.ausweisArtField.addItem("IDENTIFICATION_CARD");
            this.ausweisArtField.addItem("PASSPORT");
            this.ausweisArtField.addItem("DRIVING_LICENSE");
            this.ausweisArtField.setRenderer(new AusweisArtRenderer());
            this.ausweisArtField.setEditor(new AusweisArtEditor());
            this.ausweisArtField.setEditable(true);
            this.ausweisBehoerdeField = new JTextField();
            this.ausweisBehoerdeField.setName("ausweisBehoerdeField");
            this.ausweisNrField = new JTextField();
            this.ausweisNrField.setName("ausweisNrField");
            this.citizenshipField = new JTextField();
            this.citizenshipField.setName("citizenshipField");
            this.steuerNrField = new JTextField();
            this.steuerNrField.setName("steuerNrField");
            this.steuerIdNrField = new JTextField();
            this.steuerIdNrField.setName("steuerIdNrField");
            this.steuerUmsatzIdNrField = new JTextField();
            this.steuerUmsatzIdNrField.setName("steuerUmsatzIdNrField");
            this.wirtschaftIdNrField = new JTextField();
            this.wirtschaftIdNrField.setName("wirtschaftIdNrField");
            this.kontoInhaberField = new JTextField();
            this.kontoInhaberField.setName("kontoInhaberField");
            this.kontoInstitutField = new JTextField();
            this.kontoInstitutField.setName("kontoInstitutField");
            this.kontoNrField = new JTextField();
            this.kontoNrField.setName("kontoNrField");
            this.kontoBlzField = new JTextField();
            this.kontoBlzField.setName("kontoBlzField");
            this.kontoIbanField = new JTextField();
            this.kontoIbanField.setName("kontoIbanField");
            this.kontoBicField = new JTextField();
            this.kontoBicField.setName("kontoBicField");
            this.setupLanguageButton = new JButton();
            this.setupLanguageButton.setName("setupLanguageButton");
            this.setupLanguageButton.setAction(ContactsEntryViewPanel.this.actionMap.get("doSelectLanguage"));
            this.setupLanguageMenu = new JPopupMenu();
            this.languageList = new JList();
            this.languageList.setName("languageList");
            this.languageList.setModel(new DefaultListModel());
            this.languageList.setCellRenderer(new LocaleRenderer());
            JScrollPane jScrollPane = new JScrollPane(this.languageList);
            jScrollPane.setPreferredSize(new Dimension(0, 125));
            DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:[30dlu,pref], 3dlu, 30dlu:grow, 3dlu,right:pref, 3dlu, 30dlu:grow");
            defaultFormBuilder.border(Borders.DIALOG);
            defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)ContactsEntryViewPanel.this.resourceMap.getString("detailsTab.citizenshipTitle", new Object[0])), 7);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(ContactsEntryViewPanel.this.resourceMap.getString("label.dayOfBirth", new Object[0]), (Component)this.dayOfBirthField);
            defaultFormBuilder.append(ContactsEntryViewPanel.this.resourceMap.getString("label.placeOfBirth", new Object[0]), (Component)this.placeOfBirthField);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(ContactsEntryViewPanel.this.resourceMap.getString("label.ausweisArt", new Object[0]), (Component)this.ausweisArtField);
            defaultFormBuilder.append(ContactsEntryViewPanel.this.resourceMap.getString("label.ausweisNr", new Object[0]), (Component)this.ausweisNrField);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(ContactsEntryViewPanel.this.resourceMap.getString("label.ausweisBehoerde", new Object[0]), (Component)this.ausweisBehoerdeField, 5);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(ContactsEntryViewPanel.this.resourceMap.getString("label.citizenship", new Object[0]), (Component)this.citizenshipField, 5);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)ContactsEntryViewPanel.this.resourceMap.getString("detailsTab.idsAndNrsTitle", new Object[0])), 7);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(ContactsEntryViewPanel.this.resourceMap.getString("label.steuerNr", new Object[0]), (Component)this.steuerNrField, 5);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(ContactsEntryViewPanel.this.resourceMap.getString("label.steuerIdNr", new Object[0]), (Component)this.steuerIdNrField, 5);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(ContactsEntryViewPanel.this.resourceMap.getString("label.steuerUmsatzIdNr", new Object[0]), (Component)this.steuerUmsatzIdNrField, 5);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(ContactsEntryViewPanel.this.resourceMap.getString("label.wirtschaftIdNr", new Object[0]), (Component)this.wirtschaftIdNrField, 5);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)ContactsEntryViewPanel.this.resourceMap.getString("detailsTab.accountTitle", new Object[0])), 7);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(ContactsEntryViewPanel.this.resourceMap.getString("label.kontoNr", new Object[0]), (Component)this.kontoNrField, 5);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(ContactsEntryViewPanel.this.resourceMap.getString("label.kontoInhaber", new Object[0]), (Component)this.kontoInhaberField, 5);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(ContactsEntryViewPanel.this.resourceMap.getString("label.kontoInstitut", new Object[0]), (Component)this.kontoInstitutField, 5);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(ContactsEntryViewPanel.this.resourceMap.getString("label.kontoBlz", new Object[0]), (Component)this.kontoBlzField, 5);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(ContactsEntryViewPanel.this.resourceMap.getString("label.kontoIban", new Object[0]), (Component)this.kontoIbanField, 5);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(ContactsEntryViewPanel.this.resourceMap.getString("label.kontoBic", new Object[0]), (Component)this.kontoBicField, 5);
            defaultFormBuilder.nextLine();
            DefaultFormBuilder defaultFormBuilder2 = ImmoToolUtils.createFormBuilder((String)"75dlu:grow, 3dlu, pref");
            defaultFormBuilder2.border(Borders.DIALOG);
            defaultFormBuilder2.defaultRowSpec(RowSpec.decode((String)"top:pref"));
            defaultFormBuilder2.append((Component)ImmoToolUtils.createHead2Separator((String)ContactsEntryViewPanel.this.resourceMap.getString("detailsTab.languageTitle", new Object[0])));
            defaultFormBuilder2.append((Component)this.setupLanguageButton);
            defaultFormBuilder2.nextLine();
            defaultFormBuilder2.defaultRowSpec(FormSpecs.PREF_ROWSPEC);
            defaultFormBuilder2.append((Component)jScrollPane, 3);
            defaultFormBuilder2.nextLine();
            this.setLayout(new BorderLayout(5, 5));
            this.add(defaultFormBuilder.getPanel(), "Center");
            this.add(defaultFormBuilder2.getPanel(), "East");
            this.revalidate();
            this.repaint();
        }

        @Override
        public String getTitle() {
            return ContactsEntryViewPanel.this.resourceMap.getString("detailsTab.title", new Object[0]);
        }

        public boolean isFormModified() {
            return this.modifications.isModified();
        }

        @Override
        public void load(ContactsEntry contactsEntry) throws ImmoToolException {
            this.ausweisArtField.setSelectedItem(contactsEntry != null ? contactsEntry.getAusweisArt() : "");
            this.ausweisBehoerdeField.setText(contactsEntry != null ? contactsEntry.getAusweisBehoerde() : "");
            this.ausweisNrField.setText(contactsEntry != null ? contactsEntry.getAusweisNr() : "");
            this.citizenshipField.setText(contactsEntry != null ? contactsEntry.getCitizenship() : "");
            this.kontoBicField.setText(contactsEntry != null ? contactsEntry.getKontoBic() : "");
            this.kontoBlzField.setText(contactsEntry != null ? contactsEntry.getKontoBlz() : "");
            this.kontoIbanField.setText(contactsEntry != null ? contactsEntry.getKontoIban() : "");
            this.kontoInhaberField.setText(contactsEntry != null ? contactsEntry.getKontoInhaber() : "");
            this.kontoInstitutField.setText(contactsEntry != null ? contactsEntry.getKontoInstitut() : "");
            this.kontoNrField.setText(contactsEntry != null ? contactsEntry.getKontoNr() : "");
            this.steuerIdNrField.setText(contactsEntry != null ? contactsEntry.getSteuerIdNr() : "");
            this.steuerNrField.setText(contactsEntry != null ? contactsEntry.getSteuerNr() : "");
            this.steuerUmsatzIdNrField.setText(contactsEntry != null ? contactsEntry.getSteuerUmsatzIdNr() : "");
            this.wirtschaftIdNrField.setText(contactsEntry != null ? contactsEntry.getWirtschaftIdNr() : "");
            this.dayOfBirthField.setDate(contactsEntry != null ? contactsEntry.getDayOfBirth() : null);
            this.placeOfBirthField.setText(contactsEntry != null ? contactsEntry.getPlaceOfBirth() : "");
            this.loadLanguages(contactsEntry);
            this.modifications.clear();
            this.modifications.putValue((JComponent)this.ausweisArtField);
            this.modifications.putValue((JComponent)this.ausweisBehoerdeField);
            this.modifications.putValue((JComponent)this.ausweisNrField);
            this.modifications.putValue((JComponent)this.citizenshipField);
            this.modifications.putValue((JComponent)this.kontoBicField);
            this.modifications.putValue((JComponent)this.kontoBlzField);
            this.modifications.putValue((JComponent)this.kontoIbanField);
            this.modifications.putValue((JComponent)this.kontoInhaberField);
            this.modifications.putValue((JComponent)this.kontoInstitutField);
            this.modifications.putValue((JComponent)this.kontoNrField);
            this.modifications.putValue((JComponent)this.steuerIdNrField);
            this.modifications.putValue((JComponent)this.steuerNrField);
            this.modifications.putValue((JComponent)this.steuerUmsatzIdNrField);
            this.modifications.putValue((JComponent)this.dayOfBirthField);
            this.modifications.putValue((JComponent)this.placeOfBirthField);
        }

        /*
         * WARNING - void declaration
         */
        private void loadLanguages(ContactsEntry contactsEntry) {
            Object object;
            List<Object> list = contactsEntry == null ? new ArrayList() : Arrays.asList(contactsEntry.getSprachen());
            TreeMap<String, Locale> treeMap = new TreeMap<String, Locale>();
            DefaultListModel<Locale> defaultListModel = new DefaultListModel<Locale>();
            for (Locale object22 : list) {
                treeMap.put(object22.getDisplayLanguage(), object22);
            }
            for (Locale locale : treeMap.values()) {
                defaultListModel.addElement(locale);
            }
            this.languageList.setModel(defaultListModel);
            TreeMap treeMap2 = new TreeMap();
            for (String string : Locale.getISOLanguages()) {
                object = new Locale(string);
                treeMap2.put(((Locale)object).getDisplayLanguage().toUpperCase(), object);
            }
            this.setupLanguageMenu.removeAll();
            Object var6_10 = null;
            JMenu jMenu = null;
            for (final Locale locale : treeMap2.values()) {
                void var6_11;
                object = locale.getDisplayLanguage();
                if (var6_11 == null || !var6_11.equals(((String)object).toUpperCase().substring(0, 1))) {
                    String string = ((String)object).toUpperCase().substring(0, 1);
                    jMenu = new JMenu(string);
                    this.setupLanguageMenu.add(jMenu);
                }
                JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem((String)object);
                jCheckBoxMenuItem.setSelected(list.contains(locale));
                jCheckBoxMenuItem.setOpaque(true);
                jMenu.add(jCheckBoxMenuItem);
                jCheckBoxMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                        if (jCheckBoxMenuItem.isSelected()) {
                            ((DefaultListModel)DetailsPanel.this.languageList.getModel()).addElement(locale);
                        } else {
                            ((DefaultListModel)DetailsPanel.this.languageList.getModel()).removeElement(locale);
                        }
                    }
                });
            }
        }

        @Override
        public void save(ContactsEntry contactsEntry) throws ImmoToolException {
            contactsEntry.setAusweisArt(((String)this.ausweisArtField.getSelectedItem()).trim());
            contactsEntry.setAusweisBehoerde(this.ausweisBehoerdeField.getText().trim());
            contactsEntry.setAusweisNr(this.ausweisNrField.getText().trim());
            contactsEntry.setCitizenship(this.citizenshipField.getText().trim());
            contactsEntry.setKontoBic(this.kontoBicField.getText().trim());
            contactsEntry.setKontoBlz(this.kontoBlzField.getText().trim());
            contactsEntry.setKontoIban(this.kontoIbanField.getText().trim());
            contactsEntry.setKontoInhaber(this.kontoInhaberField.getText().trim());
            contactsEntry.setKontoInstitut(this.kontoInstitutField.getText().trim());
            contactsEntry.setKontoNr(this.kontoNrField.getText().trim());
            contactsEntry.setSteuerIdNr(this.steuerIdNrField.getText().trim());
            contactsEntry.setSteuerNr(this.steuerNrField.getText().trim());
            contactsEntry.setSteuerUmsatzIdNr(this.steuerUmsatzIdNrField.getText().trim());
            contactsEntry.setWirtschaftIdNr(this.wirtschaftIdNrField.getText().trim());
            contactsEntry.setDayOfBirth(this.dayOfBirthField.getDate());
            contactsEntry.setPlaceOfBirth(this.placeOfBirthField.getText().trim());
            ArrayList<Locale> arrayList = new ArrayList<Locale>();
            for (int i = 0; i < this.languageList.getModel().getSize(); ++i) {
                arrayList.add((Locale)this.languageList.getModel().getElementAt(i));
            }
            contactsEntry.setSprachen(arrayList.toArray(new Locale[arrayList.size()]));
        }

        @Override
        public void saveFinished(ContactsEntry contactsEntry) throws ImmoToolException {
        }

        private void showLanguageMenu() {
            this.setupLanguageMenu.show(this.setupLanguageButton, 0, this.setupLanguageButton.getSize().height);
        }

        public boolean isFormEnabled() {
            return true;
        }

        public boolean isFormUsable() {
            return true;
        }
    }

    private class AdressPanel
    extends ContactsEntryViewAddonPanel {
        private ModificationHandler modifications = ImmoToolUtils.createModificationHandler();
        private JComboBox groupBox;
        private JComboBox statusBox;
        private JCheckBox contactAllowedBox;
        private JAdressPanel formPanel;
        private long groupId = 0L;

        public AdressPanel() {
            this.groupBox = new JComboBox<String>(new String[]{" [ " + ContactsEntryViewPanel.this.resourceMap.getString("label.group.select", new Object[0]) + " ] "});
            this.groupBox.setName("groupBox");
            this.statusBox = new JComboBox();
            this.statusBox.setName("statusBox");
            this.statusBox.setRenderer(new StatusRenderer());
            this.statusBox.addItem(null);
            this.statusBox.addItem("active");
            this.statusBox.addItem("inactive");
            this.contactAllowedBox = new JCheckBox();
            this.contactAllowedBox.setName("contactAllowedBox");
            this.formPanel = new JAdressPanel((SimpleAdressImpl)new CompanyAdressImpl()){

                protected void init() {
                    this.registerValidation(this.personFirstNameField, new ValidationRule(){

                        public boolean isValid(Object object) {
                            String string = companyNameField.getText().trim();
                            String string2 = personLastNameField.getText().trim();
                            return string.length() > 0 || string2.length() > 0 || ValidationHandler.NOT_BLANK.isValid(object);
                        }
                    });
                    this.registerValidation(this.personLastNameField, new ValidationRule(){

                        public boolean isValid(Object object) {
                            String string = companyNameField.getText().trim();
                            String string2 = personFirstNameField.getText().trim();
                            return string.length() > 0 || string2.length() > 0 || ValidationHandler.NOT_BLANK.isValid(object);
                        }
                    });
                    this.registerValidation(this.companyNameField, new ValidationRule(){

                        public boolean isValid(Object object) {
                            String string = personFirstNameField.getText().trim();
                            String string2 = personLastNameField.getText().trim();
                            return string.length() > 0 || string2.length() > 0 || ValidationHandler.NOT_BLANK.isValid(object);
                        }
                    });
                }
            };
            JScrollPane jScrollPane = new JScrollPane((Component)this.formPanel);
            jScrollPane.setBorder(Borders.EMPTY);
            jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
            this.getValidationHandler().putRule((JComponent)this.groupBox, (ValidationRule)new NonEmptyComboBoxRule(this.groupBox));
            this.getValidationHandler().putRule((JComponent)this.statusBox, (ValidationRule)new NonEmptyComboBoxRule(this.statusBox));
            DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:[40dlu,pref], 3dlu, 20dlu:grow, 3dlu, right:pref, 3dlu, pref", (JPanel)((Object)this));
            defaultFormBuilder.border(Borders.DIALOG);
            defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)ContactsEntryViewPanel.this.resourceMap.getString("contactTab.general", new Object[0])), 7);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(ContactsEntryViewPanel.this.resourceMap.getString("label.group", new Object[0]), (Component)this.groupBox);
            defaultFormBuilder.append(ContactsEntryViewPanel.this.resourceMap.getString("label.status", new Object[0]), (Component)this.statusBox);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append("", (Component)this.contactAllowedBox, 5);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append((Component)jScrollPane, 7);
            defaultFormBuilder.nextLine();
            this.revalidate();
            this.repaint();
        }

        @Override
        public Task doLoadInBackground() {
            this.groupBox.setEnabled(false);
            this.groupBox.setSelectedIndex(-1);
            return new ImmoToolTask<Boolean>(){

                protected Boolean executeTask() throws Exception {
                    AdressPanel.this.groupBox.removeAllItems();
                    AdressPanel.this.groupBox.addItem(" [ " + ContactsEntryViewPanel.this.resourceMap.getString("label.group.select", new Object[0]) + " ] ");
                    ContactsGroupItem.load(AdressPanel.this.groupBox);
                    return true;
                }

                protected void finished() {
                    super.finished();
                    AdressPanel.this.groupBox.setEnabled(true);
                    AdressPanel.this.getValidationHandler().init();
                }

                protected void succeeded(Boolean bl) {
                    super.succeeded((Object)bl);
                    AdressPanel.this.groupBox.setSelectedIndex(0);
                    if (AdressPanel.this.groupId > 0L) {
                        for (int i = 1; i < AdressPanel.this.groupBox.getItemCount(); ++i) {
                            ContactsGroupItem contactsGroupItem = (ContactsGroupItem)AdressPanel.this.groupBox.getItemAt(i);
                            if (contactsGroupItem.getGroupId() != AdressPanel.this.groupId) continue;
                            AdressPanel.this.groupBox.setSelectedIndex(i);
                            break;
                        }
                    }
                    AdressPanel.this.modifications.putValue((JComponent)AdressPanel.this.groupBox);
                }
            };
        }

        @Override
        public String getTitle() {
            return ContactsEntryViewPanel.this.resourceMap.getString("contactTab.title", new Object[0]);
        }

        public boolean isFormModified() {
            return this.modifications.isModified() || this.formPanel.isModifiedInput();
        }

        @Override
        public void load(ContactsEntry contactsEntry) throws ImmoToolException {
            this.groupId = contactsEntry != null ? contactsEntry.getGroupId() : 0L;
            this.groupBox.setSelectedIndex(-1);
            if (contactsEntry != null) {
                this.formPanel.loadAdress(contactsEntry.getAdress());
            }
            String string = contactsEntry != null ? contactsEntry.getStatus() : null;
            this.statusBox.setSelectedItem(string != null && string.trim().length() > 0 ? string : null);
            this.contactAllowedBox.setSelected(contactsEntry != null && contactsEntry.isContactAllowed());
            this.modifications.clear();
            this.modifications.putValue((JComponent)this.statusBox);
            this.modifications.putValue((JComponent)this.contactAllowedBox);
        }

        public boolean isFormEnabled() {
            return true;
        }

        public boolean isFormUsable() {
            return true;
        }

        public boolean isFormValid() {
            return super.isFormValid() && this.formPanel.isValidInput();
        }

        @Override
        public boolean isLoadedInBackground() {
            return true;
        }

        @Override
        public void save(ContactsEntry contactsEntry) throws ImmoToolException {
            ContactsGroupItem contactsGroupItem = (ContactsGroupItem)this.groupBox.getSelectedItem();
            contactsEntry.setGroupId(contactsGroupItem.getGroupId());
            contactsEntry.setStatus((String)this.statusBox.getSelectedItem());
            contactsEntry.setContactAllowed(this.contactAllowedBox.isSelected());
            this.formPanel.saveAdress(contactsEntry.getAdress());
        }

        @Override
        public void saveFinished(ContactsEntry contactsEntry) throws ImmoToolException {
        }

        public void validateForm() {
            super.validateForm();
            this.formPanel.validateInputs();
        }
    }
}

