/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts;

import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolDb;
import com.openindex.openestate.tool.ImmoToolDbException;
import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.contacts.ContactsEntry;
import com.openindex.openestate.tool.contacts.ContactsPluginUtils;
import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.modules.XMLResource;

public class ContactsGroup {
    private static final Logger LOGGER = Logger.getLogger(ContactsGroup.class);
    public static final String KEY_DESCRIPTION = "description";
    public static final String KEY_ID = "id";
    public static final String KEY_NAME = "name";
    private long id = 0L;
    private String description = "";
    private String name = "";

    public long getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContactsEntry[] listEntries() throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = this.openGroupCollection();
            ContactsEntry[] contactsEntryArray = this.listEntries(collection);
            return contactsEntryArray;
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public ContactsEntry[] listEntries(Collection collection) throws ImmoToolDbException {
        try {
            if (collection == null) {
                throw new ImmoToolDbException("empty collection!");
            }
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Contacts/" + String.valueOf(this.getId()))) {
                throw new IllegalArgumentException("invalid collection!");
            }
            ArrayList<ContactsEntry> arrayList = new ArrayList<ContactsEntry>();
            for (String string : collection.listResources()) {
                String[] stringArray = string.split("\\.");
                if (stringArray.length != 3 || !stringArray[0].equals("contact") || !stringArray[2].equals("xml")) continue;
                ContactsEntry contactsEntry = ContactsEntry.load(this.getId(), Long.valueOf(stringArray[1]), collection);
                if (contactsEntry == null) {
                    LOGGER.warn((Object)("could not load contact-entries from " + string));
                    continue;
                }
                arrayList.add(contactsEntry);
            }
            return arrayList.toArray(new ContactsEntry[arrayList.size()]);
        }
        catch (Exception exception) {
            throw new ImmoToolDbException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContactsGroup load(long l) throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = ContactsPluginUtils.openPluginCollection("");
            ContactsGroup contactsGroup = ContactsGroup.load(l, collection);
            return contactsGroup;
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static ContactsGroup load(long l, Collection collection) throws ImmoToolDbException {
        try {
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Contacts")) {
                throw new ImmoToolDbException("invalid collection!");
            }
            String string = "group." + l + ".xml";
            if (!ImmoToolDbUtils.hasResource((Collection)collection, (String)string)) {
                return null;
            }
            Properties properties = ImmoToolDbUtils.loadProperties((Collection)collection, (String)string);
            ContactsGroup contactsGroup = new ContactsGroup();
            contactsGroup.load(properties);
            return contactsGroup;
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public void load(Properties properties) {
        this.setId(Long.valueOf(properties.getProperty(KEY_ID, "0")));
        this.setName(properties.getProperty(KEY_NAME, ""));
        this.setDescription(properties.getProperty(KEY_DESCRIPTION, "").replaceAll("<br/>", SystemUtils.LINE_SEPARATOR));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContactsGroup[] loadGroups() throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = ContactsPluginUtils.openPluginCollection("");
            ContactsGroup[] contactsGroupArray = ContactsGroup.loadGroups(collection);
            return contactsGroupArray;
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static ContactsGroup[] loadGroups(Collection collection) throws ImmoToolDbException {
        try {
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Contacts")) {
                throw new ImmoToolDbException("invalid collection!");
            }
            ArrayList<ContactsGroup> arrayList = new ArrayList<ContactsGroup>();
            for (String string : collection.listResources()) {
                String[] stringArray = string.split("\\.");
                if (stringArray.length != 3 || !stringArray[0].equals("group") || !stringArray[2].equals("xml")) continue;
                ContactsGroup contactsGroup = ContactsGroup.load(Long.valueOf(stringArray[1]), collection);
                if (contactsGroup == null) {
                    LOGGER.warn((Object)("could not load group from " + string));
                    continue;
                }
                arrayList.add(contactsGroup);
            }
            return arrayList.toArray(new ContactsGroup[arrayList.size()]);
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public Collection openGroupCollection() throws ImmoToolDbException {
        if (this.getId() <= 0L) {
            throw new ImmoToolDbException("group has no id!");
        }
        return ContactsPluginUtils.openPluginCollection("/" + String.valueOf(this.getId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = ContactsPluginUtils.openPluginCollection("");
            this.remove(collection);
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public void remove(Collection collection) throws ImmoToolDbException {
        try {
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Contacts")) {
                throw new ImmoToolDbException("invalid collection!");
            }
            String string = "group." + this.id + ".xml";
            if (!ImmoToolDbUtils.hasResource((Collection)collection, (String)string)) {
                throw new Exception("unknown group-resource: " + string);
            }
            XMLResource xMLResource = ImmoToolDbUtils.loadXMLResource((Collection)collection, (String)string);
            if (xMLResource == null) {
                throw new Exception("group-resource not found: " + string);
            }
            Collection collection2 = collection.getChildCollection(String.valueOf(this.getId()));
            if (collection2 != null) {
                String string2 = collection2.getName();
                for (String string3 : collection2.listResources()) {
                    ImmoToolDbUtils.removeResource((Collection)collection2, (Resource)ImmoToolDbUtils.loadXMLResource((Collection)collection2, (String)string3));
                }
                collection2.close();
                ImmoToolApp.getApplication().getDatabase().removeCollection(string2);
            }
            ImmoToolDbUtils.removeResource((Collection)collection, (Resource)xMLResource);
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = ContactsPluginUtils.openPluginCollection("");
            this.save(collection);
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public void save(Collection collection) throws ImmoToolDbException {
        this.save(collection, ImmoToolApp.getApplication().getDatabase());
    }

    public void save(Collection collection, ImmoToolDb immoToolDb) throws ImmoToolDbException {
        try {
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Contacts")) {
                throw new ImmoToolDbException("invalid collection!");
            }
            if (this.getId() <= 0L) {
                this.setId(immoToolDb.getNextSequence("OpenEstate-Contacts.Group"));
            }
            if (this.getId() <= 0L) {
                throw new ImmoToolDbException("could not get sequence-value!");
            }
            Collection collection2 = collection.getChildCollection(String.valueOf(this.getId()));
            if (collection2 == null) {
                collection2 = immoToolDb.createCollection("ImmoTool/OpenEstate-Contacts/" + String.valueOf(this.getId()));
            }
            if (collection2 == null) {
                throw new ImmoToolDbException("could not create child collection!");
            }
            collection2.close();
            Properties properties = new Properties();
            this.save(properties);
            ImmoToolDbUtils.storeProperties((Collection)collection, (Properties)properties, (String)("group." + this.getId() + ".xml"));
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public void save(Properties properties) {
        if (this.getId() <= 0L) {
            throw new IllegalArgumentException("no id defined!");
        }
        properties.setProperty(KEY_ID, String.valueOf(this.getId()));
        properties.setProperty(KEY_NAME, this.getName());
        properties.setProperty(KEY_DESCRIPTION, this.getDescription().replaceAll(Pattern.quote(SystemUtils.LINE_SEPARATOR), "<br/>"));
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setId(long l) {
        this.id = l;
    }

    public void setName(String string) {
        this.name = string;
    }
}

