/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts;

import com.openindex.openestate.tool.ImmoToolDbException;
import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.contacts.ContactsGroup;
import com.openindex.openestate.tool.contacts.ContactsPluginUtils;
import java.util.TreeMap;
import javax.swing.JComboBox;
import org.xmldb.api.base.Collection;

public class ContactsGroupItem {
    private final long groupId;
    private final String groupName;

    public ContactsGroupItem(ContactsGroup contactsGroup) {
        this.groupId = contactsGroup.getId();
        this.groupName = contactsGroup.getName();
    }

    public long getGroupId() {
        return this.groupId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public static void load(JComboBox jComboBox) throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = ContactsPluginUtils.openPluginCollection("");
            TreeMap<String, ContactsGroupItem> treeMap = new TreeMap<String, ContactsGroupItem>();
            for (String string : collection.listResources()) {
                String[] stringArray = string.split("\\.");
                if (stringArray.length != 3 || !stringArray[0].equals("group") || !stringArray[2].equals("xml")) continue;
                Long l = Long.valueOf(stringArray[1]);
                ContactsGroupItem contactsGroupItem = new ContactsGroupItem(ContactsGroup.load(l));
                treeMap.put(contactsGroupItem.toString(), contactsGroupItem);
            }
            for (ContactsGroupItem contactsGroupItem : treeMap.values()) {
                jComboBox.addItem(contactsGroupItem);
            }
        }
        catch (Exception exception) {
            throw new ImmoToolDbException("could not load groups: " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public String toString() {
        return " " + this.groupName + " (#" + this.groupId + ")";
    }
}

