/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.contacts.ContactsGroup;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.application.ResourceMap;

public class ContactsGroupTableModel
extends DefaultTableModel {
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_DESCRIPTION = 2;
    private static final Map<Integer, String> COLUMN_NAMES = new HashMap<Integer, String>();
    private static final Map<Integer, Class> COLUMN_CLASSES;
    private final ResourceMap resourceMap;

    public ContactsGroupTableModel() {
        this.setColumnCount(COLUMN_NAMES.size());
        this.resourceMap = ImmoToolUtils.getResourceMap(ContactsGroupTableModel.class);
    }

    public void addContactsGroup(ContactsGroup contactsGroup) {
        this.addRow(this.buildRow(contactsGroup));
    }

    private Object[] buildRow(ContactsGroup contactsGroup) {
        TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
        treeMap.put(0, contactsGroup.getId());
        treeMap.put(1, contactsGroup.getName());
        treeMap.put(2, contactsGroup.getDescription());
        return treeMap.values().toArray(new Object[treeMap.size()]);
    }

    public void clear() {
        while (this.getRowCount() > 0) {
            this.removeRow(0);
        }
    }

    public Class getColumnClass(int n) {
        return COLUMN_CLASSES.containsKey(n) ? COLUMN_CLASSES.get(n) : null;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES.containsKey(n) ? this.resourceMap.getString(COLUMN_NAMES.get(n), new Object[0]) : null;
    }

    public Long getGroupIdAt(int n) {
        int n2 = n;
        return (Long)this.getValueAt(n2, 0);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    static {
        COLUMN_NAMES.put(0, "col.id");
        COLUMN_NAMES.put(1, "col.name");
        COLUMN_NAMES.put(2, "col.description");
        COLUMN_CLASSES = new HashMap<Integer, Class>();
        COLUMN_CLASSES.put(0, Long.class);
        COLUMN_CLASSES.put(1, String.class);
        COLUMN_CLASSES.put(2, String.class);
    }
}

