/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts;

import com.openindex.openestate.tool.ImmoToolTabPanel;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.contacts.ContactsGroup;
import com.openindex.openestate.tool.contacts.ContactsGroupTableModel;
import com.openindex.openestate.tool.contacts.ContactsGroupViewPanel;
import com.openindex.openestate.tool.utils.QuickTableExport;
import com.openindex.openestate.tool.utils.TabComponent;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.NumberFormat;
import javax.swing.ActionMap;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledSeparator;

public class ContactsGroupTablePanel
extends ImmoToolTabPanel {
    private ActionMap actionMap;
    private ResourceMap resourceMap;
    private JPopupMenu actionsMenu;
    private ContactsGroupTableModel resultTableModel;
    private JButton actionButton;
    private JButton addButton;
    private JButton closeButton;
    private JButton helpButton;
    private JButton refreshButton;
    private JXTable resultTable;
    private JScrollPane resultTableScroller;
    private JXTitledSeparator titleLabel;

    public ContactsGroupTablePanel() {
        this.build();
    }

    private void build() {
        this.actionMap = ImmoToolUtils.getActionMap(ContactsGroupTablePanel.class, (Object)((Object)this));
        this.resourceMap = ImmoToolUtils.getResourceMap(ContactsGroupTablePanel.class);
        this.initComponents();
        this.resourceMap.injectComponents((Component)((Object)this));
        this.actionsMenu = new JPopupMenu();
        this.actionsMenu.add(new JMenuItem(this.actionMap.get("doView")));
        this.actionsMenu.add(new JMenuItem(this.actionMap.get("doRemove")));
        this.resultTableModel = new ContactsGroupTableModel();
        this.resultTable.setModel((TableModel)this.resultTableModel);
        this.resultTable.setSortable(true);
        this.resultTable.getSelectionModel().setSelectionMode(0);
        this.resultTable.getColumn(0).setMaxWidth(75);
        this.resultTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                    Task task = ContactsGroupTablePanel.this.doView();
                    if (task != null) {
                        ImmoToolUtils.executeTask((Task)task);
                    }
                } else if (mouseEvent.getButton() == 3 && mouseEvent.getClickCount() == 1) {
                    int n = ContactsGroupTablePanel.this.resultTable.rowAtPoint(mouseEvent.getPoint());
                    if (n >= 0 && n != ContactsGroupTablePanel.this.resultTable.getSelectedRow() && n >= 0) {
                        ContactsGroupTablePanel.this.resultTable.getSelectionModel().setSelectionInterval(n, n);
                    }
                    if (n < 0) {
                        n = ContactsGroupTablePanel.this.resultTable.getSelectedRow();
                    }
                    if (n < 0) {
                        return;
                    }
                    ContactsGroupTablePanel.this.actionsMenu.show((Component)ContactsGroupTablePanel.this.resultTable, ((ContactsGroupTablePanel)ContactsGroupTablePanel.this).resultTable.getMousePosition().x, ((ContactsGroupTablePanel)ContactsGroupTablePanel.this).resultTable.getMousePosition().y);
                }
            }
        });
        this.resultTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ContactsGroupTablePanel.this.actionButton.setEnabled(ContactsGroupTablePanel.this.resultTable.getSelectedRow() >= 0);
            }
        });
        this.resultTable.setColumnControl((JComponent)QuickTableExport.createColumnControl((JXTable)this.resultTable));
        ImmoToolUtils.configureTable((JXTable)this.resultTable);
        this.addButton.setAction(this.actionMap.get(this.addButton.getText()));
        this.closeButton.setAction(this.actionMap.get(this.closeButton.getText()));
        this.helpButton.setAction(this.actionMap.get(this.helpButton.getText()));
        this.refreshButton.setAction(this.actionMap.get(this.refreshButton.getText()));
        this.actionButton.setAction(this.actionMap.get(this.actionButton.getText()));
        this.actionButton.setEnabled(false);
    }

    @Action
    public void doAction() {
        this.actionsMenu.show(this.actionButton, 0, this.actionButton.getSize().height);
    }

    @Action
    public void doAdd() {
        String string = ContactsGroupViewPanel.getInstanceTabTitle(0L);
        if (ImmoToolUtils.selectPanel((String)string)) {
            return;
        }
        ImmoToolUtils.showPanel((TabComponent)new ContactsGroupViewPanel());
    }

    @Action
    public void doClose() {
        ImmoToolUtils.removePanel((String)this.getTabTitle());
    }

    @Action
    public void doHelp() {
        ImmoToolUtils.showHelpDialog((String)"contacts.groups");
    }

    @Action
    public Task doRefresh() {
        this.resultTableModel.clear();
        this.resultTable.setEnabled(false);
        this.setButtonsEnabled(false);
        return new ImmoToolTask<Boolean>(){

            protected Boolean executeTask() throws Exception {
                for (ContactsGroup contactsGroup : ContactsGroup.loadGroups()) {
                    ContactsGroupTablePanel.this.resultTableModel.addContactsGroup(contactsGroup);
                }
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)ContactsGroupTablePanel.this.resourceMap.getString("error.cantRefresh", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                ContactsGroupTablePanel.this.resultTable.setEnabled(true);
                ContactsGroupTablePanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(Boolean bl) {
                super.succeeded((Object)bl);
                ContactsGroupTablePanel.this.titleLabel.setTitle(ContactsGroupTablePanel.this.resourceMap.getString("titleLabel.title", new Object[0]) + " / " + ContactsGroupTablePanel.this.resourceMap.getString("message.resultCount", new Object[]{NumberFormat.getIntegerInstance().format(ContactsGroupTablePanel.this.resultTable.getRowCount())}));
                ContactsGroupTablePanel.this.resultTable.packAll();
            }
        };
    }

    @Action
    public Task doRemove() {
        if (this.resultTable.getSelectedRowCount() < 1) {
            return null;
        }
        int n = this.resultTable.getSelectedRow();
        int n2 = this.resultTable.convertRowIndexToModel(n);
        final long l = this.resultTableModel.getGroupIdAt(n2);
        boolean bl = ImmoToolUtils.showQuestionDialog((String)this.resourceMap.getString("question.reallyDeleteGroup", new Object[]{l}));
        if (!bl) {
            return null;
        }
        this.setButtonsEnabled(false);
        return new ImmoToolTask<Boolean>(){

            protected Boolean executeTask() throws Exception {
                ContactsGroup contactsGroup = ContactsGroup.load(l);
                if (contactsGroup == null) {
                    throw new Exception("could not load group #" + l);
                }
                contactsGroup.remove();
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)ContactsGroupTablePanel.this.resourceMap.getString("error.cantRemoveGroup", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                ContactsGroupTablePanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(Boolean bl) {
                super.succeeded((Object)bl);
                ImmoToolUtils.executeTask((Task)ContactsGroupTablePanel.this.doRefresh());
            }
        };
    }

    @Action
    public Task doView() {
        if (this.resultTable.getSelectedRowCount() < 1) {
            return null;
        }
        int n = this.resultTable.getSelectedRow();
        int n2 = this.resultTable.convertRowIndexToModel(n);
        final long l = this.resultTableModel.getGroupIdAt(n2);
        String string = ContactsGroupViewPanel.getInstanceTabTitle(l);
        if (ImmoToolUtils.selectPanel((String)string)) {
            return null;
        }
        this.setButtonsEnabled(false);
        return new ImmoToolTask<ContactsGroupViewPanel>(){

            protected ContactsGroupViewPanel executeTask() throws Exception {
                ContactsGroup contactsGroup = ContactsGroup.load(l);
                if (contactsGroup == null) {
                    throw new Exception("could not load group #" + l);
                }
                ContactsGroupViewPanel contactsGroupViewPanel = new ContactsGroupViewPanel();
                contactsGroupViewPanel.load(contactsGroup);
                return contactsGroupViewPanel;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)ContactsGroupTablePanel.this.resourceMap.getString("error.cantViewGroup", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                ContactsGroupTablePanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(ContactsGroupViewPanel contactsGroupViewPanel) {
                super.succeeded((Object)contactsGroupViewPanel);
                ImmoToolUtils.showPanel((TabComponent)contactsGroupViewPanel);
            }
        };
    }

    public static String getInstanceTabTitle() {
        return ImmoToolUtils.getResourceMap(ContactsGroupTablePanel.class).getString("tabTitle", new Object[0]);
    }

    public String getTabInfo() {
        return this.resourceMap.getString("tabInfo", new Object[0]);
    }

    public String getTabTitle() {
        return ContactsGroupTablePanel.getInstanceTabTitle();
    }

    public void refreshTab() {
        ImmoToolUtils.executeTask((Task)this.doRefresh());
    }

    private void setButtonsEnabled(boolean bl) {
        this.addButton.setEnabled(bl);
        this.refreshButton.setEnabled(bl);
        if (!bl) {
            this.actionButton.setEnabled(false);
        } else {
            this.actionButton.setEnabled(this.resultTable.getSelectedRow() >= 0);
        }
    }

    private void initComponents() {
        this.titleLabel = ImmoToolUtils.createHead1Separator((String)"");
        this.refreshButton = new JButton();
        this.addButton = new JButton();
        this.actionButton = new JButton();
        this.helpButton = new JButton();
        this.closeButton = new JButton();
        this.resultTableScroller = new JScrollPane();
        this.resultTable = new JXTable();
        this.setName("Form");
        this.titleLabel.setName("titleLabel");
        this.titleLabel.setTitle("titleLabel");
        this.refreshButton.setText("doRefresh");
        this.refreshButton.setName("refreshButton");
        this.addButton.setText("doAdd");
        this.addButton.setName("addButton");
        this.actionButton.setText("doAction");
        this.actionButton.setName("actionButton");
        this.helpButton.setText("doHelp");
        this.helpButton.setName("helpButton");
        this.closeButton.setText("doClose");
        this.closeButton.setName("closeButton");
        this.resultTableScroller.setName("resultTableScroller");
        this.resultTable.setColumnControlVisible(true);
        this.resultTable.setName("resultTable");
        this.resultTableScroller.setViewportView((Component)this.resultTable);
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.resultTableScroller, GroupLayout.Alignment.LEADING, -1, 822, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent((Component)this.titleLabel, -1, 329, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.refreshButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.actionButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.helpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeButton).addComponent(this.helpButton).addComponent(this.actionButton).addComponent(this.addButton).addComponent(this.refreshButton)).addComponent((Component)this.titleLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resultTableScroller, -1, 370, Short.MAX_VALUE).addContainerGap()));
    }
}

