/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.ImmoToolTabPanel;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.contacts.ContactsGroup;
import com.openindex.openestate.tool.contacts.ContactsPluginUtils;
import com.openindex.openestate.tool.utils.ModificationHandler;
import com.openindex.openestate.tool.utils.ValidationHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.print.Printable;
import javax.swing.ActionMap;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.fife.ui.rtextarea.RTextArea;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXTitledSeparator;
import org.w3c.dom.Node;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.modules.XMLResource;

public class ContactsGroupViewPanel
extends ImmoToolTabPanel {
    private static final Logger LOGGER = Logger.getLogger(ContactsGroupViewPanel.class);
    private ActionMap actionMap = null;
    private ResourceMap resourceMap = null;
    private ModificationHandler modifications = null;
    private ValidationHandler validationHandler = null;
    private JTextField groupNameField = null;
    private RTextArea groupTextField = null;
    private JPopupMenu actionsMenu = null;
    private long groupId = 0L;
    private String groupInfo = null;
    private long nextGroupId = 0L;
    private long prevGroupId = 0L;
    private JButton actionButton;
    private JButton closeButton;
    private JPanel groupFormPanel;
    private JButton helpButton;
    private JButton nextButton;
    private JButton prevButton;
    private JButton submitButton;
    private JTabbedPane tabPanel;
    private JXTitledSeparator titleLabel;

    public ContactsGroupViewPanel() {
        this.build();
    }

    private void build() {
        this.modifications = ImmoToolUtils.createModificationHandler();
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.actionMap = ImmoToolUtils.getActionMap(ContactsGroupViewPanel.class, (Object)((Object)this));
        this.resourceMap = ImmoToolUtils.getResourceMap(ContactsGroupViewPanel.class);
        this.initComponents();
        this.buildGroupFormPanel();
        this.resourceMap.injectComponents((Component)((Object)this));
        this.tabPanel.setTitleAt(0, this.resourceMap.getString("groupTab", new Object[0]));
        this.titleLabel.setTitle(this.resourceMap.getString("tabTitle.new", new Object[0]));
        this.actionsMenu = new JPopupMenu();
        this.actionsMenu.add(new JMenuItem(this.actionMap.get("doCopy")));
        this.actionsMenu.add(new JMenuItem(this.actionMap.get("doRemove")));
        this.actionsMenu.addSeparator();
        this.actionsMenu.add(new JMenuItem(this.actionMap.get("doPrintNotes")));
        this.getActionMap().put("doViewNext", this.actionMap.get("doViewNext"));
        this.getInputMap().put(KeyStroke.getKeyStroke("alt pressed PAGE_UP"), "doViewNext");
        this.getInputMap().put(KeyStroke.getKeyStroke("ctrl pressed RIGHT"), "doViewNext");
        this.getActionMap().put("doViewPrevious", this.actionMap.get("doViewPrevious"));
        this.getInputMap().put(KeyStroke.getKeyStroke("alt pressed PAGE_DOWN"), "doViewPrevious");
        this.getInputMap().put(KeyStroke.getKeyStroke("ctrl pressed LEFT"), "doViewPrevious");
        this.setButtonsEnabled(true);
        if (SystemUtils.IS_OS_MAC_OSX) {
            this.tabPanel.setTabPlacement(1);
        }
    }

    private void buildGroupFormPanel() {
        this.groupNameField = new JTextField();
        this.groupNameField.setName("groupNameField");
        this.groupTextField = new RTextArea();
        this.groupTextField.setName("groupTextField");
        this.groupTextField.setLineWrap(true);
        this.groupTextField.setWrapStyleWord(true);
        if (this.groupTextField.getPopupMenu() != null) {
            this.groupTextField.getPopupMenu().add(new JMenuItem(this.actionMap.get("doPrintNotes")));
        }
        this.validationHandler.putRule((JComponent)this.groupNameField, ValidationHandler.NOT_BLANK);
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"pref:grow");
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("label.groupName", new Object[0])));
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.groupNameField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)new JLabel(" "));
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("label.groupDescription", new Object[0])));
        defaultFormBuilder.nextLine();
        JScrollPane jScrollPane = new JScrollPane((Component)this.groupTextField);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(20);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.groupFormPanel.setBorder(Borders.DIALOG);
        this.groupFormPanel.setLayout(new BorderLayout(5, 5));
        this.groupFormPanel.add((Component)defaultFormBuilder.getPanel(), "North");
        this.groupFormPanel.add((Component)jScrollPane, "Center");
        this.groupFormPanel.revalidate();
        this.groupFormPanel.repaint();
    }

    public static String getInstanceTabTitle(long l) {
        return l > 0L ? ImmoToolUtils.getResourceMap(ContactsGroupViewPanel.class).getString("tabTitle.edit", new Object[]{l}) : ImmoToolUtils.getResourceMap(ContactsGroupViewPanel.class).getString("tabTitle.new", new Object[0]);
    }

    public String getTabInfo() {
        if (this.groupId <= 0L) {
            return this.resourceMap.getString("tabInfo.new", new Object[0]);
        }
        return this.groupInfo;
    }

    public String getTabTitle() {
        return ContactsGroupViewPanel.getInstanceTabTitle(this.groupId);
    }

    public boolean isTabModified() {
        return this.modifications.isModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(ContactsGroup contactsGroup) {
        this.nextGroupId = 0L;
        this.prevGroupId = 0L;
        this.groupId = contactsGroup.getId();
        this.groupInfo = this.groupId > 0L ? contactsGroup.getName() : null;
        this.groupNameField.setText(contactsGroup.getName());
        this.groupTextField.setText(contactsGroup.getDescription());
        this.titleLabel.setTitle(ContactsGroupViewPanel.getInstanceTabTitle(this.groupId));
        ImmoToolUtils.updateTabs();
        if (this.groupId > 0L) {
            long l = this.groupId;
            Collection collection = null;
            try {
                collection = ContactsPluginUtils.openPluginCollection("");
                String string = "declare namespace xmldb=\"http://exist-db.org/xquery/xmldb\";\nfor $x in xmldb:xcollection('ImmoTool/OpenEstate-Contacts')/properties/entry[@key=\"id\"]\nreturn <row id=\"{$x/text()}\" />";
                ResourceSet resourceSet = ImmoToolDbUtils.executeXQuery((Collection)collection, (String)string);
                for (long i = 0L; i < resourceSet.getSize(); ++i) {
                    try {
                        XMLResource xMLResource = (XMLResource)resourceSet.getResource(i);
                        Node node = xMLResource.getContentAsDOM();
                        Long l2 = Long.valueOf(node.getAttributes().getNamedItem("id").getNodeValue());
                        if (l2 > l && (l2 < this.nextGroupId || this.nextGroupId <= 0L)) {
                            this.nextGroupId = l2;
                        }
                        if (l2 >= l || l2 <= this.prevGroupId && this.prevGroupId > 0L) continue;
                        this.prevGroupId = l2;
                        continue;
                    }
                    catch (Exception exception) {
                        LOGGER.warn((Object)"Can't extract id!");
                        LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    }
                }
            }
            catch (Exception exception) {
                this.nextGroupId = 0L;
                this.prevGroupId = 0L;
                LOGGER.warn((Object)"Can't load previous and next entry!");
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
            finally {
                ImmoToolDbUtils.close((Collection)collection);
            }
        }
        this.modifications.clear();
        this.modifications.putValue((JComponent)this.groupNameField);
        this.modifications.putValue((JComponent)this.groupTextField);
        if (this.groupId > 0L) {
            this.validationHandler.validate();
        } else {
            this.validationHandler.init();
        }
        this.setButtonsEnabled(true);
    }

    public void refreshTab() {
        if (this.groupId <= 0L) {
            return;
        }
        ImmoToolTask<Boolean> immoToolTask = new ImmoToolTask<Boolean>(){

            protected Boolean executeTask() throws Exception {
                ContactsGroupViewPanel.this.load(ContactsGroup.load(ContactsGroupViewPanel.this.groupId));
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)ContactsGroupViewPanel.this.resourceMap.getString("error.cantRefresh", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                ContactsGroupViewPanel.this.setButtonsEnabled(true);
            }
        };
        this.setButtonsEnabled(false);
        ImmoToolUtils.executeTask((Task)immoToolTask);
    }

    public void save(ContactsGroup contactsGroup) {
        contactsGroup.setName(ImmoToolUtils.replaceTags((String)this.groupNameField.getText()).trim());
        contactsGroup.setDescription(ImmoToolUtils.replaceTags((String)this.groupTextField.getText()).trim());
    }

    public ImmoToolTask saveModifications() {
        return (ImmoToolTask)this.doSubmit();
    }

    private void setButtonsEnabled(boolean bl) {
        this.submitButton.setEnabled(bl);
        this.closeButton.setEnabled(bl);
        this.actionButton.setEnabled(bl && this.groupId > 0L);
        this.nextButton.setEnabled(bl && this.nextGroupId > 0L);
        this.prevButton.setEnabled(bl && this.prevGroupId > 0L);
    }

    private void initComponents() {
        this.titleLabel = ImmoToolUtils.createHead1Separator((String)"");
        this.prevButton = new JButton();
        this.nextButton = new JButton();
        this.submitButton = new JButton();
        this.actionButton = new JButton();
        this.helpButton = new JButton();
        this.closeButton = new JButton();
        this.tabPanel = new JTabbedPane();
        this.groupFormPanel = new JPanel();
        this.setName("Form");
        this.titleLabel.setName("titleLabel");
        ApplicationActionMap applicationActionMap = Application.getInstance().getContext().getActionMap(ContactsGroupViewPanel.class, (Object)this);
        this.prevButton.setAction(applicationActionMap.get("doViewPrevious"));
        this.prevButton.setName("prevButton");
        this.nextButton.setAction(applicationActionMap.get("doViewNext"));
        this.nextButton.setName("nextButton");
        this.submitButton.setAction(applicationActionMap.get("doSubmit"));
        this.submitButton.setName("submitButton");
        this.actionButton.setAction(applicationActionMap.get("doAction"));
        this.actionButton.setName("actionButton");
        this.helpButton.setAction(applicationActionMap.get("doHelp"));
        this.helpButton.setName("helpButton");
        this.closeButton.setAction(applicationActionMap.get("doClose"));
        this.closeButton.setName("closeButton");
        this.tabPanel.setTabPlacement(2);
        this.tabPanel.setName("tabPanel");
        this.groupFormPanel.setName("groupFormPanel");
        GroupLayout groupLayout = new GroupLayout(this.groupFormPanel);
        this.groupFormPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 577, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 363, Short.MAX_VALUE));
        this.tabPanel.addTab("group", this.groupFormPanel);
        GroupLayout groupLayout2 = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.tabPanel, -1, 647, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addComponent((Component)this.titleLabel, -1, 303, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.prevButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nextButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.submitButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.actionButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.helpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton))).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeButton).addComponent(this.helpButton).addComponent(this.actionButton).addComponent(this.submitButton).addComponent(this.nextButton).addComponent(this.prevButton)).addComponent((Component)this.titleLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tabPanel, -1, 370, Short.MAX_VALUE).addContainerGap()));
        ResourceMap resourceMap = Application.getInstance().getContext().getResourceMap(ContactsGroupViewPanel.class);
        resourceMap.injectComponents((Component)((Object)this));
    }

    @Action
    public void doAction() {
        this.actionsMenu.show(this.actionButton, 0, this.actionButton.getSize().height);
    }

    @Action
    public void doClose() {
        ImmoToolUtils.removePanel((String)this.getTabTitle());
    }

    @Action
    public Task doCopy() {
        if (this.groupId <= 0L) {
            return null;
        }
        this.validationHandler.validate();
        if (!this.validationHandler.isValid()) {
            ImmoToolUtils.showMessageWarningDialog((String)this.resourceMap.getString("error.invalidInput", new Object[0]));
            return null;
        }
        this.closeButton.setEnabled(false);
        this.submitButton.setEnabled(false);
        return new ImmoToolTask<ContactsGroup>(this.resourceMap.getString("doCopy.Action.text", new Object[0])){

            protected ContactsGroup executeTask() throws Exception {
                ContactsGroup contactsGroup = ContactsGroup.load(ContactsGroupViewPanel.this.groupId);
                if (contactsGroup == null) {
                    throw new Exception("group #" + ContactsGroupViewPanel.this.groupId + " not found!");
                }
                contactsGroup.setId(0L);
                ContactsGroupViewPanel.this.save(contactsGroup);
                contactsGroup.save();
                ContactsGroupViewPanel.this.load(contactsGroup);
                return contactsGroup;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)ContactsGroupViewPanel.this.resourceMap.getString("error.cantSaveGroup", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                ContactsGroupViewPanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(ContactsGroup contactsGroup) {
                super.succeeded((Object)contactsGroup);
                ImmoToolUtils.updateTabs();
            }
        };
    }

    @Action
    public void doHelp() {
        ImmoToolUtils.showHelpDialog((String)"contacts.groups.form");
    }

    @Action
    public void doPrintNotes() {
        try {
            ImmoToolUtils.print((Printable)this.groupTextField);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Printing failed!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)"Printing failed!", (Throwable)exception);
        }
    }

    @Action
    public Task doRemove() {
        if (this.groupId <= 0L) {
            return null;
        }
        boolean bl = ImmoToolUtils.showQuestionDialog((String)this.resourceMap.getString("question.reallyDeleteGroup", new Object[]{this.groupId}));
        if (!bl) {
            return null;
        }
        this.setButtonsEnabled(false);
        return new ImmoToolTask<Boolean>(this.resourceMap.getString("doRemove.Action.text", new Object[0])){

            protected Boolean executeTask() throws Exception {
                ContactsGroup contactsGroup = ContactsGroup.load(ContactsGroupViewPanel.this.groupId);
                if (contactsGroup == null) {
                    throw new Exception("could not load group #" + ContactsGroupViewPanel.this.groupId);
                }
                contactsGroup.remove();
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)ContactsGroupViewPanel.this.resourceMap.getString("error.cantRemoveGroup", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                ContactsGroupViewPanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(Boolean bl) {
                super.succeeded((Object)bl);
                if (Boolean.TRUE.equals(bl)) {
                    ImmoToolUtils.removePanel((String)ContactsGroupViewPanel.this.getTabTitle(), (boolean)true);
                }
            }
        };
    }

    @Action
    public Task doSubmit() {
        this.validationHandler.validate();
        if (!this.validationHandler.isValid()) {
            ImmoToolUtils.showMessageWarningDialog((String)this.resourceMap.getString("error.invalidInput", new Object[0]));
            return null;
        }
        this.setButtonsEnabled(false);
        return new ImmoToolTask<ContactsGroup>(this.resourceMap.getString("doSubmit.Action.text", new Object[0])){

            protected ContactsGroup executeTask() throws Exception {
                ContactsGroup contactsGroup;
                ContactsGroup contactsGroup2 = contactsGroup = ContactsGroupViewPanel.this.groupId <= 0L ? new ContactsGroup() : ContactsGroup.load(ContactsGroupViewPanel.this.groupId);
                if (contactsGroup == null) {
                    throw new Exception("group #" + ContactsGroupViewPanel.this.groupId + " not found!");
                }
                ContactsGroupViewPanel.this.save(contactsGroup);
                contactsGroup.save();
                ContactsGroupViewPanel.this.load(contactsGroup);
                return contactsGroup;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)ContactsGroupViewPanel.this.resourceMap.getString("error.cantSaveGroup", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                ContactsGroupViewPanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(ContactsGroup contactsGroup) {
                super.succeeded((Object)contactsGroup);
                ImmoToolUtils.updateTabs();
            }
        };
    }

    @Action
    public Task doViewNext() {
        if (this.nextGroupId <= 0L) {
            return null;
        }
        if (!this.checkForModifications()) {
            return null;
        }
        this.setButtonsEnabled(false);
        return new ImmoToolTask<ContactsGroup>(){

            protected ContactsGroup executeTask() throws Exception {
                ContactsGroup contactsGroup = ContactsGroup.load(ContactsGroupViewPanel.this.nextGroupId);
                if (contactsGroup == null) {
                    throw new Exception("Group #" + ContactsGroupViewPanel.this.nextGroupId + " not found!");
                }
                ContactsGroupViewPanel.this.load(contactsGroup);
                return contactsGroup;
            }

            protected void finished() {
                super.finished();
                ContactsGroupViewPanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(ContactsGroup contactsGroup) {
                super.succeeded((Object)contactsGroup);
                ImmoToolUtils.updateTabs();
                ContactsGroupViewPanel.this.requestFocus();
            }
        };
    }

    @Action
    public Task doViewPrevious() {
        if (this.prevGroupId <= 0L) {
            return null;
        }
        if (!this.checkForModifications()) {
            return null;
        }
        this.setButtonsEnabled(false);
        return new ImmoToolTask<ContactsGroup>(){

            protected ContactsGroup executeTask() throws Exception {
                ContactsGroup contactsGroup = ContactsGroup.load(ContactsGroupViewPanel.this.prevGroupId);
                if (contactsGroup == null) {
                    throw new Exception("Group #" + ContactsGroupViewPanel.this.prevGroupId + " not found!");
                }
                ContactsGroupViewPanel.this.load(contactsGroup);
                return contactsGroup;
            }

            protected void finished() {
                super.finished();
                ContactsGroupViewPanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(ContactsGroup contactsGroup) {
                super.succeeded((Object)contactsGroup);
                ImmoToolUtils.updateTabs();
                ContactsGroupViewPanel.this.requestFocus();
            }
        };
    }
}

