/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts;

import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.SerializableXmlElement;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolDb;
import com.openindex.openestate.tool.ImmoToolDbException;
import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolPlugin;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolTaskDialog;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.contacts.ContactsEntry;
import com.openindex.openestate.tool.contacts.ContactsEntryExportCsvTask;
import com.openindex.openestate.tool.contacts.ContactsEntryExportDialog;
import com.openindex.openestate.tool.contacts.ContactsEntryExportVcardTask;
import com.openindex.openestate.tool.contacts.ContactsEntryExportXlsTask;
import com.openindex.openestate.tool.contacts.ContactsEntryImportCsvTask;
import com.openindex.openestate.tool.contacts.ContactsEntryImportVCardTask;
import com.openindex.openestate.tool.contacts.ContactsEntryTablePanel;
import com.openindex.openestate.tool.contacts.ContactsGroup;
import com.openindex.openestate.tool.contacts.ContactsGroupTablePanel;
import com.openindex.openestate.tool.contacts.ContactsPluginUtils;
import com.openindex.openestate.tool.utils.CsvImportDialog;
import com.openindex.openestate.tool.utils.CsvImportTask;
import com.openindex.openestate.tool.utils.JOptionFileChooser;
import com.openindex.openestate.tool.utils.TabComponent;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.util.Date;
import java.util.Properties;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.application.TaskEvent;
import org.jdesktop.application.TaskListener;
import org.jdesktop.swingx.JXTaskPane;
import org.xmldb.api.base.Collection;

public final class ContactsPlugin
extends ImmoToolPlugin {
    private static final Logger LOGGER = Logger.getLogger(ContactsPlugin.class);
    public static final String PLUGIN_NAME = "OpenEstate-Contacts";
    public static final String PLUGIN_URL = "http://media.openestate.org/Plugins/OpenEstate-Tool-Contacts.xml";
    public static final String PLUGIN_DB_PATH = "ImmoTool/OpenEstate-Contacts";
    public static final String PLUGIN_RES_PATH = "/com/openindex/openestate/tool/contacts/resources/";
    public static final String DB_SEQUENCE_CONTACT = "OpenEstate-Contacts.Contact";
    public static final String DB_SEQUENCE_GROUP = "OpenEstate-Contacts.Group";
    private static File lastExportLocation = null;

    public HelpSet createHelpSet() throws HelpSetException {
        URL uRL = ((Object)((Object)this)).getClass().getResource("/com/openindex/openestate/tool/contacts/resources/help/help.hs");
        return new HelpSet(null, uRL);
    }

    public JMenu createMenu() {
        JMenu jMenu = new JMenu(this.getResourceMap().getString("Title", new Object[0]));
        jMenu.add(new JMenuItem(this.getActionMap().get("doShowContacts")));
        jMenu.add(new JMenuItem(this.getActionMap().get("doShowGroups")));
        jMenu.addSeparator();
        JMenu jMenu2 = new JMenu();
        jMenu2.setName("importMenu");
        this.getResourceMap().injectComponent((Component)jMenu2);
        jMenu2.add(new JMenuItem(this.getActionMap().get("doImportFromCsv")));
        jMenu2.add(new JMenuItem(this.getActionMap().get("doImportFromVcard")));
        jMenu.add(jMenu2);
        jMenu.add(new JMenuItem(this.getActionMap().get("doExport")));
        return jMenu;
    }

    public JXTaskPane createTaskPane() {
        JXTaskPane jXTaskPane = new JXTaskPane();
        jXTaskPane.setTitle(this.getResourceMap().getString("Title", new Object[0]));
        jXTaskPane.add(this.getActionMap().get("doShowContacts"));
        jXTaskPane.add(this.getActionMap().get("doShowGroups"));
        return jXTaskPane;
    }

    public void destroy() {
    }

    @Action
    public void doImportFromCsv() {
        CsvImportDialog csvImportDialog;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(this.getResourceMap().getString("label.importCsvFile", new Object[0]));
        jFileChooser.setApproveButtonText(this.getResourceMap().getString("label.importCsvFile.approve", new Object[0]));
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(".csv") || file.getName().toLowerCase().endsWith(".txt");
            }

            @Override
            public String getDescription() {
                return ContactsPlugin.this.getResourceMap().getString("label.filter.csv", new Object[]{"*.csv, *.txt"});
            }
        });
        int n = jFileChooser.showOpenDialog(ImmoToolApp.getApplication() != null ? ImmoToolApp.getApplication().getMainFrame() : null);
        if (n != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        ContactsEntryImportCsvTask contactsEntryImportCsvTask = new ContactsEntryImportCsvTask(file);
        try {
            csvImportDialog = new CsvImportDialog(file, (CsvImportTask)contactsEntryImportCsvTask);
            csvImportDialog.setVisible(true);
            if (csvImportDialog.getStatus() != 2) {
                return;
            }
            csvImportDialog.configureTask((CsvImportTask)contactsEntryImportCsvTask);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"cant import csv-file!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)this.getResourceMap().getString("error.cantImportCsvFile", new Object[0]), (Throwable)exception);
            return;
        }
        csvImportDialog = new ImmoToolTaskDialog();
        csvImportDialog.addTask((ImmoToolTask)contactsEntryImportCsvTask);
        csvImportDialog.execute();
    }

    @Action
    public void doImportFromVcard() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(this.getResourceMap().getString("label.importVCardFile", new Object[0]));
        jFileChooser.setApproveButtonText(this.getResourceMap().getString("label.importVCardFile.approve", new Object[0]));
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(".vcf") || file.getName().toLowerCase().endsWith(".vcard");
            }

            @Override
            public String getDescription() {
                return ContactsPlugin.this.getResourceMap().getString("label.filter.vcard", new Object[]{"*.vcf, *.vcard"});
            }
        });
        int n = jFileChooser.showOpenDialog(ImmoToolApp.getApplication() != null ? ImmoToolApp.getApplication().getMainFrame() : null);
        if (n != 0) {
            return;
        }
        ContactsEntryImportVCardTask contactsEntryImportVCardTask = new ContactsEntryImportVCardTask(jFileChooser.getSelectedFile());
        ImmoToolTaskDialog immoToolTaskDialog = new ImmoToolTaskDialog();
        immoToolTaskDialog.addTask((ImmoToolTask)contactsEntryImportVCardTask);
        immoToolTaskDialog.execute();
    }

    @Action
    public Task doExport() {
        Object object;
        block15: {
            File file = ContactsPlugin.getLastExportLocation();
            object = null;
            try {
                ContactsEntryExportDialog contactsEntryExportDialog = new ContactsEntryExportDialog();
                contactsEntryExportDialog.loadContactGroups();
                contactsEntryExportDialog.setVisible(true);
                if (contactsEntryExportDialog.getStatus() != 2) {
                    return null;
                }
                final boolean bl = contactsEntryExportDialog.isCsvSelected();
                final boolean bl2 = contactsEntryExportDialog.isXlsSelected();
                final boolean bl3 = contactsEntryExportDialog.isVCardSelected();
                Charset charset = contactsEntryExportDialog.getSelectedCharset();
                Long l = contactsEntryExportDialog.getSelectedContactGroup();
                if (!(bl || bl2 || bl3)) {
                    throw new Exception("invalid export-format!");
                }
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setDialogTitle(this.getResourceMap().getString("label.export", new Object[0]));
                jFileChooser.setApproveButtonText(this.getResourceMap().getString("label.export.approve", new Object[0]));
                String string = null;
                if (bl) {
                    string = this.getResourceMap().getString("label.export.csvFile", new Object[]{System.currentTimeMillis()});
                } else if (bl3) {
                    string = this.getResourceMap().getString("label.export.vcardFile", new Object[]{System.currentTimeMillis()});
                } else if (bl2) {
                    string = this.getResourceMap().getString("label.export.xlsFile", new Object[]{System.currentTimeMillis()});
                }
                if (file == null) {
                    jFileChooser.setSelectedFile(new File(string));
                } else {
                    jFileChooser.setSelectedFile(new File(file.getAbsolutePath() + File.separator + string));
                }
                jFileChooser.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.isDirectory() || bl && file.getName().toLowerCase().endsWith(".csv") || bl2 && file.getName().toLowerCase().endsWith(".xls") || bl3 && file.getName().toLowerCase().endsWith(".vcf") || bl3 && file.getName().toLowerCase().endsWith(".vcard");
                    }

                    @Override
                    public String getDescription() {
                        if (bl) {
                            return ContactsPlugin.this.getResourceMap().getString("label.filter.csv", new Object[]{"*.csv"});
                        }
                        if (bl2) {
                            return ContactsPlugin.this.getResourceMap().getString("label.filter.xls", new Object[]{"*.xls"});
                        }
                        if (bl3) {
                            return ContactsPlugin.this.getResourceMap().getString("label.filter.vcard", new Object[]{"*.vcf, *.vcard"});
                        }
                        return null;
                    }
                });
                int n = jFileChooser.showSaveDialog(ImmoToolApp.getApplication() != null ? ImmoToolApp.getApplication().getMainFrame() : null);
                if (n != 0) {
                    return null;
                }
                final ResourceMap resourceMap = this.getResourceMap();
                final File file2 = jFileChooser.getSelectedFile();
                ContactsPlugin.setLastExportLocation(file2.getAbsoluteFile().getParentFile());
                if (bl) {
                    object = new ContactsEntryExportCsvTask(file2, charset, l){

                        protected void failed(Throwable throwable) {
                            super.failed(throwable);
                            ImmoToolUtils.showMessageErrorDialog((String)resourceMap.getString("error.cantExportFile", new Object[0]), (Throwable)throwable);
                        }

                        protected void succeeded(Long l) {
                            super.succeeded((Object)l);
                            ImmoToolUtils.showMessageInfoDialog((String)resourceMap.getString("message.exportSuccessful", new Object[]{file2.getAbsolutePath()}), (Component)(ImmoToolApp.getApplication() != null ? ImmoToolApp.getApplication().getMainFrame() : null));
                        }
                    };
                    break block15;
                }
                if (bl2) {
                    object = new ContactsEntryExportXlsTask(file2, charset, l){

                        protected void failed(Throwable throwable) {
                            super.failed(throwable);
                            ImmoToolUtils.showMessageErrorDialog((String)resourceMap.getString("error.cantExportFile", new Object[0]), (Throwable)throwable);
                        }

                        protected void succeeded(Long l) {
                            super.succeeded((Object)l);
                            ImmoToolUtils.showMessageInfoDialog((String)resourceMap.getString("message.exportSuccessful", new Object[]{file2.getAbsolutePath()}), (Component)(ImmoToolApp.getApplication() != null ? ImmoToolApp.getApplication().getMainFrame() : null));
                        }
                    };
                    break block15;
                }
                if (bl3) {
                    object = new ContactsEntryExportVcardTask(file2, charset, l){

                        protected void failed(Throwable throwable) {
                            super.failed(throwable);
                            ImmoToolUtils.showMessageErrorDialog((String)resourceMap.getString("error.cantExportFile", new Object[0]), (Throwable)throwable);
                        }

                        protected void succeeded(Long l) {
                            super.succeeded((Object)l);
                            ImmoToolUtils.showMessageInfoDialog((String)resourceMap.getString("message.exportSuccessful", new Object[]{file2.getAbsolutePath()}), (Component)(ImmoToolApp.getApplication() != null ? ImmoToolApp.getApplication().getMainFrame() : null));
                        }
                    };
                    break block15;
                }
                throw new Exception("no export-task was created!");
            }
            catch (Exception exception) {
                LOGGER.error((Object)"cant export to table!");
                LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                ImmoToolUtils.showMessageErrorDialog((String)this.getResourceMap().getString("error.cantExportFile", new Object[0]), (Throwable)exception);
            }
        }
        return object;
    }

    @Action
    public Task doShowContacts() {
        String string = ContactsEntryTablePanel.getInstanceTabTitle();
        if (ImmoToolUtils.selectPanel((String)string)) {
            return null;
        }
        final ResourceMap resourceMap = this.getResourceMap();
        return new ImmoToolTask<ContactsEntryTablePanel>(){

            protected ContactsEntryTablePanel executeTask() throws Exception {
                ContactsEntryTablePanel contactsEntryTablePanel = new ContactsEntryTablePanel();
                contactsEntryTablePanel.loadGroups();
                return contactsEntryTablePanel;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)resourceMap.getString("error.cantOpenAdressTable", new Object[0]), (Throwable)throwable);
            }

            protected void succeeded(ContactsEntryTablePanel contactsEntryTablePanel) {
                super.succeeded((Object)contactsEntryTablePanel);
                ImmoToolUtils.showPanel((TabComponent)contactsEntryTablePanel);
                ImmoToolUtils.executeTask((Task)contactsEntryTablePanel.doSearch());
            }
        };
    }

    @Action
    public Task doShowGroups() {
        String string = ContactsGroupTablePanel.getInstanceTabTitle();
        if (ImmoToolUtils.selectPanel((String)string)) {
            return null;
        }
        final ContactsGroupTablePanel contactsGroupTablePanel = new ContactsGroupTablePanel();
        Task task = contactsGroupTablePanel.doRefresh();
        task.addTaskListener(new TaskListener(){

            public void doInBackground(TaskEvent taskEvent) {
            }

            public void process(TaskEvent taskEvent) {
            }

            public void succeeded(TaskEvent taskEvent) {
                ImmoToolUtils.showPanel((TabComponent)contactsGroupTablePanel);
            }

            public void failed(TaskEvent taskEvent) {
                ImmoToolUtils.showMessageErrorDialog((String)ContactsPlugin.this.getResourceMap().getString("error.cantOpenGroupTable", new Object[0]));
            }

            public void cancelled(TaskEvent taskEvent) {
            }

            public void interrupted(TaskEvent taskEvent) {
            }

            public void finished(TaskEvent taskEvent) {
            }
        });
        return task;
    }

    public void exportDatabase(File file, ImmoToolDb immoToolDb, ImmoToolProject immoToolProject, JOptionFileChooser jOptionFileChooser, ImmoToolTask.Callback callback) throws ImmoToolException {
        File file2 = new File(file.getAbsolutePath() + File.separator + "OpenEstate-Tool-Contacts");
        if (!file2.exists() && !file2.mkdir()) {
            throw new ImmoToolException("Can't create directory: " + file2.getAbsolutePath());
        }
        File file3 = new File(file2.getAbsolutePath() + File.separator + "groups");
        if (!file3.exists() && !file3.mkdir()) {
            throw new ImmoToolException("Can't create directory: " + file3.getAbsolutePath());
        }
        File file4 = new File(file2.getAbsolutePath() + File.separator + "entries");
        if (!file4.exists() && !file4.mkdir()) {
            throw new ImmoToolException("Can't create directory: " + file4.getAbsolutePath());
        }
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);
        String string = "exported at " + dateFormat.format(new Date());
        Collection collection = null;
        Collection collection2 = null;
        try {
            collection = ContactsPluginUtils.openPluginCollection("");
            for (ContactsGroup contactsGroup : ContactsGroup.loadGroups(collection)) {
                Serializable serializable;
                FileOutputStream fileOutputStream = null;
                try {
                    if (callback != null) {
                        callback.setMessage("> /group." + contactsGroup.getId() + ".xml");
                    }
                    serializable = new Properties();
                    contactsGroup.save((Properties)serializable);
                    fileOutputStream = new FileOutputStream(new File(file3.getAbsolutePath() + File.separator + contactsGroup.getId() + ".xml"));
                    ((Properties)serializable).storeToXML(fileOutputStream, string);
                    fileOutputStream.flush();
                }
                catch (Exception exception) {
                    try {
                        if (callback != null) {
                            callback.setMessage("> Can't save contact group #" + contactsGroup.getId());
                            callback.setMessage("> " + exception.getLocalizedMessage());
                        }
                        throw new Exception("Can't save contact group #" + contactsGroup.getId(), exception);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(fileOutputStream);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((OutputStream)fileOutputStream);
                serializable = new File(file4.getAbsolutePath() + File.separator + contactsGroup.getId());
                if (!((File)serializable).exists() && !((File)serializable).mkdir()) {
                    throw new Exception("Can't create directory: " + ((File)serializable).getAbsolutePath());
                }
                collection2 = ContactsPluginUtils.openPluginCollection("/" + contactsGroup.getId());
                for (String string2 : collection2.listResources()) {
                    FileWriter fileWriter = null;
                    try {
                        if (!string2.startsWith("contact.") || !string2.endsWith(".xml")) continue;
                        if (callback != null) {
                            callback.setMessage("> /" + contactsGroup.getId() + "/" + string2);
                        }
                        String[] stringArray = string2.split("\\.");
                        Long l = Long.valueOf(stringArray[stringArray.length - 2]);
                        ContactsEntry contactsEntry = ContactsEntry.load(contactsGroup.getId(), l, collection2);
                        if (contactsEntry == null) continue;
                        fileWriter = new FileWriter(new File(((File)serializable).getAbsolutePath() + File.separator + contactsEntry.getId() + ".xml"));
                        OpenEstateUtils.serializeToXML((SerializableXmlElement)contactsEntry.getAdress(), (Writer)fileWriter, (boolean)false);
                        IOUtils.closeQuietly((Writer)fileWriter);
                    }
                    catch (Exception exception) {
                        if (callback != null) {
                            callback.setMessage("> Can't save contact entry '" + string2 + "' of group #" + contactsGroup.getId());
                            callback.setMessage("> " + exception.getLocalizedMessage());
                        }
                        throw new Exception("Can't save contact entry '" + string2 + "' of group #" + contactsGroup.getId(), exception);
                    }
                    finally {
                        IOUtils.closeQuietly(fileWriter);
                    }
                }
                collection2.close();
                collection2 = null;
            }
        }
        catch (Exception exception) {
            if (callback != null) {
                callback.setMessage("> Can't save contacts!");
                callback.setMessage("> " + exception.getLocalizedMessage());
            }
            throw new ImmoToolException("Can't save contacts!", (Throwable)exception);
        }
        finally {
            ImmoToolDbUtils.close(collection2);
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public BufferedImage getIcon() {
        try {
            return ImageIO.read(((Object)((Object)this)).getClass().getResourceAsStream(this.getResourceMap().getString("Plugin.Icon", new Object[0])));
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not load plugin-icon!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return null;
        }
    }

    public static ContactsPlugin getInstance() {
        return (ContactsPlugin)ImmoToolApp.getApplication().getProject().getPlugin(PLUGIN_NAME);
    }

    public static File getLastExportLocation() {
        return lastExportLocation;
    }

    public String getName() {
        return PLUGIN_NAME;
    }

    public final URI getURI() {
        try {
            return new URL(PLUGIN_URL).toURI();
        }
        catch (Exception exception) {
            throw new RuntimeException("could not load plugin: " + exception.getLocalizedMessage(), exception);
        }
    }

    public boolean hasOptions() {
        return false;
    }

    public void init(Object ... objectArray) {
    }

    public void initDatabase(ImmoToolDb immoToolDb, ImmoToolProject immoToolProject, ImmoToolTask.Callback callback) throws ImmoToolException {
        super.initDatabase(immoToolDb, immoToolProject, callback);
        Collection collection = null;
        try {
            collection = ContactsPluginUtils.openPluginCollection(immoToolDb, "");
            if (collection == null) {
                collection = immoToolDb.createCollection(PLUGIN_DB_PATH);
                ContactsGroup contactsGroup = new ContactsGroup();
                contactsGroup.setName(this.getResourceMap().getString("label.defaultAdressbook.business", new Object[0]));
                contactsGroup.setDescription(this.getResourceMap().getString("label.defaultAdressbook.business.info", new Object[0]));
                contactsGroup.save(collection, immoToolDb);
                contactsGroup = new ContactsGroup();
                contactsGroup.setName(this.getResourceMap().getString("label.defaultAdressbook.private", new Object[0]));
                contactsGroup.setDescription(this.getResourceMap().getString("label.defaultAdressbook.private.info", new Object[0]));
                contactsGroup.save(collection, immoToolDb);
            }
        }
        catch (Exception exception) {
            throw new ImmoToolDbException("db-init-error: " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public void load() {
        super.load();
    }

    public void openOptions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildDatabase(ImmoToolDb immoToolDb, ImmoToolProject immoToolProject, ImmoToolTask.Callback callback) {
        Collection collection = null;
        Collection collection2 = null;
        try {
            collection = ContactsPluginUtils.openPluginCollection("");
            for (ContactsGroup contactsGroup : ContactsGroup.loadGroups(collection)) {
                try {
                    if (callback != null) {
                        callback.setMessage("> /group." + contactsGroup.getId() + ".xml");
                    }
                    contactsGroup.save(collection);
                    collection2 = ContactsPluginUtils.openPluginCollection("/" + contactsGroup.getId());
                    for (String string : collection2.listResources()) {
                        try {
                            if (!string.startsWith("contact.") || !string.endsWith(".xml")) continue;
                            if (callback != null) {
                                callback.setMessage("> /" + contactsGroup.getId() + "/" + string);
                            }
                            String[] stringArray = string.split("\\.");
                            Long l = Long.valueOf(stringArray[stringArray.length - 2]);
                            ContactsEntry contactsEntry = ContactsEntry.load(contactsGroup.getId(), l, collection2);
                            if (contactsEntry == null) continue;
                            contactsEntry.save(collection2);
                        }
                        catch (Exception exception) {
                            LOGGER.warn((Object)"Can't rebuild contact-entry!");
                            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                            if (callback == null) continue;
                            callback.setMessage("> ERROR: " + exception.getLocalizedMessage());
                        }
                    }
                    collection2.close();
                    collection2 = null;
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"Can't rebuild contact-groups!");
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    if (callback == null) continue;
                    callback.setMessage("> ERROR: " + exception.getLocalizedMessage());
                }
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't rebuild contacts!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            if (callback != null) {
                callback.setMessage("> ERROR: " + exception.getLocalizedMessage());
            }
        }
        finally {
            ImmoToolDbUtils.close(collection2);
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static synchronized void setLastExportLocation(File file) {
        lastExportLocation = file;
    }

    public void update(ImmoToolProject immoToolProject, ImmoToolDb immoToolDb, String string, String string2) throws ImmoToolException {
        super.update(immoToolProject, immoToolDb, string, string2);
    }
}

