/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.exist.memtree.DocumentBuilderReceiver;
import org.exist.memtree.DocumentImpl;
import org.exist.memtree.MemTreeBuilder;
import org.exist.memtree.SAXAdapter;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.NodeValue;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ModuleUtils {
    protected static final Logger LOG = Logger.getLogger((Class)ModuleUtils.class);

    public static NodeValue stringToXML(XQueryContext context, String xml) throws XPathException, SAXException {
        context.pushDocumentContext();
        XMLReader reader = null;
        try {
            reader = context.getBroker().getBrokerPool().getParserPool().borrowXMLReader();
            LOG.debug((Object)"Parsing XML response ...");
            InputSource src = new InputSource(new ByteArrayInputStream(xml.getBytes()));
            MemTreeBuilder builder = context.getDocumentBuilder();
            DocumentBuilderReceiver receiver = new DocumentBuilderReceiver(builder);
            reader.setContentHandler((ContentHandler)receiver);
            reader.parse(src);
            Document doc = receiver.getDocument();
            NodeValue nodeValue = (NodeValue)doc;
            return nodeValue;
        }
        catch (IOException e) {
            throw new XPathException(e.getMessage());
        }
        finally {
            context.popDocumentContext();
            if (reader != null) {
                context.getBroker().getBrokerPool().getParserPool().returnXMLReader(reader);
            }
        }
    }

    public static DocumentImpl htmlToXHtml(XQueryContext context, String url, InputSource srcHtml) throws XPathException, SAXException {
        DocumentImpl memtreeDoc = null;
        XMLReader reader = null;
        try {
            LOG.debug((Object)("Converting HTML to XML using NekoHTML parser for: " + url));
            reader = (XMLReader)Class.forName("org.cyberneko.html.parsers.SAXParser").newInstance();
            reader.setProperty("http://cyberneko.org/html/properties/names/elems", "match");
            reader.setProperty("http://cyberneko.org/html/properties/names/attrs", "no-change");
        }
        catch (Exception e) {
            String errorMsg = "Error while involing NekoHTML parser. (" + e.getMessage() + "). If you want to parse non-wellformed HTML files, put " + "nekohtml.jar into directory 'lib/user'.";
            LOG.error((Object)errorMsg, (Throwable)e);
            throw new XPathException(errorMsg, (Throwable)e);
        }
        SAXAdapter adapter = new SAXAdapter();
        reader.setContentHandler((ContentHandler)adapter);
        try {
            reader.parse(srcHtml);
        }
        catch (IOException e) {
            throw new XPathException(e.getMessage(), (Throwable)e);
        }
        Document doc = adapter.getDocument();
        memtreeDoc = (DocumentImpl)doc;
        memtreeDoc.setContext(context);
        return memtreeDoc;
    }

    public static Properties parseParameters(Node nParameters) throws XPathException {
        return ModuleUtils.parseProperties(nParameters, "param");
    }

    public static Properties parseProperties(Node nProperties) throws XPathException {
        return ModuleUtils.parseProperties(nProperties, "property");
    }

    private static final Properties parseProperties(Node container, String elementName) throws XPathException {
        Properties properties = new Properties();
        if (container != null && container.getNodeType() == 1) {
            NodeList params = ((Element)container).getElementsByTagName(elementName);
            for (int i = 0; i < params.getLength(); ++i) {
                Element param = (Element)params.item(i);
                String name = param.getAttribute("name");
                String value = param.getAttribute("value");
                if (name != null && value != null) {
                    properties.setProperty(name, value);
                    continue;
                }
                LOG.warn((Object)("Name or value attribute missing for " + elementName));
            }
        }
        return properties;
    }
}

