/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.compression;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.exist.collections.Collection;
import org.exist.dom.BinaryDocument;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.QName;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.serializers.Serializer;
import org.exist.util.LockException;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.Base64Binary;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.xml.sax.SAXException;

public class ZipFunction
extends BasicFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("zip", "http://exist-db.org/xquery/compression", "compression"), "Zip's resources and/or collections. $a is a sequence of URI's, if a URI points to a collectionthen the collection, its resources and sub-collections are zipped recursively. $b indicates whether to use the collection hierarchy in the zip file.", new SequenceType[]{new SequenceType(25, 6), new SequenceType(23, 2)}, new SequenceType(26, 7)), new FunctionSignature(new QName("zip", "http://exist-db.org/xquery/compression", "compression"), "Zip's resources and/or collections. $a is a sequence of URI's, if a URI points to a collectionthen the collection, its resources and sub-collections are zipped recursively. $b indicates whether to use the collection hierarchy in the zip file.$c is removed from the beginning of each file path.", new SequenceType[]{new SequenceType(25, 6), new SequenceType(23, 2), new SequenceType(22, 2)}, new SequenceType(26, 7))};

    public ZipFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        boolean useHierarchy = args[1].effectiveBooleanValue();
        String stripOffset = "";
        if (args.length == 3) {
            stripOffset = args[2].getStringValue();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(baos);
        SequenceIterator i = args[0].iterate();
        while (i.hasNext()) {
            AnyURIValue uri = (AnyURIValue)i.nextItem();
            DocumentImpl doc = null;
            try {
                doc = this.context.getBroker().getXMLResource(uri.toXmldbURI(), 0);
                if (doc == null) {
                    Collection col = this.context.getBroker().getCollection(uri.toXmldbURI());
                    if (col != null) {
                        this.zipCollection(zos, col, useHierarchy, stripOffset);
                        continue;
                    }
                    throw new XPathException(this.getASTNode(), "Invalid URI: " + uri.toString());
                }
                this.zipResource(zos, doc, useHierarchy, stripOffset);
            }
            catch (PermissionDeniedException pde) {
                throw new XPathException(this.getASTNode(), pde.getMessage());
            }
            catch (IOException ioe) {
                throw new XPathException(this.getASTNode(), ioe.getMessage());
            }
            catch (SAXException se) {
                throw new XPathException(this.getASTNode(), se.getMessage());
            }
            catch (LockException le) {
                throw new XPathException(this.getASTNode(), le.getMessage());
            }
            finally {
                if (doc == null) continue;
                doc.getUpdateLock().release(0);
            }
        }
        try {
            zos.close();
        }
        catch (IOException ioe) {
            throw new XPathException(this.getASTNode(), ioe.getMessage());
        }
        return new Base64Binary(baos.toByteArray());
    }

    private void zipResource(ZipOutputStream zos, DocumentImpl doc, boolean useHierarchy, String stripOffset) throws IOException, SAXException {
        ZipEntry entry = null;
        if (useHierarchy) {
            String docCollection = doc.getCollection().getURI().toString();
            if (docCollection.startsWith(stripOffset)) {
                docCollection = docCollection.substring(stripOffset.length());
            }
            if (docCollection.startsWith("/")) {
                docCollection = docCollection.substring(1);
            }
            XmldbURI collection = XmldbURI.create((String)docCollection);
            entry = new ZipEntry(collection.append(doc.getFileURI()).toString());
        } else {
            entry = new ZipEntry(doc.getFileURI().toString());
        }
        zos.putNextEntry(entry);
        if (doc.getResourceType() == 0) {
            Serializer serializer = this.context.getBroker().getSerializer();
            serializer.setUser(this.context.getUser());
            serializer.setProperty("omit-xml-declaration", (Object)"no");
            String strDoc = serializer.serialize(doc);
            zos.write(strDoc.getBytes());
        } else if (doc.getResourceType() == 1) {
            byte[] data = this.context.getBroker().getBinaryResource((BinaryDocument)doc);
            zos.write(data);
        }
        zos.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zipCollection(ZipOutputStream zos, Collection col, boolean useHierarchy, String stripOffset) throws IOException, SAXException, LockException {
        DocumentSet childDocs = new DocumentSet();
        col.getDocuments(this.context.getBroker(), childDocs, true);
        Iterator itChildDocs = childDocs.iterator();
        while (itChildDocs.hasNext()) {
            DocumentImpl childDoc = (DocumentImpl)itChildDocs.next();
            childDoc.getUpdateLock().acquire(0);
            try {
                this.zipResource(zos, childDoc, useHierarchy, stripOffset);
            }
            finally {
                childDoc.getUpdateLock().release(0);
            }
        }
        Iterator itChildCols = col.collectionIterator();
        while (itChildCols.hasNext()) {
            XmldbURI childColURI = (XmldbURI)itChildCols.next();
            Collection childCol = this.context.getBroker().getCollection(col.getURI().append(childColURI));
            this.zipCollection(zos, childCol, useHierarchy, stripOffset);
        }
    }
}

