/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.datetime;

import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.TimeValue;

public class FormatTimeFunction
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("format-time", "http://exist-db.org/xquery/datetime", "datetime"), "Returns a xs:string of the xs:time in $a formatted according to the template specification in $b as in java.text.SimpleDateFormat.", new SequenceType[]{new SequenceType(52, 2), new SequenceType(22, 2)}, new SequenceType(22, 2));

    public FormatTimeFunction(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        TimeValue t = (TimeValue)args[0].itemAt(0);
        String timeFormat = args[1].itemAt(0).toString();
        SimpleDateFormat sdf = new SimpleDateFormat(timeFormat);
        GregorianCalendar cal = t.calendar.toGregorianCalendar();
        String formattedDate = sdf.format(cal.getTime());
        return new StringValue(formattedDate);
    }
}

