/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.httpclient;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Vector;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.ProxyHost;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.exist.dom.QName;
import org.exist.memtree.DocumentBuilderReceiver;
import org.exist.memtree.MemTreeBuilder;
import org.exist.memtree.NodeImpl;
import org.exist.util.MimeTable;
import org.exist.util.MimeType;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.ModuleUtils;
import org.exist.xquery.value.Base64Binary;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class BaseHTTPClientFunction
extends BasicFunction {
    static final String NAMESPACE_URI = "http://exist-db.org/xquery/httpclient";
    static final String PREFIX = "httpclient";
    static final String HTTP_MODULE_PERSISTENT_COOKIES = "_eXist_httpclient_module_cookies";
    static final String HTTP_EXCEPTION_STATUS_CODE = "500";

    public BaseHTTPClientFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    protected void setHeaders(HttpMethod method, Node headers) throws XPathException {
        if (headers.getNodeType() == 1 && headers.getLocalName().equals("headers")) {
            NodeList headerList = headers.getChildNodes();
            for (int i = 0; i < headerList.getLength(); ++i) {
                Node header = headerList.item(i);
                if (header.getNodeType() != 1 || !header.getLocalName().equals("header")) continue;
                String name = ((Element)header).getAttribute("name");
                String value = ((Element)header).getAttribute("value");
                if (name == null || value == null) {
                    throw new XPathException(this.getASTNode(), "Name or value attribute missing for request header parameter");
                }
                method.addRequestHeader(new Header(name, value));
            }
        }
    }

    protected Sequence doRequest(XQueryContext context, HttpMethod method, boolean persistCookies) throws IOException, XPathException {
        Cookie[] cookies;
        int statusCode = 0;
        Sequence encodedResponse = null;
        if (persistCookies && (cookies = (Cookie[])context.getXQueryContextVar(HTTP_MODULE_PERSISTENT_COOKIES)) != null) {
            for (int c = 0; c < cookies.length; ++c) {
                method.setRequestHeader("Cookie", cookies[c].toExternalForm());
            }
        }
        HttpClient http = new HttpClient();
        try {
            String proxyHost = System.getProperty("http.proxyHost");
            if (proxyHost != null) {
                ProxyHost proxy = new ProxyHost(proxyHost, Integer.parseInt(System.getProperty("http.proxyPort")));
                http.getHostConfiguration().setProxyHost(proxy);
            }
            statusCode = http.executeMethod(method);
            encodedResponse = this.encodeResponseAsXML(context, method, statusCode);
            if (persistCookies) {
                HttpState state = http.getState();
                Cookie[] incomingCookies = state.getCookies();
                Cookie[] currentCookies = (Cookie[])context.getXQueryContextVar(HTTP_MODULE_PERSISTENT_COOKIES);
                context.setXQueryContextVar(HTTP_MODULE_PERSISTENT_COOKIES, (Object)this.mergeCookies(currentCookies, incomingCookies));
            }
        }
        catch (Exception e) {
            encodedResponse = this.encodeErrorResponse(context, e.getMessage());
        }
        return encodedResponse;
    }

    private Sequence encodeResponseAsXML(XQueryContext context, HttpMethod method, int statusCode) throws XPathException, IOException {
        NodeValue xmlResponse = null;
        MemTreeBuilder builder = context.getDocumentBuilder();
        builder.startDocument();
        builder.startElement(new QName("response", NAMESPACE_URI, PREFIX), null);
        builder.addAttribute(new QName("statusCode", null, null), String.valueOf(statusCode));
        builder.startElement(new QName("headers", NAMESPACE_URI, PREFIX), null);
        Header[] headers = method.getResponseHeaders();
        for (int i = 0; i < headers.length; ++i) {
            builder.startElement(new QName("header", NAMESPACE_URI, PREFIX), null);
            builder.addAttribute(new QName("name", null, null), headers[i].getName());
            builder.addAttribute(new QName("value", null, null), headers[i].getValue());
            builder.endElement();
        }
        builder.endElement();
        if (!(method instanceof HeadMethod) && !(method instanceof OptionsMethod)) {
            builder.startElement(new QName("body", NAMESPACE_URI, PREFIX), null);
            this.insertResponseBody(context, method, builder);
            builder.endElement();
        }
        builder.endElement();
        xmlResponse = (NodeValue)builder.getDocument().getDocumentElement();
        return xmlResponse;
    }

    private Sequence encodeErrorResponse(XQueryContext context, String message) throws IOException, XPathException {
        NodeValue xmlResponse = null;
        MemTreeBuilder builder = context.getDocumentBuilder();
        builder.startDocument();
        builder.startElement(new QName("response", NAMESPACE_URI, PREFIX), null);
        builder.addAttribute(new QName("statusCode", null, null), HTTP_EXCEPTION_STATUS_CODE);
        builder.startElement(new QName("body", NAMESPACE_URI, PREFIX), null);
        builder.addAttribute(new QName("type", null, null), "text");
        builder.addAttribute(new QName("encoding", null, null), "URLEncoded");
        if (message != null) {
            builder.characters((CharSequence)URLEncoder.encode(message, "UTF-8"));
        }
        builder.endElement();
        builder.endElement();
        xmlResponse = (NodeValue)builder.getDocument().getDocumentElement();
        return xmlResponse;
    }

    private void insertResponseBody(XQueryContext context, HttpMethod method, MemTreeBuilder builder) throws IOException, XPathException {
        boolean parsed = false;
        NodeImpl responseNode = null;
        String bodyAsString = method.getResponseBodyAsString();
        if (bodyAsString != null) {
            MimeType responseMimeType = this.getResponseMimeType(method.getResponseHeader("Content-Type"));
            builder.addAttribute(new QName("mimetype", null, null), method.getResponseHeader("Content-Type").getValue());
            try {
                responseNode = (NodeImpl)ModuleUtils.stringToXML(context, bodyAsString);
                builder.addAttribute(new QName("type", null, null), "xml");
                responseNode.copyTo(null, new DocumentBuilderReceiver(builder));
            }
            catch (SAXException se) {
                // empty catch block
            }
            if (responseNode == null && responseMimeType.getName().equals(MimeType.HTML_TYPE.getName())) {
                try {
                    responseNode = (NodeImpl)ModuleUtils.htmlToXHtml(context, method.getURI().toString(), new InputSource(method.getResponseBodyAsStream())).getDocumentElement();
                    builder.addAttribute(new QName("type", null, null), "xhtml");
                    responseNode.copyTo(null, new DocumentBuilderReceiver(builder));
                }
                catch (URIException ue) {
                    throw new XPathException(this.getASTNode(), (Throwable)ue);
                }
                catch (SAXException se) {
                    // empty catch block
                }
            }
            if (responseNode == null) {
                if (responseMimeType.getName().startsWith("text/")) {
                    builder.addAttribute(new QName("type", null, null), "text");
                    builder.addAttribute(new QName("encoding", null, null), "URLEncoded");
                    builder.characters((CharSequence)URLEncoder.encode(method.getResponseBodyAsString(), "UTF-8"));
                } else {
                    byte[] body = method.getResponseBody();
                    builder.addAttribute(new QName("type", null, null), "binary");
                    builder.addAttribute(new QName("encoding", null, null), "Base64Encoded");
                    if (body != null) {
                        Base64Binary binary = new Base64Binary(body);
                        builder.characters((CharSequence)binary.getStringValue());
                    }
                }
            }
        }
    }

    protected MimeType getResponseMimeType(Header responseHeaderContentType) {
        MimeType returnMimeType = MimeType.BINARY_TYPE;
        if (responseHeaderContentType != null && responseHeaderContentType.getName().equals("Content-Type")) {
            String responseContentType = responseHeaderContentType.getValue();
            int contentTypeEnd = responseContentType.indexOf(";");
            if (contentTypeEnd == -1) {
                contentTypeEnd = responseContentType.length();
            }
            String responseMimeType = responseContentType.substring(0, contentTypeEnd);
            MimeTable mimeTable = MimeTable.getInstance();
            MimeType mimeType = mimeTable.getContentType(responseMimeType);
            if (mimeType != null) {
                returnMimeType = mimeType;
            }
        }
        return returnMimeType;
    }

    protected Cookie[] mergeCookies(Cookie[] current, Cookie[] incoming) {
        Cookie[] cookies = null;
        if (current == null) {
            if (incoming != null && incoming.length > 0) {
                cookies = incoming;
            }
        } else if (incoming == null) {
            cookies = current;
        } else {
            HashMap<Integer, Cookie> replacements = new HashMap<Integer, Cookie>();
            Vector<Cookie> additions = new Vector<Cookie>();
            for (int i = 0; i < incoming.length; ++i) {
                boolean cookieExists = false;
                int c = 0;
                while (c < current.length) {
                    if (current[c].equals((Object)incoming[i])) {
                        replacements.put(new Integer(c), incoming[i]);
                        cookieExists = true;
                        break;
                    }
                    ++i;
                }
                if (cookieExists) continue;
                additions.add(incoming[i]);
            }
            cookies = new Cookie[current.length + additions.size()];
            for (int c = 0; c < current.length; ++c) {
                cookies[c] = replacements.containsKey(new Integer(c)) ? (Cookie)replacements.get(new Integer(c)) : current[c];
            }
            for (int a = 0; a < additions.size(); ++a) {
                int offset = current.length + a;
                cookies[offset] = (Cookie)additions.get(a);
            }
        }
        return cookies;
    }
}

