/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.httpclient;

import java.io.IOException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.exist.dom.QName;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.httpclient.BaseHTTPClientFunction;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class DELETEFunction
extends BaseHTTPClientFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("delete", "http://exist-db.org/xquery/httpclient", "httpclient"), "Performs a HTTP DELETE request. $a is the URL, $b determines if cookies persist for the query lifetime. $c defines any HTTP Request Headers to set in the form <headers><header name=\"\" value=\"\"/></headers>. This method returns the HTTP response encoded as an XML fragment, that looks as follows: <httpclient:response xmlns:httpclient=\"http://exist-db.org/xquery/httpclient\" statusCode=\"200\"><httpclient:headers><httpclient:header name=\"name\" value=\"value\"/>...</httpclient:headers><httpclient:body type=\"xml|xhtml|text|binary\" mimetype=\"returned content mimetype\">body content</httpclient:body></httpclient:response> where XML body content will be returned as a Node, HTML body content will be tidied into an XML compatible form, a body with mime-type of \"text/...\" will be returned as a URLEncoded string, and any other body content will be returned as xs:base64Binary encoded data.", new SequenceType[]{new SequenceType(25, 2), new SequenceType(23, 2), new SequenceType(1, 3)}, new SequenceType(11, 2));

    public DELETEFunction(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Sequence response = null;
        if (args[0].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        String url = args[0].itemAt(0).getStringValue();
        boolean persistCookies = args[1].effectiveBooleanValue();
        DeleteMethod delete = new DeleteMethod(url);
        if (!args[2].isEmpty()) {
            this.setHeaders((HttpMethod)delete, ((NodeValue)args[2].itemAt(0)).getNode());
        }
        try {
            response = this.doRequest(this.context, (HttpMethod)delete, persistCookies);
        }
        catch (IOException ioe) {
            throw new XPathException(this.getASTNode(), (Throwable)ioe);
        }
        finally {
            delete.releaseConnection();
        }
        return response;
    }
}

