/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.image;

import java.awt.Image;
import java.io.IOException;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.image.ImageModule;
import org.exist.xquery.value.Base64Binary;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class GetHeightFunction
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("get-height", "http://exist-db.org/xquery/image", "image"), "Get's the Height of the image passed in $a, returning an integer of the images Height in pixels or an empty sequence if $a is invalid.", new SequenceType[]{new SequenceType(26, 2)}, new SequenceType(31, 3));

    public GetHeightFunction(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        Image image = null;
        try {
            image = ImageModule.getImage((Base64Binary)args[0].itemAt(0));
        }
        catch (IOException ioe) {
            LOG.error((Object)"Unable to read image data!", (Throwable)ioe);
            return Sequence.EMPTY_SEQUENCE;
        }
        if (image == null) {
            LOG.error((Object)"Unable to read image data!");
            return Sequence.EMPTY_SEQUENCE;
        }
        int iHeight = image.getHeight(null);
        if (iHeight == -1) {
            LOG.error((Object)"Unable to read image data!");
            return Sequence.EMPTY_SEQUENCE;
        }
        return new IntegerValue((long)iHeight);
    }
}

