/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.image;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import org.exist.collections.Collection;
import org.exist.dom.BinaryDocument;
import org.exist.dom.DocumentImpl;
import org.exist.dom.QName;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.image.ImageModule;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;

public class GetThumbnailsFunction
extends BasicFunction {
    private static final int MAXTHUMBHEIGHT = 100;
    private static final int MAXTHUMBWIDTH = 100;
    private static final String THUMBPREFIX = "";
    private static final String THUMBPATH = "thumbs";
    public static final FunctionSignature signature = new FunctionSignature(new QName("thumbnail", "http://exist-db.org/xquery/image", "image"), "Get or generate thumbnails from the given database collection $a$b point to a location where the thumbnails should be created, $b can be a local path, with the prefix 'xmldb:' a absolute path within the database or with 'rel:' path relative to the given collection at $a.You can leave $b empty then the default is 'rel:/thumbs'. $c specifies the dimension of the thumbnails, if empty then the default values are 'maxheight = 100' and 'maxwidth = 100', the first value of $c is 'maxheight' and the second 'maxwidth'. $d is the prefix (if any) for the thumbnails", new SequenceType[]{new SequenceType(25, 2), new SequenceType(25, 3), new SequenceType(31, 7), new SequenceType(22, 3)}, new SequenceType(22, 7));

    public GetThumbnailsFunction(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        ValueSequence result = new ValueSequence();
        boolean isSaveToDataBase = false;
        if (args[0].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        AnyURIValue picturePath = (AnyURIValue)args[0].itemAt(0);
        if (picturePath.getStringValue().startsWith("xmldb:exist://")) {
            picturePath = new AnyURIValue(picturePath.getStringValue().substring(14));
        }
        AnyURIValue thumbPath = null;
        if (args[1].isEmpty()) {
            thumbPath = new AnyURIValue(picturePath.toXmldbURI().append(THUMBPATH));
            isSaveToDataBase = true;
        } else {
            thumbPath = (AnyURIValue)args[1].itemAt(0);
            if (thumbPath.getStringValue().startsWith("file:")) {
                isSaveToDataBase = false;
                thumbPath = new AnyURIValue(thumbPath.getStringValue().substring(5));
            } else {
                isSaveToDataBase = true;
                try {
                    XmldbURI thumbsURI = XmldbURI.xmldbUriFor((String)thumbPath.getStringValue());
                    if (!thumbsURI.isAbsolute()) {
                        thumbsURI = picturePath.toXmldbURI().append(thumbPath.toString());
                    }
                    thumbPath = new AnyURIValue(thumbsURI.toString());
                }
                catch (URISyntaxException e) {
                    throw new XPathException(this.getASTNode(), e.getMessage());
                }
            }
        }
        int maxThumbHeight = 100;
        int maxThumbWidth = 100;
        if (!args[2].isEmpty()) {
            maxThumbHeight = ((IntegerValue)args[2].itemAt(0)).getInt();
            if (args[2].hasMany()) {
                maxThumbWidth = ((IntegerValue)args[2].itemAt(1)).getInt();
            }
        }
        String prefix = THUMBPREFIX;
        if (!args[3].isEmpty()) {
            prefix = args[3].itemAt(0).getStringValue();
        }
        DBBroker dbbroker = this.context.getBroker();
        BrokerPool pool = null;
        try {
            pool = BrokerPool.getInstance();
        }
        catch (Exception e) {
            result.add((Item)new StringValue(e.getMessage()));
            return result;
        }
        TransactionManager transact = pool.getTransactionManager();
        Txn transaction = transact.beginTransaction();
        Collection thumbCollection = null;
        File thumbDir = null;
        if (isSaveToDataBase) {
            try {
                thumbCollection = dbbroker.getOrCreateCollection(transaction, thumbPath.toXmldbURI());
                dbbroker.saveCollection(transaction, thumbCollection);
            }
            catch (Exception e) {
                throw new XPathException(this.getASTNode(), e.getMessage());
            }
        }
        thumbDir = new File(thumbPath.toString());
        if (!thumbDir.isDirectory()) {
            try {
                thumbDir.mkdirs();
            }
            catch (Exception e) {
                throw new XPathException(this.getASTNode(), e.getMessage());
            }
        }
        Collection allPictures = dbbroker.getCollection(picturePath.toXmldbURI());
        if (allPictures == null) {
            return Sequence.EMPTY_SEQUENCE;
        }
        Collection existingThumbsCol = null;
        File[] existingThumbsArray = null;
        if (isSaveToDataBase) {
            existingThumbsCol = dbbroker.getCollection(thumbPath.toXmldbURI());
        } else {
            existingThumbsArray = thumbDir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".jpeg") || name.endsWith(".jpg");
                }
            });
        }
        DocumentImpl docImage = null;
        BinaryDocument binImage = null;
        BinaryDocument doc = null;
        BufferedImage bImage = null;
        byte[] imgData = null;
        BufferedImage image = null;
        ByteArrayOutputStream os = null;
        Iterator i = allPictures.iterator(dbbroker);
        while (i.hasNext()) {
            docImage = (DocumentImpl)i.next();
            if (!this.fileExist(existingThumbsCol, docImage, prefix) && !this.fileExist(existingThumbsArray, docImage, prefix)) {
                if (docImage.getResourceType() != 1 || !docImage.getMetadata().getMimeType().startsWith("image/jpeg")) continue;
                binImage = (BinaryDocument)docImage;
                imgData = dbbroker.getBinaryResource(binImage);
                try {
                    image = ImageIO.read(new ByteArrayInputStream(imgData));
                }
                catch (IOException ioe) {
                    throw new XPathException(this.getASTNode(), ioe.getMessage());
                }
                try {
                    bImage = ImageModule.createThumb(image, maxThumbHeight, maxThumbWidth);
                }
                catch (Exception e) {
                    throw new XPathException(this.getASTNode(), e.getMessage());
                }
                if (isSaveToDataBase) {
                    os = new ByteArrayOutputStream();
                    try {
                        ImageIO.write((RenderedImage)bImage, "jpg", os);
                    }
                    catch (Exception e) {
                        throw new XPathException(this.getASTNode(), e.getMessage());
                    }
                    try {
                        doc = thumbCollection.addBinaryResource(transaction, dbbroker, XmldbURI.create((String)(prefix + docImage.getFileURI())), os.toByteArray(), "image/jpeg");
                        continue;
                    }
                    catch (Exception e) {
                        throw new XPathException(this.getASTNode(), e.getMessage());
                    }
                }
                try {
                    ImageIO.write((RenderedImage)bImage, "jpg", new File(thumbPath.toString() + "/" + prefix + docImage.getFileURI()));
                    continue;
                }
                catch (Exception e) {
                    throw new XPathException(this.getASTNode(), e.getMessage());
                }
            }
            result.add((Item)new StringValue(docImage.getFileURI().toString()));
        }
        try {
            transact.commit(transaction);
        }
        catch (Exception e) {
            throw new XPathException(this.getASTNode(), e.getMessage());
        }
        transact.getJournal().flushToLog(true);
        dbbroker.closeDocument();
        return result;
    }

    private boolean fileExist(Collection col, DocumentImpl file, String prefix) {
        if (col != null) {
            return col.hasDocument(XmldbURI.create((String)(prefix + file.getFileURI())));
        }
        return false;
    }

    private boolean fileExist(File[] col, DocumentImpl file, String prefix) {
        if (col != null) {
            for (int i = 0; i < col.length; ++i) {
                if (!col[i].getName().endsWith(prefix + file.getFileURI())) continue;
                return true;
            }
        }
        return false;
    }
}

