/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.image;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import javax.imageio.ImageIO;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.image.ImageModule;
import org.exist.xquery.value.Base64Binary;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class ScaleFunction
extends BasicFunction {
    private static final int MAXHEIGHT = 100;
    private static final int MAXWIDTH = 100;
    public static final FunctionSignature signature = new FunctionSignature(new QName("scale", "http://exist-db.org/xquery/image", "image"), "Scale the image passed in $a. $b specifies the maximum dimensions of the scaled image, if empty then the default values are 'maxheight = 100' and 'maxwidth = 100', the first value of $b is 'maxheight' and the second 'maxwidth'. $c specifies the mime-type of the image. The return value is the scaled image or an empty sequence if $a is invalid", new SequenceType[]{new SequenceType(26, 2), new SequenceType(31, 7), new SequenceType(22, 2)}, new SequenceType(26, 3));

    public ScaleFunction(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty() || args[2].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        int maxHeight = 100;
        int maxWidth = 100;
        if (!args[1].isEmpty()) {
            maxHeight = ((IntegerValue)args[1].itemAt(0)).getInt();
            if (args[1].hasMany()) {
                maxWidth = ((IntegerValue)args[1].itemAt(1)).getInt();
            }
        }
        String mimeType = args[2].itemAt(0).getStringValue();
        String formatName = mimeType.substring(mimeType.indexOf("/") + 1);
        Image image = null;
        BufferedImage bImage = null;
        try {
            image = ImageModule.getImage((Base64Binary)args[0].itemAt(0));
            if (image == null) {
                LOG.error((Object)"Unable to read image data!");
                return Sequence.EMPTY_SEQUENCE;
            }
            bImage = ImageModule.createThumb(image, maxHeight, maxWidth);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bImage, formatName, os);
            return new Base64Binary(os.toByteArray());
        }
        catch (Exception e) {
            throw new XPathException(this.getASTNode(), e.getMessage());
        }
    }
}

