/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.math;

import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.DoubleValue;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class OneParamFunctions
extends BasicFunction {
    public static final FunctionSignature[] signature = new FunctionSignature[]{new FunctionSignature(new QName("abs", "http://exist-db.org/xquery/math"), "Returns the absolute value of a number.", new SequenceType[]{new SequenceType(34, 2)}, new SequenceType(34, 2)), new FunctionSignature(new QName("acos", "http://exist-db.org/xquery/math"), "Returns the arccosine value of a number in radians.", new SequenceType[]{new SequenceType(34, 2)}, new SequenceType(34, 2)), new FunctionSignature(new QName("asin", "http://exist-db.org/xquery/math"), "Returns the arcsine value of a number in radians.", new SequenceType[]{new SequenceType(34, 2)}, new SequenceType(34, 2)), new FunctionSignature(new QName("atan", "http://exist-db.org/xquery/math"), "Returns the arctangent value of a number in radians.", new SequenceType[]{new SequenceType(34, 2)}, new SequenceType(34, 2)), new FunctionSignature(new QName("ceil", "http://exist-db.org/xquery/math"), "Returns the smallest (closest to negative infinity) value that is not less than the argument and is equal to a mathematical integer.", new SequenceType[]{new SequenceType(34, 2)}, new SequenceType(34, 2)), new FunctionSignature(new QName("cos", "http://exist-db.org/xquery/math"), "Returns e (the base of natural logarithms) raised to a power.", new SequenceType[]{new SequenceType(34, 2)}, new SequenceType(34, 2)), new FunctionSignature(new QName("exp", "http://exist-db.org/xquery/math"), "Returns the absolute value of a number.", new SequenceType[]{new SequenceType(34, 2)}, new SequenceType(34, 2)), new FunctionSignature(new QName("floor", "http://exist-db.org/xquery/math"), "Returns the largest (closest to positive infinity) value that is not greater than the argument and is equal to a mathematical integer.", new SequenceType[]{new SequenceType(34, 2)}, new SequenceType(34, 2)), new FunctionSignature(new QName("log", "http://exist-db.org/xquery/math"), "Returns the natural logarithm of a number.", new SequenceType[]{new SequenceType(34, 2)}, new SequenceType(34, 2)), new FunctionSignature(new QName("round", "http://exist-db.org/xquery/math"), "Returns the double value that is closest to a integer.", new SequenceType[]{new SequenceType(34, 2)}, new SequenceType(34, 2)), new FunctionSignature(new QName("sin", "http://exist-db.org/xquery/math"), "Returns the sine of the number in radians.", new SequenceType[]{new SequenceType(34, 2)}, new SequenceType(34, 2)), new FunctionSignature(new QName("sqrt", "http://exist-db.org/xquery/math"), "Returns the square root of a number.", new SequenceType[]{new SequenceType(34, 2)}, new SequenceType(34, 2)), new FunctionSignature(new QName("tan", "http://exist-db.org/xquery/math"), "Returns the tangent of the number passed as an argument in radians.", new SequenceType[]{new SequenceType(34, 2)}, new SequenceType(34, 2)), new FunctionSignature(new QName("degrees", "http://exist-db.org/xquery/math"), "Converts angle in radians to degrees.", new SequenceType[]{new SequenceType(34, 2)}, new SequenceType(34, 2)), new FunctionSignature(new QName("radians", "http://exist-db.org/xquery/math"), "Converts angle in degrees to radians.", new SequenceType[]{new SequenceType(34, 2)}, new SequenceType(34, 2))};

    public OneParamFunctions(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Sequence result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start((Expression)this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName((int)this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
        }
        AtomicValue seq = args[0].convertTo(34);
        NumericValue value = (NumericValue)seq.itemAt(0).convertTo(34);
        if (seq.isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            double calcValue = 0.0;
            String functionName = this.getSignature().getName().getLocalName();
            if ("abs".equals(functionName)) {
                calcValue = Math.abs(value.getDouble());
            } else if ("acos".equals(functionName)) {
                calcValue = Math.acos(value.getDouble());
            } else if ("asin".equals(functionName)) {
                calcValue = Math.asin(value.getDouble());
            } else if ("atan".equals(functionName)) {
                calcValue = Math.atan(value.getDouble());
            } else if ("ceil".equals(functionName)) {
                calcValue = Math.ceil(value.getDouble());
            } else if ("cos".equals(functionName)) {
                calcValue = Math.cos(value.getDouble());
            } else if ("exp".equals(functionName)) {
                calcValue = Math.exp(value.getDouble());
            } else if ("floor".equals(functionName)) {
                calcValue = Math.floor(value.getDouble());
            } else if ("log".equals(functionName)) {
                calcValue = Math.log(value.getDouble());
            } else if ("round".equals(functionName)) {
                calcValue = Math.rint(value.getDouble());
            } else if ("sin".equals(functionName)) {
                calcValue = Math.sin(value.getDouble());
            } else if ("sqrt".equals(functionName)) {
                calcValue = Math.sqrt(value.getDouble());
            } else if ("tan".equals(functionName)) {
                calcValue = Math.tan(value.getDouble());
            } else if ("degrees".equals(functionName)) {
                calcValue = Math.toDegrees(value.getDouble());
            } else if ("radians".equals(functionName)) {
                calcValue = Math.toRadians(value.getDouble());
            } else {
                throw new XPathException(this.getASTNode(), "Function " + functionName + " not found.");
            }
            result = new DoubleValue(calcValue);
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end((Expression)this, "", result);
        }
        return result;
    }
}

