/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.math;

import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.DoubleValue;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class TwoParamFunctions
extends BasicFunction {
    public static final FunctionSignature[] signature = new FunctionSignature[]{new FunctionSignature(new QName("atan2", "http://exist-db.org/xquery/math"), "Returns the angle (radians) from the X axis to a point ($b,$a).", new SequenceType[]{new SequenceType(34, 2), new SequenceType(34, 2)}, new SequenceType(34, 2)), new FunctionSignature(new QName("power", "http://exist-db.org/xquery/math"), "Returns the value of $a raised to the power of $b.", new SequenceType[]{new SequenceType(34, 2), new SequenceType(34, 2)}, new SequenceType(34, 2))};

    public TwoParamFunctions(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start((Expression)this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName((int)this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
        }
        double calcValue = 0.0;
        String functionName = this.getSignature().getName().getLocalName();
        AtomicValue seqA = args[0].convertTo(34);
        NumericValue valueA = (NumericValue)seqA.itemAt(0).convertTo(34);
        AtomicValue seqB = args[1].convertTo(34);
        NumericValue valueB = (NumericValue)seqB.itemAt(0).convertTo(34);
        if ("atan2".equals(functionName)) {
            calcValue = Math.atan2(valueB.getDouble(), valueA.getDouble());
        } else if ("power".equals(functionName)) {
            calcValue = Math.pow(valueA.getDouble(), valueB.getDouble());
        } else {
            throw new XPathException(this.getASTNode(), "Function " + functionName + " not found.");
        }
        DoubleValue result = new DoubleValue(calcValue);
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end((Expression)this, "", (Sequence)result);
        }
        return result;
    }
}

