/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.metadata;

import java.util.Iterator;
import org.exist.collections.Collection;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.NodeProxy;
import org.exist.dom.QName;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class MetadataFunction
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("metadata", "http://exist-db.org/xquery/metadata", "metadata"), "Retrieves metadata for the dynamic context.If the context item is undefined an error is raised.", null, new SequenceType(-1, 3));

    public MetadataFunction(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (contextSequence == null) {
            throw new XPathException(this.getASTNode(), "FONC0001: undefined context item");
        }
        DocumentSet sourceDocuments = contextSequence.getDocumentSet();
        Iterator itSourceDocuments = sourceDocuments.iterator();
        ExtArrayNodeSet metadataDocuments = new ExtArrayNodeSet(sourceDocuments.getLength(), 1);
        Collection metadataCollection = null;
        XmldbURI lastMetadataCollectionURI = null;
        while (itSourceDocuments.hasNext()) {
            DocumentImpl sourceDoc = (DocumentImpl)itSourceDocuments.next();
            XmldbURI metadataDocURI = XmldbURI.METADATA_COLLECTION_URI.append(sourceDoc.getURI());
            String tmpMetadataCollectionURI = metadataDocURI.getCollectionPath();
            tmpMetadataCollectionURI = tmpMetadataCollectionURI.substring(0, tmpMetadataCollectionURI.lastIndexOf(47));
            XmldbURI metadataCollectionURI = XmldbURI.create((String)tmpMetadataCollectionURI);
            DocumentImpl metadataDoc = null;
            if (!metadataCollectionURI.equals(lastMetadataCollectionURI)) {
                metadataCollection = this.context.getBroker().getCollection(metadataCollectionURI);
                lastMetadataCollectionURI = metadataCollectionURI;
            }
            if (metadataCollection != null && metadataCollection.hasDocument(metadataDocURI.lastSegment())) {
                metadataDoc = metadataCollection.getDocument(this.context.getBroker(), metadataDocURI.lastSegment());
            }
            if (metadataDoc == null) continue;
            metadataDocuments.add(new NodeProxy(metadataDoc));
        }
        return metadataDocuments;
    }
}

