/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.scheduler;

import org.exist.dom.QName;
import org.exist.scheduler.Scheduler;
import org.exist.scheduler.UserJob;
import org.exist.security.User;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class PauseScheduledJob
extends BasicFunction {
    private Scheduler scheduler = null;
    public static final FunctionSignature signature = new FunctionSignature(new QName("pause-scheduled-job", "http://exist-db.org/xquery/scheduler", "scheduler"), "Pause the job named in $a with the Scheduler. Will only pause User Scheduled Jobs!", new SequenceType[]{new SequenceType(22, 2)}, new SequenceType(23, 2));

    public PauseScheduledJob(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
        this.scheduler = context.getBroker().getBrokerPool().getScheduler();
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        String jobName = args[0].getStringValue();
        User user = this.context.getUser();
        if (!user.hasDbaRole()) {
            return BooleanValue.FALSE;
        }
        return BooleanValue.valueOf((boolean)this.scheduler.pauseJob(jobName, UserJob.JOB_GROUP));
    }
}

