/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.scheduler;

import org.exist.dom.QName;
import org.exist.scheduler.JobDescription;
import org.exist.scheduler.Scheduler;
import org.exist.scheduler.UserJavaJob;
import org.exist.scheduler.UserJob;
import org.exist.scheduler.UserXQueryJob;
import org.exist.security.User;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class ScheduleFunctions
extends BasicFunction {
    private Scheduler scheduler = null;
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("schedule-java-cron-job", "http://exist-db.org/xquery/scheduler", "scheduler"), "Schedules the Java Class named in $a (the class must extend org.exist.scheduler.UserJob) according to the Cron expression in $b", new SequenceType[]{new SequenceType(22, 2), new SequenceType(22, 2)}, new SequenceType(23, 2)), new FunctionSignature(new QName("schedule-xquery-cron-job", "http://exist-db.org/xquery/scheduler", "scheduler"), "Schedules the XQuery resource named in $a (e.g. /db/foo.xql) according to the Cron expression in $b", new SequenceType[]{new SequenceType(22, 2), new SequenceType(22, 2)}, new SequenceType(23, 2))};

    public ScheduleFunctions(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
        this.scheduler = context.getBroker().getBrokerPool().getScheduler();
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        String resource = args[0].getStringValue();
        String cronExpression = args[1].getStringValue();
        User user = this.context.getUser();
        if (!user.hasDbaRole()) {
            return BooleanValue.FALSE;
        }
        Object job = null;
        if (this.isCalledAs("schedule-xquery-cron-job")) {
            job = new UserXQueryJob(null, resource, user);
        } else if (this.isCalledAs("schedule-java-cron-job")) {
            try {
                Class<?> jobClass = Class.forName(resource);
                job = jobClass.newInstance();
                if (!(job instanceof UserJavaJob)) {
                    LOG.error((Object)("Cannot Schedule job. Class " + resource + " is not an instance of org.exist.scheduler.UserJavaJob"));
                    return BooleanValue.FALSE;
                }
            }
            catch (ClassNotFoundException cnfe) {
                LOG.error((Object)cnfe);
                return BooleanValue.FALSE;
            }
            catch (IllegalAccessException iae) {
                LOG.error((Object)iae);
                return BooleanValue.FALSE;
            }
            catch (InstantiationException ie) {
                LOG.error((Object)ie);
                return BooleanValue.FALSE;
            }
        }
        if (job != null) {
            if (this.scheduler.createCronJob(cronExpression, (JobDescription)((UserJob)job), null)) {
                return BooleanValue.TRUE;
            }
            return BooleanValue.FALSE;
        }
        return BooleanValue.FALSE;
    }
}

