/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.ModuleUtils;
import org.exist.xquery.modules.sql.SQLModule;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;
import org.xml.sax.SAXException;

public class ExecuteFunction
extends BasicFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("execute", "http://exist-db.org/xquery/sql", "sql"), "Executes a SQL statement $b against a SQL db using the connection indicated by the connection handle in $a. $c indicates whether the xml nodes should be formed from the column names (in this mode a space in a Column Name will be replaced by an underscore!)", new SequenceType[]{new SequenceType(31, 2), new SequenceType(22, 2), new SequenceType(23, 2)}, new SequenceType(-1, 3))};

    public ExecuteFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty() || args[1].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        long connectionUID = ((IntegerValue)args[0].itemAt(0)).getLong();
        Connection con = SQLModule.retrieveConnection(this.context, connectionUID);
        if (con == null) {
            return Sequence.EMPTY_SEQUENCE;
        }
        String sql = args[1].getStringValue();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            StringBuffer xmlBuf = new StringBuffer();
            stmt = con.createStatement();
            if (stmt.execute(sql)) {
                rs = stmt.getResultSet();
                ResultSetMetaData rsmd = rs.getMetaData();
                int iColumns = rsmd.getColumnCount();
                int iRows = 0;
                while (rs.next()) {
                    xmlBuf.append("<sql:row index=\"" + rs.getRow() + "\">");
                    for (int i = 0; i < iColumns; ++i) {
                        String columnName = rsmd.getColumnName(i + 1);
                        if (columnName == null) continue;
                        String colValue = rs.getString(i + 1);
                        String sqlNull = "";
                        if (rs.wasNull()) {
                            sqlNull = " sql:null=\"true\"";
                        }
                        if (((BooleanValue)args[2].itemAt(0)).effectiveBooleanValue()) {
                            xmlBuf.append("<" + ExecuteFunction.escapeXmlAttr(columnName.replace(' ', '_')) + " " + "sql" + ":type=\"" + rsmd.getColumnTypeName(i + 1) + "\" xs:type=\"" + Type.getTypeName((int)this.sqlTypeToXMLType(rsmd.getColumnType(i + 1))) + "\"" + sqlNull + " >");
                            if (colValue != null) {
                                xmlBuf.append(ExecuteFunction.escapeXmlText(colValue));
                            }
                            xmlBuf.append("</" + ExecuteFunction.escapeXmlAttr(columnName.replace(' ', '_')) + ">");
                            continue;
                        }
                        xmlBuf.append("<sql:field name=\"" + ExecuteFunction.escapeXmlAttr(columnName) + "\" sql:type=\"" + rsmd.getColumnTypeName(i + 1) + "\" xs:type=\"" + Type.getTypeName((int)this.sqlTypeToXMLType(rsmd.getColumnType(i + 1))) + "\"" + sqlNull + " >");
                        if (colValue != null) {
                            xmlBuf.append(ExecuteFunction.escapeXmlText(colValue));
                        }
                        xmlBuf.append("</sql:field>");
                    }
                    xmlBuf.append("</sql:row>");
                    ++iRows;
                }
                xmlBuf.insert(0, "<sql:result xmlns:sql=\"http://exist-db.org/xquery/sql\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" count=\"" + iRows + "\">");
                xmlBuf.append("</sql:result>");
            } else {
                xmlBuf.append("<sql:result xmlns:sql=\"http://exist-db.org/xquery/sql\" updateCount=\"" + stmt.getUpdateCount() + "\"/>");
            }
            NodeValue nodeValue = ModuleUtils.stringToXML(this.context, xmlBuf.toString());
            return nodeValue;
        }
        catch (SAXException saxe) {
            LOG.error((Object)("sql:execute() Could not serialize SQL results to XML for SQL: \"" + sql + "\""), (Throwable)saxe);
            throw new XPathException(this.getASTNode(), "sql:execute() Could not serialize SQL results to XML for SQL: \"" + sql + "\"", (Throwable)saxe);
        }
        catch (SQLException sqle) {
            LOG.error((Object)("sql:execute() Caught SQLException for SQL: \"" + sql + "\""), (Throwable)sqle);
            throw new XPathException(this.getASTNode(), "sql:execute() Caught SQLException for SQL: \"" + sql + "\"", (Throwable)sqle);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException se) {
                LOG.debug((Object)"Unable to cleanup JDBC results", (Throwable)se);
            }
            rs = null;
            stmt = null;
        }
    }

    private int sqlTypeToXMLType(int sqlType) {
        switch (sqlType) {
            case 2003: {
                return -1;
            }
            case -5: {
                return 38;
            }
            case -2: {
                return 26;
            }
            case -7: {
                return 38;
            }
            case 2004: {
                return 26;
            }
            case 16: {
                return 23;
            }
            case 1: {
                return 22;
            }
            case 2005: {
                return 22;
            }
            case 3: {
                return 32;
            }
            case 8: {
                return 34;
            }
            case 6: {
                return 33;
            }
            case -1: {
                return 22;
            }
            case 2: {
                return 30;
            }
            case 5: {
                return 38;
            }
            case -6: {
                return 38;
            }
            case 4: {
                return 31;
            }
            case 12: {
                return 22;
            }
        }
        return 12;
    }

    private static String escapeXmlText(String text) {
        String work = null;
        if (text != null) {
            work = text.replaceAll("\\&", "\\&amp;");
            work = work.replaceAll("<", "\\&lt;");
            work = work.replaceAll(">", "\\&gt;");
        }
        return work;
    }

    private static String escapeXmlAttr(String attr) {
        String work = null;
        if (attr != null) {
            work = ExecuteFunction.escapeXmlText(attr);
            work = work.replaceAll("'", "\\&apos;");
            work = work.replaceAll("\"", "\\&quot;");
        }
        return work;
    }
}

