/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.ModuleUtils;
import org.exist.xquery.modules.sql.SQLModule;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class GetConnectionFunction
extends BasicFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("get-connection", "http://exist-db.org/xquery/sql", "sql"), "Open's a connection to a SQL Database. Expects a JDBC Driver class name in $a and a JDBC URL in $b. Returns an xs:long representing the connection handle.", new SequenceType[]{new SequenceType(22, 2), new SequenceType(22, 2)}, new SequenceType(37, 3)), new FunctionSignature(new QName("get-connection", "http://exist-db.org/xquery/sql", "sql"), "Open's a connection to a SQL Database. Expects a JDBC Driver class name in $a and a JDBC URL in $b. Additional JDBC properties may be set in $c in the form <properties><property name=\"\" value=\"\"/></properties>. Returns an xs:long representing the connection handle.", new SequenceType[]{new SequenceType(22, 2), new SequenceType(22, 2), new SequenceType(1, 3)}, new SequenceType(37, 3)), new FunctionSignature(new QName("get-connection", "http://exist-db.org/xquery/sql", "sql"), "Open's a connection to a SQL Database. Expects a JDBC Driver class name in $a, a JDBC URL in $b, a username in $c and a password in $d. Returns an xs:long representing the connection handle.", new SequenceType[]{new SequenceType(22, 2), new SequenceType(22, 2), new SequenceType(22, 2), new SequenceType(22, 2)}, new SequenceType(37, 3))};

    public GetConnectionFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty() || args[1].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        String dbDriver = args[0].getStringValue();
        String dbURL = args[1].getStringValue();
        try {
            Class.forName(dbDriver).newInstance();
            Connection con = null;
            if (args.length == 2) {
                con = DriverManager.getConnection(dbURL);
            } else if (args.length == 3) {
                Properties props = ModuleUtils.parseProperties(((NodeValue)args[2].itemAt(0)).getNode());
                con = DriverManager.getConnection(dbURL, props);
            } else if (args.length == 4) {
                String dbUser = args[2].getStringValue();
                String dbPassword = args[3].getStringValue();
                con = DriverManager.getConnection(dbURL, dbUser, dbPassword);
            }
            return new IntegerValue(SQLModule.storeConnection(this.context, con));
        }
        catch (IllegalAccessException iae) {
            LOG.error((Object)("sql:get-connection() Illegal Access to database driver class: " + dbDriver), (Throwable)iae);
            throw new XPathException(this.getASTNode(), "sql:get-connection() Illegal Access to database driver class: " + dbDriver, (Throwable)iae);
        }
        catch (ClassNotFoundException cnfe) {
            LOG.error((Object)("sql:get-connection() Cannot find database driver class: " + dbDriver), (Throwable)cnfe);
            throw new XPathException(this.getASTNode(), "sql:get-connection() Cannot find database driver class: " + dbDriver, (Throwable)cnfe);
        }
        catch (InstantiationException ie) {
            LOG.error((Object)("sql:get-connection() Cannot instantiate database driver class: " + dbDriver), (Throwable)ie);
            throw new XPathException(this.getASTNode(), "sql:get-connection() Cannot instantiate database driver class: " + dbDriver, (Throwable)ie);
        }
        catch (SQLException sqle) {
            LOG.error((Object)("sql:get-connection() Cannot connect to database: " + dbURL), (Throwable)sqle);
            throw new XPathException(this.getASTNode(), "sql:get-connection() Cannot connect to database: " + dbURL, (Throwable)sqle);
        }
    }
}

