/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.sql;

import java.sql.Connection;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.sql.SQLModule;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class GetJNDIConnectionFunction
extends BasicFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("get-jndi-connection", "http://exist-db.org/xquery/sql", "sql"), "Open's a connection to a SQL Database. Expects a JNDI name in $a. Returns an xs:long representing the connection handle.", new SequenceType[]{new SequenceType(22, 2), new SequenceType(22, 2)}, new SequenceType(37, 3)), new FunctionSignature(new QName("get-jndi-connection", "http://exist-db.org/xquery/sql", "sql"), "Open's a connection to a SQL Database. Expects a JNDI name in $a, a username in $b and a password in $c. Returns an xs:long representing the connection handle.", new SequenceType[]{new SequenceType(22, 2), new SequenceType(22, 2), new SequenceType(22, 2)}, new SequenceType(37, 3))};

    public GetJNDIConnectionFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        try {
            Connection con = null;
            String jndiName = args[0].getStringValue();
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup(jndiName);
            if (args.length == 1) {
                con = ds.getConnection();
            }
            if (args.length == 3) {
                String jndiUser = args[1].getStringValue();
                String jndiPassword = args[2].getStringValue();
                con = ds.getConnection(jndiUser, jndiPassword);
            }
            return new IntegerValue(SQLModule.storeConnection(this.context, con));
        }
        catch (Exception e) {
            throw new XPathException(this.getASTNode(), e.getMessage());
        }
    }
}

