/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.exist.xquery.AbstractInternalModule;
import org.exist.xquery.FunctionDef;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.sql.ExecuteFunction;
import org.exist.xquery.modules.sql.GetConnectionFunction;
import org.exist.xquery.modules.sql.GetJNDIConnectionFunction;

public class SQLModule
extends AbstractInternalModule {
    protected static final Logger LOG = Logger.getLogger((Class)SQLModule.class);
    public static final String NAMESPACE_URI = "http://exist-db.org/xquery/sql";
    public static final String PREFIX = "sql";
    private static final FunctionDef[] functions = new FunctionDef[]{new FunctionDef(GetConnectionFunction.signatures[0], GetConnectionFunction.class), new FunctionDef(GetConnectionFunction.signatures[1], GetConnectionFunction.class), new FunctionDef(GetConnectionFunction.signatures[2], GetConnectionFunction.class), new FunctionDef(GetJNDIConnectionFunction.signatures[0], GetJNDIConnectionFunction.class), new FunctionDef(GetJNDIConnectionFunction.signatures[1], GetJNDIConnectionFunction.class), new FunctionDef(ExecuteFunction.signatures[0], ExecuteFunction.class)};
    private static long currentConnectionUID = System.currentTimeMillis();
    public static final String CONNECTIONS_CONTEXTVAR = "_eXist_sql_connections";

    public SQLModule() {
        super(functions);
    }

    public String getNamespaceURI() {
        return NAMESPACE_URI;
    }

    public String getDefaultPrefix() {
        return PREFIX;
    }

    public String getDescription() {
        return "A module for performing SQL queries against Databases, returning XML representations of the result sets.";
    }

    public static final Connection retrieveConnection(XQueryContext context, long connectionUID) {
        HashMap connections = (HashMap)context.getXQueryContextVar(CONNECTIONS_CONTEXTVAR);
        if (connections == null) {
            return null;
        }
        return (Connection)connections.get(new Long(connectionUID));
    }

    public static final synchronized long storeConnection(XQueryContext context, Connection con) {
        HashMap<Long, Connection> connections = (HashMap<Long, Connection>)context.getXQueryContextVar(CONNECTIONS_CONTEXTVAR);
        if (connections == null) {
            connections = new HashMap<Long, Connection>();
        }
        long conID = SQLModule.getUID();
        connections.put(new Long(conID), con);
        context.setXQueryContextVar(CONNECTIONS_CONTEXTVAR, connections);
        return conID;
    }

    private static final void closeAllConnections(XQueryContext xqueryContext) {
        HashMap connections = (HashMap)xqueryContext.getXQueryContextVar(CONNECTIONS_CONTEXTVAR);
        if (connections != null) {
            Set keys = connections.keySet();
            Iterator itKeys = keys.iterator();
            while (itKeys.hasNext()) {
                Long conID = (Long)itKeys.next();
                Connection con = (Connection)connections.get(conID);
                try {
                    con.close();
                    connections.remove(conID);
                }
                catch (SQLException se) {
                    LOG.debug((Object)"Unable to close JDBC connection", (Throwable)se);
                }
            }
            xqueryContext.setXQueryContextVar(CONNECTIONS_CONTEXTVAR, (Object)connections);
        }
    }

    private static synchronized long getUID() {
        return currentConnectionUID++;
    }

    public void reset(XQueryContext xqueryContext) {
        super.reset(xqueryContext);
        SQLModule.closeAllConnections(xqueryContext);
    }
}

