/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.addons;

import com.openindex.openestate.impl.CustomValuesImpl;
import com.openindex.openestate.tool.ImmoToolDbException;
import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.calendar.CalendarEntryRelation;
import java.math.BigInteger;
import java.util.ArrayList;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.modules.XMLResource;

public class AgencyEstateCalendar
extends CalendarEntryRelation {
    private static final Logger LOGGER = Logger.getLogger(AgencyEstateCalendar.class);
    public static final String VALUE_CALENDAR_ID = "calendar.id.";
    public static final String VALUE_CALENDAR_UID = "calendar.uid.";
    public static final String VALUE_CALENDAR_TEXT = "calendar.text.";
    private long relationEstateId;

    public AgencyEstateCalendar() {
    }

    public AgencyEstateCalendar(long l, long l2, String string, String string2) {
        this.relationEstateId = l;
        this.setCalendarId(l2);
        this.setCalendarUid(string);
        this.setDescription(string2);
    }

    public static AgencyEstateCalendar[] getAgencyEstateCalendars(AgencyEstate agencyEstate) {
        return AgencyEstateCalendar.getAgencyEstateCalendars(agencyEstate.getIdNr(), agencyEstate.getCustomValues());
    }

    public static AgencyEstateCalendar[] getAgencyEstateCalendars(long l) throws ImmoToolDbException {
        return AgencyEstateCalendar.getAgencyEstateCalendars(AgencyEstate.loadEstate((long)l));
    }

    public static AgencyEstateCalendar[] getAgencyEstateCalendars(long l, Collection collection) throws ImmoToolDbException {
        return AgencyEstateCalendar.getAgencyEstateCalendars(AgencyEstate.loadEstate((long)l, (Collection)collection));
    }

    public static AgencyEstateCalendar[] getAgencyEstateCalendars(long l, CustomValuesImpl customValuesImpl) {
        ArrayList<AgencyEstateCalendar> arrayList = new ArrayList<AgencyEstateCalendar>();
        for (String string : customValuesImpl.getValueMap().keySet()) {
            if (!string.startsWith(VALUE_CALENDAR_ID)) continue;
            String string2 = VALUE_CALENDAR_UID + string.substring(VALUE_CALENDAR_ID.length());
            String string3 = VALUE_CALENDAR_TEXT + string.substring(VALUE_CALENDAR_ID.length());
            Long l2 = customValuesImpl.getCustomValue(string).getInteger().longValue();
            String string4 = customValuesImpl.getCustomValue(string2).getString();
            String string5 = customValuesImpl.hasCustomValue(string3) ? (customValuesImpl.getCustomValue(string3).isText() ? customValuesImpl.getCustomValue(string3).getText() : customValuesImpl.getCustomValue(string3).getString()) : "";
            arrayList.add(new AgencyEstateCalendar(l, l2, string4, string5));
        }
        return arrayList.toArray(new AgencyEstateCalendar[arrayList.size()]);
    }

    public long getEstateId() {
        return this.relationEstateId;
    }

    public AgencyEstate loadAgencyEstate() throws ImmoToolDbException {
        return AgencyEstate.loadEstate((long)this.getEstateId());
    }

    public static AgencyEstateCalendar[] loadEntriesForCalendar(String string) throws ImmoToolDbException {
        Collection collection = null;
        ArrayList<AgencyEstateCalendar> arrayList = new ArrayList<AgencyEstateCalendar>();
        try {
            collection = AgencyPluginUtils.openPluginCollection((String)"/estates");
            String string2 = "declare namespace util=\"http://exist-db.org/xquery/util\";\ndeclare namespace openestate=\"http://www.openestate.org/1.0/\";\nfor $x in collection('ImmoTool/OpenEstate-Agency/estates')/openestate:Estate/openestate:CustomValues/openestate:CustomValue\n  let $pos:=substring($x/@Key, " + (VALUE_CALENDAR_UID.length() + 1) + ")\n" + "  let $calIdVar:=concat('" + VALUE_CALENDAR_ID + "', $pos)\n" + "  let $calId:=$x/../openestate:" + "CustomValue" + "[@" + "Key" + "=$calIdVar]/openestate:" + "Integer" + "/text()\n" + "  let $txtVar:=concat('" + VALUE_CALENDAR_TEXT + "', $pos)\n" + "  let $txt:=$x/../openestate:" + "CustomValue" + "[@" + "Key" + "=$txtVar]/*/text()\n" + "  where (starts-with($x/@" + "Key" + ", '" + VALUE_CALENDAR_UID + "') and ($x/openestate:" + "String" + "/text()='" + StringEscapeUtils.escapeSql((String)string) + "') )\n" + "  return <result path=\"{util:collection-name( $x )}\" file=\"{util:document-name( $x )}\" pos=\"{$pos}\" calId=\"{$calId}\">{$txt}</result>";
            ResourceSet resourceSet = ImmoToolDbUtils.executeXQuery((Collection)collection, (String)string2);
            for (long i = 0L; i < resourceSet.getSize(); ++i) {
                try {
                    XMLResource xMLResource = (XMLResource)resourceSet.getResource(i);
                    Node node = xMLResource.getContentAsDOM();
                    String string3 = node.getAttributes().getNamedItem("file").getNodeValue();
                    Long l = Long.valueOf(node.getAttributes().getNamedItem("calId").getNodeValue());
                    String string4 = node.getFirstChild() != null ? node.getFirstChild().getNodeValue() : "";
                    string4 = string4.replaceAll("<br/>", SystemUtils.LINE_SEPARATOR);
                    String[] stringArray = string3.split("\\.");
                    arrayList.add(new AgencyEstateCalendar(Long.valueOf(stringArray[1]), l, string, string4));
                    continue;
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"could not load AgencyEstateCalendar!");
                    LOGGER.warn((Object)("> for uid " + string));
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
            }
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException(exception.getLocalizedMessage(), (Throwable)exception);
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
        return arrayList.toArray(new AgencyEstateCalendar[arrayList.size()]);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AgencyEstateCalendar[] loadEntriesForEstate(long l) throws ImmoToolDbException {
        AgencyEstateCalendar[] agencyEstateCalendarArray;
        Collection collection = null;
        ArrayList<AgencyEstateCalendar> arrayList = new ArrayList<AgencyEstateCalendar>();
        try {
            String string = "Estate." + l + ".xml";
            String string2 = "declare namespace util=\"http://exist-db.org/xquery/util\";\ndeclare namespace openestate=\"http://www.openestate.org/1.0/\";\nfor $x in document('ImmoTool/OpenEstate-Agency/estates/" + string + "')/openestate:" + "Estate" + "/openestate:" + "CustomValues" + "/openestate:" + "CustomValue" + "\n" + "  let $uid:=$x/openestate:" + "String" + "/text()\n" + "  let $pos:=substring($x/@" + "Key" + ", " + (VALUE_CALENDAR_UID.length() + 1) + ")\n" + "  let $calIdVar:=concat('" + VALUE_CALENDAR_ID + "', $pos)\n" + "  let $calId:=$x/../openestate:" + "CustomValue" + "[@" + "Key" + "=$calIdVar]/openestate:" + "Integer" + "/text()\n" + "  let $txtVar:=concat('" + VALUE_CALENDAR_TEXT + "', $pos)\n" + "  let $txt:=$x/../openestate:" + "CustomValue" + "[@" + "Key" + "=$txtVar]/*/text()\n" + "  where (starts-with($x/@" + "Key" + ", '" + VALUE_CALENDAR_UID + "'))\n" + "  return <result pos=\"{$pos}\" calId=\"{$calId}\" calUid=\"{$uid}\">{$txt}</result>";
            collection = AgencyPluginUtils.openPluginCollection((String)"/estates");
            ResourceSet resourceSet = ImmoToolDbUtils.executeXQuery((Collection)collection, (String)string2);
            for (long i = 0L; i < resourceSet.getSize(); ++i) {
                try {
                    XMLResource xMLResource = (XMLResource)resourceSet.getResource(i);
                    Node node = xMLResource.getContentAsDOM();
                    Long l2 = Long.valueOf(node.getAttributes().getNamedItem("calId").getNodeValue());
                    String string3 = node.getAttributes().getNamedItem("calUid").getNodeValue();
                    String string4 = node.getFirstChild() != null ? node.getFirstChild().getNodeValue() : "";
                    string4 = string4.replaceAll("<br/>", SystemUtils.LINE_SEPARATOR);
                    arrayList.add(new AgencyEstateCalendar(l, l2, string3, string4));
                    continue;
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"could not load AgencyEstateCalendar!");
                    LOGGER.warn((Object)("> for estateId " + l));
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
            }
            agencyEstateCalendarArray = arrayList.toArray(new AgencyEstateCalendar[arrayList.size()]);
        }
        catch (ImmoToolDbException immoToolDbException) {
            try {
                throw immoToolDbException;
                catch (Exception exception) {
                    throw new ImmoToolDbException(exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
            catch (Throwable throwable) {
                ImmoToolDbUtils.close(collection);
                throw throwable;
            }
        }
        ImmoToolDbUtils.close((Collection)collection);
        return agencyEstateCalendarArray;
    }

    public static void setAgencyEstateCalendars(AgencyEstate agencyEstate, AgencyEstateCalendar[] agencyEstateCalendarArray) {
        AgencyEstateCalendar.setAgencyEstateCalendars(agencyEstate.getCustomValues(), agencyEstateCalendarArray);
    }

    public static void setAgencyEstateCalendars(CustomValuesImpl customValuesImpl, AgencyEstateCalendar[] agencyEstateCalendarArray) {
        int n = customValuesImpl.getValueMap().size();
        for (String string : customValuesImpl.getValueMap().keySet().toArray(new String[n])) {
            String string2;
            if (!string.startsWith(VALUE_CALENDAR_ID)) continue;
            customValuesImpl.getValueMap().remove(string);
            String string3 = VALUE_CALENDAR_UID + string.substring(VALUE_CALENDAR_ID.length());
            if (customValuesImpl.hasCustomValue(string3)) {
                customValuesImpl.getValueMap().remove(string3);
            }
            if (!customValuesImpl.hasCustomValue(string2 = VALUE_CALENDAR_TEXT + string.substring(VALUE_CALENDAR_ID.length()))) continue;
            customValuesImpl.getValueMap().remove(string2);
        }
        for (int i = 0; i < agencyEstateCalendarArray.length; ++i) {
            String string;
            String string4 = VALUE_CALENDAR_ID + i;
            customValuesImpl.putCustomValue(string4, (Object)BigInteger.valueOf(agencyEstateCalendarArray[i].getCalendarId()), 4);
            String string5 = VALUE_CALENDAR_UID + i;
            if (agencyEstateCalendarArray[i].getCalendarUid().trim().length() > 0) {
                customValuesImpl.putCustomValue(string5, (Object)agencyEstateCalendarArray[i].getCalendarUid().trim(), 5);
            }
            string = VALUE_CALENDAR_TEXT + i;
            if (agencyEstateCalendarArray[i].getDescription().trim().length() <= 0) continue;
            customValuesImpl.putCustomValue(string, (Object)agencyEstateCalendarArray[i].getDescription().trim(), 6);
        }
    }

    public void setEstateId(long l) {
        this.relationEstateId = l;
    }
}

