/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.addons;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.agency.addons.AgencyEstateCalendar;
import com.openindex.openestate.tool.calendar.CalendarEntry;
import com.openindex.openestate.tool.calendar.CalendarJournalEntry;
import com.openindex.openestate.tool.calendar.CalendarObject;
import com.openindex.openestate.tool.calendar.CalendarPluginUtils;
import com.openindex.openestate.tool.calendar.CalendarSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.ArrayList;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.fife.ui.rtextarea.RTextArea;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;
import org.xmldb.api.base.Collection;

public class AgencyEstateCalendarDialog
extends JDialog {
    private static final Logger LOGGER = Logger.getLogger(AgencyEstateCalendarDialog.class);
    private static final DateFormat DATEFORMAT_SHORT = DateFormat.getDateInstance(3);
    public static final int SELECT_ALL = 0;
    public static final int SELECT_ESTATE = 1;
    public static final int SELECT_CALENDAR = 2;
    private int selection = 0;
    public static final int UNDEFINED = 0;
    public static final int CANCELLED = 1;
    public static final int APPROVED = 2;
    private int status = 0;
    private ActionMap actionMap;
    private ResourceMap resourceMap;
    private JXPanel contentPane;
    private RTextArea notesField;
    private JButton closeButton;
    private JButton submitButton;
    private JComboBox estateField = null;
    private JXBusyLabel estateBusyField = null;
    private JComboBox calendarGroupField = null;
    private JXBusyLabel calendarGroupBusyField = null;
    private JComboBox calendarEntryField = null;
    private JXBusyLabel calendarEntryBusyField = null;
    private Task estateTask = null;
    private Task calendarGroupTask = null;
    private Task calendarEntryTask = null;
    private Collection calendarCollection = null;
    private String calendarEntryUIdOnLoad = null;

    public AgencyEstateCalendarDialog(int n, Dialog dialog, boolean bl) {
        super(dialog, bl);
        this.build(n);
        this.setLocationRelativeTo(dialog);
    }

    public AgencyEstateCalendarDialog(int n, Frame frame, boolean bl) {
        super(frame, bl);
        this.build(n);
        this.setLocationRelativeTo(frame);
    }

    private void build(int n) {
        this.actionMap = ImmoToolUtils.getActionMap(AgencyEstateCalendarDialog.class, (Object)this);
        this.resourceMap = ImmoToolUtils.getResourceMap(AgencyEstateCalendarDialog.class);
        this.contentPane = new JXPanel();
        this.contentPane.setOpaque(true);
        this.selection = n;
        this.setContentPane((Container)this.contentPane);
        this.buildForm();
        this.setDefaultCloseOperation(2);
        this.resourceMap.injectComponents((Component)this);
        if (this.calendarGroupField != null) {
            this.calendarGroupField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (AgencyEstateCalendarDialog.this.calendarGroupField.getSelectedIndex() < 0) {
                        return;
                    }
                    String string = AgencyEstateCalendarDialog.this.calendarEntryUIdOnLoad != null ? AgencyEstateCalendarDialog.this.calendarEntryUIdOnLoad : null;
                    ImmoToolUtils.executeTask((Task)AgencyEstateCalendarDialog.this.reloadCalendarEntries(string));
                }
            });
        }
        if (this.estateField != null) {
            final String string = this.estateField.getToolTipText();
            this.estateField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (AgencyEstateCalendarDialog.this.estateField.getSelectedIndex() <= 0) {
                        AgencyEstateCalendarDialog.this.estateField.setToolTipText(string);
                    } else {
                        AgencyEstateCalendarDialog.this.estateField.setToolTipText(((AgencyEstate.Row)AgencyEstateCalendarDialog.this.estateField.getSelectedItem()).writeToolTip());
                    }
                }
            });
        }
        if (SystemUtils.IS_OS_MAC_OSX) {
            this.closeButton.setOpaque(false);
            this.submitButton.setOpaque(false);
        }
        this.setSize(500, 400);
        ImmoToolUtils.configureDialog((JDialog)this, (JXPanel)this.contentPane);
    }

    private void buildForm() {
        this.notesField = new RTextArea();
        this.notesField.setName("estateTextField");
        this.notesField.setLineWrap(true);
        this.notesField.setWrapStyleWord(true);
        JPanel jPanel = null;
        if (this.selection == 0 || this.selection == 1) {
            this.estateField = new JComboBox();
            this.estateField.setName("estateField");
            this.estateField.setRenderer(new EstateRenderer());
            this.estateBusyField = new JXBusyLabel();
            this.estateBusyField.setName("estateBusyField");
            this.estateBusyField.setOpaque(false);
            this.estateBusyField.setVisible(false);
            jPanel = new JPanel(new BorderLayout());
            jPanel.setOpaque(false);
            jPanel.add((Component)this.estateField, "North");
            jPanel.add((Component)this.estateBusyField, "South");
            AutoCompleteDecorator.decorate((JComboBox)this.estateField, (ObjectToStringConverter)new ObjectToStringConverter(){

                public String getPreferredStringForItem(Object object) {
                    if (object instanceof AgencyEstate.Row) {
                        AgencyEstate.Row row = (AgencyEstate.Row)object;
                        String string = "#" + row.id;
                        if (row.publicId != null && row.publicId.trim().length() > 0) {
                            string = string + " / " + row.publicId;
                        }
                        if (row.title != null && row.title.trim().length() > 0) {
                            string = string + " | " + row.title;
                        }
                        return string.trim();
                    }
                    return "-";
                }

                public String[] getPossibleStringsForItem(Object object) {
                    if (object instanceof AgencyEstate.Row) {
                        AgencyEstate.Row row = (AgencyEstate.Row)object;
                        ArrayList<String> arrayList = new ArrayList<String>();
                        arrayList.add(this.getPreferredStringForItem(object));
                        if (row.publicId != null && row.publicId.trim().length() > 0) {
                            arrayList.add(row.publicId);
                        }
                        if (row.title != null && row.title.trim().length() > 0) {
                            arrayList.add(row.title);
                        }
                        return arrayList.toArray(new String[arrayList.size()]);
                    }
                    return super.getPossibleStringsForItem(object);
                }
            });
        }
        JPanel jPanel2 = null;
        JPanel jPanel3 = null;
        if (this.selection == 0 || this.selection == 2) {
            this.calendarGroupField = new JComboBox();
            this.calendarGroupField.setName("calendarGroupField");
            this.calendarGroupField.setRenderer(new CalendarSourceRenderer());
            this.calendarGroupBusyField = new JXBusyLabel();
            this.calendarGroupBusyField.setName("calendarGroupBusyField");
            this.calendarGroupBusyField.setOpaque(false);
            this.calendarGroupBusyField.setVisible(false);
            jPanel2 = new JPanel(new BorderLayout());
            jPanel2.setOpaque(false);
            jPanel2.add((Component)this.calendarGroupField, "North");
            jPanel2.add((Component)this.calendarGroupBusyField, "South");
            this.calendarEntryField = new JComboBox();
            this.calendarEntryField.setName("calendarEntryField");
            this.calendarEntryField.setRenderer(new CalendarEntryRenderer());
            this.calendarEntryBusyField = new JXBusyLabel();
            this.calendarEntryBusyField.setName("calendarEntryBusyField");
            this.calendarEntryBusyField.setOpaque(false);
            this.calendarEntryBusyField.setVisible(false);
            jPanel3 = new JPanel(new BorderLayout());
            jPanel3.setOpaque(false);
            jPanel3.add((Component)this.calendarEntryField, "North");
            jPanel3.add((Component)this.calendarEntryBusyField, "South");
            AutoCompleteDecorator.decorate((JComboBox)this.calendarEntryField, (ObjectToStringConverter)new ObjectToStringConverter(){

                public String getPreferredStringForItem(Object object) {
                    if (object instanceof CalendarEntry) {
                        CalendarEntry calendarEntry = (CalendarEntry)object;
                        String string = calendarEntry.getBegin() != null ? DATEFORMAT_SHORT.format(calendarEntry.getBegin()) + " | " + calendarEntry.getSummaryString() : calendarEntry.getSummaryString();
                        return string.trim();
                    }
                    return "-";
                }

                public String[] getPossibleStringsForItem(Object object) {
                    if (object instanceof CalendarEntry) {
                        CalendarEntry calendarEntry = (CalendarEntry)object;
                        ArrayList<String> arrayList = new ArrayList<String>();
                        arrayList.add(this.getPreferredStringForItem(object));
                        arrayList.add(calendarEntry.getSummaryString());
                        return arrayList.toArray(new String[arrayList.size()]);
                    }
                    return super.getPossibleStringsForItem(object);
                }
            });
        }
        this.closeButton = new JButton(this.actionMap.get("doClose"));
        this.closeButton.setName("closeButton");
        this.submitButton = new JButton(this.actionMap.get("doSubmit"));
        this.submitButton.setName("submitButton");
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:pref, 3dlu, 20dlu:grow");
        defaultFormBuilder.opaque(false);
        if (this.selection == 0 || this.selection == 1) {
            defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("label.selectEstate", new Object[0])), 3);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(this.resourceMap.getString("label.selectEstate.object", new Object[0]), (Component)jPanel);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append((Component)new JLabel(" "), 3);
            defaultFormBuilder.nextLine();
        }
        if (this.selection == 0 || this.selection == 2) {
            defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("label.selectCalendar", new Object[0])), 3);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(this.resourceMap.getString("label.selectCalendar.group", new Object[0]), (Component)jPanel2);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(this.resourceMap.getString("label.selectCalendar.entry", new Object[0]), jPanel3);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append((Component)new JLabel(" "), 3);
            defaultFormBuilder.nextLine();
        }
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("label.estateText", new Object[0])), 3);
        defaultFormBuilder.nextLine();
        this.contentPane.setLayout((LayoutManager)new BorderLayout(5, 5));
        this.contentPane.setBorder(Borders.DIALOG);
        this.contentPane.add((Component)defaultFormBuilder.getPanel(), (Object)"North");
        JScrollPane jScrollPane = new JScrollPane((Component)this.notesField);
        jScrollPane.setOpaque(false);
        this.contentPane.add((Component)jScrollPane, (Object)"Center");
        JPanel jPanel4 = ImmoToolUtils.buildButtonBar((JButton[])new JButton[]{this.submitButton, this.closeButton});
        jPanel4.setOpaque(false);
        this.contentPane.add((Component)jPanel4, (Object)"South");
        this.contentPane.revalidate();
        this.contentPane.repaint();
    }

    @Action
    public void doClose() {
        this.status = 1;
        this.setVisible(false);
    }

    @Action
    public void doSubmit() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.estateField != null && this.estateField.getSelectedIndex() <= 0) {
            arrayList.add(this.resourceMap.getString("error.noEstateSelected", new Object[0]));
        }
        if (this.calendarGroupField != null && this.calendarGroupField.getSelectedIndex() <= 0) {
            arrayList.add(this.resourceMap.getString("error.noCalendarSourceSelected", new Object[0]));
        }
        if (this.calendarEntryField != null && this.calendarEntryField.getSelectedIndex() <= 0) {
            arrayList.add(this.resourceMap.getString("error.noCalendarEntrySelected", new Object[0]));
        }
        if (!arrayList.isEmpty()) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.invalidInput", new Object[0]), arrayList);
            return;
        }
        this.status = 2;
        this.setVisible(false);
    }

    public AgencyEstate.Row getSelectedAgencyEstate() {
        if (this.estateField == null) {
            return null;
        }
        Object object = this.estateField.getSelectedItem();
        return object instanceof AgencyEstate.Row ? (AgencyEstate.Row)object : null;
    }

    public long getSelectedAgencyEstateId() {
        AgencyEstate.Row row = this.getSelectedAgencyEstate();
        return row != null ? row.id : 0L;
    }

    public CalendarEntry getSelectedCalendarEntry() {
        if (this.calendarEntryField == null) {
            return null;
        }
        Object object = this.calendarEntryField.getSelectedItem();
        return object instanceof CalendarEntry ? (CalendarEntry)object : null;
    }

    public CalendarSource getSelectedCalendarSource() {
        if (this.calendarGroupField == null) {
            return null;
        }
        Object object = this.calendarGroupField.getSelectedItem();
        return object instanceof CalendarSource ? (CalendarSource)object : null;
    }

    public int getStatus() {
        return this.status;
    }

    public void load(AgencyEstateCalendar agencyEstateCalendar) throws ImmoToolException {
        this.notesField.setText(agencyEstateCalendar != null && agencyEstateCalendar.getDescription() != null ? agencyEstateCalendar.getDescription().trim() : "");
    }

    public void loadCalendar(CalendarEntry calendarEntry) throws ImmoToolException {
        if (calendarEntry != null && calendarEntry.getUId() != null) {
            this.loadCalendar(calendarEntry.getCalendarId(), calendarEntry.getUId().getValue());
        } else {
            this.loadCalendar(0L, null);
        }
    }

    public void loadCalendar(long l, String string) throws ImmoToolException {
        if (this.calendarGroupField == null || this.calendarEntryField == null) {
            return;
        }
        this.calendarEntryUIdOnLoad = string;
        this.calendarGroupField.setSelectedIndex(-1);
        ImmoToolUtils.executeTask((Task)this.reloadCalendarGroups(l));
    }

    private DefaultComboBoxModel loadCalendarEntryModel(Collection collection) throws ImmoToolException {
        CalendarSource calendarSource = this.getSelectedCalendarSource();
        if (calendarSource == null) {
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            defaultComboBoxModel.addElement("[ " + this.resourceMap.getString("message.pleaseSelectCalendarSource", new Object[0]) + " ]");
            return defaultComboBoxModel;
        }
        try {
            DefaultComboBoxModel<CalendarEntry> defaultComboBoxModel = new DefaultComboBoxModel<CalendarEntry>();
            defaultComboBoxModel.addElement(null);
            CalendarObject calendarObject = CalendarObject.load((long)calendarSource.getCalendarId());
            for (CalendarEntry calendarEntry : calendarObject.getEntries()) {
                if (calendarEntry == null || calendarEntry instanceof CalendarJournalEntry) continue;
                defaultComboBoxModel.addElement(calendarEntry);
            }
            return defaultComboBoxModel;
        }
        catch (Exception exception) {
            throw new ImmoToolException("Can't load calendar entries!", (Throwable)exception);
        }
    }

    private DefaultComboBoxModel loadCalendarGroupModel(Collection collection) throws ImmoToolException {
        try {
            DefaultComboBoxModel<CalendarSource> defaultComboBoxModel = new DefaultComboBoxModel<CalendarSource>();
            defaultComboBoxModel.addElement(null);
            for (CalendarSource calendarSource : CalendarSource.loadSources((Collection)collection)) {
                defaultComboBoxModel.addElement(calendarSource);
            }
            return defaultComboBoxModel;
        }
        catch (Exception exception) {
            throw new ImmoToolException("Can't load calendar sources!", (Throwable)exception);
        }
    }

    public void loadEstate(AgencyEstate agencyEstate) throws ImmoToolException {
        this.loadEstate(agencyEstate != null ? agencyEstate.getIdNr() : 0L);
    }

    public void loadEstate(long l) throws ImmoToolException {
        if (this.estateField == null) {
            return;
        }
        ImmoToolUtils.executeTask((Task)this.reloadEstates(l));
    }

    private DefaultComboBoxModel loadEstateModel() throws ImmoToolException {
        try {
            DefaultComboBoxModel<AgencyEstate.Row> defaultComboBoxModel = new DefaultComboBoxModel<AgencyEstate.Row>();
            defaultComboBoxModel.addElement(null);
            AgencyEstate.Row[] rowArray = AgencyEstate.loadEstateRows(null, null, null);
            if (rowArray != null) {
                for (AgencyEstate.Row row : rowArray) {
                    defaultComboBoxModel.addElement(row);
                }
            }
            return defaultComboBoxModel;
        }
        catch (Exception exception) {
            throw new ImmoToolException("Can't load estates!", (Throwable)exception);
        }
    }

    private Task reloadCalendarEntries(final String string) {
        if (this.calendarEntryTask != null) {
            LOGGER.info((Object)"cancel running entry-task...");
            this.calendarEntryTask.cancel(true);
        }
        this.calendarEntryField.setEnabled(false);
        this.calendarEntryField.setVisible(false);
        this.calendarEntryBusyField.setVisible(true);
        this.calendarEntryBusyField.setBusy(true);
        this.calendarEntryBusyField.setText(this.resourceMap.getString("message.doSearchCalendarEntries", new Object[0]));
        this.calendarEntryTask = new ImmoToolTask<DefaultComboBoxModel>(){

            protected DefaultComboBoxModel executeTask() throws Exception {
                if (AgencyEstateCalendarDialog.this.calendarCollection == null) {
                    AgencyEstateCalendarDialog.this.calendarCollection = CalendarPluginUtils.openPluginCollection((String)"");
                }
                DefaultComboBoxModel defaultComboBoxModel = AgencyEstateCalendarDialog.this.loadCalendarEntryModel(AgencyEstateCalendarDialog.this.calendarCollection);
                AgencyEstateCalendarDialog.this.calendarEntryBusyField.setText(AgencyEstateCalendarDialog.this.resourceMap.getString("message.doRefreshBox", new Object[0]));
                AgencyEstateCalendarDialog.this.calendarEntryField.setModel(defaultComboBoxModel);
                return defaultComboBoxModel;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)AgencyEstateCalendarDialog.this.resourceMap.getString("error.cantLoadCalendarEntriesBox", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                AgencyEstateCalendarDialog.this.calendarEntryField.setEnabled(true);
                AgencyEstateCalendarDialog.this.calendarEntryField.setVisible(true);
                AgencyEstateCalendarDialog.this.calendarEntryBusyField.setVisible(false);
                AgencyEstateCalendarDialog.this.calendarEntryBusyField.setBusy(false);
                AgencyEstateCalendarDialog.this.calendarEntryTask = null;
                if (AgencyEstateCalendarDialog.this.calendarEntryUIdOnLoad != null) {
                    AgencyEstateCalendarDialog.this.calendarEntryUIdOnLoad = null;
                }
                if (AgencyEstateCalendarDialog.this.calendarCollection != null && AgencyEstateCalendarDialog.this.calendarGroupTask == null) {
                    ImmoToolDbUtils.close((Collection)AgencyEstateCalendarDialog.this.calendarCollection);
                    AgencyEstateCalendarDialog.this.calendarCollection = null;
                }
            }

            protected void succeeded(DefaultComboBoxModel defaultComboBoxModel) {
                super.succeeded((Object)defaultComboBoxModel);
                AgencyEstateCalendarDialog.this.calendarEntryField.setSelectedIndex(-1);
                if (string != null) {
                    for (int i = 0; i < defaultComboBoxModel.getSize(); ++i) {
                        CalendarEntry calendarEntry;
                        Object e = defaultComboBoxModel.getElementAt(i);
                        if (!(e instanceof CalendarEntry) || !string.equals((calendarEntry = (CalendarEntry)e).getUId().getValue())) continue;
                        AgencyEstateCalendarDialog.this.calendarEntryField.setSelectedIndex(i);
                        break;
                    }
                }
            }
        };
        return this.calendarEntryTask;
    }

    private Task reloadCalendarGroups(final long l) {
        if (this.calendarGroupTask != null) {
            LOGGER.info((Object)"cancel running group-task...");
            this.calendarGroupTask.cancel(true);
        }
        this.calendarGroupField.setEnabled(false);
        this.calendarGroupField.setVisible(false);
        this.calendarGroupBusyField.setVisible(true);
        this.calendarGroupBusyField.setBusy(true);
        this.calendarGroupBusyField.setText(this.resourceMap.getString("message.doSearchCalendarSources", new Object[0]));
        this.calendarGroupTask = new ImmoToolTask<DefaultComboBoxModel>(){

            protected DefaultComboBoxModel executeTask() throws Exception {
                if (AgencyEstateCalendarDialog.this.calendarCollection == null) {
                    AgencyEstateCalendarDialog.this.calendarCollection = CalendarPluginUtils.openPluginCollection((String)"");
                }
                DefaultComboBoxModel defaultComboBoxModel = AgencyEstateCalendarDialog.this.loadCalendarGroupModel(AgencyEstateCalendarDialog.this.calendarCollection);
                AgencyEstateCalendarDialog.this.calendarGroupBusyField.setText(AgencyEstateCalendarDialog.this.resourceMap.getString("message.doRefreshBox", new Object[0]));
                AgencyEstateCalendarDialog.this.calendarGroupField.setModel(defaultComboBoxModel);
                return defaultComboBoxModel;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)AgencyEstateCalendarDialog.this.resourceMap.getString("error.cantLoadCalendarSourcesBox", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                AgencyEstateCalendarDialog.this.calendarGroupField.setEnabled(true);
                AgencyEstateCalendarDialog.this.calendarGroupField.setVisible(true);
                AgencyEstateCalendarDialog.this.calendarGroupBusyField.setVisible(false);
                AgencyEstateCalendarDialog.this.calendarGroupBusyField.setBusy(false);
                AgencyEstateCalendarDialog.this.calendarGroupTask = null;
                if (AgencyEstateCalendarDialog.this.calendarCollection != null && AgencyEstateCalendarDialog.this.calendarEntryTask == null) {
                    ImmoToolDbUtils.close((Collection)AgencyEstateCalendarDialog.this.calendarCollection);
                    AgencyEstateCalendarDialog.this.calendarCollection = null;
                }
            }

            protected void succeeded(DefaultComboBoxModel defaultComboBoxModel) {
                super.succeeded((Object)defaultComboBoxModel);
                if (l == 0L) {
                    AgencyEstateCalendarDialog.this.calendarGroupField.setSelectedIndex(0);
                } else if (l > 0L) {
                    AgencyEstateCalendarDialog.this.calendarGroupField.setSelectedIndex(-1);
                    for (int i = 0; i < defaultComboBoxModel.getSize(); ++i) {
                        CalendarSource calendarSource;
                        Object e = defaultComboBoxModel.getElementAt(i);
                        if (!(e instanceof CalendarSource) || (calendarSource = (CalendarSource)e).getCalendarId() != l) continue;
                        AgencyEstateCalendarDialog.this.calendarGroupField.setSelectedIndex(i);
                        break;
                    }
                }
            }
        };
        return this.calendarGroupTask;
    }

    private Task reloadEstates(final long l) {
        if (this.estateTask != null) {
            LOGGER.info((Object)"cancel running estate-task...");
            this.estateTask.cancel(true);
        }
        this.estateField.setEnabled(false);
        this.estateField.setVisible(false);
        this.estateBusyField.setVisible(true);
        this.estateBusyField.setBusy(true);
        this.estateBusyField.setText(this.resourceMap.getString("message.doSearchEstates", new Object[0]));
        this.estateTask = new ImmoToolTask<DefaultComboBoxModel>(){

            protected DefaultComboBoxModel executeTask() throws Exception {
                DefaultComboBoxModel defaultComboBoxModel = AgencyEstateCalendarDialog.this.loadEstateModel();
                AgencyEstateCalendarDialog.this.estateBusyField.setText(AgencyEstateCalendarDialog.this.resourceMap.getString("message.doRefreshBox", new Object[0]));
                AgencyEstateCalendarDialog.this.estateField.setModel(defaultComboBoxModel);
                return defaultComboBoxModel;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)AgencyEstateCalendarDialog.this.resourceMap.getString("error.cantLoadEstatesBox", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                AgencyEstateCalendarDialog.this.estateField.setEnabled(true);
                AgencyEstateCalendarDialog.this.estateField.setVisible(true);
                AgencyEstateCalendarDialog.this.estateBusyField.setVisible(false);
                AgencyEstateCalendarDialog.this.estateBusyField.setBusy(false);
                AgencyEstateCalendarDialog.this.estateTask = null;
            }

            protected void succeeded(DefaultComboBoxModel defaultComboBoxModel) {
                super.succeeded((Object)defaultComboBoxModel);
                AgencyEstateCalendarDialog.this.estateField.setSelectedIndex(0);
                if (l > 0L) {
                    for (int i = 0; i < defaultComboBoxModel.getSize(); ++i) {
                        Object e = defaultComboBoxModel.getElementAt(i);
                        if (!(e instanceof AgencyEstate.Row)) continue;
                        AgencyEstate.Row row = (AgencyEstate.Row)e;
                        if (row.id != l) continue;
                        AgencyEstateCalendarDialog.this.estateField.setSelectedIndex(i);
                        break;
                    }
                }
            }
        };
        return this.estateTask;
    }

    public void save(AgencyEstateCalendar agencyEstateCalendar) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.estateField != null && this.estateField.getSelectedIndex() <= 0) {
            arrayList.add(this.resourceMap.getString("error.noEstateSelected", new Object[0]));
        }
        if (this.calendarGroupField != null && this.calendarGroupField.getSelectedIndex() <= 0) {
            arrayList.add(this.resourceMap.getString("error.noCalendarSourceSelected", new Object[0]));
        }
        if (this.calendarEntryField != null && this.calendarEntryField.getSelectedIndex() <= 0) {
            arrayList.add(this.resourceMap.getString("error.noCalendarEntrySelected", new Object[0]));
        }
        if (!arrayList.isEmpty()) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.invalidInput", new Object[0]), arrayList);
            return;
        }
        agencyEstateCalendar.setDescription(ImmoToolUtils.replaceTags((String)this.notesField.getText()).trim());
        if (this.estateField != null) {
            agencyEstateCalendar.setEstateId(this.getSelectedAgencyEstateId());
        }
        if (this.calendarGroupField != null) {
            agencyEstateCalendar.setCalendarId(this.getSelectedCalendarSource().getCalendarId());
        }
        if (this.calendarEntryField != null) {
            agencyEstateCalendar.setCalendarUid(this.getSelectedCalendarEntry().getUId().getValue());
        }
    }

    private static class EstateRenderer
    extends JLabel
    implements ListCellRenderer {
        private EstateRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            AgencyPluginUtils.prepareListCellRenderer((JLabel)this, (JList)jList, (AgencyEstate.Row)((AgencyEstate.Row)object), (int)n, (boolean)bl, (boolean)bl2);
            return this;
        }
    }

    private class CalendarSourceRenderer
    extends JLabel
    implements ListCellRenderer {
        public CalendarSourceRenderer() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof CalendarSource) {
                CalendarSource calendarSource = (CalendarSource)object;
                this.setText("#" + calendarSource.getCalendarId() + " | " + calendarSource.getName());
            } else if (object instanceof String) {
                this.setText(object.toString());
            } else {
                this.setText(n <= 0 ? "[ " + AgencyEstateCalendarDialog.this.resourceMap.getString("message.pleaseSelectCalendarSource", new Object[0]) + " ]" : "");
            }
            return this;
        }
    }

    private class CalendarEntryRenderer
    extends JLabel
    implements ListCellRenderer {
        public CalendarEntryRenderer() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof CalendarEntry) {
                CalendarEntry calendarEntry = (CalendarEntry)object;
                if (calendarEntry.getBegin() != null) {
                    this.setText(DATEFORMAT_SHORT.format(calendarEntry.getBegin()) + " | " + calendarEntry.getSummaryString());
                } else {
                    this.setText("- | " + calendarEntry.getSummaryString());
                }
            } else if (object instanceof String) {
                this.setText(object.toString());
            } else {
                this.setText(n <= 0 ? "[ " + AgencyEstateCalendarDialog.this.resourceMap.getString("message.selectCalendarEntry", new Object[0]) + " ]" : "");
            }
            return this;
        }
    }
}

