/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.addons;

import com.jgoodies.forms.factories.Borders;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.AgencyEstateViewAddonPanel;
import com.openindex.openestate.tool.agency.addons.AgencyEstateCalendar;
import com.openindex.openestate.tool.agency.addons.AgencyEstateCalendarDialog;
import com.openindex.openestate.tool.calendar.CalendarEntry;
import com.openindex.openestate.tool.calendar.CalendarEntryTableModel;
import com.openindex.openestate.tool.calendar.CalendarEntryViewTask;
import com.openindex.openestate.tool.calendar.CalendarEventEntry;
import com.openindex.openestate.tool.calendar.CalendarEventEntryPanel;
import com.openindex.openestate.tool.calendar.CalendarObject;
import com.openindex.openestate.tool.calendar.CalendarPluginUtils;
import com.openindex.openestate.tool.calendar.CalendarSource;
import com.openindex.openestate.tool.calendar.CalendarTodoEntry;
import com.openindex.openestate.tool.calendar.CalendarTodoEntryPanel;
import com.openindex.openestate.tool.utils.QuickTableExport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import org.apache.log4j.Logger;
import org.fife.ui.rtextarea.RTextArea;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledSeparator;
import org.xmldb.api.base.Collection;

public class AgencyEstateCalendarTablePanel
extends AgencyEstateViewAddonPanel {
    private static final Logger LOGGER = Logger.getLogger(AgencyEstateCalendarTablePanel.class);
    private ActionMap actionMap;
    private ResourceMap resourceMap;
    private JPopupMenu actionsMenu;
    private TableModel resultTableModel;
    private CalendarEventEntryPanel eventEntryPanel;
    private CalendarTodoEntryPanel taskEntryPanel;
    private List<AgencyEstateCalendar> selectedEstateCalendars;
    private AgencyEstate selectedEstate = null;
    private boolean isLoaded = false;
    private boolean isModified = false;
    private JButton actionButton;
    private JButton addButton;
    private JButton calendarNotesButton;
    private JTextArea calendarNotesField;
    private JPanel calendarNotesPanel;
    private JScrollPane calendarNotesScroller;
    private JXTitledSeparator calendarNotesTitleLabel;
    private JXTable calendarTable;
    private JPanel calendarTablePanel;
    private JScrollPane calendarTableScroller;
    private JXTitledSeparator calendarTableTitleLabel;
    private JPanel eventEntryFormPanel;
    private JPanel eventFormPanel;
    private JXTitledSeparator eventFormTitleLabel;
    private JButton refreshButton;
    private JButton submitEventButton;
    private JButton submitTaskButton;
    private JTabbedPane tabPanel;
    private JPanel taskEntryFormPanel;
    private JPanel taskFormPanel;
    private JXTitledSeparator taskFormTitleLabel;
    private JXTitledSeparator titleLabel;

    public AgencyEstateCalendarTablePanel() {
        this.build();
    }

    private void build() {
        this.actionMap = ImmoToolUtils.getActionMap(AgencyEstateCalendarTablePanel.class, (Object)((Object)this));
        this.resourceMap = ImmoToolUtils.getResourceMap(AgencyEstateCalendarTablePanel.class);
        this.selectedEstateCalendars = new ArrayList<AgencyEstateCalendar>();
        this.initComponents();
        this.buildEventEntryFormPanel();
        this.buildTaskEntryFormPanel();
        this.resourceMap.injectComponents((Component)((Object)this));
        this.tabPanel.setTitleAt(0, this.resourceMap.getString("tab.calendarTable", new Object[0]));
        this.tabPanel.setTitleAt(1, this.resourceMap.getString("tab.taskForm", new Object[0]));
        this.tabPanel.setTitleAt(2, this.resourceMap.getString("tab.eventForm", new Object[0]));
        this.actionsMenu = new JPopupMenu();
        this.actionsMenu.add(new JMenuItem(this.actionMap.get("doViewEntry")));
        this.actionsMenu.addSeparator();
        this.actionsMenu.add(new JMenuItem(this.actionMap.get("doView")));
        this.actionsMenu.add(new JMenuItem(this.actionMap.get("doRemove")));
        this.resultTableModel = new TableModel();
        this.calendarTable.setModel((javax.swing.table.TableModel)((Object)this.resultTableModel));
        this.calendarTable.setSortable(true);
        this.calendarTable.getSelectionModel().setSelectionMode(0);
        this.calendarTable.getColumn(1).setCellRenderer((TableCellRenderer)new CalendarEntryTableModel.CalendarDateRenderer());
        this.calendarTable.getColumn(2).setCellRenderer((TableCellRenderer)new CalendarEntryTableModel.CalendarDateRenderer());
        this.calendarTable.getColumnModel().removeColumn(this.calendarTable.getColumn(0));
        this.calendarTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                    AgencyEstateCalendarTablePanel.this.doView();
                } else if (mouseEvent.getButton() == 3 && mouseEvent.getClickCount() == 1) {
                    int n = AgencyEstateCalendarTablePanel.this.calendarTable.rowAtPoint(mouseEvent.getPoint());
                    if (n >= 0 && n != AgencyEstateCalendarTablePanel.this.calendarTable.getSelectedRow() && n >= 0) {
                        AgencyEstateCalendarTablePanel.this.calendarTable.getSelectionModel().setSelectionInterval(n, n);
                    }
                    if (n < 0) {
                        n = AgencyEstateCalendarTablePanel.this.calendarTable.getSelectedRow();
                    }
                    if (n < 0) {
                        return;
                    }
                    AgencyEstateCalendarTablePanel.this.showActions((JComponent)AgencyEstateCalendarTablePanel.this.calendarTable, ((AgencyEstateCalendarTablePanel)AgencyEstateCalendarTablePanel.this).calendarTable.getMousePosition().x, ((AgencyEstateCalendarTablePanel)AgencyEstateCalendarTablePanel.this).calendarTable.getMousePosition().y);
                }
            }
        });
        this.calendarTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                AgencyEstateCalendarTablePanel.this.actionButton.setEnabled(AgencyEstateCalendarTablePanel.this.calendarTable.getSelectedRowCount() > 0);
                if (AgencyEstateCalendarTablePanel.this.calendarTable.getSelectedRowCount() < 1) {
                    AgencyEstateCalendarTablePanel.this.calendarNotesField.setText("");
                    AgencyEstateCalendarTablePanel.this.calendarNotesPanel.setVisible(false);
                } else {
                    int n = AgencyEstateCalendarTablePanel.this.calendarTable.convertRowIndexToModel(AgencyEstateCalendarTablePanel.this.calendarTable.getSelectedRow());
                    String string = AgencyEstateCalendarTablePanel.this.resultTableModel.getDescriptionAt(n);
                    AgencyEstateCalendarTablePanel.this.calendarNotesField.setText(string != null ? string.trim() : "");
                    AgencyEstateCalendarTablePanel.this.calendarNotesField.setCaretPosition(0);
                    AgencyEstateCalendarTablePanel.this.calendarNotesPanel.setVisible(true);
                }
            }
        });
        this.calendarTable.setColumnControl((JComponent)QuickTableExport.createColumnControl((JXTable)this.calendarTable));
        ImmoToolUtils.configureTable((JXTable)this.calendarTable);
        this.actionButton.setEnabled(false);
        this.calendarNotesPanel.setVisible(false);
    }

    private void buildEventEntryFormPanel() {
        this.eventEntryPanel = new CalendarEventEntryPanel();
        JScrollPane jScrollPane = new JScrollPane((Component)this.eventEntryPanel);
        jScrollPane.setBorder(Borders.EMPTY);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.eventEntryFormPanel.setLayout(new BorderLayout());
        this.eventEntryFormPanel.add((Component)jScrollPane, "Center");
        this.eventEntryFormPanel.revalidate();
        this.eventEntryFormPanel.repaint();
    }

    private void buildTaskEntryFormPanel() {
        this.taskEntryPanel = new CalendarTodoEntryPanel();
        JScrollPane jScrollPane = new JScrollPane((Component)this.taskEntryPanel);
        jScrollPane.setBorder(Borders.EMPTY);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.taskEntryFormPanel.setLayout(new BorderLayout());
        this.taskEntryFormPanel.add((Component)jScrollPane, "Center");
        this.taskEntryFormPanel.revalidate();
        this.taskEntryFormPanel.repaint();
    }

    @Action
    public void doAction() {
        this.showActions(this.actionButton, 0, this.actionButton.getSize().height);
    }

    @Action
    public void doAdd() {
        AgencyEstateCalendarDialog agencyEstateCalendarDialog = null;
        try {
            agencyEstateCalendarDialog = new AgencyEstateCalendarDialog(2, ImmoToolApp.getApplication().getMainFrame(), true);
            agencyEstateCalendarDialog.load(null);
            agencyEstateCalendarDialog.loadCalendar(null);
            agencyEstateCalendarDialog.setVisible(true);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"cant open calendar-dialog!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.cantOpenCalendarDialog", new Object[0]), (Throwable)exception);
            return;
        }
        try {
            if (agencyEstateCalendarDialog.getStatus() != 2) {
                return;
            }
            AgencyEstateCalendar agencyEstateCalendar = new AgencyEstateCalendar();
            agencyEstateCalendarDialog.save(agencyEstateCalendar);
            if (this.getRowForCalendar(agencyEstateCalendar.getCalendarId(), agencyEstateCalendar.getCalendarUid()) > -1) {
                LOGGER.warn((Object)"calendar-entry already exists!");
                LOGGER.warn((Object)("> cal #" + agencyEstateCalendar.getCalendarId()));
                LOGGER.warn((Object)("> uid " + agencyEstateCalendar.getCalendarUid()));
                ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.calendarEntryAlreadyExists", new Object[0]));
                return;
            }
            CalendarSource calendarSource = agencyEstateCalendarDialog.getSelectedCalendarSource();
            String string = calendarSource != null ? calendarSource.getName() : null;
            this.resultTableModel.addCalendarEntry(agencyEstateCalendarDialog.getSelectedCalendarEntry(), string, agencyEstateCalendar.getDescription());
            this.selectedEstateCalendars.add(agencyEstateCalendar);
            this.isModified = true;
        }
        catch (Exception exception) {
            LOGGER.error((Object)"cant put calendar-entry!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.cantPutCalendarEntry", new Object[0]), (Throwable)exception);
            return;
        }
    }

    public Task doLoadInBackground() {
        this.isLoaded = false;
        return this.doRefresh();
    }

    @Action
    public Task doRefresh() {
        this.resultTableModel.clear();
        this.selectedEstateCalendars.clear();
        this.calendarTable.setEnabled(false);
        this.addButton.setEnabled(false);
        this.actionButton.setEnabled(false);
        this.refreshButton.setEnabled(false);
        return new ImmoToolTask<Long>(){

            protected Long executeTask() throws Exception {
                AgencyEstateCalendar[] agencyEstateCalendarArray;
                HashMap<Long, CalendarSource> hashMap = new HashMap<Long, CalendarSource>();
                for (CalendarSource calendarSource : CalendarSource.loadSources()) {
                    hashMap.put(calendarSource.getCalendarId(), calendarSource);
                }
                Long l = AgencyEstateCalendarTablePanel.this.selectedEstate.getIdNr();
                if (l == null || l <= 0L) {
                    return 0L;
                }
                for (AgencyEstateCalendar agencyEstateCalendar : agencyEstateCalendarArray = AgencyEstateCalendar.loadEntriesForEstate(AgencyEstateCalendarTablePanel.this.selectedEstate.getIdNr())) {
                    CalendarEntry calendarEntry = agencyEstateCalendar.loadCalendarEntry();
                    if (calendarEntry == null) {
                        LOGGER.warn((Object)"calendar-entry not found!");
                        LOGGER.warn((Object)("> cal #" + agencyEstateCalendar.getCalendarId()));
                        LOGGER.warn((Object)("> uid " + agencyEstateCalendar.getCalendarUid()));
                        continue;
                    }
                    AgencyEstateCalendarTablePanel.this.selectedEstateCalendars.add(agencyEstateCalendar);
                    String string = hashMap.containsKey(calendarEntry.getCalendarId()) ? ((CalendarSource)hashMap.get(calendarEntry.getCalendarId())).getName() : null;
                    AgencyEstateCalendarTablePanel.this.resultTableModel.addCalendarEntry(calendarEntry, string, agencyEstateCalendar.getDescription());
                }
                return agencyEstateCalendarArray.length;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)AgencyEstateCalendarTablePanel.this.resourceMap.getString("error.cantLoadCalendarEntries", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                AgencyEstateCalendarTablePanel.this.calendarTable.setEnabled(true);
                AgencyEstateCalendarTablePanel.this.addButton.setEnabled(true);
                AgencyEstateCalendarTablePanel.this.refreshButton.setEnabled(true);
            }

            protected void succeeded(Long l) {
                super.succeeded((Object)l);
                AgencyEstateCalendarTablePanel.this.isLoaded = true;
                AgencyEstateCalendarTablePanel.this.isModified = false;
                AgencyEstateCalendarTablePanel.this.calendarTableTitleLabel.setTitle(AgencyEstateCalendarTablePanel.this.resourceMap.getString("calendarTableTitleLabel.title", new Object[0]) + " / " + AgencyEstateCalendarTablePanel.this.resourceMap.getString("message.resultCount", new Object[]{NumberFormat.getIntegerInstance().format(AgencyEstateCalendarTablePanel.this.calendarTable.getRowCount())}));
                AgencyEstateCalendarTablePanel.this.calendarTable.packAll();
                ImmoToolUtils.executeTask((Task)AgencyEstateCalendarTablePanel.this.eventEntryPanel.doLoadInBackground());
                ImmoToolUtils.executeTask((Task)AgencyEstateCalendarTablePanel.this.taskEntryPanel.doLoadInBackground());
            }
        };
    }

    @Action
    public void doRemove() {
        String string;
        int n;
        int n2 = n = this.calendarTable.getSelectedRowCount() > 0 ? this.calendarTable.convertRowIndexToModel(this.calendarTable.getSelectedRow()) : -1;
        if (n < 0) {
            ImmoToolUtils.showMessageWarningDialog((String)this.resourceMap.getString("error.noDeletableEntrySelected", new Object[0]));
            return;
        }
        if (!ImmoToolUtils.showQuestionDialog((String)this.resourceMap.getString("question.reallyDeleteCalendarEntry", new Object[0]))) {
            return;
        }
        CalendarEntry calendarEntry = this.resultTableModel.getEntry(n);
        if (calendarEntry == null) {
            return;
        }
        long l = calendarEntry.getCalendarId();
        String string2 = string = calendarEntry.getUId() != null ? calendarEntry.getUId().getValue() : null;
        if (string == null || l < 1L) {
            return;
        }
        for (AgencyEstateCalendar agencyEstateCalendar : this.selectedEstateCalendars) {
            if (agencyEstateCalendar.getCalendarId() != l || !agencyEstateCalendar.getCalendarUid().equals(string)) continue;
            this.selectedEstateCalendars.remove((Object)agencyEstateCalendar);
            break;
        }
        this.resultTableModel.removeRow(n);
        this.isModified = true;
    }

    @Action
    public void doSaveNotes() {
        int n;
        int n2 = n = this.calendarTable.getSelectedRowCount() > 0 ? this.calendarTable.convertRowIndexToModel(this.calendarTable.getSelectedRow()) : -1;
        if (n < 0) {
            return;
        }
        CalendarEntry calendarEntry = this.resultTableModel.getEntry(n);
        if (calendarEntry == null) {
            return;
        }
        long l = calendarEntry.getCalendarId();
        String string = calendarEntry.getUId() != null ? calendarEntry.getUId().getValue() : null;
        for (AgencyEstateCalendar agencyEstateCalendar : this.selectedEstateCalendars) {
            if (agencyEstateCalendar.getCalendarId() != l || !agencyEstateCalendar.getCalendarUid().equals(string)) continue;
            String string2 = this.calendarNotesField.getText().trim();
            agencyEstateCalendar.setDescription(string2);
            this.resultTableModel.setDescription(n, string2);
            this.isModified = true;
            break;
        }
    }

    @Action
    public Task doSubmitEvent() {
        this.eventEntryPanel.getValidationHandler().validate();
        if (!this.eventEntryPanel.getValidationHandler().isValid()) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.invalidInput", new Object[0]));
            return null;
        }
        this.submitEventButton.setEnabled(false);
        return new ImmoToolTask<CalendarEventEntry>(){
            private CalendarSource src = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected CalendarEventEntry executeTask() throws Exception {
                CalendarEventEntry calendarEventEntry;
                Collection collection = null;
                try {
                    CalendarEventEntry calendarEventEntry2 = new CalendarEventEntry();
                    AgencyEstateCalendarTablePanel.this.eventEntryPanel.save(calendarEventEntry2);
                    collection = CalendarPluginUtils.openPluginCollection((String)"");
                    this.src = CalendarSource.load((long)calendarEventEntry2.getCalendarId(), (Collection)collection);
                    if (this.src == null) {
                        throw new Exception("cant find calendar-source #" + calendarEventEntry2.getCalendarId() + "!");
                    }
                    CalendarObject calendarObject = CalendarObject.load((long)calendarEventEntry2.getCalendarId(), (Collection)collection);
                    if (calendarObject == null) {
                        throw new Exception("cant find calendar #" + calendarEventEntry2.getCalendarId() + "!");
                    }
                    calendarObject.add((CalendarEntry)calendarEventEntry2);
                    calendarObject.save(collection);
                    AgencyEstateCalendarTablePanel.this.eventEntryPanel.load(new CalendarEventEntry());
                    calendarEventEntry = calendarEventEntry2;
                }
                catch (Throwable throwable) {
                    ImmoToolDbUtils.close(collection);
                    throw throwable;
                }
                ImmoToolDbUtils.close((Collection)collection);
                return calendarEventEntry;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)AgencyEstateCalendarTablePanel.this.resourceMap.getString("error.cantCreateEvent", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                AgencyEstateCalendarTablePanel.this.submitEventButton.setEnabled(true);
            }

            protected void succeeded(CalendarEventEntry calendarEventEntry) {
                super.succeeded((Object)calendarEventEntry);
                AgencyEstateCalendarTablePanel.this.resultTableModel.addCalendarEntry((CalendarEntry)calendarEventEntry, this.src != null ? this.src.getName() : "", "");
                AgencyEstateCalendar agencyEstateCalendar = new AgencyEstateCalendar(AgencyEstateCalendarTablePanel.this.selectedEstate.getIdNr() > 0L ? AgencyEstateCalendarTablePanel.this.selectedEstate.getIdNr() : 0L, calendarEventEntry.getCalendarId(), calendarEventEntry.getUId().getValue(), "");
                AgencyEstateCalendarTablePanel.this.selectedEstateCalendars.add(agencyEstateCalendar);
                AgencyEstateCalendarTablePanel.this.isModified = true;
                AgencyEstateCalendarTablePanel.this.tabPanel.setSelectedIndex(0);
                ImmoToolUtils.showMessageInfoDialog((String)AgencyEstateCalendarTablePanel.this.resourceMap.getString("message.eventSavedAndMapped", new Object[0]));
            }
        };
    }

    @Action
    public Task doSubmitTask() {
        this.taskEntryPanel.getValidationHandler().validate();
        if (!this.taskEntryPanel.getValidationHandler().isValid()) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.invalidInput", new Object[0]));
            return null;
        }
        this.submitTaskButton.setEnabled(false);
        return new ImmoToolTask<CalendarTodoEntry>(){
            private CalendarSource src = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected CalendarTodoEntry executeTask() throws Exception {
                CalendarTodoEntry calendarTodoEntry;
                Collection collection = null;
                try {
                    CalendarTodoEntry calendarTodoEntry2 = new CalendarTodoEntry();
                    AgencyEstateCalendarTablePanel.this.taskEntryPanel.save(calendarTodoEntry2);
                    collection = CalendarPluginUtils.openPluginCollection((String)"");
                    this.src = CalendarSource.load((long)calendarTodoEntry2.getCalendarId(), (Collection)collection);
                    if (this.src == null) {
                        throw new Exception("cant find calendar-source #" + calendarTodoEntry2.getCalendarId() + "!");
                    }
                    CalendarObject calendarObject = CalendarObject.load((long)calendarTodoEntry2.getCalendarId(), (Collection)collection);
                    if (calendarObject == null) {
                        throw new Exception("cant find calendar #" + calendarTodoEntry2.getCalendarId() + "!");
                    }
                    calendarObject.add((CalendarEntry)calendarTodoEntry2);
                    calendarObject.save(collection);
                    AgencyEstateCalendarTablePanel.this.taskEntryPanel.load(new CalendarTodoEntry());
                    calendarTodoEntry = calendarTodoEntry2;
                }
                catch (Throwable throwable) {
                    ImmoToolDbUtils.close(collection);
                    throw throwable;
                }
                ImmoToolDbUtils.close((Collection)collection);
                return calendarTodoEntry;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)AgencyEstateCalendarTablePanel.this.resourceMap.getString("error.cantCreateTask", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                AgencyEstateCalendarTablePanel.this.submitTaskButton.setEnabled(true);
            }

            protected void succeeded(CalendarTodoEntry calendarTodoEntry) {
                super.succeeded((Object)calendarTodoEntry);
                AgencyEstateCalendarTablePanel.this.resultTableModel.addCalendarEntry((CalendarEntry)calendarTodoEntry, this.src != null ? this.src.getName() : "", "");
                AgencyEstateCalendar agencyEstateCalendar = new AgencyEstateCalendar(AgencyEstateCalendarTablePanel.this.selectedEstate.getIdNr() > 0L ? AgencyEstateCalendarTablePanel.this.selectedEstate.getIdNr() : 0L, calendarTodoEntry.getCalendarId(), calendarTodoEntry.getUId().getValue(), "");
                AgencyEstateCalendarTablePanel.this.selectedEstateCalendars.add(agencyEstateCalendar);
                AgencyEstateCalendarTablePanel.this.isModified = true;
                AgencyEstateCalendarTablePanel.this.tabPanel.setSelectedIndex(0);
                ImmoToolUtils.showMessageInfoDialog((String)AgencyEstateCalendarTablePanel.this.resourceMap.getString("message.taskSavedAndMapped", new Object[0]));
            }
        };
    }

    @Action
    public void doView() {
        if (this.calendarTable.getSelectedRowCount() < 1) {
            return;
        }
        int n = this.calendarTable.getSelectedRow();
        int n2 = this.calendarTable.convertRowIndexToModel(n);
        AgencyEstateCalendar agencyEstateCalendar = null;
        CalendarEntry calendarEntry = this.resultTableModel.getEntry(n2);
        if (calendarEntry == null) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.noCalendarEntryFound", new Object[0]));
            return;
        }
        long l = calendarEntry.getCalendarId();
        String string = calendarEntry.getUId() != null ? calendarEntry.getUId().getValue() : null;
        for (AgencyEstateCalendar agencyEstateCalendar2 : this.selectedEstateCalendars) {
            if (agencyEstateCalendar2.getCalendarId() != l || !agencyEstateCalendar2.getCalendarUid().equals(string)) continue;
            agencyEstateCalendar = agencyEstateCalendar2;
            break;
        }
        if (agencyEstateCalendar == null) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.noViewableEntrySelected", new Object[0]));
            return;
        }
        Object object = null;
        try {
            object = new AgencyEstateCalendarDialog(2, ImmoToolApp.getApplication().getMainFrame(), true);
            ((AgencyEstateCalendarDialog)object).load(agencyEstateCalendar);
            ((AgencyEstateCalendarDialog)object).loadCalendar(calendarEntry);
            ((Dialog)object).setVisible(true);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Can't open calendar-dialog!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.cantOpenCalendarDialog", new Object[0]), (Throwable)exception);
            return;
        }
        if (((AgencyEstateCalendarDialog)object).getStatus() != 2) {
            return;
        }
        try {
            int n3;
            ((AgencyEstateCalendarDialog)object).save(agencyEstateCalendar);
            int n4 = this.getRowForCalendar(agencyEstateCalendar.getCalendarId(), agencyEstateCalendar.getCalendarUid());
            int n5 = n3 = n4 > -1 ? this.calendarTable.convertRowIndexToModel(n4) : -1;
            if (n3 > -1 && n2 != n3) {
                LOGGER.warn((Object)"Calendar entry is already mapped!");
                LOGGER.warn((Object)("> cal #" + agencyEstateCalendar.getCalendarId()));
                LOGGER.warn((Object)("> uid " + agencyEstateCalendar.getCalendarUid()));
                ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.calendarEntryAlreadyExists", new Object[0]));
                return;
            }
            CalendarSource calendarSource = ((AgencyEstateCalendarDialog)object).getSelectedCalendarSource();
            String string2 = calendarSource != null ? calendarSource.getName() : null;
            this.resultTableModel.setCalendarEntry(n2, ((AgencyEstateCalendarDialog)object).getSelectedCalendarEntry(), string2, agencyEstateCalendar.getDescription());
            this.isModified = true;
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Can't put calendar entry!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.cantPutCalendarEntry", new Object[0]), (Throwable)exception);
            return;
        }
    }

    @Action
    public Task doViewEntry() {
        int n;
        int n2 = n = this.calendarTable.getSelectedRowCount() > 0 ? this.calendarTable.convertRowIndexToModel(this.calendarTable.getSelectedRow()) : -1;
        if (n < 0) {
            return null;
        }
        CalendarEntry calendarEntry = this.resultTableModel.getEntry(n);
        return new CalendarEntryViewTask(calendarEntry);
    }

    private int getRowForCalendar(long l, String string) {
        for (int i = 0; i < this.calendarTable.getRowCount(); ++i) {
            if (!string.equals(this.resultTableModel.getEntryUId(i)) || l != this.resultTableModel.getEntryCalId(i)) continue;
            return i;
        }
        return -1;
    }

    public String getTitle() {
        return this.resourceMap.getString("title", new Object[0]);
    }

    public boolean isLoadedInBackground() {
        return true;
    }

    public boolean isFormEnabled() {
        return this.isLoaded;
    }

    public boolean isFormModified() {
        return this.isModified;
    }

    public boolean isFormUsable() {
        return ImmoToolApp.getApplication().getProject().getPlugin("OpenEstate-Agency") != null;
    }

    public void load(AgencyEstate agencyEstate) throws ImmoToolException {
        this.selectedEstate = agencyEstate;
    }

    public void save(AgencyEstate agencyEstate) throws ImmoToolException {
    }

    public void saveFinished(AgencyEstate agencyEstate) throws ImmoToolException {
        AgencyEstateCalendar[] agencyEstateCalendarArray;
        int n = this.selectedEstateCalendars.size();
        for (AgencyEstateCalendar agencyEstateCalendar : agencyEstateCalendarArray = this.selectedEstateCalendars.toArray(new AgencyEstateCalendar[n])) {
            agencyEstateCalendar.setEstateId(agencyEstate.getIdNr());
        }
        AgencyEstateCalendar.setAgencyEstateCalendars(agencyEstate, agencyEstateCalendarArray);
        AgencyEstate.storeEstate((AgencyEstate)agencyEstate);
    }

    private void showActions(JComponent jComponent, int n, int n2) {
        if (this.calendarTable.getSelectedRowCount() < 1) {
            return;
        }
        this.actionsMenu.show(jComponent, n, n2);
    }

    private void initComponents() {
        this.titleLabel = ImmoToolUtils.createHead2Separator((String)"");
        this.tabPanel = new JTabbedPane();
        this.calendarTablePanel = new JPanel();
        this.calendarTableTitleLabel = ImmoToolUtils.createHead2Separator((String)"");
        this.refreshButton = new JButton();
        this.addButton = new JButton();
        this.actionButton = new JButton();
        this.calendarTableScroller = new JScrollPane();
        this.calendarTable = new JXTable();
        this.calendarNotesPanel = new JPanel();
        this.calendarNotesTitleLabel = ImmoToolUtils.createHead2Separator((String)"");
        this.calendarNotesButton = new JButton();
        this.calendarNotesScroller = new JScrollPane();
        this.calendarNotesField = new RTextArea();
        this.taskFormPanel = new JPanel();
        this.taskFormTitleLabel = ImmoToolUtils.createHead2Separator((String)"");
        this.submitTaskButton = new JButton();
        this.taskEntryFormPanel = new JPanel();
        this.eventFormPanel = new JPanel();
        this.eventFormTitleLabel = ImmoToolUtils.createHead2Separator((String)"");
        this.submitEventButton = new JButton();
        this.eventEntryFormPanel = new JPanel();
        this.titleLabel.setName("titleLabel");
        this.tabPanel.setName("tabPanel");
        this.calendarTablePanel.setName("calendarTablePanel");
        this.calendarTableTitleLabel.setName("calendarTableTitleLabel");
        ApplicationActionMap applicationActionMap = Application.getInstance().getContext().getActionMap(AgencyEstateCalendarTablePanel.class, (Object)this);
        this.refreshButton.setAction(applicationActionMap.get("doRefresh"));
        this.refreshButton.setName("refreshButton");
        this.addButton.setAction(applicationActionMap.get("doAdd"));
        this.addButton.setName("addButton");
        this.actionButton.setAction(applicationActionMap.get("doAction"));
        this.actionButton.setName("actionButton");
        this.calendarTableScroller.setName("calendarTableScroller");
        this.calendarTable.setColumnControlVisible(true);
        this.calendarTable.setName("calendarTable");
        this.calendarTableScroller.setViewportView((Component)this.calendarTable);
        this.calendarNotesPanel.setName("calendarNotesPanel");
        this.calendarNotesTitleLabel.setName("calendarNotesTitleLabel");
        this.calendarNotesButton.setAction(applicationActionMap.get("doSaveNotes"));
        this.calendarNotesButton.setName("calendarNotesButton");
        this.calendarNotesScroller.setName("calendarNotesScroller");
        this.calendarNotesField.setColumns(20);
        this.calendarNotesField.setLineWrap(true);
        this.calendarNotesField.setRows(5);
        this.calendarNotesField.setWrapStyleWord(true);
        this.calendarNotesField.setName("calendarNotesField");
        this.calendarNotesScroller.setViewportView(this.calendarNotesField);
        GroupLayout groupLayout = new GroupLayout(this.calendarNotesPanel);
        this.calendarNotesPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent((Component)this.calendarNotesTitleLabel, -1, 467, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.calendarNotesButton)).addComponent(this.calendarNotesScroller, GroupLayout.Alignment.TRAILING, -1, 528, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.calendarNotesButton).addComponent((Component)this.calendarNotesTitleLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.calendarNotesScroller, -2, -1, -2)));
        GroupLayout groupLayout2 = new GroupLayout(this.calendarTablePanel);
        this.calendarTablePanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.calendarTableScroller, GroupLayout.Alignment.LEADING, -1, 528, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addComponent((Component)this.calendarTableTitleLabel, -1, 345, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.refreshButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.actionButton)).addComponent(this.calendarNotesPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.calendarTableTitleLabel, -2, -1, -2).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.actionButton).addComponent(this.addButton).addComponent(this.refreshButton))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.calendarTableScroller, -1, 253, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.calendarNotesPanel, -2, -1, -2).addContainerGap()));
        ResourceMap resourceMap = Application.getInstance().getContext().getResourceMap(AgencyEstateCalendarTablePanel.class);
        this.tabPanel.addTab(resourceMap.getString("calendarTablePanel.TabConstraints.tabTitle", new Object[0]), this.calendarTablePanel);
        this.taskFormPanel.setName("taskFormPanel");
        this.taskFormTitleLabel.setName("taskFormTitleLabel");
        this.submitTaskButton.setAction(applicationActionMap.get("doSubmitTask"));
        this.submitTaskButton.setName("submitTaskButton");
        this.taskEntryFormPanel.setName("taskEntryFormPanel");
        GroupLayout groupLayout3 = new GroupLayout(this.taskEntryFormPanel);
        this.taskEntryFormPanel.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 528, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 368, Short.MAX_VALUE));
        GroupLayout groupLayout4 = new GroupLayout(this.taskFormPanel);
        this.taskFormPanel.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout4.createSequentialGroup().addContainerGap().addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.taskEntryFormPanel, -1, -1, Short.MAX_VALUE).addGroup(groupLayout4.createSequentialGroup().addComponent((Component)this.taskFormTitleLabel, -1, 461, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.submitTaskButton))).addContainerGap()));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addContainerGap().addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.taskFormTitleLabel, -2, -1, -2).addComponent(this.submitTaskButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.taskEntryFormPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.tabPanel.addTab(resourceMap.getString("taskFormPanel.TabConstraints.tabTitle", new Object[0]), this.taskFormPanel);
        this.eventFormPanel.setName("eventFormPanel");
        this.eventFormTitleLabel.setName("eventFormTitleLabel");
        this.submitEventButton.setAction(applicationActionMap.get("doSubmitEvent"));
        this.submitEventButton.setName("submitEventButton");
        this.eventEntryFormPanel.setName("eventEntryFormPanel");
        GroupLayout groupLayout5 = new GroupLayout(this.eventEntryFormPanel);
        this.eventEntryFormPanel.setLayout(groupLayout5);
        groupLayout5.setHorizontalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 528, Short.MAX_VALUE));
        groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 368, Short.MAX_VALUE));
        GroupLayout groupLayout6 = new GroupLayout(this.eventFormPanel);
        this.eventFormPanel.setLayout(groupLayout6);
        groupLayout6.setHorizontalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout6.createSequentialGroup().addContainerGap().addGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.eventEntryFormPanel, -1, -1, Short.MAX_VALUE).addGroup(groupLayout6.createSequentialGroup().addComponent((Component)this.eventFormTitleLabel, -1, 461, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.submitEventButton))).addContainerGap()));
        groupLayout6.setVerticalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout6.createSequentialGroup().addContainerGap().addGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.eventFormTitleLabel, -2, -1, -2).addComponent(this.submitEventButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.eventEntryFormPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.tabPanel.addTab(resourceMap.getString("eventFormPanel.TabConstraints.tabTitle", new Object[0]), this.eventFormPanel);
        GroupLayout groupLayout7 = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout7);
        groupLayout7.setHorizontalGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout7.createSequentialGroup().addContainerGap().addGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.tabPanel, GroupLayout.Alignment.LEADING, -1, 557, Short.MAX_VALUE).addComponent((Component)this.titleLabel, GroupLayout.Alignment.LEADING, -1, 557, Short.MAX_VALUE)).addContainerGap()));
        groupLayout7.setVerticalGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout7.createSequentialGroup().addContainerGap().addComponent((Component)this.titleLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.tabPanel, -1, 450, Short.MAX_VALUE).addContainerGap()));
        resourceMap.injectComponents((Component)((Object)this));
    }

    private final class TableModel
    extends CalendarEntryTableModel {
        private int descriptionCol = this.getColumnCount();

        public TableModel() {
            this.setColumnCount(this.descriptionCol + 1);
        }

        public void addCalendarEntry(CalendarEntry calendarEntry, String string) {
            this.addCalendarEntry(calendarEntry, string, "");
        }

        public void addCalendarEntry(CalendarEntry calendarEntry, String string, String string2) {
            super.addCalendarEntry(calendarEntry, string);
            this.setDescription(this.getRowCount() - 1, string2);
        }

        public Class getColumnClass(int n) {
            if (n == this.descriptionCol) {
                return String.class;
            }
            return super.getColumnClass(n);
        }

        public String getColumnName(int n) {
            return n == this.descriptionCol ? AgencyEstateCalendarTablePanel.this.resourceMap.getString("label.descriptionCol", new Object[0]) : super.getColumnName(n);
        }

        public String getDescriptionAt(int n) {
            return (String)this.getValueAt(n, this.descriptionCol);
        }

        public int getDescriptionCol() {
            return this.descriptionCol;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void setCalendarEntry(int n, CalendarEntry calendarEntry, String string) {
            this.setCalendarEntry(n, calendarEntry, string, "");
        }

        public void setCalendarEntry(int n, CalendarEntry calendarEntry, String string, String string2) {
            super.setCalendarEntry(n, calendarEntry, string);
            this.setDescription(n, string2);
        }

        public void setDescription(int n, String string) {
            this.setValueAt(string, n, this.descriptionCol);
        }
    }
}

