/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.addons;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.openindex.openestate.impl.CompanyAdressImpl;
import com.openindex.openestate.impl.SimpleAdressImpl;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.AgencyEstateViewAddonPanel;
import com.openindex.openestate.tool.agency.addons.ContactsEntryEstate;
import com.openindex.openestate.tool.agency.addons.ContactsEntryEstateDialog;
import com.openindex.openestate.tool.contacts.ContactsEntry;
import com.openindex.openestate.tool.contacts.ContactsEntryTableModel;
import com.openindex.openestate.tool.contacts.ContactsEntryViewPanel;
import com.openindex.openestate.tool.contacts.ContactsGroup;
import com.openindex.openestate.tool.contacts.ContactsGroupItem;
import com.openindex.openestate.tool.utils.JAdressPanel;
import com.openindex.openestate.tool.utils.NonEmptyComboBoxRule;
import com.openindex.openestate.tool.utils.QuickTableExport;
import com.openindex.openestate.tool.utils.TabComponent;
import com.openindex.openestate.tool.utils.ValidationHandler;
import com.openindex.openestate.tool.utils.ValidationRule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ActionMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import org.fife.ui.rtextarea.RTextArea;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledSeparator;

public class AgencyEstateContactTablePanel
extends AgencyEstateViewAddonPanel {
    private static final Logger LOGGER = Logger.getLogger(AgencyEstateContactTablePanel.class);
    private ActionMap actionMap;
    private ResourceMap resourceMap;
    private ValidationHandler validationHandler;
    private JPopupMenu actionsMenu;
    private TableModel contactsTableModel;
    private JAdressPanel adressPanel;
    private JComboBox adressGroupBox;
    private JComboBox adressTypeBox;
    private RTextArea adressTextArea;
    private Map<String, String> adressTypes;
    private List<ContactsEntryEstate> selectedContacts;
    private AgencyEstate selectedEstate = null;
    private long selectedEstateId = 0L;
    private boolean isLoaded = false;
    private boolean isModified = false;
    private JButton actionButton;
    private JButton addButton;
    private JPanel adressFormContainerPanel;
    private JPanel adressFormPanel;
    private JXTitledSeparator adressFormTitleLabel;
    private JButton adressNotesButton;
    private JTextArea adressNotesField;
    private JPanel adressNotesPanel;
    private JScrollPane adressNotesScroller;
    private JXTitledSeparator adressNotesTitleLabel;
    private JXTable adressTable;
    private JPanel adressTablePanel;
    private JScrollPane adressTableScroller;
    private JXTitledSeparator adressTableTitleLabel;
    private JButton refreshButton;
    private JButton submitAdressButton;
    private JTabbedPane tabPanel;
    private JXTitledSeparator titleLabel;

    public AgencyEstateContactTablePanel() {
        this.build();
    }

    private void build() {
        this.actionMap = ImmoToolUtils.getActionMap(AgencyEstateContactTablePanel.class, (Object)((Object)this));
        this.resourceMap = ImmoToolUtils.getResourceMap(AgencyEstateContactTablePanel.class);
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.selectedContacts = new ArrayList<ContactsEntryEstate>();
        this.initComponents();
        this.buildFormPanel();
        this.resourceMap.injectComponents((Component)((Object)this));
        this.tabPanel.setTitleAt(0, this.resourceMap.getString("tab.adressTable", new Object[0]));
        this.tabPanel.setTitleAt(1, this.resourceMap.getString("tab.adressForm", new Object[0]));
        this.adressTypes = new TreeMap<String, String>();
        this.adressTypes.put(ContactsEntryEstate.writeType("customer"), "customer");
        this.adressTypes.put(ContactsEntryEstate.writeType("interested"), "interested");
        this.adressTypes.put(ContactsEntryEstate.writeType("owner"), "owner");
        ((DefaultComboBoxModel)this.adressTypeBox.getModel()).addElement("");
        for (String string : this.adressTypes.keySet()) {
            ((DefaultComboBoxModel)this.adressTypeBox.getModel()).addElement(string);
        }
        this.actionsMenu = new JPopupMenu();
        this.actionsMenu.add(new JMenuItem(this.actionMap.get("doViewCustomer")));
        this.actionsMenu.addSeparator();
        this.actionsMenu.add(new JMenuItem(this.actionMap.get("doView")));
        this.actionsMenu.add(new JMenuItem(this.actionMap.get("doRemove")));
        this.contactsTableModel = new TableModel();
        this.adressTable.setModel((javax.swing.table.TableModel)((Object)this.contactsTableModel));
        this.adressTable.removeColumn(this.adressTable.getColumn(10));
        this.adressTable.setSortable(true);
        this.adressTable.getSelectionModel().setSelectionMode(0);
        this.adressTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                    AgencyEstateContactTablePanel.this.doView();
                } else if (mouseEvent.getButton() == 3 && mouseEvent.getClickCount() == 1) {
                    int n = AgencyEstateContactTablePanel.this.adressTable.rowAtPoint(mouseEvent.getPoint());
                    if (n >= 0 && n != AgencyEstateContactTablePanel.this.adressTable.getSelectedRow() && n >= 0) {
                        AgencyEstateContactTablePanel.this.adressTable.getSelectionModel().setSelectionInterval(n, n);
                    }
                    if (n < 0) {
                        n = AgencyEstateContactTablePanel.this.adressTable.getSelectedRow();
                    }
                    if (n < 0) {
                        return;
                    }
                    AgencyEstateContactTablePanel.this.actionsMenu.show((Component)AgencyEstateContactTablePanel.this.adressTable, ((AgencyEstateContactTablePanel)AgencyEstateContactTablePanel.this).adressTable.getMousePosition().x, ((AgencyEstateContactTablePanel)AgencyEstateContactTablePanel.this).adressTable.getMousePosition().y);
                }
            }
        });
        this.adressTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                AgencyEstateContactTablePanel.this.actionButton.setEnabled(AgencyEstateContactTablePanel.this.adressTable.getSelectedRowCount() > 0);
                if (AgencyEstateContactTablePanel.this.adressTable.getSelectedRowCount() < 1) {
                    AgencyEstateContactTablePanel.this.adressNotesField.setText("");
                    AgencyEstateContactTablePanel.this.adressNotesPanel.setVisible(false);
                } else {
                    int n = AgencyEstateContactTablePanel.this.adressTable.convertRowIndexToModel(AgencyEstateContactTablePanel.this.adressTable.getSelectedRow());
                    String string = AgencyEstateContactTablePanel.this.contactsTableModel.getDescriptionAt(n);
                    AgencyEstateContactTablePanel.this.adressNotesField.setText(string != null ? string.trim() : "");
                    AgencyEstateContactTablePanel.this.adressNotesField.setCaretPosition(0);
                    AgencyEstateContactTablePanel.this.adressNotesPanel.setVisible(true);
                }
            }
        });
        this.adressTable.setColumnControl((JComponent)QuickTableExport.createColumnControl((JXTable)this.adressTable));
        ImmoToolUtils.configureTable((JXTable)this.adressTable);
        this.actionButton.setEnabled(false);
        this.adressNotesPanel.setVisible(false);
    }

    private void buildFormPanel() {
        this.adressGroupBox = new JComboBox(new DefaultComboBoxModel());
        this.adressGroupBox.setName("adressGroupBox");
        this.adressTypeBox = new JComboBox(new DefaultComboBoxModel());
        this.adressTypeBox.setName("adressTypeBox");
        this.adressTypeBox.setEditable(true);
        this.adressTextArea = new RTextArea();
        this.adressTextArea.setName("adressTextArea");
        this.adressTextArea.setLineWrap(true);
        this.adressTextArea.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane((Component)this.adressTextArea);
        jScrollPane.setPreferredSize(new Dimension(jScrollPane.getPreferredSize().width, 50));
        this.adressPanel = new JAdressPanel(new ContactsEntry().getAdress(), 40, 40){

            protected void init() {
                this.registerValidation(this.personFirstNameField);
                this.registerValidation(this.personLastNameField);
            }
        };
        this.validationHandler.putRule((JComponent)this.adressGroupBox, (ValidationRule)new NonEmptyComboBoxRule(this.adressGroupBox));
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:[40dlu,pref], 3dlu, pref:grow");
        defaultFormBuilder.border(Borders.DIALOG);
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("label.adressMapping", new Object[0])), 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.adressMapping.group", new Object[0]), (Component)this.adressGroupBox);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.adressMapping.type", new Object[0]), (Component)this.adressTypeBox);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.adressMapping.notes", new Object[0]), (Component)jScrollPane);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.adressPanel, 3);
        defaultFormBuilder.nextLine();
        JScrollPane jScrollPane2 = new JScrollPane(defaultFormBuilder.getPanel());
        jScrollPane2.setBorder(Borders.EMPTY);
        jScrollPane2.getVerticalScrollBar().setUnitIncrement(20);
        this.adressFormContainerPanel.setLayout(new BorderLayout());
        this.adressFormContainerPanel.add((Component)jScrollPane2, "Center");
        this.adressFormContainerPanel.revalidate();
        this.adressFormContainerPanel.repaint();
    }

    @Action
    public void doAction() {
        this.actionsMenu.show(this.actionButton, 0, this.actionButton.getSize().height);
    }

    @Action
    public void doAdd() {
        ContactsEntryEstateDialog contactsEntryEstateDialog = null;
        try {
            contactsEntryEstateDialog = new ContactsEntryEstateDialog(2, ImmoToolApp.getApplication().getMainFrame(), true);
            contactsEntryEstateDialog.load(null);
            contactsEntryEstateDialog.loadContact(null);
            contactsEntryEstateDialog.setVisible(true);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"cant open contact-dialog!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.cantOpenContactDialog", new Object[0]), (Throwable)exception);
            return;
        }
        try {
            if (contactsEntryEstateDialog.getStatus() != 2) {
                return;
            }
            ContactsEntryEstate contactsEntryEstate = new ContactsEntryEstate();
            contactsEntryEstateDialog.save(contactsEntryEstate);
            if (this.getRowForCustomer(contactsEntryEstate.getContactEntryId()) > -1) {
                LOGGER.warn((Object)"contact-entry already exists!");
                LOGGER.warn((Object)("> group #" + contactsEntryEstate.getContactGroupId()));
                LOGGER.warn((Object)("> entry # " + contactsEntryEstate.getContactEntryId()));
                ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.contactEntryAlreadyExists", new Object[0]));
                return;
            }
            ContactsEntry.Row[] rowArray = ContactsEntry.loadRows((Long[])new Long[]{contactsEntryEstate.getContactEntryId()}, (Long[])new Long[]{contactsEntryEstate.getContactGroupId()}, null, null);
            if (rowArray != null && rowArray.length > 0) {
                ContactsGroup contactsGroup = ContactsGroup.load((long)rowArray[0].group);
                if (contactsGroup == null) {
                    LOGGER.warn((Object)("unknown contact-group #" + rowArray[0].group + "!"));
                }
                String string = contactsGroup != null ? contactsGroup.getName() : "";
                this.contactsTableModel.addContactsEntry(rowArray[0], string, contactsEntryEstate.getDescription(), contactsEntryEstate.getType());
                this.selectedContacts.add(contactsEntryEstate);
                this.isModified = true;
            }
        }
        catch (Exception exception) {
            LOGGER.error((Object)"cant put contact-entry!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.cantPutContactEntry", new Object[0]), (Throwable)exception);
            return;
        }
    }

    public Task doLoadInBackground() {
        this.isLoaded = false;
        this.actionButton.setEnabled(false);
        return new ImmoToolTask<Object[]>(){

            protected Object[] executeTask() throws Exception {
                ArrayList<ContactsEntryEstate> arrayList;
                Object object;
                Object[] objectArray = new Object[3];
                DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
                defaultComboBoxModel.addElement(" [ " + AgencyEstateContactTablePanel.this.resourceMap.getString("label.selectContactGroup", new Object[0]) + " ] ");
                Object object2 = ContactsGroup.loadGroups();
                int n = ((ContactsGroup[])object2).length;
                for (int i = 0; i < n; ++i) {
                    object = object2[i];
                    defaultComboBoxModel.addElement((String)new ContactsGroupItem((ContactsGroup)object));
                }
                objectArray[0] = defaultComboBoxModel;
                objectArray[1] = object2 = new TableModel();
                objectArray[2] = arrayList = new ArrayList<ContactsEntryEstate>();
                if (AgencyEstateContactTablePanel.this.selectedEstateId > 0L) {
                    ContactsEntryEstate[] contactsEntryEstateArray = ContactsEntryEstate.loadEntriesForEstate(AgencyEstateContactTablePanel.this.selectedEstateId);
                    if (contactsEntryEstateArray == null) {
                        return objectArray;
                    }
                    object = new ArrayList();
                    HashMap<Long, ContactsEntryEstate> hashMap = new HashMap<Long, ContactsEntryEstate>();
                    ContactsEntryEstate[] contactsEntryEstateArray2 = contactsEntryEstateArray;
                    int n2 = contactsEntryEstateArray2.length;
                    for (int i = 0; i < n2; ++i) {
                        ContactsEntryEstate contactsEntryEstate = contactsEntryEstateArray2[i];
                        hashMap.put(contactsEntryEstate.getContactEntryId(), contactsEntryEstate);
                        if (object.contains(contactsEntryEstate.getContactGroupId())) continue;
                        object.add(contactsEntryEstate.getContactGroupId());
                    }
                    if (!hashMap.isEmpty() && !object.isEmpty() && (contactsEntryEstateArray2 = ContactsEntry.loadRows((Long[])hashMap.keySet().toArray(new Long[hashMap.size()]), (Long[])object.toArray(new Long[object.size()]), null, null)) != null) {
                        for (ContactsEntryEstate contactsEntryEstate : contactsEntryEstateArray2) {
                            if (!hashMap.containsKey(((ContactsEntry.Row)contactsEntryEstate).id)) {
                                LOGGER.warn((Object)("unknown contact-entry #" + ((ContactsEntry.Row)contactsEntryEstate).id));
                                continue;
                            }
                            ContactsEntryEstate contactsEntryEstate2 = (ContactsEntryEstate)hashMap.get(((ContactsEntry.Row)contactsEntryEstate).id);
                            arrayList.add(contactsEntryEstate2);
                            ContactsGroup contactsGroup = ContactsGroup.load((long)((ContactsEntry.Row)contactsEntryEstate).group);
                            if (contactsGroup == null) {
                                LOGGER.warn((Object)("unknown contact-group #" + ((ContactsEntry.Row)contactsEntryEstate).group + "!"));
                            }
                            String string = contactsGroup != null ? contactsGroup.getName() : "";
                            ((TableModel)((Object)object2)).addContactsEntry((ContactsEntry.Row)contactsEntryEstate, string, contactsEntryEstate2.getDescription(), contactsEntryEstate2.getType());
                        }
                    }
                }
                return objectArray;
            }

            protected void finished() {
                super.finished();
                AgencyEstateContactTablePanel.this.actionButton.setEnabled(false);
            }

            protected void succeeded(Object[] objectArray) {
                super.succeeded((Object)objectArray);
                AgencyEstateContactTablePanel.this.adressGroupBox.setModel((DefaultComboBoxModel)objectArray[0]);
                AgencyEstateContactTablePanel.this.contactsTableModel = (TableModel)((Object)objectArray[1]);
                AgencyEstateContactTablePanel.this.selectedContacts = (List)objectArray[2];
                AgencyEstateContactTablePanel.this.adressTable.setModel((javax.swing.table.TableModel)((Object)AgencyEstateContactTablePanel.this.contactsTableModel));
                AgencyEstateContactTablePanel.this.isLoaded = true;
                AgencyEstateContactTablePanel.this.isModified = false;
                AgencyEstateContactTablePanel.this.adressTableTitleLabel.setTitle(AgencyEstateContactTablePanel.this.resourceMap.getString("adressTableTitleLabel.title", new Object[0]) + " / " + AgencyEstateContactTablePanel.this.resourceMap.getString("message.resultCount", new Object[]{NumberFormat.getIntegerInstance().format(AgencyEstateContactTablePanel.this.adressTable.getRowCount())}));
                AgencyEstateContactTablePanel.this.adressTable.packAll();
            }
        };
    }

    @Action
    public Task doRefresh() {
        if (this.selectedEstate == null) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.noEstateSelected", new Object[0]));
            return null;
        }
        this.adressTable.setEnabled(false);
        this.refreshButton.setEnabled(false);
        return new ImmoToolTask<Boolean>(){

            protected Boolean executeTask() throws Exception {
                AgencyEstateContactTablePanel.this.load(AgencyEstateContactTablePanel.this.selectedEstate);
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                AgencyEstateContactTablePanel.this.adressTable.setEnabled(true);
                AgencyEstateContactTablePanel.this.refreshButton.setEnabled(true);
                ImmoToolUtils.showMessageErrorDialog((String)AgencyEstateContactTablePanel.this.resourceMap.getString("error.cantLoadEstate", new Object[0]), (Throwable)throwable);
            }

            protected void succeeded(Boolean bl) {
                super.succeeded((Object)bl);
                AgencyEstateContactTablePanel.this.adressTable.packAll();
                AgencyEstateContactTablePanel.this.adressTable.setEnabled(true);
                AgencyEstateContactTablePanel.this.refreshButton.setEnabled(true);
                AgencyEstateContactTablePanel.this.isModified = false;
            }
        };
    }

    @Action
    public void doRemove() {
        if (this.adressTable.getSelectedRowCount() < 1) {
            return;
        }
        int n = this.adressTable.getSelectedRow();
        int n2 = this.adressTable.convertRowIndexToModel(n);
        ContactsEntryEstate contactsEntryEstate = null;
        long l = this.contactsTableModel.getEntryIdAt(n2);
        for (ContactsEntryEstate contactsEntryEstate2 : this.selectedContacts) {
            if (contactsEntryEstate2.getContactEntryId() != l) continue;
            contactsEntryEstate = contactsEntryEstate2;
            break;
        }
        if (contactsEntryEstate == null) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.cantFindContactEntry", new Object[]{l}));
            return;
        }
        Iterator<ContactsEntryEstate> iterator = contactsEntryEstate;
        if (ImmoToolUtils.showQuestionDialog((String)this.resourceMap.getString("question.reallyDeleteContactEntry", new Object[]{((ContactsEntryEstate)((Object)iterator)).getContactEntryId()}))) {
            this.selectedContacts.remove(iterator);
            this.contactsTableModel.removeRow(n2);
            this.isModified = true;
        }
    }

    @Action
    public void doSaveNotes() {
        if (this.adressTable.getSelectedRowCount() < 1) {
            return;
        }
        int n = this.adressTable.getSelectedRow();
        int n2 = this.adressTable.convertRowIndexToModel(n);
        String string = this.adressNotesField.getText().trim();
        Long l = this.contactsTableModel.getEntryIdAt(n2);
        for (ContactsEntryEstate contactsEntryEstate : this.selectedContacts) {
            if (contactsEntryEstate.getContactEntryId() != l.longValue()) continue;
            contactsEntryEstate.setDescription(string);
            this.contactsTableModel.setDescriptionAt(n2, string);
            break;
        }
    }

    @Action
    public Task doSubmitAdress() {
        this.validationHandler.validate();
        this.adressPanel.validateInputs();
        if (!this.validationHandler.isValid() || !this.adressPanel.isValidInput()) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.invalidInput", new Object[0]));
            return null;
        }
        this.submitAdressButton.setEnabled(false);
        return new ImmoToolTask<ContactsEntry>(){

            protected ContactsEntry executeTask() throws Exception {
                ContactsEntry contactsEntry = new ContactsEntry();
                if (AgencyEstateContactTablePanel.this.adressGroupBox.getSelectedIndex() <= 0) {
                    throw new Exception("no contact-group selected!");
                }
                ContactsGroupItem contactsGroupItem = (ContactsGroupItem)AgencyEstateContactTablePanel.this.adressGroupBox.getSelectedItem();
                contactsEntry.setGroupId(contactsGroupItem.getGroupId());
                AgencyEstateContactTablePanel.this.adressPanel.saveAdress(contactsEntry.getAdress());
                contactsEntry.save();
                return contactsEntry;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)AgencyEstateContactTablePanel.this.resourceMap.getString("error.cantSaveContact", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                AgencyEstateContactTablePanel.this.submitAdressButton.setEnabled(true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void succeeded(ContactsEntry contactsEntry) {
                super.succeeded((Object)contactsEntry);
                try {
                    ContactsEntryEstate contactsEntryEstate = new ContactsEntryEstate();
                    contactsEntryEstate.setEstateId(AgencyEstateContactTablePanel.this.selectedEstateId);
                    contactsEntryEstate.setContactEntryId(contactsEntry.getId());
                    contactsEntryEstate.setContactGroupId(contactsEntry.getGroupId());
                    contactsEntryEstate.setDescription(ImmoToolUtils.replaceTags((String)AgencyEstateContactTablePanel.this.adressTextArea.getText().trim()).trim());
                    String string = (String)AgencyEstateContactTablePanel.this.adressTypeBox.getSelectedItem();
                    contactsEntryEstate.setType(string == null ? "" : (AgencyEstateContactTablePanel.this.adressTypes.containsKey(string) ? (String)AgencyEstateContactTablePanel.this.adressTypes.get(string) : string));
                    if (AgencyEstateContactTablePanel.this.getRowForCustomer(contactsEntryEstate.getContactEntryId()) > -1) {
                        LOGGER.warn((Object)"contact-entry already exists!");
                        LOGGER.warn((Object)("> group #" + contactsEntryEstate.getContactGroupId()));
                        LOGGER.warn((Object)("> entry # " + contactsEntryEstate.getContactEntryId()));
                        ImmoToolUtils.showMessageErrorDialog((String)AgencyEstateContactTablePanel.this.resourceMap.getString("error.contactEntryAlreadyExists", new Object[0]));
                        return;
                    }
                    ContactsGroup contactsGroup = ContactsGroup.load((long)contactsEntry.getGroupId());
                    if (contactsGroup == null) {
                        LOGGER.warn((Object)("unknown contact-group #" + contactsEntry.getGroupId() + "!"));
                    }
                    String string2 = contactsGroup != null ? contactsGroup.getName() : "";
                    AgencyEstateContactTablePanel.this.contactsTableModel.addContactsEntry(contactsEntry.createRow(), string2, contactsEntryEstate.getDescription(), contactsEntryEstate.getType());
                    AgencyEstateContactTablePanel.this.selectedContacts.add(contactsEntryEstate);
                    AgencyEstateContactTablePanel.this.adressGroupBox.setSelectedIndex(0);
                    AgencyEstateContactTablePanel.this.adressTypeBox.setSelectedItem("");
                    AgencyEstateContactTablePanel.this.adressTextArea.setText("");
                    AgencyEstateContactTablePanel.this.adressPanel.loadAdress((SimpleAdressImpl)new CompanyAdressImpl());
                    AgencyEstateContactTablePanel.this.validationHandler.init();
                    AgencyEstateContactTablePanel.this.adressPanel.initInputs();
                    AgencyEstateContactTablePanel.this.isModified = true;
                    AgencyEstateContactTablePanel.this.tabPanel.setSelectedIndex(0);
                    ImmoToolUtils.showMessageInfoDialog((String)AgencyEstateContactTablePanel.this.resourceMap.getString("message.contactSavedAndMapped", new Object[0]));
                }
                catch (Exception exception) {
                    LOGGER.error((Object)"cant map contact!");
                    LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    ImmoToolUtils.showMessageErrorDialog((String)AgencyEstateContactTablePanel.this.resourceMap.getString("error.cantMapContact", new Object[0]), (Throwable)exception);
                }
                finally {
                    ImmoToolUtils.updateTabs();
                }
            }
        };
    }

    @Action
    public void doView() {
        ContactsEntryEstateDialog contactsEntryEstateDialog;
        if (this.adressTable.getSelectedRowCount() < 1) {
            return;
        }
        int n = this.adressTable.getSelectedRow();
        int n2 = this.adressTable.convertRowIndexToModel(n);
        ContactsEntryEstate contactsEntryEstate = null;
        long l = this.contactsTableModel.getEntryIdAt(n2);
        for (ContactsEntryEstate object2 : this.selectedContacts) {
            if (object2.getContactEntryId() != l) continue;
            contactsEntryEstate = object2;
            break;
        }
        if (contactsEntryEstate == null) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.cantFindContactEntry", new Object[]{l}));
            return;
        }
        Iterator<ContactsEntryEstate> iterator = contactsEntryEstate;
        Object var7_7 = null;
        try {
            contactsEntryEstateDialog = new ContactsEntryEstateDialog(2, ImmoToolApp.getApplication().getMainFrame(), true);
            contactsEntryEstateDialog.load((ContactsEntryEstate)((Object)iterator));
            contactsEntryEstateDialog.loadContact(((ContactsEntryEstate)((Object)iterator)).getContactGroupId(), ((ContactsEntryEstate)((Object)iterator)).getContactEntryId());
            contactsEntryEstateDialog.setVisible(true);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Can't open contact-dialog!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.cantOpenContactDialog", new Object[0]), (Throwable)exception);
            return;
        }
        if (contactsEntryEstateDialog.getStatus() != 2) {
            return;
        }
        try {
            int n3;
            contactsEntryEstateDialog.save((ContactsEntryEstate)((Object)iterator));
            int n4 = this.getRowForCustomer(((ContactsEntryEstate)((Object)iterator)).getContactEntryId());
            int n5 = n3 = n4 > -1 ? this.adressTable.convertRowIndexToModel(n4) : -1;
            if (n3 > -1 && n2 != n3) {
                LOGGER.warn((Object)"Contact-entry already exists!");
                LOGGER.warn((Object)("> group #" + ((ContactsEntryEstate)((Object)iterator)).getContactGroupId()));
                LOGGER.warn((Object)("> entry # " + ((ContactsEntryEstate)((Object)iterator)).getContactEntryId()));
                ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.contactEntryAlreadyExists", new Object[0]));
                return;
            }
            ContactsEntry.Row[] rowArray = ContactsEntry.loadRows((Long[])new Long[]{((ContactsEntryEstate)((Object)iterator)).getContactEntryId()}, (Long[])new Long[]{((ContactsEntryEstate)((Object)iterator)).getContactGroupId()}, null, null);
            if (rowArray != null && rowArray.length > 0) {
                ContactsGroup contactsGroup = ContactsGroup.load((long)rowArray[0].group);
                if (contactsGroup == null) {
                    LOGGER.warn((Object)("unknown contact-group #" + rowArray[0].group + "!"));
                }
                String string = contactsGroup != null ? contactsGroup.getName() : "";
                this.contactsTableModel.setContactEntryAt(n2, rowArray[0], string, ((ContactsEntryEstate)((Object)iterator)).getDescription(), ((ContactsEntryEstate)((Object)iterator)).getType());
                this.isModified = true;
            }
        }
        catch (Exception exception) {
            LOGGER.error((Object)"cant put contact-entry!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.cantPutContactEntry", new Object[0]), (Throwable)exception);
            return;
        }
    }

    @Action
    public Task doViewCustomer() {
        ContactsEntryEstate contactsEntryEstate3;
        if (this.adressTable.getSelectedRowCount() < 1) {
            return null;
        }
        int n = this.adressTable.getSelectedRow();
        int n2 = this.adressTable.convertRowIndexToModel(n);
        ContactsEntryEstate contactsEntryEstate2 = null;
        long l = this.contactsTableModel.getEntryIdAt(n2);
        for (final ContactsEntryEstate contactsEntryEstate3 : this.selectedContacts) {
            if (contactsEntryEstate3.getContactEntryId() != l) continue;
            contactsEntryEstate2 = contactsEntryEstate3;
            break;
        }
        if (contactsEntryEstate2 == null) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.cantFindContactEntry", new Object[]{l}));
            return null;
        }
        String string = ContactsEntryViewPanel.getInstanceTabTitle((long)contactsEntryEstate2.getContactEntryId());
        if (ImmoToolUtils.selectPanel((String)string)) {
            return null;
        }
        contactsEntryEstate3 = contactsEntryEstate2;
        return new ImmoToolTask<ContactsEntryViewPanel>(){

            protected ContactsEntryViewPanel executeTask() throws Exception {
                ContactsEntryViewPanel contactsEntryViewPanel = new ContactsEntryViewPanel();
                contactsEntryViewPanel.setContact(contactsEntryEstate3.loadContactsEntry());
                return contactsEntryViewPanel;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)AgencyEstateContactTablePanel.this.resourceMap.getString("error.cantOpenContact", new Object[0]), (Throwable)throwable);
            }

            protected void succeeded(ContactsEntryViewPanel contactsEntryViewPanel) {
                super.succeeded((Object)contactsEntryViewPanel);
                contactsEntryViewPanel.executeFormTasks();
                ImmoToolUtils.showPanel((TabComponent)contactsEntryViewPanel);
            }
        };
    }

    private int getRowForCustomer(long l) {
        for (int i = 0; i < this.adressTable.getRowCount(); ++i) {
            if (this.contactsTableModel.getEntryIdAt(i) != l) continue;
            return i;
        }
        return -1;
    }

    public String getTitle() {
        return this.resourceMap.getString("title", new Object[0]);
    }

    public boolean isLoadedInBackground() {
        return true;
    }

    public boolean isFormEnabled() {
        return this.isLoaded;
    }

    public boolean isFormModified() {
        return this.isModified;
    }

    public boolean isFormUsable() {
        return ImmoToolApp.getApplication().getProject().getPlugin("OpenEstate-Contacts") != null;
    }

    public void load(AgencyEstate agencyEstate) throws ImmoToolException {
        this.selectedEstate = agencyEstate;
        this.selectedEstateId = agencyEstate.getId() != null && agencyEstate.getId().trim().length() > 0 ? agencyEstate.getIdNr() : 0L;
    }

    public void save(AgencyEstate agencyEstate) throws ImmoToolException {
    }

    public void saveFinished(AgencyEstate agencyEstate) throws ImmoToolException {
        ArrayList<ContactsEntryEstate> arrayList;
        ContactsEntryEstate contactsEntryEstate2;
        ContactsEntryEstate[] contactsEntryEstateArray = ContactsEntryEstate.loadEntriesForEstate(agencyEstate.getIdNr());
        HashMap<Long, ContactsEntryEstate> hashMap = new HashMap<Long, ContactsEntryEstate>();
        for (ContactsEntryEstate contactsEntryEstate2 : contactsEntryEstateArray) {
            hashMap.put(contactsEntryEstate2.getContactEntryId(), contactsEntryEstate2);
        }
        HashMap hashMap2 = new HashMap();
        for (ContactsEntryEstate contactsEntryEstate3 : this.selectedContacts) {
            contactsEntryEstate3.setEstateId(agencyEstate.getIdNr());
            contactsEntryEstate2 = null;
            if (hashMap2.containsKey(contactsEntryEstate3.getContactEntryId())) {
                contactsEntryEstate2 = (ContactsEntry)hashMap2.get(contactsEntryEstate3.getContactEntryId());
            } else {
                contactsEntryEstate2 = contactsEntryEstate3.loadContactsEntry();
                hashMap2.put(contactsEntryEstate2.getId(), contactsEntryEstate2);
            }
            if (hashMap.containsKey(contactsEntryEstate3.getContactEntryId())) {
                hashMap.remove(contactsEntryEstate3.getContactEntryId());
            }
            contactsEntryEstateArray = ContactsEntryEstate.getContactEntryEstates((ContactsEntry)contactsEntryEstate2);
            arrayList = new ArrayList();
            for (ContactsEntryEstate contactsEntryEstate4 : contactsEntryEstateArray) {
                if (contactsEntryEstate4.getEstateId() == agencyEstate.getIdNr()) continue;
                arrayList.add(contactsEntryEstate4);
            }
            arrayList.add(contactsEntryEstate3);
            ContactsEntryEstate.setContactEntryEstates((ContactsEntry)contactsEntryEstate2, arrayList.toArray(new ContactsEntryEstate[arrayList.size()]));
        }
        for (ContactsEntry contactsEntry : hashMap2.values()) {
            contactsEntry.save();
        }
        for (ContactsEntryEstate contactsEntryEstate5 : hashMap.values()) {
            contactsEntryEstate2 = contactsEntryEstate5.loadContactsEntry();
            contactsEntryEstateArray = ContactsEntryEstate.getContactEntryEstates((ContactsEntry)contactsEntryEstate2);
            arrayList = new ArrayList<ContactsEntryEstate>();
            for (ContactsEntryEstate contactsEntryEstate4 : contactsEntryEstateArray) {
                if (contactsEntryEstate4.getEstateId() == agencyEstate.getIdNr()) continue;
                arrayList.add(contactsEntryEstate4);
            }
            ContactsEntryEstate.setContactEntryEstates((ContactsEntry)contactsEntryEstate2, arrayList.toArray(new ContactsEntryEstate[arrayList.size()]));
            contactsEntryEstate2.save();
        }
    }

    private void initComponents() {
        this.titleLabel = ImmoToolUtils.createHead2Separator((String)"");
        this.tabPanel = new JTabbedPane();
        this.adressTablePanel = new JPanel();
        this.adressTableTitleLabel = ImmoToolUtils.createHead2Separator((String)"");
        this.refreshButton = new JButton();
        this.addButton = new JButton();
        this.actionButton = new JButton();
        this.adressTableScroller = new JScrollPane();
        this.adressTable = new JXTable();
        this.adressNotesPanel = new JPanel();
        this.adressNotesTitleLabel = ImmoToolUtils.createHead2Separator((String)"");
        this.adressNotesButton = new JButton();
        this.adressNotesScroller = new JScrollPane();
        this.adressNotesField = new RTextArea();
        this.adressFormPanel = new JPanel();
        this.adressFormTitleLabel = ImmoToolUtils.createHead2Separator((String)"");
        this.submitAdressButton = new JButton();
        this.adressFormContainerPanel = new JPanel();
        this.titleLabel.setName("titleLabel");
        this.tabPanel.setName("tabPanel");
        this.adressTablePanel.setName("adressTablePanel");
        this.adressTableTitleLabel.setName("adressTableTitleLabel");
        ApplicationActionMap applicationActionMap = Application.getInstance().getContext().getActionMap(AgencyEstateContactTablePanel.class, (Object)this);
        this.refreshButton.setAction(applicationActionMap.get("doRefresh"));
        this.refreshButton.setName("refreshButton");
        this.addButton.setAction(applicationActionMap.get("doAdd"));
        this.addButton.setName("addButton");
        this.actionButton.setAction(applicationActionMap.get("doAction"));
        this.actionButton.setName("actionButton");
        this.adressTableScroller.setName("adressTableScroller");
        this.adressTable.setColumnControlVisible(true);
        this.adressTable.setName("adressTable");
        this.adressTableScroller.setViewportView((Component)this.adressTable);
        this.adressNotesPanel.setName("adressNotesPanel");
        this.adressNotesTitleLabel.setName("adressNotesTitleLabel");
        this.adressNotesButton.setAction(applicationActionMap.get("doSaveNotes"));
        this.adressNotesButton.setName("adressNotesButton");
        this.adressNotesScroller.setName("adressNotesScroller");
        this.adressNotesField.setColumns(20);
        this.adressNotesField.setLineWrap(true);
        this.adressNotesField.setRows(5);
        this.adressNotesField.setWrapStyleWord(true);
        this.adressNotesField.setName("adressNotesField");
        this.adressNotesScroller.setViewportView(this.adressNotesField);
        GroupLayout groupLayout = new GroupLayout(this.adressNotesPanel);
        this.adressNotesPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent((Component)this.adressNotesTitleLabel, -1, 496, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.adressNotesButton)).addComponent(this.adressNotesScroller, GroupLayout.Alignment.TRAILING, -1, 557, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.adressNotesButton).addComponent((Component)this.adressNotesTitleLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.adressNotesScroller, -2, 110, -2)));
        GroupLayout groupLayout2 = new GroupLayout(this.adressTablePanel);
        this.adressTablePanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.adressTableScroller, GroupLayout.Alignment.LEADING, -1, 557, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addComponent((Component)this.adressTableTitleLabel, -1, 368, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.refreshButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.actionButton)).addComponent(this.adressNotesPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.adressTableTitleLabel, -2, -1, -2).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.actionButton).addComponent(this.addButton).addComponent(this.refreshButton))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.adressTableScroller, -1, 196, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.adressNotesPanel, -2, -1, -2).addContainerGap()));
        ResourceMap resourceMap = Application.getInstance().getContext().getResourceMap(AgencyEstateContactTablePanel.class);
        this.tabPanel.addTab(resourceMap.getString("adressTablePanel.TabConstraints.tabTitle", new Object[0]), this.adressTablePanel);
        this.adressFormPanel.setName("adressFormPanel");
        this.adressFormTitleLabel.setName("adressFormTitleLabel");
        this.submitAdressButton.setAction(applicationActionMap.get("doSubmitAdress"));
        this.submitAdressButton.setName("submitAdressButton");
        this.adressFormContainerPanel.setName("adressFormContainerPanel");
        GroupLayout groupLayout3 = new GroupLayout(this.adressFormContainerPanel);
        this.adressFormContainerPanel.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 557, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 343, Short.MAX_VALUE));
        GroupLayout groupLayout4 = new GroupLayout(this.adressFormPanel);
        this.adressFormPanel.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addContainerGap().addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.adressFormContainerPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(groupLayout4.createSequentialGroup().addComponent((Component)this.adressFormTitleLabel, -1, 490, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.submitAdressButton))).addContainerGap()));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addContainerGap().addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.adressFormTitleLabel, -2, -1, -2).addComponent(this.submitAdressButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.adressFormContainerPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.tabPanel.addTab(resourceMap.getString("adressFormPanel.TabConstraints.tabTitle", new Object[0]), this.adressFormPanel);
        GroupLayout groupLayout5 = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout5);
        groupLayout5.setHorizontalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout5.createSequentialGroup().addContainerGap().addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.tabPanel, GroupLayout.Alignment.LEADING, -1, 586, Short.MAX_VALUE).addComponent((Component)this.titleLabel, GroupLayout.Alignment.LEADING, -1, 586, Short.MAX_VALUE)).addContainerGap()));
        groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addContainerGap().addComponent((Component)this.titleLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.tabPanel, -1, 425, Short.MAX_VALUE).addContainerGap()));
        resourceMap.injectComponents((Component)((Object)this));
    }

    private final class TableModel
    extends ContactsEntryTableModel {
        private int typeCol = this.getColumnCount();
        private int descriptionCol = this.getColumnCount() + 1;

        public TableModel() {
            this.setColumnCount(this.getColumnCount() + 2);
        }

        public void addContactsEntry(ContactsEntry.Row row, String string) {
            this.addContactsEntry(row, string, "", "");
        }

        public void addContactsEntry(ContactsEntry.Row row, String string, String string2, String string3) {
            super.addContactsEntry(row, string);
            this.setDescriptionAt(this.getRowCount() - 1, string2);
            this.setTypeAt(this.getRowCount() - 1, string3);
        }

        public Class getColumnClass(int n) {
            if (n == this.descriptionCol) {
                return String.class;
            }
            if (n == this.typeCol) {
                return String.class;
            }
            return super.getColumnClass(n);
        }

        public String getColumnName(int n) {
            if (n == this.descriptionCol) {
                return AgencyEstateContactTablePanel.this.resourceMap.getString("label.descriptionCol", new Object[0]);
            }
            if (n == this.typeCol) {
                return AgencyEstateContactTablePanel.this.resourceMap.getString("label.mappingCol", new Object[0]);
            }
            return super.getColumnName(n);
        }

        public String getDescriptionAt(int n) {
            return (String)this.getValueAt(n, this.descriptionCol);
        }

        public int getDescriptionCol() {
            return this.descriptionCol;
        }

        public int getTypeCol() {
            return this.typeCol;
        }

        public String getTypeAt(int n) {
            return (String)this.getValueAt(n, this.typeCol);
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void setContactEntryAt(int n, ContactsEntry.Row row, String string) {
            this.setContactEntryAt(n, row, string, "", "");
        }

        public void setContactEntryAt(int n, ContactsEntry.Row row, String string, String string2, String string3) {
            super.setContactEntryAt(n, row, string);
            this.setDescriptionAt(n, string2);
            this.setTypeAt(n, string3);
        }

        public void setDescriptionAt(int n, String string) {
            this.setValueAt(string, n, this.descriptionCol);
        }

        public void setTypeAt(int n, String string) {
            String string2 = ContactsEntryEstate.writeType(string);
            this.setValueAt(string2 != null && string2.trim().length() > 0 ? string2 : string, n, this.typeCol);
        }
    }
}

