/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.addons;

import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolTaskDialog;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstateTableAddon;
import com.openindex.openestate.tool.agency.addons.ContactsEntryEstate;
import com.openindex.openestate.tool.agency.addons.ContactsEntryEstateDialog;
import com.openindex.openestate.tool.contacts.ContactsEntry;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.jdesktop.application.ResourceMap;

public class AgencyEstateTableContactsAddon
extends AgencyEstateTableAddon {
    private final ResourceMap resourceMap = ImmoToolUtils.getResourceMap(AgencyEstateTableContactsAddon.class);

    private Action buildEstateAddressAction(final Long[] longArray) {
        ImmoToolTask<Boolean> immoToolTask = new ImmoToolTask<Boolean>(this.resourceMap.getString("doAssignAddressToEstates.Action.text", new Object[0])){

            protected Boolean executeTask() throws Exception {
                ContactsEntryEstateDialog contactsEntryEstateDialog = new ContactsEntryEstateDialog(2, (Dialog)this.getTaskDialog(), true);
                contactsEntryEstateDialog.load(null);
                contactsEntryEstateDialog.loadContact(null);
                contactsEntryEstateDialog.setVisible(true);
                if (contactsEntryEstateDialog.getStatus() != 2) {
                    return false;
                }
                ContactsEntry.Row row = contactsEntryEstateDialog.getSelectedContactsEntry();
                ContactsEntry contactsEntry = ContactsEntry.load((long)row.group, (long)row.id);
                HashMap<Object, ContactsEntryEstate> hashMap = new HashMap<Object, ContactsEntryEstate>();
                for (ContactsEntryEstate object : ContactsEntryEstate.getContactEntryEstates(contactsEntry)) {
                    hashMap.put(object.getEstateId(), object);
                }
                for (Long l : longArray) {
                    ContactsEntryEstate contactsEntryEstate = null;
                    if (hashMap.containsKey(l)) {
                        this.setMessage("Update assignment of address #" + row.id + " with estate #" + l);
                        contactsEntryEstate = (ContactsEntryEstate)hashMap.get(l);
                    } else {
                        this.setMessage("Add assignment of address #" + row.id + " with estate #" + l);
                        contactsEntryEstate = new ContactsEntryEstate(l, contactsEntry, null, null);
                    }
                    contactsEntryEstate.setDescription(contactsEntryEstateDialog.getSelectedDescription());
                    contactsEntryEstate.setType(contactsEntryEstateDialog.getSelectedType());
                    hashMap.put(l, contactsEntryEstate);
                }
                this.setMessage("Save address #" + row.id);
                ContactsEntryEstate.setContactEntryEstates(contactsEntry, hashMap.values().toArray(new ContactsEntryEstate[hashMap.size()]));
                contactsEntry.save();
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)AgencyEstateTableContactsAddon.this.resourceMap.getString("doAssignAddressToEstates.Message.error", new Object[0]), (Throwable)throwable);
            }
        };
        AbstractAction abstractAction = new AbstractAction((ImmoToolTask)immoToolTask){
            final /* synthetic */ ImmoToolTask val$task;
            {
                this.val$task = immoToolTask;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImmoToolTaskDialog.execute((ImmoToolTask)this.val$task);
            }
        };
        abstractAction.putValue("Name", this.resourceMap.getString("doAssignAddressToEstates.Action.text", new Object[0]));
        abstractAction.putValue("ShortDescription", this.resourceMap.getString("doAssignAddressToEstates.Action.shortDescription", new Object[0]));
        abstractAction.putValue("SmallIcon", this.resourceMap.getIcon("doAssignAddressToEstates.Action.smallIcon"));
        return abstractAction;
    }

    public Action[] getActions(Long[] longArray) {
        return new Action[]{this.buildEstateAddressAction(longArray)};
    }

    public boolean isUsable() {
        return ImmoToolApp.getApplication().getProject().getPlugin("OpenEstate-Contacts") != null;
    }
}

