/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.addons;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.addons.AgencyEstateCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.application.ResourceMap;

public class CalendarEntryEstateTableModel
extends DefaultTableModel {
    public static final int COLUMN_ENTRY = 0;
    public static final int COLUMN_ESTATE_ID = 1;
    public static final int COLUMN_ESTATE_NR = 2;
    public static final int COLUMN_ESTATE_TITLE = 3;
    public static final int COLUMN_ESTATE_STATUS = 4;
    public static final int COLUMN_DESCRIPTION = 5;
    private static final Map<Integer, String> COLUMN_NAMES = new HashMap<Integer, String>();
    private static final Map<Integer, Class> COLUMN_CLASSES;
    private final ResourceMap resourceMap = ImmoToolUtils.getResourceMap(CalendarEntryEstateTableModel.class);

    public CalendarEntryEstateTableModel() {
        this.setColumnCount(COLUMN_NAMES.size());
    }

    public void addEstate(AgencyEstate agencyEstate, AgencyEstateCalendar agencyEstateCalendar) {
        this.addRow(this.buildRow(agencyEstate, agencyEstateCalendar));
    }

    private Object[] buildRow(AgencyEstate agencyEstate, AgencyEstateCalendar agencyEstateCalendar) {
        TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
        treeMap.put(0, (Object)agencyEstateCalendar);
        treeMap.put(1, agencyEstate.getIdNr());
        treeMap.put(2, agencyEstate.getPublicId());
        treeMap.put(3, agencyEstate.getTitle());
        treeMap.put(4, agencyEstate.writeStatus());
        treeMap.put(5, agencyEstateCalendar.getDescription());
        return treeMap.values().toArray(new Object[treeMap.size()]);
    }

    public void clear() {
        while (this.getRowCount() > 0) {
            this.removeRow(0);
        }
    }

    public Class getColumnClass(int n) {
        return COLUMN_CLASSES.containsKey(n) ? COLUMN_CLASSES.get(n) : null;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES.containsKey(n) ? this.resourceMap.getString(COLUMN_NAMES.get(n), new Object[0]) : null;
    }

    public String getDescriptionAt(int n) {
        return (String)this.getValueAt(n, 5);
    }

    public AgencyEstateCalendar getEntryAt(int n) {
        return (AgencyEstateCalendar)((Object)this.getValueAt(n, 0));
    }

    public long getEstateIdAt(int n) {
        AgencyEstateCalendar agencyEstateCalendar = this.getEntryAt(n);
        return agencyEstateCalendar != null ? agencyEstateCalendar.getEstateId() : 0L;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void setEstateAt(int n, AgencyEstate agencyEstate, AgencyEstateCalendar agencyEstateCalendar) {
        Object[] objectArray = this.buildRow(agencyEstate, agencyEstateCalendar);
        for (int i = 0; i < objectArray.length; ++i) {
            this.setValueAt(objectArray[i], n, i);
        }
    }

    static {
        COLUMN_NAMES.put(0, "col.entry");
        COLUMN_NAMES.put(1, "col.id");
        COLUMN_NAMES.put(2, "col.nr");
        COLUMN_NAMES.put(3, "col.title");
        COLUMN_NAMES.put(4, "col.status");
        COLUMN_NAMES.put(5, "col.notes");
        COLUMN_CLASSES = new HashMap<Integer, Class>();
        COLUMN_CLASSES.put(0, AgencyEstateCalendar.class);
        COLUMN_CLASSES.put(1, Long.class);
        COLUMN_CLASSES.put(2, String.class);
        COLUMN_CLASSES.put(3, String.class);
        COLUMN_CLASSES.put(4, String.class);
        COLUMN_CLASSES.put(5, String.class);
    }
}

