/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.addons;

import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolTaskDialog;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.AgencyEstateStatusTask;
import com.openindex.openestate.tool.agency.AgencyEstateViewTask;
import com.openindex.openestate.tool.agency.addons.AgencyEstateCalendar;
import com.openindex.openestate.tool.agency.addons.AgencyEstateCalendarDialog;
import com.openindex.openestate.tool.agency.addons.CalendarEntryEstateTableModel;
import com.openindex.openestate.tool.calendar.CalendarEntry;
import com.openindex.openestate.tool.calendar.CalendarEntryViewAddonPanel;
import com.openindex.openestate.tool.calendar.CalendarObject;
import com.openindex.openestate.tool.utils.QuickTableExport;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.ActionMap;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import net.fortuna.ical4j.model.property.Uid;
import org.apache.log4j.Logger;
import org.fife.ui.rtextarea.RTextArea;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledSeparator;

public class CalendarEntryEstateTablePanel
extends CalendarEntryViewAddonPanel {
    private static final Logger LOGGER = Logger.getLogger(CalendarEntryEstateTablePanel.class);
    private ActionMap actionMap;
    private ResourceMap resourceMap;
    private JPopupMenu actionsMenu;
    private CalendarEntryEstateTableModel estateTableModel;
    private Uid selectedCalendarEntryUid = null;
    private CalendarEntry selectedCalendarEntry = null;
    private boolean editable = true;
    private boolean isModified = false;
    private JButton actionButton;
    private JButton addButton;
    private JButton estateNotesButton;
    private JTextArea estateNotesField;
    private JPanel estateNotesPanel;
    private JScrollPane estateNotesScroller;
    private JXTitledSeparator estateNotesTitleLabel;
    private JXTable estateTable;
    private JScrollPane estateTableScroller;
    private JButton refreshButton;
    private JXTitledSeparator titleLabel;

    public CalendarEntryEstateTablePanel() {
        this.build();
    }

    private void build() {
        this.actionMap = ImmoToolUtils.getActionMap(CalendarEntryEstateTablePanel.class, (Object)((Object)this));
        this.resourceMap = ImmoToolUtils.getResourceMap(CalendarEntryEstateTablePanel.class);
        this.initComponents();
        this.resourceMap.injectComponents((Component)((Object)this));
        JMenu jMenu = new JMenu();
        jMenu.setName("estateActionStatusMenu");
        for (final String string : AgencyEstate.getStatusList()) {
            JMenuItem jMenuItem = new JMenuItem(AgencyEstate.writeStatus((String)string));
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CalendarEntryEstateTablePanel.this.doChangeEstateStatus(string);
                }
            });
            jMenu.add(jMenuItem);
        }
        this.resourceMap.injectComponent((Component)jMenu);
        this.actionsMenu = new JPopupMenu();
        this.actionsMenu.add(new JMenuItem(this.actionMap.get("doViewEstate")));
        this.actionsMenu.add(jMenu);
        this.actionsMenu.addSeparator();
        this.actionsMenu.add(new JMenuItem(this.actionMap.get("doView")));
        this.actionsMenu.add(new JMenuItem(this.actionMap.get("doRemove")));
        this.estateTableModel = new CalendarEntryEstateTableModel();
        this.estateTable.setModel((TableModel)this.estateTableModel);
        this.estateTable.removeColumn(this.estateTable.getColumn(0));
        this.estateTable.setSortable(true);
        this.estateTable.getSelectionModel().setSelectionMode(2);
        this.estateTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (!CalendarEntryEstateTablePanel.this.estateTable.isEnabled()) {
                    return;
                }
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                    CalendarEntryEstateTablePanel.this.doView();
                } else if (mouseEvent.getButton() == 3 && mouseEvent.getClickCount() == 1) {
                    if (CalendarEntryEstateTablePanel.this.estateTable.getSelectedRow() < 0) {
                        int n = CalendarEntryEstateTablePanel.this.estateTable.rowAtPoint(mouseEvent.getPoint());
                        if (n < 0) {
                            return;
                        }
                        CalendarEntryEstateTablePanel.this.estateTable.getSelectionModel().setSelectionInterval(n, n);
                    }
                    CalendarEntryEstateTablePanel.this.actionsMenu.show((Component)CalendarEntryEstateTablePanel.this.estateTable, ((CalendarEntryEstateTablePanel)CalendarEntryEstateTablePanel.this).estateTable.getMousePosition().x, ((CalendarEntryEstateTablePanel)CalendarEntryEstateTablePanel.this).estateTable.getMousePosition().y);
                }
            }
        });
        this.estateTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!CalendarEntryEstateTablePanel.this.estateTable.isEnabled()) {
                    return;
                }
                CalendarEntryEstateTablePanel.this.actionButton.setEnabled(CalendarEntryEstateTablePanel.this.estateTable.getSelectedRowCount() > 0);
                if (CalendarEntryEstateTablePanel.this.estateTable.getSelectedRowCount() < 1) {
                    CalendarEntryEstateTablePanel.this.estateNotesField.setText("");
                    CalendarEntryEstateTablePanel.this.estateNotesPanel.setVisible(false);
                } else {
                    int n = CalendarEntryEstateTablePanel.this.estateTable.convertRowIndexToModel(CalendarEntryEstateTablePanel.this.estateTable.getSelectedRow());
                    String string = CalendarEntryEstateTablePanel.this.estateTableModel.getDescriptionAt(n);
                    CalendarEntryEstateTablePanel.this.estateNotesField.setText(string != null ? string.trim() : "");
                    CalendarEntryEstateTablePanel.this.estateNotesField.setCaretPosition(0);
                    CalendarEntryEstateTablePanel.this.estateNotesPanel.setVisible(true);
                }
            }
        });
        this.estateTable.setColumnControl((JComponent)QuickTableExport.createColumnControl((JXTable)this.estateTable));
        ImmoToolUtils.configureTable((JXTable)this.estateTable);
        this.actionButton.setEnabled(false);
        this.refreshButton.setEnabled(false);
        this.estateNotesPanel.setVisible(false);
    }

    @Action
    public void doAction() {
        this.actionsMenu.show(this.actionButton, 0, this.actionButton.getSize().height);
    }

    @Action
    public void doAdd() {
        AgencyEstateCalendarDialog agencyEstateCalendarDialog = null;
        try {
            agencyEstateCalendarDialog = new AgencyEstateCalendarDialog(1, ImmoToolApp.getApplication().getMainFrame(), true);
            agencyEstateCalendarDialog.load(null);
            agencyEstateCalendarDialog.loadEstate(null);
            agencyEstateCalendarDialog.setVisible(true);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"cant open estate-dialog!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.cantOpenEstateDialog", new Object[0]), (Throwable)exception);
            return;
        }
        try {
            if (agencyEstateCalendarDialog.getStatus() != 2) {
                return;
            }
            AgencyEstateCalendar agencyEstateCalendar = new AgencyEstateCalendar();
            agencyEstateCalendarDialog.save(agencyEstateCalendar);
            if (this.getRowForEstate(agencyEstateCalendar.getEstateId()) > -1) {
                LOGGER.warn((Object)"estate-entry already exists!");
                LOGGER.warn((Object)("> estate #" + agencyEstateCalendar.getEstateId()));
                ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.estateEntryAlreadyExists", new Object[0]));
                return;
            }
            this.estateTableModel.addEstate(AgencyEstate.loadEstate((long)agencyEstateCalendar.getEstateId()), agencyEstateCalendar);
            this.isModified = true;
        }
        catch (Exception exception) {
            LOGGER.error((Object)"cant put estate-entry!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.cantPutEstateEntry", new Object[0]), (Throwable)exception);
            return;
        }
    }

    private void doChangeEstateStatus(final String string) {
        if (this.estateTable.getSelectedRowCount() < 1) {
            return;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int n : this.estateTable.getSelectedRows()) {
            int n2 = this.estateTable.convertRowIndexToModel(n);
            arrayList.add(this.estateTableModel.getEstateIdAt(n2));
        }
        boolean bl = ImmoToolUtils.showQuestionDialog((String)this.resourceMap.getString("question.reallyChangeEstateStatus", new Object[]{AgencyEstate.writeStatus((String)string)}), (Component)((Object)this));
        if (!bl) {
            return;
        }
        ImmoToolTaskDialog.execute((ImmoToolTask)new AgencyEstateStatusTask(arrayList.toArray(new Long[arrayList.size()]), string){
            {
                super(longArray, string3);
                this.setTitle(CalendarEntryEstateTablePanel.this.resourceMap.getString("estateActionStatusMenu.text", new Object[0]));
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)CalendarEntryEstateTablePanel.this.resourceMap.getString("error.cantChangeEstateStatus", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
            }

            protected void succeeded(Boolean bl) {
                super.succeeded((Object)bl);
                if (!Boolean.TRUE.equals(bl)) {
                    return;
                }
                for (int n : CalendarEntryEstateTablePanel.this.estateTable.getSelectedRows()) {
                    int n2 = CalendarEntryEstateTablePanel.this.estateTable.convertRowIndexToModel(n);
                    CalendarEntryEstateTablePanel.this.estateTableModel.setValueAt(AgencyEstate.writeStatus((String)string), n2, 4);
                }
            }
        });
    }

    public final Task doLoadInBackground() {
        if (this.selectedCalendarEntryUid == null) {
            return null;
        }
        this.estateTable.setEnabled(false);
        return new ImmoToolTask<CalendarEntryEstateTableModel>(){

            protected CalendarEntryEstateTableModel executeTask() throws Exception {
                CalendarEntryEstateTableModel calendarEntryEstateTableModel = new CalendarEntryEstateTableModel();
                AgencyEstateCalendar[] agencyEstateCalendarArray = AgencyEstateCalendar.loadEntriesForCalendar(CalendarEntryEstateTablePanel.this.selectedCalendarEntryUid.getValue());
                if (agencyEstateCalendarArray == null) {
                    return calendarEntryEstateTableModel;
                }
                for (AgencyEstateCalendar agencyEstateCalendar : agencyEstateCalendarArray) {
                    AgencyEstate agencyEstate = agencyEstateCalendar.loadAgencyEstate();
                    if (agencyEstate == null) {
                        LOGGER.warn((Object)("cant find estate #" + agencyEstateCalendar.getEstateId()));
                        continue;
                    }
                    calendarEntryEstateTableModel.addEstate(agencyEstate, agencyEstateCalendar);
                }
                return calendarEntryEstateTableModel;
            }

            protected void finished() {
                super.finished();
                CalendarEntryEstateTablePanel.this.estateTable.setEnabled(true);
            }

            protected void succeeded(CalendarEntryEstateTableModel calendarEntryEstateTableModel) {
                super.succeeded((Object)calendarEntryEstateTableModel);
                CalendarEntryEstateTablePanel.this.estateTableModel = calendarEntryEstateTableModel;
                CalendarEntryEstateTablePanel.this.estateTable.setModel((TableModel)calendarEntryEstateTableModel);
                CalendarEntryEstateTablePanel.this.estateTable.removeColumn(CalendarEntryEstateTablePanel.this.estateTable.getColumn(0));
                CalendarEntryEstateTablePanel.this.titleLabel.setTitle(CalendarEntryEstateTablePanel.this.resourceMap.getString("titleLabel.title", new Object[0]) + " / " + CalendarEntryEstateTablePanel.this.resourceMap.getString("message.resultCount", new Object[]{NumberFormat.getIntegerInstance().format(CalendarEntryEstateTablePanel.this.estateTable.getRowCount())}));
                CalendarEntryEstateTablePanel.this.estateTable.packAll();
            }
        };
    }

    @Action
    public Task doRefresh() {
        if (this.selectedCalendarEntry == null) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.cantLoadEstateEntries", new Object[0]));
            return null;
        }
        this.estateTable.setEnabled(false);
        this.refreshButton.setEnabled(false);
        return new ImmoToolTask<Boolean>(){

            protected Boolean executeTask() throws Exception {
                CalendarEntryEstateTablePanel.this.load(CalendarEntryEstateTablePanel.this.selectedCalendarEntry);
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                CalendarEntryEstateTablePanel.this.estateTable.setEnabled(true);
                CalendarEntryEstateTablePanel.this.refreshButton.setEnabled(true);
                ImmoToolUtils.showMessageErrorDialog((String)CalendarEntryEstateTablePanel.this.resourceMap.getString("error.cantLoadEstateEntries", new Object[0]), (Throwable)throwable);
            }

            protected void succeeded(Boolean bl) {
                super.succeeded((Object)bl);
                CalendarEntryEstateTablePanel.this.estateTable.packAll();
                CalendarEntryEstateTablePanel.this.estateTable.setEnabled(true);
                CalendarEntryEstateTablePanel.this.refreshButton.setEnabled(true);
                CalendarEntryEstateTablePanel.this.isModified = false;
            }
        };
    }

    @Action
    public void doRemove() {
        if (this.estateTable.getSelectedRowCount() < 1) {
            return;
        }
        boolean bl = ImmoToolUtils.showQuestionDialog((String)this.resourceMap.getString("question.reallyDeleteEstateEntries", new Object[0]), (Component)((Object)this));
        if (!bl) {
            return;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int n : this.estateTable.getSelectedRows()) {
            int n2 = this.estateTable.convertRowIndexToModel(n);
            arrayList.add(this.estateTableModel.getEstateIdAt(n2));
        }
        this.estateTable.setEnabled(false);
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            int n;
            Long l = (Long)object.next();
            if (l < 1L || (n = this.getRowForEstate(l)) < 0) continue;
            this.estateTableModel.removeRow(n);
            this.isModified = true;
        }
        this.estateTable.setEnabled(true);
    }

    @Action
    public void doSaveNotes() {
        if (this.estateTable.getSelectedRowCount() < 1) {
            return;
        }
        int n = this.estateTable.getSelectedRow();
        int n2 = this.estateTable.convertRowIndexToModel(n);
        String string = this.estateNotesField.getText().trim();
        AgencyEstateCalendar agencyEstateCalendar = this.estateTableModel.getEntryAt(n2);
        if (agencyEstateCalendar != null) {
            agencyEstateCalendar.setDescription(string);
            this.estateTableModel.setValueAt(string, n2, 5);
        }
    }

    @Action
    public void doView() {
        if (this.estateTable.getSelectedRowCount() < 1) {
            return;
        }
        int n = this.estateTable.getSelectedRow();
        int n2 = this.estateTable.convertRowIndexToModel(n);
        AgencyEstateCalendar agencyEstateCalendar = this.estateTableModel.getEntryAt(n2);
        AgencyEstateCalendarDialog agencyEstateCalendarDialog = null;
        try {
            agencyEstateCalendarDialog = new AgencyEstateCalendarDialog(1, ImmoToolApp.getApplication().getMainFrame(), true);
            agencyEstateCalendarDialog.load(agencyEstateCalendar);
            agencyEstateCalendarDialog.loadEstate(agencyEstateCalendar.getEstateId());
            agencyEstateCalendarDialog.setVisible(true);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"cant open estate-dialog!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.cantOpenEstateDialog", new Object[0]), (Throwable)exception);
            return;
        }
        if (agencyEstateCalendarDialog.getStatus() != 2) {
            return;
        }
        try {
            int n3;
            agencyEstateCalendarDialog.save(agencyEstateCalendar);
            int n4 = this.getRowForEstate(agencyEstateCalendar.getEstateId());
            int n5 = n3 = n4 > -1 ? this.estateTable.convertRowIndexToModel(n4) : -1;
            if (n3 > -1 && n3 != n2) {
                LOGGER.warn((Object)"estate-entry already exists!");
                LOGGER.warn((Object)("> estate #" + agencyEstateCalendar.getEstateId()));
                ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.estateEntryAlreadyExists", new Object[0]));
                return;
            }
            this.estateTableModel.setEstateAt(n2, AgencyEstate.loadEstate((long)agencyEstateCalendar.getEstateId()), agencyEstateCalendar);
            this.isModified = true;
        }
        catch (Exception exception) {
            LOGGER.error((Object)"cant put estate-entry!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.cantPutEstateEntry", new Object[0]), (Throwable)exception);
            return;
        }
    }

    @Action
    public Task doViewEstate() {
        if (this.estateTable.getSelectedRowCount() < 1) {
            return null;
        }
        int n = this.estateTable.getSelectedRow();
        int n2 = this.estateTable.convertRowIndexToModel(n);
        AgencyEstateCalendar agencyEstateCalendar = this.estateTableModel.getEntryAt(n2);
        return new AgencyEstateViewTask(agencyEstateCalendar.getEstateId());
    }

    private int getRowForEstate(long l) {
        for (int i = 0; i < this.estateTable.getRowCount(); ++i) {
            if (this.estateTableModel.getEntryAt(i).getEstateId() != l) continue;
            return i;
        }
        return -1;
    }

    public String getTitle() {
        return this.resourceMap.getString("title", new Object[0]);
    }

    public boolean isFormEnabled() {
        return this.editable;
    }

    public boolean isFormModified() {
        return this.isModified;
    }

    public boolean isFormUsable() {
        return ImmoToolApp.getApplication().getProject().getPlugin("OpenEstate-Agency") != null;
    }

    public boolean isLoadedInBackground() {
        return true;
    }

    public void load(CalendarEntry calendarEntry) throws ImmoToolException {
        this.selectedCalendarEntry = calendarEntry;
        this.selectedCalendarEntryUid = calendarEntry != null ? calendarEntry.getUId() : null;
        this.estateTableModel.clear();
        this.refreshButton.setEnabled(this.selectedCalendarEntryUid != null);
        this.isModified = false;
    }

    public void save(CalendarEntry calendarEntry) throws ImmoToolException {
    }

    public void saveFinished(CalendarObject calendarObject, CalendarEntry calendarEntry) throws ImmoToolException {
        Object object;
        for (AgencyEstateCalendar agencyEstateCalendarArray : AgencyEstateCalendar.loadEntriesForCalendar(calendarEntry.getUId().getValue())) {
            if (this.getRowForEstate(agencyEstateCalendarArray.getEstateId()) >= 0) continue;
            object = agencyEstateCalendarArray.loadAgencyEstate();
            AgencyEstateCalendar[] agencyEstateCalendarArray2 = new ArrayList();
            AgencyEstateCalendar[] agencyEstateCalendarArray3 = AgencyEstateCalendar.getAgencyEstateCalendars((AgencyEstate)object);
            int n = agencyEstateCalendarArray3.length;
            for (int agencyEstateCalendar2 = 0; agencyEstateCalendar2 < n; ++agencyEstateCalendar2) {
                AgencyEstateCalendar agencyEstateCalendar = agencyEstateCalendarArray3[agencyEstateCalendar2];
                if (agencyEstateCalendar.getCalendarUid().equals(calendarEntry.getUId().getValue())) continue;
                agencyEstateCalendarArray2.add(agencyEstateCalendar);
            }
            AgencyEstateCalendar.setAgencyEstateCalendars((AgencyEstate)object, agencyEstateCalendarArray2.toArray(new AgencyEstateCalendar[agencyEstateCalendarArray2.size()]));
            AgencyEstate.storeEstate((AgencyEstate)object);
        }
        for (int i = 0; i < this.estateTableModel.getRowCount(); ++i) {
            AgencyEstateCalendar agencyEstateCalendar = this.estateTableModel.getEntryAt(i);
            agencyEstateCalendar.setCalendarId(calendarEntry.getCalendarId());
            agencyEstateCalendar.setCalendarUid(calendarEntry.getUId().getValue());
            AgencyEstate agencyEstate = AgencyEstate.loadEstate((long)agencyEstateCalendar.getEstateId());
            AgencyEstateCalendar[] agencyEstateCalendarArray = AgencyEstateCalendar.getAgencyEstateCalendars(agencyEstate);
            object = new ArrayList();
            for (AgencyEstateCalendar agencyEstateCalendar2 : agencyEstateCalendarArray) {
                if (agencyEstateCalendar2.getCalendarUid().equals(calendarEntry.getUId().getValue())) continue;
                object.add(agencyEstateCalendar2);
            }
            object.add(agencyEstateCalendar);
            AgencyEstateCalendar.setAgencyEstateCalendars(agencyEstate, object.toArray(new AgencyEstateCalendar[object.size()]));
            AgencyEstate.storeEstate((AgencyEstate)agencyEstate);
        }
    }

    public void setEditable(boolean bl) {
        super.setEditable(bl);
        this.editable = bl;
    }

    private void initComponents() {
        this.titleLabel = ImmoToolUtils.createHead2Separator((String)"");
        this.refreshButton = new JButton();
        this.addButton = new JButton();
        this.actionButton = new JButton();
        this.estateTableScroller = new JScrollPane();
        this.estateTable = new JXTable();
        this.estateNotesPanel = new JPanel();
        this.estateNotesTitleLabel = ImmoToolUtils.createHead2Separator((String)"");
        this.estateNotesButton = new JButton();
        this.estateNotesScroller = new JScrollPane();
        this.estateNotesField = new RTextArea();
        this.titleLabel.setName("titleLabel");
        ApplicationActionMap applicationActionMap = Application.getInstance().getContext().getActionMap(CalendarEntryEstateTablePanel.class, (Object)this);
        this.refreshButton.setAction(applicationActionMap.get("doRefresh"));
        this.refreshButton.setName("refreshButton");
        this.addButton.setAction(applicationActionMap.get("doAdd"));
        this.addButton.setName("addButton");
        this.actionButton.setAction(applicationActionMap.get("doAction"));
        this.actionButton.setName("actionButton");
        this.estateTableScroller.setName("estateTableScroller");
        this.estateTable.setColumnControlVisible(true);
        this.estateTable.setEditable(false);
        this.estateTable.setName("estateTable");
        this.estateTableScroller.setViewportView((Component)this.estateTable);
        this.estateNotesPanel.setName("estateNotesPanel");
        this.estateNotesTitleLabel.setName("estateNotesTitleLabel");
        this.estateNotesButton.setAction(applicationActionMap.get("doSaveNotes"));
        this.estateNotesButton.setName("estateNotesButton");
        this.estateNotesScroller.setName("estateNotesScroller");
        this.estateNotesField.setColumns(20);
        this.estateNotesField.setLineWrap(true);
        this.estateNotesField.setRows(5);
        this.estateNotesField.setWrapStyleWord(true);
        this.estateNotesField.setName("estateNotesField");
        this.estateNotesScroller.setViewportView(this.estateNotesField);
        GroupLayout groupLayout = new GroupLayout(this.estateNotesPanel);
        this.estateNotesPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent((Component)this.estateNotesTitleLabel, -1, 516, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.estateNotesButton)).addComponent(this.estateNotesScroller, GroupLayout.Alignment.TRAILING, -1, 577, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.estateNotesButton).addComponent((Component)this.estateNotesTitleLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.estateNotesScroller, -2, 90, -2)));
        GroupLayout groupLayout2 = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.estateTableScroller, GroupLayout.Alignment.TRAILING, -1, 577, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addComponent((Component)this.titleLabel, -1, 388, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.refreshButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.actionButton)).addComponent(this.estateNotesPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.titleLabel, -2, -1, -2).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.actionButton).addComponent(this.addButton).addComponent(this.refreshButton))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.estateTableScroller, -1, 240, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.estateNotesPanel, -2, -1, -2).addContainerGap()));
        ResourceMap resourceMap = Application.getInstance().getContext().getResourceMap(CalendarEntryEstateTablePanel.class);
        resourceMap.injectComponents((Component)((Object)this));
    }
}

