/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.addons;

import com.openindex.openestate.impl.CustomValuesImpl;
import com.openindex.openestate.tool.ImmoToolDbException;
import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.contacts.ContactsEntry;
import com.openindex.openestate.tool.contacts.ContactsGroup;
import com.openindex.openestate.tool.contacts.ContactsPluginUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.modules.XMLResource;

public class ContactsEntryEstate {
    private static final Logger LOGGER = Logger.getLogger(ContactsEntryEstate.class);
    public static final String VALUE_ESTATE_ID = "estate.id.";
    public static final String VALUE_ESTATE_TEXT = "estate.text.";
    public static final String VALUE_ESTATE_TYPE = "estate.type.";
    public static final String TYPE_OWNER = "owner";
    public static final String TYPE_INTERESTED = "interested";
    public static final String TYPE_CUSTOMER = "customer";
    private long entryContactEntryId = 0L;
    private long entryContactGroupId = 0L;
    private long entryEstateId = 0L;
    private String entryDescription = "";
    private String entryType = "";

    public ContactsEntryEstate() {
    }

    public ContactsEntryEstate(long l, ContactsEntry contactsEntry, String string, String string2) {
        this(l, contactsEntry.getGroupId(), contactsEntry.getId(), string, string2);
    }

    public ContactsEntryEstate(long l, long l2, long l3, String string, String string2) {
        this();
        this.entryEstateId = l;
        this.entryContactGroupId = l2;
        this.entryContactEntryId = l3;
        this.entryDescription = string != null ? string.trim() : "";
        this.entryType = string2 != null ? string2.trim() : "";
    }

    public long getContactEntryId() {
        return this.entryContactEntryId;
    }

    public long getContactGroupId() {
        return this.entryContactGroupId;
    }

    public String getDescription() {
        return this.entryDescription != null ? StringEscapeUtils.unescapeHtml((String)this.entryDescription) : "";
    }

    public static ContactsEntryEstate[] getContactEntryEstates(ContactsEntry contactsEntry) {
        return ContactsEntryEstate.getContactEntryEstates(contactsEntry.getGroupId(), contactsEntry.getId(), contactsEntry.getCompanyAdress().getCustomValues());
    }

    public static ContactsEntryEstate[] getContactEntryEstates(long l, long l2) throws ImmoToolDbException {
        return ContactsEntryEstate.getContactEntryEstates(ContactsEntry.load((long)l, (long)l2));
    }

    public static ContactsEntryEstate[] getContactEntryEstates(long l, long l2, Collection collection) throws ImmoToolDbException {
        return ContactsEntryEstate.getContactEntryEstates(ContactsEntry.load((long)l, (long)l2, (Collection)collection));
    }

    public static ContactsEntryEstate[] getContactEntryEstates(long l, long l2, CustomValuesImpl customValuesImpl) {
        ArrayList<ContactsEntryEstate> arrayList = new ArrayList<ContactsEntryEstate>();
        for (String string : customValuesImpl.getValueMap().keySet()) {
            String string2;
            if (!string.startsWith(VALUE_ESTATE_ID)) continue;
            String string3 = VALUE_ESTATE_TEXT + string.substring(VALUE_ESTATE_ID.length());
            String string4 = VALUE_ESTATE_TYPE + string.substring(VALUE_ESTATE_ID.length());
            Long l3 = customValuesImpl.getCustomValue(string).getInteger().longValue();
            String string5 = customValuesImpl.hasCustomValue(string3) ? (customValuesImpl.getCustomValue(string3).isText() ? customValuesImpl.getCustomValue(string3).getText() : customValuesImpl.getCustomValue(string3).getString()) : (string2 = "");
            String string6 = customValuesImpl.hasCustomValue(string4) ? (customValuesImpl.getCustomValue(string4).isText() ? customValuesImpl.getCustomValue(string4).getText() : customValuesImpl.getCustomValue(string4).getString()) : "";
            arrayList.add(new ContactsEntryEstate(l3, l, l2, string2, string6));
        }
        return arrayList.toArray(new ContactsEntryEstate[arrayList.size()]);
    }

    public long getEstateId() {
        return this.entryEstateId;
    }

    public String getType() {
        return this.entryType;
    }

    public AgencyEstate loadAgencyEstate() throws ImmoToolDbException {
        return AgencyEstate.loadEstate((long)this.getEstateId());
    }

    public ContactsEntry loadContactsEntry() throws ImmoToolDbException {
        return ContactsEntry.load((long)this.getContactGroupId(), (long)this.getContactEntryId());
    }

    public ContactsGroup loadContactsGroup() throws ImmoToolDbException {
        return ContactsGroup.load((long)this.getContactGroupId());
    }

    public static ContactsEntryEstate[] loadEntriesForEstate(long l) throws ImmoToolDbException {
        Collection collection = null;
        ArrayList<ContactsEntryEstate> arrayList = new ArrayList<ContactsEntryEstate>();
        try {
            collection = ContactsPluginUtils.openPluginCollection((String)"");
            String string = "declare namespace util=\"http://exist-db.org/xquery/util\";\ndeclare namespace openestate=\"http://www.openestate.org/1.0/\";\nfor $x in collection('ImmoTool/OpenEstate-Contacts')/openestate:CompanyAdress//openestate:CustomValues/openestate:CustomValue\nlet $pos:=substring($x/@Key, " + (VALUE_ESTATE_ID.length() + 1) + ")\n" + "let $txtVar:=concat('" + VALUE_ESTATE_TEXT + "', $pos)\n" + "let $txt:=$x/../openestate:" + "CustomValue" + "[@" + "Key" + "=$txtVar]/*/text()\n" + "let $typeVar:=concat('" + VALUE_ESTATE_TYPE + "', $pos)\n" + "let $type:=$x/../openestate:" + "CustomValue" + "[@" + "Key" + "=$typeVar]/*/text()\n" + "where (starts-with($x/@" + "Key" + ", '" + VALUE_ESTATE_ID + "') and ($x/openestate:" + "Integer" + "/text()='" + l + "') )\n" + "return <result path=\"{util:collection-name( $x )}\" file=\"{util:document-name( $x )}\" pos=\"{$pos}\" type=\"{$type}\">{$txt}</result>";
            ResourceSet resourceSet = ImmoToolDbUtils.executeXQuery((Collection)collection, (String)string);
            for (long i = 0L; i < resourceSet.getSize(); ++i) {
                try {
                    XMLResource xMLResource = (XMLResource)resourceSet.getResource(i);
                    Node node = xMLResource.getContentAsDOM();
                    String string2 = node.getAttributes().getNamedItem("path").getNodeValue();
                    String string3 = node.getAttributes().getNamedItem("file").getNodeValue();
                    String string4 = node.getAttributes().getNamedItem("type").getNodeValue();
                    String string5 = node.getFirstChild() != null ? node.getFirstChild().getNodeValue() : "";
                    string5 = string5.replaceAll("<br/>", SystemUtils.LINE_SEPARATOR);
                    String[] stringArray = string2.split("/");
                    String[] stringArray2 = string3.split("\\.");
                    arrayList.add(new ContactsEntryEstate(l, Long.valueOf(stringArray[stringArray.length - 1]), Long.valueOf(stringArray2[1]), string5, string4));
                    continue;
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"could not load ContactsEntryEstate!");
                    LOGGER.warn((Object)("> for estateId " + l));
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
            }
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException(exception.getLocalizedMessage(), (Throwable)exception);
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
        return arrayList.toArray(new ContactsEntryEstate[arrayList.size()]);
    }

    public void setContactEntryId(long l) {
        this.entryContactEntryId = l;
    }

    public static void setContactEntryEstates(ContactsEntry contactsEntry, ContactsEntryEstate[] contactsEntryEstateArray) {
        ContactsEntryEstate.setContactEntryEstates(contactsEntry.getCompanyAdress().getCustomValues(), contactsEntryEstateArray);
    }

    public static void setContactEntryEstates(CustomValuesImpl customValuesImpl, ContactsEntryEstate[] contactsEntryEstateArray) {
        int n = customValuesImpl.getValueMap().size();
        for (String string : customValuesImpl.getValueMap().keySet().toArray(new String[n])) {
            String string2;
            if (!string.startsWith(VALUE_ESTATE_ID)) continue;
            customValuesImpl.getValueMap().remove(string);
            String string3 = VALUE_ESTATE_TEXT + string.substring(VALUE_ESTATE_ID.length());
            if (customValuesImpl.hasCustomValue(string3)) {
                customValuesImpl.getValueMap().remove(string3);
            }
            if (!customValuesImpl.hasCustomValue(string2 = VALUE_ESTATE_TYPE + string.substring(VALUE_ESTATE_ID.length()))) continue;
            customValuesImpl.getValueMap().remove(string2);
        }
        for (int i = 0; i < contactsEntryEstateArray.length; ++i) {
            String string;
            String string4 = VALUE_ESTATE_ID + i;
            customValuesImpl.putCustomValue(string4, (Object)BigInteger.valueOf(contactsEntryEstateArray[i].getEstateId()), 4);
            String string5 = VALUE_ESTATE_TEXT + i;
            if (contactsEntryEstateArray[i].getDescription().trim().length() > 0) {
                customValuesImpl.putCustomValue(string5, (Object)contactsEntryEstateArray[i].getDescription().trim(), 6);
            }
            string = VALUE_ESTATE_TYPE + i;
            if (contactsEntryEstateArray[i].getType().trim().length() <= 0) continue;
            customValuesImpl.putCustomValue(string, (Object)contactsEntryEstateArray[i].getType().trim(), 5);
        }
    }

    public void setContactGroupId(long l) {
        this.entryContactGroupId = l;
    }

    public void setDescription(String string) {
        this.entryDescription = string;
    }

    public void setEstateId(long l) {
        this.entryEstateId = l;
    }

    public void setType(String string) {
        this.entryType = string;
    }

    public String writeType() {
        return ContactsEntryEstate.writeType(this.getType());
    }

    public static String writeType(String string) {
        if (TYPE_CUSTOMER.equals(string)) {
            return ImmoToolUtils.getResourceMap(ContactsEntryEstate.class).getString("type.customer", new Object[0]);
        }
        if (TYPE_INTERESTED.equals(string)) {
            return ImmoToolUtils.getResourceMap(ContactsEntryEstate.class).getString("type.interested", new Object[0]);
        }
        if (TYPE_OWNER.equals(string)) {
            return ImmoToolUtils.getResourceMap(ContactsEntryEstate.class).getString("type.owner", new Object[0]);
        }
        return string;
    }
}

