/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.addons;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.agency.addons.ContactsEntryEstate;
import com.openindex.openestate.tool.contacts.ContactsEntry;
import com.openindex.openestate.tool.contacts.ContactsGroup;
import com.openindex.openestate.tool.contacts.ContactsPluginUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.fife.ui.rtextarea.RTextArea;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;
import org.xmldb.api.base.Collection;

public class ContactsEntryEstateDialog
extends JDialog {
    private static final Logger LOGGER = Logger.getLogger(ContactsEntryEstateDialog.class);
    public static final int SELECT_ALL = 0;
    public static final int SELECT_ESTATE = 1;
    public static final int SELECT_CONTACT = 2;
    private int selection = 0;
    public static final int UNDEFINED = 0;
    public static final int CANCELLED = 1;
    public static final int APPROVED = 2;
    private int status = 0;
    private ActionMap actionMap;
    private ResourceMap resourceMap;
    private JXPanel contentPane;
    private JComboBox typeBox;
    private RTextArea notesField;
    private JButton closeButton;
    private JButton submitButton;
    private JComboBox estateField = null;
    private JXBusyLabel estateBusyField = null;
    private JComboBox contactGroupField = null;
    private JXBusyLabel contactGroupBusyField = null;
    private JComboBox contactEntryField = null;
    private JXBusyLabel contactEntryBusyField = null;
    private Map<String, String> contactTypes = null;
    private Long contactEntryIdOnLoad = null;
    private Task estateTask = null;
    private Task contactGroupTask = null;
    private Task contactEntryTask = null;
    private Collection contactCollection = null;

    public ContactsEntryEstateDialog(int n, Dialog dialog, boolean bl) {
        super(dialog, bl);
        this.build(n);
        this.setLocationRelativeTo(dialog);
    }

    public ContactsEntryEstateDialog(int n, Frame frame, boolean bl) {
        super(frame, bl);
        this.build(n);
        this.setLocationRelativeTo(frame);
    }

    private void build(int n) {
        Object object;
        this.actionMap = ImmoToolUtils.getActionMap(ContactsEntryEstateDialog.class, (Object)this);
        this.resourceMap = ImmoToolUtils.getResourceMap(ContactsEntryEstateDialog.class);
        this.contentPane = new JXPanel();
        this.contentPane.setOpaque(true);
        this.selection = n;
        this.setContentPane((Container)this.contentPane);
        this.buildForm();
        this.setDefaultCloseOperation(2);
        this.resourceMap.injectComponents((Component)this);
        this.contactTypes = new TreeMap<String, String>();
        this.contactTypes.put(ContactsEntryEstate.writeType("customer"), "customer");
        this.contactTypes.put(ContactsEntryEstate.writeType("interested"), "interested");
        this.contactTypes.put(ContactsEntryEstate.writeType("owner"), "owner");
        ((DefaultComboBoxModel)this.typeBox.getModel()).addElement("");
        for (String string : this.contactTypes.keySet()) {
            ((DefaultComboBoxModel)this.typeBox.getModel()).addElement(string);
        }
        if (this.contactGroupField != null && this.contactEntryField != null) {
            this.contactGroupField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ContactsEntryEstateDialog.this.contactGroupField.getSelectedIndex() < 0) {
                        return;
                    }
                    long l = ContactsEntryEstateDialog.this.contactEntryIdOnLoad != null ? ContactsEntryEstateDialog.this.contactEntryIdOnLoad : 0L;
                    ImmoToolUtils.executeTask((Task)ContactsEntryEstateDialog.this.reloadContactEntries(l));
                }
            });
            object = this.contactEntryField.getToolTipText();
            this.contactEntryField.addActionListener(new ActionListener((String)object){
                final /* synthetic */ String val$contactEntryFieldToolTip;
                {
                    this.val$contactEntryFieldToolTip = string;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ContactsEntryEstateDialog.this.contactEntryField.getSelectedIndex() <= 0) {
                        ContactsEntryEstateDialog.this.contactEntryField.setToolTipText(this.val$contactEntryFieldToolTip);
                    } else {
                        ContactsEntryEstateDialog.this.contactEntryField.setToolTipText(((ContactsEntry.Row)ContactsEntryEstateDialog.this.contactEntryField.getSelectedItem()).writeToolTip());
                    }
                }
            });
        }
        if (this.estateField != null) {
            object = this.estateField.getToolTipText();
            this.estateField.addActionListener(new ActionListener((String)object){
                final /* synthetic */ String val$estateFieldToolTip;
                {
                    this.val$estateFieldToolTip = string;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ContactsEntryEstateDialog.this.estateField.getSelectedIndex() <= 0) {
                        ContactsEntryEstateDialog.this.estateField.setToolTipText(this.val$estateFieldToolTip);
                    } else {
                        ContactsEntryEstateDialog.this.estateField.setToolTipText(((AgencyEstate.Row)ContactsEntryEstateDialog.this.estateField.getSelectedItem()).writeToolTip());
                    }
                }
            });
        }
        if (SystemUtils.IS_OS_MAC_OSX) {
            this.closeButton.setOpaque(false);
            this.submitButton.setOpaque(false);
        }
        this.setSize(500, 400);
        ImmoToolUtils.configureDialog((JDialog)this, (JXPanel)this.contentPane);
    }

    private void buildForm() {
        this.notesField = new RTextArea();
        this.notesField.setName("notesField");
        this.notesField.setLineWrap(true);
        this.notesField.setWrapStyleWord(true);
        this.typeBox = new JComboBox(new DefaultComboBoxModel());
        this.typeBox.setName("typeBox");
        this.typeBox.setEditable(true);
        this.closeButton = new JButton(this.actionMap.get("doClose"));
        this.closeButton.setName("closeButton");
        this.submitButton = new JButton(this.actionMap.get("doSubmit"));
        this.submitButton.setName("submitButton");
        JPanel jPanel = null;
        if (this.selection == 0 || this.selection == 1) {
            this.estateField = new JComboBox();
            this.estateField.setName("estateField");
            this.estateField.setRenderer(new EstateRenderer());
            this.estateBusyField = new JXBusyLabel();
            this.estateBusyField.setName("estateBusyField");
            this.estateBusyField.setOpaque(false);
            this.estateBusyField.setVisible(false);
            jPanel = new JPanel(new BorderLayout());
            jPanel.setOpaque(false);
            jPanel.add((Component)this.estateField, "North");
            jPanel.add((Component)this.estateBusyField, "South");
            AutoCompleteDecorator.decorate((JComboBox)this.estateField, (ObjectToStringConverter)new ObjectToStringConverter(){

                public String getPreferredStringForItem(Object object) {
                    if (object instanceof AgencyEstate.Row) {
                        AgencyEstate.Row row = (AgencyEstate.Row)object;
                        String string = "#" + row.id;
                        if (row.publicId != null && row.publicId.trim().length() > 0) {
                            string = string + " / " + row.publicId;
                        }
                        if (row.title != null && row.title.trim().length() > 0) {
                            string = string + " | " + row.title;
                        }
                        return string.trim();
                    }
                    return "-";
                }

                public String[] getPossibleStringsForItem(Object object) {
                    if (object instanceof AgencyEstate.Row) {
                        AgencyEstate.Row row = (AgencyEstate.Row)object;
                        ArrayList<String> arrayList = new ArrayList<String>();
                        arrayList.add(this.getPreferredStringForItem(object));
                        if (row.publicId != null && row.publicId.trim().length() > 0) {
                            arrayList.add(row.publicId);
                        }
                        if (row.title != null && row.title.trim().length() > 0) {
                            arrayList.add(row.title);
                        }
                        return arrayList.toArray(new String[arrayList.size()]);
                    }
                    return super.getPossibleStringsForItem(object);
                }
            });
        }
        JPanel jPanel2 = null;
        JPanel jPanel3 = null;
        if (this.selection == 0 || this.selection == 2) {
            this.contactGroupField = new JComboBox();
            this.contactGroupField.setName("contactGroupField");
            this.contactGroupField.setRenderer(new ContactGroupRenderer());
            this.contactGroupBusyField = new JXBusyLabel();
            this.contactGroupBusyField.setName("contactGroupBusyField");
            this.contactGroupBusyField.setOpaque(false);
            this.contactGroupBusyField.setVisible(false);
            jPanel2 = new JPanel(new BorderLayout());
            jPanel2.setOpaque(false);
            jPanel2.add((Component)this.contactGroupField, "North");
            jPanel2.add((Component)this.contactGroupBusyField, "South");
            this.contactEntryField = new JComboBox();
            this.contactEntryField.setName("contactEntryField");
            this.contactEntryField.setRenderer(new ContactEntryRenderer());
            this.contactEntryBusyField = new JXBusyLabel();
            this.contactEntryBusyField.setName("contactEntryBusyField");
            this.contactEntryBusyField.setOpaque(false);
            this.contactEntryBusyField.setVisible(false);
            jPanel3 = new JPanel(new BorderLayout());
            jPanel3.setOpaque(false);
            jPanel3.add((Component)this.contactEntryField, "North");
            jPanel3.add((Component)this.contactEntryBusyField, "South");
            AutoCompleteDecorator.decorate((JComboBox)this.contactEntryField, (ObjectToStringConverter)new ObjectToStringConverter(){

                public String getPreferredStringForItem(Object object) {
                    if (object instanceof ContactsEntry.Row) {
                        String string;
                        ContactsEntry.Row row = (ContactsEntry.Row)object;
                        String string2 = "";
                        String string3 = row.writePerson();
                        if (string3 != null && string3.trim().length() > 0) {
                            if (string2.length() > 0) {
                                string2 = string2 + " / ";
                            }
                            string2 = string2 + string3.trim();
                        }
                        if ((string = row.company) != null && string.trim().length() > 0) {
                            if (string2.length() > 0) {
                                string2 = string2 + " / ";
                            }
                            string2 = string2 + string.trim();
                        }
                        return "#" + row.id + " | " + string2;
                    }
                    return "-";
                }

                public String[] getPossibleStringsForItem(Object object) {
                    if (object instanceof ContactsEntry.Row) {
                        ContactsEntry.Row row = (ContactsEntry.Row)object;
                        ArrayList<String> arrayList = new ArrayList<String>();
                        arrayList.add(this.getPreferredStringForItem(object));
                        arrayList.add("#" + row.id);
                        if (row.firstName != null && row.firstName.trim().length() > 0) {
                            arrayList.add(row.firstName);
                        }
                        if (row.lastName != null && row.lastName.trim().length() > 0) {
                            arrayList.add(row.lastName);
                        }
                        if (row.company != null && row.company.trim().length() > 0) {
                            arrayList.add(row.company);
                        }
                        return arrayList.toArray(new String[arrayList.size()]);
                    }
                    return super.getPossibleStringsForItem(object);
                }
            });
        }
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:pref, 3dlu, 20dlu:grow");
        defaultFormBuilder.opaque(false);
        if (this.selection == 0 || this.selection == 1) {
            defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("label.selectEstate", new Object[0])), 3);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(this.resourceMap.getString("label.selectEstate.estate", new Object[0]), (Component)jPanel);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append((Component)new JLabel(" "), 3);
            defaultFormBuilder.nextLine();
        }
        if (this.selection == 0 || this.selection == 2) {
            defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("label.selectContact", new Object[0])), 3);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(this.resourceMap.getString("label.selectContact.group", new Object[0]), (Component)jPanel2);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(this.resourceMap.getString("label.selectContact.contact", new Object[0]), jPanel3);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append((Component)new JLabel(" "), 3);
            defaultFormBuilder.nextLine();
        }
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("label.setNotes", new Object[0])), 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.setNotes.mapping", new Object[0]), (Component)this.typeBox);
        defaultFormBuilder.nextLine();
        this.contentPane.setLayout((LayoutManager)new BorderLayout(5, 5));
        this.contentPane.setBorder(Borders.DIALOG);
        this.contentPane.add((Component)defaultFormBuilder.getPanel(), (Object)"North");
        JScrollPane jScrollPane = new JScrollPane((Component)this.notesField);
        jScrollPane.setOpaque(false);
        this.contentPane.add((Component)jScrollPane, (Object)"Center");
        JPanel jPanel4 = ImmoToolUtils.buildButtonBar((JButton[])new JButton[]{this.submitButton, this.closeButton});
        jPanel4.setOpaque(false);
        this.contentPane.add((Component)jPanel4, (Object)"South");
        this.contentPane.revalidate();
        this.contentPane.repaint();
    }

    @Action
    public void doClose() {
        this.status = 1;
        this.setVisible(false);
    }

    @Action
    public void doSubmit() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.estateField != null && this.estateField.getSelectedIndex() <= 0) {
            arrayList.add(this.resourceMap.getString("error.noEstateSelected", new Object[0]));
        }
        if (this.contactGroupField != null && this.contactEntryField != null && (this.contactGroupField.getSelectedIndex() <= 0 || this.contactEntryField.getSelectedIndex() <= 0)) {
            arrayList.add(this.resourceMap.getString("error.noContactSelected", new Object[0]));
        }
        if (!arrayList.isEmpty()) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.invalidInput", new Object[0]), arrayList);
            return;
        }
        this.status = 2;
        this.setVisible(false);
    }

    public AgencyEstate.Row getSelectedAgencyEstate() {
        if (this.estateField == null) {
            return null;
        }
        Object object = this.estateField.getSelectedItem();
        return object instanceof AgencyEstate.Row ? (AgencyEstate.Row)object : null;
    }

    public long getSelectedAgencyEstateId() {
        AgencyEstate.Row row = this.getSelectedAgencyEstate();
        return row != null ? row.id : 0L;
    }

    public ContactsEntry.Row getSelectedContactsEntry() {
        if (this.contactEntryField == null) {
            return null;
        }
        Object object = this.contactEntryField.getSelectedItem();
        return object instanceof ContactsEntry.Row ? (ContactsEntry.Row)object : null;
    }

    public ContactsGroup getSelectedContactsGroup() {
        if (this.contactGroupField == null) {
            return null;
        }
        Object object = this.contactGroupField.getSelectedItem();
        return object instanceof ContactsGroup ? (ContactsGroup)object : null;
    }

    public String getSelectedDescription() {
        return ImmoToolUtils.replaceTags((String)this.notesField.getText()).trim();
    }

    public String getSelectedType() {
        String string = (String)this.typeBox.getSelectedItem();
        if (string == null) {
            return "";
        }
        return this.contactTypes.containsKey(string) ? this.contactTypes.get(string) : string;
    }

    public int getStatus() {
        return this.status;
    }

    public void load(ContactsEntryEstate contactsEntryEstate) {
        String string;
        this.notesField.setText(contactsEntryEstate != null && contactsEntryEstate.getDescription() != null ? contactsEntryEstate.getDescription().trim() : "");
        this.typeBox.setSelectedIndex(0);
        String string2 = string = contactsEntryEstate != null ? contactsEntryEstate.getType() : "";
        if (string != null && string.trim().length() > 0) {
            if (this.contactTypes.containsValue(string)) {
                String string3 = ContactsEntryEstate.writeType(string);
                for (int i = 1; i < this.typeBox.getItemCount(); ++i) {
                    String string4 = (String)this.typeBox.getItemAt(i);
                    if (!string4.equals(string3)) continue;
                    this.typeBox.setSelectedIndex(i);
                    break;
                }
            }
            if (this.typeBox.getSelectedIndex() <= 0) {
                ((DefaultComboBoxModel)this.typeBox.getModel()).addElement(string);
                this.typeBox.setSelectedIndex(this.typeBox.getItemCount() - 1);
            }
        }
    }

    public void loadContact(ContactsEntry contactsEntry) throws ImmoToolException {
        if (contactsEntry != null) {
            this.loadContact(contactsEntry.getGroupId(), contactsEntry.getId());
        } else {
            this.loadContact(0L, 0L);
        }
    }

    public void loadContact(long l, long l2) throws ImmoToolException {
        if (this.contactGroupField == null || this.contactEntryField == null) {
            return;
        }
        this.contactEntryIdOnLoad = l2;
        this.contactGroupField.setSelectedIndex(-1);
        ImmoToolUtils.executeTask((Task)this.reloadContactGroups(l));
    }

    private DefaultComboBoxModel loadContactEntryModel(Collection collection) throws ImmoToolException {
        ContactsGroup contactsGroup = this.getSelectedContactsGroup();
        if (contactsGroup == null) {
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            defaultComboBoxModel.addElement("[ " + this.resourceMap.getString("message.pleaseSelectContactGroup", new Object[0]) + " ]");
            return defaultComboBoxModel;
        }
        try {
            DefaultComboBoxModel<ContactsEntry.Row> defaultComboBoxModel = new DefaultComboBoxModel<ContactsEntry.Row>();
            defaultComboBoxModel.addElement(null);
            ContactsEntry.Row[] rowArray = ContactsEntry.loadRows(null, (Long[])new Long[]{contactsGroup.getId()}, null, null, (Collection)collection);
            if (rowArray != null) {
                for (ContactsEntry.Row row : rowArray) {
                    defaultComboBoxModel.addElement(row);
                }
            }
            return defaultComboBoxModel;
        }
        catch (Exception exception) {
            throw new ImmoToolException("Can't load contact entries!", (Throwable)exception);
        }
    }

    private DefaultComboBoxModel loadContactGroupModel(Collection collection) throws ImmoToolException {
        try {
            DefaultComboBoxModel<ContactsGroup> defaultComboBoxModel = new DefaultComboBoxModel<ContactsGroup>();
            defaultComboBoxModel.addElement(null);
            for (ContactsGroup contactsGroup : ContactsGroup.loadGroups((Collection)collection)) {
                defaultComboBoxModel.addElement(contactsGroup);
            }
            return defaultComboBoxModel;
        }
        catch (Exception exception) {
            throw new ImmoToolException("Can't load contact groups!", (Throwable)exception);
        }
    }

    public void loadEstate(AgencyEstate agencyEstate) throws ImmoToolException {
        this.loadEstate(agencyEstate != null ? agencyEstate.getIdNr() : 0L);
    }

    public void loadEstate(long l) throws ImmoToolException {
        if (this.estateField == null) {
            return;
        }
        ImmoToolUtils.executeTask((Task)this.reloadEstates(l));
    }

    private DefaultComboBoxModel loadEstateModel() throws ImmoToolException {
        try {
            DefaultComboBoxModel<AgencyEstate.Row> defaultComboBoxModel = new DefaultComboBoxModel<AgencyEstate.Row>();
            defaultComboBoxModel.addElement(null);
            AgencyEstate.Row[] rowArray = AgencyEstate.loadEstateRows(null, null, null);
            if (rowArray != null) {
                for (AgencyEstate.Row row : rowArray) {
                    defaultComboBoxModel.addElement(row);
                }
            }
            return defaultComboBoxModel;
        }
        catch (Exception exception) {
            throw new ImmoToolException("Can't load estates!", (Throwable)exception);
        }
    }

    private Task reloadContactEntries(final long l) {
        if (this.contactEntryTask != null) {
            LOGGER.info((Object)"cancel running entry-task...");
            this.contactEntryTask.cancel(true);
        }
        this.contactEntryField.setEnabled(false);
        this.contactEntryField.setVisible(false);
        this.contactEntryBusyField.setVisible(true);
        this.contactEntryBusyField.setBusy(true);
        this.contactEntryBusyField.setText(this.resourceMap.getString("message.doSearchContactEntries", new Object[0]));
        this.contactEntryTask = new ImmoToolTask<DefaultComboBoxModel>(){

            protected DefaultComboBoxModel executeTask() throws Exception {
                if (ContactsEntryEstateDialog.this.contactCollection == null) {
                    ContactsEntryEstateDialog.this.contactCollection = ContactsPluginUtils.openPluginCollection((String)"");
                }
                DefaultComboBoxModel defaultComboBoxModel = ContactsEntryEstateDialog.this.loadContactEntryModel(ContactsEntryEstateDialog.this.contactCollection);
                ContactsEntryEstateDialog.this.contactEntryBusyField.setText(ContactsEntryEstateDialog.this.resourceMap.getString("message.doRefreshBox", new Object[0]));
                ContactsEntryEstateDialog.this.contactEntryField.setModel(defaultComboBoxModel);
                return defaultComboBoxModel;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)ContactsEntryEstateDialog.this.resourceMap.getString("error.cantLoadContactEntriesBox", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                ContactsEntryEstateDialog.this.contactEntryField.setEnabled(true);
                ContactsEntryEstateDialog.this.contactEntryField.setVisible(true);
                ContactsEntryEstateDialog.this.contactEntryBusyField.setVisible(false);
                ContactsEntryEstateDialog.this.contactEntryBusyField.setBusy(false);
                ContactsEntryEstateDialog.this.contactEntryTask = null;
                if (ContactsEntryEstateDialog.this.contactEntryIdOnLoad != null) {
                    ContactsEntryEstateDialog.this.contactEntryIdOnLoad = null;
                }
                if (ContactsEntryEstateDialog.this.contactCollection != null && ContactsEntryEstateDialog.this.contactGroupTask == null) {
                    ImmoToolDbUtils.close((Collection)ContactsEntryEstateDialog.this.contactCollection);
                    ContactsEntryEstateDialog.this.contactCollection = null;
                }
            }

            protected void succeeded(DefaultComboBoxModel defaultComboBoxModel) {
                super.succeeded((Object)defaultComboBoxModel);
                ContactsEntryEstateDialog.this.contactEntryField.setSelectedIndex(-1);
                if (l > 0L) {
                    for (int i = 0; i < defaultComboBoxModel.getSize(); ++i) {
                        Object e = defaultComboBoxModel.getElementAt(i);
                        if (!(e instanceof ContactsEntry.Row)) continue;
                        ContactsEntry.Row row = (ContactsEntry.Row)e;
                        if (row.id != l) continue;
                        ContactsEntryEstateDialog.this.contactEntryField.setSelectedIndex(i);
                        break;
                    }
                }
            }
        };
        return this.contactEntryTask;
    }

    private Task reloadContactGroups(final long l) {
        if (this.contactGroupTask != null) {
            LOGGER.info((Object)"cancel running group-task...");
            this.contactGroupTask.cancel(true);
        }
        this.contactGroupField.setEnabled(false);
        this.contactGroupField.setVisible(false);
        this.contactGroupBusyField.setVisible(true);
        this.contactGroupBusyField.setBusy(true);
        this.contactGroupBusyField.setText(this.resourceMap.getString("message.doSearchContactGroups", new Object[0]));
        this.contactGroupTask = new ImmoToolTask<DefaultComboBoxModel>(){

            protected DefaultComboBoxModel executeTask() throws Exception {
                if (ContactsEntryEstateDialog.this.contactCollection == null) {
                    ContactsEntryEstateDialog.this.contactCollection = ContactsPluginUtils.openPluginCollection((String)"");
                }
                DefaultComboBoxModel defaultComboBoxModel = ContactsEntryEstateDialog.this.loadContactGroupModel(ContactsEntryEstateDialog.this.contactCollection);
                ContactsEntryEstateDialog.this.contactGroupBusyField.setText(ContactsEntryEstateDialog.this.resourceMap.getString("message.doRefreshBox", new Object[0]));
                ContactsEntryEstateDialog.this.contactGroupField.setModel(defaultComboBoxModel);
                return defaultComboBoxModel;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)ContactsEntryEstateDialog.this.resourceMap.getString("error.cantLoadContactGroupsBox", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                ContactsEntryEstateDialog.this.contactGroupField.setEnabled(true);
                ContactsEntryEstateDialog.this.contactGroupField.setVisible(true);
                ContactsEntryEstateDialog.this.contactGroupBusyField.setVisible(false);
                ContactsEntryEstateDialog.this.contactGroupBusyField.setBusy(false);
                ContactsEntryEstateDialog.this.contactGroupTask = null;
                if (ContactsEntryEstateDialog.this.contactCollection != null && ContactsEntryEstateDialog.this.contactEntryTask == null) {
                    ImmoToolDbUtils.close((Collection)ContactsEntryEstateDialog.this.contactCollection);
                    ContactsEntryEstateDialog.this.contactCollection = null;
                }
            }

            protected void succeeded(DefaultComboBoxModel defaultComboBoxModel) {
                super.succeeded((Object)defaultComboBoxModel);
                if (l == 0L) {
                    ContactsEntryEstateDialog.this.contactGroupField.setSelectedIndex(0);
                } else if (l > 0L) {
                    ContactsEntryEstateDialog.this.contactGroupField.setSelectedIndex(-1);
                    for (int i = 0; i < defaultComboBoxModel.getSize(); ++i) {
                        ContactsGroup contactsGroup;
                        Object e = defaultComboBoxModel.getElementAt(i);
                        if (!(e instanceof ContactsGroup) || (contactsGroup = (ContactsGroup)e).getId() != l) continue;
                        ContactsEntryEstateDialog.this.contactGroupField.setSelectedIndex(i);
                        break;
                    }
                }
            }
        };
        return this.contactGroupTask;
    }

    private Task reloadEstates(final long l) {
        if (this.estateTask != null) {
            LOGGER.info((Object)"cancel running estate-task...");
            this.estateTask.cancel(true);
        }
        this.estateField.setEnabled(false);
        this.estateField.setVisible(false);
        this.estateBusyField.setVisible(true);
        this.estateBusyField.setBusy(true);
        this.estateBusyField.setText(this.resourceMap.getString("message.doSearchEstates", new Object[0]));
        this.estateTask = new ImmoToolTask<DefaultComboBoxModel>(){

            protected DefaultComboBoxModel executeTask() throws Exception {
                DefaultComboBoxModel defaultComboBoxModel = ContactsEntryEstateDialog.this.loadEstateModel();
                ContactsEntryEstateDialog.this.estateBusyField.setText(ContactsEntryEstateDialog.this.resourceMap.getString("message.doRefreshBox", new Object[0]));
                ContactsEntryEstateDialog.this.estateField.setModel(defaultComboBoxModel);
                return defaultComboBoxModel;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)ContactsEntryEstateDialog.this.resourceMap.getString("error.cantLoadEstateBox", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                ContactsEntryEstateDialog.this.estateField.setEnabled(true);
                ContactsEntryEstateDialog.this.estateField.setVisible(true);
                ContactsEntryEstateDialog.this.estateBusyField.setVisible(false);
                ContactsEntryEstateDialog.this.estateBusyField.setBusy(false);
                ContactsEntryEstateDialog.this.estateTask = null;
            }

            protected void succeeded(DefaultComboBoxModel defaultComboBoxModel) {
                super.succeeded((Object)defaultComboBoxModel);
                ContactsEntryEstateDialog.this.estateField.setSelectedIndex(0);
                if (l > 0L) {
                    for (int i = 0; i < defaultComboBoxModel.getSize(); ++i) {
                        Object e = defaultComboBoxModel.getElementAt(i);
                        if (!(e instanceof AgencyEstate.Row)) continue;
                        AgencyEstate.Row row = (AgencyEstate.Row)e;
                        if (row.id != l) continue;
                        ContactsEntryEstateDialog.this.estateField.setSelectedIndex(i);
                        break;
                    }
                }
            }
        };
        return this.estateTask;
    }

    public void save(ContactsEntryEstate contactsEntryEstate) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.estateField != null && this.estateField.getSelectedIndex() <= 0) {
            arrayList.add(this.resourceMap.getString("error.noEstateSelected", new Object[0]));
        }
        if (this.contactGroupField != null && this.contactGroupField.getSelectedIndex() <= 0) {
            arrayList.add(this.resourceMap.getString("noContactSelected", new Object[0]));
        } else if (this.contactEntryField != null && this.contactEntryField.getSelectedIndex() <= 0) {
            arrayList.add(this.resourceMap.getString("noContactSelected", new Object[0]));
        }
        if (!arrayList.isEmpty()) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.invalidInput", new Object[0]), arrayList);
            return;
        }
        contactsEntryEstate.setEstateId(this.selection == 0 || this.selection == 1 ? this.getSelectedAgencyEstateId() : 0L);
        contactsEntryEstate.setContactEntryId(this.selection == 0 || this.selection == 2 ? this.getSelectedContactsEntry().id : 0L);
        contactsEntryEstate.setContactGroupId(this.selection == 0 || this.selection == 2 ? this.getSelectedContactsGroup().getId() : 0L);
        contactsEntryEstate.setDescription(this.getSelectedDescription());
        contactsEntryEstate.setType(this.getSelectedType());
    }

    private static class EstateRenderer
    extends JLabel
    implements ListCellRenderer {
        public EstateRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            AgencyPluginUtils.prepareListCellRenderer((JLabel)this, (JList)jList, (AgencyEstate.Row)((AgencyEstate.Row)object), (int)n, (boolean)bl, (boolean)bl2);
            return this;
        }
    }

    private class ContactGroupRenderer
    extends JLabel
    implements ListCellRenderer {
        public ContactGroupRenderer() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof ContactsGroup) {
                ContactsGroup contactsGroup = (ContactsGroup)object;
                this.setText(contactsGroup.getName());
            } else {
                this.setText(n <= 0 ? "[ " + ContactsEntryEstateDialog.this.resourceMap.getString("message.selectContactGroup", new Object[0]) + " ]" : "");
            }
            return this;
        }
    }

    private static class ContactEntryRenderer
    extends JLabel
    implements ListCellRenderer {
        public ContactEntryRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof ContactsEntry.Row) {
                ContactsPluginUtils.prepareListCellRenderer((JLabel)this, (JList)jList, (ContactsEntry.Row)((ContactsEntry.Row)object), (int)n, (boolean)bl, (boolean)bl2);
            } else if (object instanceof String) {
                this.setText((String)object);
            } else {
                this.setText("");
            }
            return this;
        }
    }
}

