/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.addons;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.addons.ContactsEntryEstate;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.application.ResourceMap;

public class ContactsEntryEstateTableModel
extends DefaultTableModel {
    public static final int COLUMN_ENTRY = 0;
    public static final int COLUMN_ESTATE_ID = 1;
    public static final int COLUMN_ESTATE_NR = 2;
    public static final int COLUMN_ESTATE_TITLE = 3;
    public static final int COLUMN_ESTATE_STATUS = 4;
    public static final int COLUMN_TYPE = 5;
    public static final int COLUMN_TEXT = 6;
    private static final Map<Integer, String> COLUMN_NAMES = new HashMap<Integer, String>();
    private static final Map<Integer, Class> COLUMN_CLASSES;
    private final ResourceMap resourceMap = ImmoToolUtils.getResourceMap(ContactsEntryEstateTableModel.class);

    public ContactsEntryEstateTableModel() {
        this.setColumnCount(COLUMN_NAMES.size());
    }

    public void addEstate(AgencyEstate.Row row, ContactsEntryEstate contactsEntryEstate) {
        this.addRow(this.buildRow(row, contactsEntryEstate));
    }

    private Object[] buildRow(AgencyEstate.Row row, ContactsEntryEstate contactsEntryEstate) {
        TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
        treeMap.put(0, contactsEntryEstate);
        treeMap.put(1, row.id);
        treeMap.put(2, row.publicId);
        treeMap.put(3, row.title);
        treeMap.put(4, AgencyEstate.writeStatus((String)row.status));
        treeMap.put(6, contactsEntryEstate.getDescription());
        treeMap.put(5, contactsEntryEstate.writeType());
        return treeMap.values().toArray(new Object[treeMap.size()]);
    }

    public void clear() {
        while (this.getRowCount() > 0) {
            this.removeRow(0);
        }
    }

    public Class getColumnClass(int n) {
        return COLUMN_CLASSES.containsKey(n) ? COLUMN_CLASSES.get(n) : null;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES.containsKey(n) ? this.resourceMap.getString(COLUMN_NAMES.get(n), new Object[0]) : null;
    }

    public String getDescriptionAt(int n) {
        return (String)this.getValueAt(n, 6);
    }

    public ContactsEntryEstate getEntryAt(int n) {
        return (ContactsEntryEstate)this.getValueAt(n, 0);
    }

    public long getEstateIdAt(int n) {
        ContactsEntryEstate contactsEntryEstate = this.getEntryAt(n);
        return contactsEntryEstate != null ? contactsEntryEstate.getEstateId() : 0L;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void setEstateAt(int n, AgencyEstate.Row row, ContactsEntryEstate contactsEntryEstate) {
        Object[] objectArray = this.buildRow(row, contactsEntryEstate);
        for (int i = 0; i < objectArray.length; ++i) {
            this.setValueAt(objectArray[i], n, i);
        }
    }

    static {
        COLUMN_NAMES.put(0, "col.entry");
        COLUMN_NAMES.put(5, "col.type");
        COLUMN_NAMES.put(1, "col.estateId");
        COLUMN_NAMES.put(2, "col.estateNr");
        COLUMN_NAMES.put(3, "col.estateTitle");
        COLUMN_NAMES.put(4, "col.estateStatus");
        COLUMN_NAMES.put(6, "col.notes");
        COLUMN_CLASSES = new HashMap<Integer, Class>();
        COLUMN_CLASSES.put(0, ContactsEntryEstate.class);
        COLUMN_CLASSES.put(5, String.class);
        COLUMN_CLASSES.put(1, Long.class);
        COLUMN_CLASSES.put(2, String.class);
        COLUMN_CLASSES.put(3, String.class);
        COLUMN_CLASSES.put(4, String.class);
        COLUMN_CLASSES.put(6, String.class);
    }
}

