/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.addons;

import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolTaskDialog;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.AgencyEstateStatusTask;
import com.openindex.openestate.tool.agency.AgencyEstateViewTask;
import com.openindex.openestate.tool.agency.addons.ContactsEntryEstate;
import com.openindex.openestate.tool.agency.addons.ContactsEntryEstateDialog;
import com.openindex.openestate.tool.agency.addons.ContactsEntryEstateTableModel;
import com.openindex.openestate.tool.contacts.ContactsEntry;
import com.openindex.openestate.tool.contacts.ContactsEntryViewAddonPanel;
import com.openindex.openestate.tool.utils.QuickTableExport;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.swing.ActionMap;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.fife.ui.rtextarea.RTextArea;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledSeparator;

public class ContactsEntryEstateTablePanel
extends ContactsEntryViewAddonPanel {
    private static final Logger LOGGER = Logger.getLogger(ContactsEntryEstateTablePanel.class);
    private ActionMap actionMap;
    private ResourceMap resourceMap;
    private JPopupMenu actionsMenu;
    private ContactsEntryEstateTableModel estateTableModel;
    private ContactsEntry selectedContact = null;
    private boolean isModified = false;
    private JButton actionButton;
    private JButton addButton;
    private JButton estateNotesButton;
    private JTextArea estateNotesField;
    private JPanel estateNotesPanel;
    private JScrollPane estateNotesScroller;
    private JXTitledSeparator estateNotesTitleLabel;
    private JXTable estateTable;
    private JScrollPane estateTableScroller;
    private JButton refreshButton;
    private JXTitledSeparator titleLabel;

    public ContactsEntryEstateTablePanel() {
        this.build();
    }

    private void build() {
        this.actionMap = ImmoToolUtils.getActionMap(ContactsEntryEstateTablePanel.class, (Object)((Object)this));
        this.resourceMap = ImmoToolUtils.getResourceMap(ContactsEntryEstateTablePanel.class);
        this.initComponents();
        this.resourceMap.injectComponents((Component)((Object)this));
        JMenu jMenu = new JMenu();
        jMenu.setName("estateActionStatusMenu");
        for (final String string : AgencyEstate.getStatusList()) {
            JMenuItem jMenuItem = new JMenuItem(AgencyEstate.writeStatus((String)string));
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ContactsEntryEstateTablePanel.this.doChangeEstateStatus(string);
                }
            });
            jMenu.add(jMenuItem);
        }
        this.resourceMap.injectComponent((Component)jMenu);
        this.actionsMenu = new JPopupMenu();
        this.actionsMenu.add(new JMenuItem(this.actionMap.get("doViewEstate")));
        this.actionsMenu.add(jMenu);
        this.actionsMenu.addSeparator();
        this.actionsMenu.add(new JMenuItem(this.actionMap.get("doView")));
        this.actionsMenu.add(new JMenuItem(this.actionMap.get("doRemove")));
        this.estateTableModel = new ContactsEntryEstateTableModel();
        this.estateTable.setModel((TableModel)this.estateTableModel);
        this.estateTable.removeColumn(this.estateTable.getColumn(0));
        this.estateTable.setSortable(true);
        this.estateTable.getSelectionModel().setSelectionMode(2);
        this.estateTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (!ContactsEntryEstateTablePanel.this.estateTable.isEnabled()) {
                    return;
                }
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                    ContactsEntryEstateTablePanel.this.doView();
                } else if (mouseEvent.getButton() == 3 && mouseEvent.getClickCount() == 1) {
                    if (ContactsEntryEstateTablePanel.this.estateTable.getSelectedRow() < 0) {
                        int n = ContactsEntryEstateTablePanel.this.estateTable.rowAtPoint(mouseEvent.getPoint());
                        if (n < 0) {
                            return;
                        }
                        ContactsEntryEstateTablePanel.this.estateTable.getSelectionModel().setSelectionInterval(n, n);
                    }
                    ContactsEntryEstateTablePanel.this.actionsMenu.show((Component)ContactsEntryEstateTablePanel.this.estateTable, ((ContactsEntryEstateTablePanel)ContactsEntryEstateTablePanel.this).estateTable.getMousePosition().x, ((ContactsEntryEstateTablePanel)ContactsEntryEstateTablePanel.this).estateTable.getMousePosition().y);
                }
            }
        });
        this.estateTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!ContactsEntryEstateTablePanel.this.estateTable.isEnabled()) {
                    return;
                }
                if (ContactsEntryEstateTablePanel.this.estateTable.getSelectedRowCount() < 1) {
                    ContactsEntryEstateTablePanel.this.actionButton.setEnabled(false);
                    ContactsEntryEstateTablePanel.this.estateNotesField.setText("");
                    ContactsEntryEstateTablePanel.this.estateNotesPanel.setVisible(false);
                } else {
                    int n = ContactsEntryEstateTablePanel.this.estateTable.convertRowIndexToModel(ContactsEntryEstateTablePanel.this.estateTable.getSelectedRow());
                    ContactsEntryEstateTablePanel.this.actionButton.setEnabled(true);
                    String string = ContactsEntryEstateTablePanel.this.estateTableModel.getDescriptionAt(n);
                    ContactsEntryEstateTablePanel.this.estateNotesField.setText(string != null ? string.trim() : "");
                    ContactsEntryEstateTablePanel.this.estateNotesField.setCaretPosition(0);
                    ContactsEntryEstateTablePanel.this.estateNotesPanel.setVisible(true);
                }
            }
        });
        this.estateTable.setColumnControl((JComponent)QuickTableExport.createColumnControl((JXTable)this.estateTable));
        ImmoToolUtils.configureTable((JXTable)this.estateTable);
        this.actionButton.setEnabled(false);
        this.estateNotesPanel.setVisible(false);
    }

    @Action
    public void doAction() {
        this.actionsMenu.show(this.actionButton, 0, this.actionButton.getSize().height);
    }

    @Action
    public void doAdd() {
        ContactsEntryEstateDialog contactsEntryEstateDialog = null;
        try {
            contactsEntryEstateDialog = new ContactsEntryEstateDialog(1, ImmoToolApp.getApplication().getMainFrame(), true);
            contactsEntryEstateDialog.load(null);
            contactsEntryEstateDialog.loadEstate(null);
            contactsEntryEstateDialog.setVisible(true);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"cant open estate-dialog!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.cantOpenEstateDialog", new Object[0]), (Throwable)exception);
            return;
        }
        try {
            if (contactsEntryEstateDialog.getStatus() != 2) {
                return;
            }
            ContactsEntryEstate contactsEntryEstate = new ContactsEntryEstate();
            contactsEntryEstateDialog.save(contactsEntryEstate);
            if (this.getRowForEstate(contactsEntryEstate.getEstateId()) > -1) {
                LOGGER.warn((Object)"estate-entry already exists!");
                LOGGER.warn((Object)("> estate #" + contactsEntryEstate.getEstateId()));
                ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.estateEntryAlreadyExists", new Object[0]));
                return;
            }
            AgencyEstate.Row[] rowArray = AgencyEstate.loadEstateRows((Long[])new Long[]{contactsEntryEstate.getEstateId()}, null, null);
            if (rowArray != null && rowArray.length > 0) {
                this.estateTableModel.addEstate(rowArray[0], contactsEntryEstate);
                this.isModified = true;
            }
        }
        catch (Exception exception) {
            LOGGER.error((Object)"cant put estate-entry!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.cantPutEstateEntry", new Object[0]), (Throwable)exception);
            return;
        }
    }

    private void doChangeEstateStatus(final String string) {
        if (this.estateTable.getSelectedRowCount() < 1) {
            return;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int n : this.estateTable.getSelectedRows()) {
            int n2 = this.estateTable.convertRowIndexToModel(n);
            arrayList.add(this.estateTableModel.getEstateIdAt(n2));
        }
        boolean bl = ImmoToolUtils.showQuestionDialog((String)this.resourceMap.getString("question.reallyChangeEstateStatus", new Object[]{AgencyEstate.writeStatus((String)string)}), (Component)((Object)this));
        if (!bl) {
            return;
        }
        ImmoToolTaskDialog.execute((ImmoToolTask)new AgencyEstateStatusTask(arrayList.toArray(new Long[arrayList.size()]), string){
            {
                super(longArray, string3);
                this.setTitle(ContactsEntryEstateTablePanel.this.resourceMap.getString("estateActionStatusMenu.text", new Object[0]));
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)ContactsEntryEstateTablePanel.this.resourceMap.getString("error.cantChangeEstateStatus", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
            }

            protected void succeeded(Boolean bl) {
                super.succeeded((Object)bl);
                if (!Boolean.TRUE.equals(bl)) {
                    return;
                }
                for (int n : ContactsEntryEstateTablePanel.this.estateTable.getSelectedRows()) {
                    int n2 = ContactsEntryEstateTablePanel.this.estateTable.convertRowIndexToModel(n);
                    ContactsEntryEstateTablePanel.this.estateTableModel.setValueAt(AgencyEstate.writeStatus((String)string), n2, 4);
                }
            }
        });
    }

    public Task doLoadInBackground() {
        return this.doRefresh();
    }

    @Action
    public Task doRefresh() {
        if (this.selectedContact == null) {
            return null;
        }
        this.estateTable.setEnabled(false);
        this.refreshButton.setEnabled(false);
        return new ImmoToolTask<ContactsEntryEstateTableModel>(){

            protected ContactsEntryEstateTableModel executeTask() throws Exception {
                ContactsEntryEstateTableModel contactsEntryEstateTableModel = new ContactsEntryEstateTableModel();
                ContactsEntryEstate[] contactsEntryEstateArray = ContactsEntryEstate.getContactEntryEstates(ContactsEntryEstateTablePanel.this.selectedContact);
                LinkedHashMap<Long, ContactsEntryEstate> linkedHashMap = new LinkedHashMap<Long, ContactsEntryEstate>();
                ContactsEntryEstate[] contactsEntryEstateArray2 = contactsEntryEstateArray;
                int n = contactsEntryEstateArray2.length;
                for (int i = 0; i < n; ++i) {
                    ContactsEntryEstate contactsEntryEstate = contactsEntryEstateArray2[i];
                    linkedHashMap.put(contactsEntryEstate.getEstateId(), contactsEntryEstate);
                }
                if (!linkedHashMap.isEmpty() && (contactsEntryEstateArray2 = AgencyEstate.loadEstateRows((Long[])linkedHashMap.keySet().toArray(new Long[linkedHashMap.size()]), null, null)) != null && contactsEntryEstateArray2.length > 0) {
                    for (ContactsEntryEstate contactsEntryEstate : contactsEntryEstateArray2) {
                        if (!linkedHashMap.containsKey(((AgencyEstate.Row)contactsEntryEstate).id)) {
                            LOGGER.warn((Object)("cant find estate #" + ((AgencyEstate.Row)contactsEntryEstate).id));
                            continue;
                        }
                        contactsEntryEstateTableModel.addEstate((AgencyEstate.Row)contactsEntryEstate, (ContactsEntryEstate)linkedHashMap.get(((AgencyEstate.Row)contactsEntryEstate).id));
                    }
                }
                return contactsEntryEstateTableModel;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)ContactsEntryEstateTablePanel.this.resourceMap.getString("error.cantLoadEstateEntries", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                ContactsEntryEstateTablePanel.this.estateTable.setEnabled(true);
                ContactsEntryEstateTablePanel.this.refreshButton.setEnabled(true);
            }

            protected void succeeded(ContactsEntryEstateTableModel contactsEntryEstateTableModel) {
                super.succeeded((Object)contactsEntryEstateTableModel);
                ContactsEntryEstateTablePanel.this.estateTableModel = contactsEntryEstateTableModel;
                ContactsEntryEstateTablePanel.this.estateTable.setModel((TableModel)contactsEntryEstateTableModel);
                ContactsEntryEstateTablePanel.this.estateTable.removeColumn(ContactsEntryEstateTablePanel.this.estateTable.getColumn(0));
                ContactsEntryEstateTablePanel.this.titleLabel.setTitle(ContactsEntryEstateTablePanel.this.resourceMap.getString("titleLabel.title", new Object[0]) + " / " + ContactsEntryEstateTablePanel.this.resourceMap.getString("message.resultCount", new Object[]{NumberFormat.getIntegerInstance().format(ContactsEntryEstateTablePanel.this.estateTable.getRowCount())}));
                ContactsEntryEstateTablePanel.this.estateTable.packAll();
                ContactsEntryEstateTablePanel.this.isModified = false;
            }
        };
    }

    @Action
    public void doRemove() {
        if (this.estateTable.getSelectedRowCount() < 1) {
            return;
        }
        boolean bl = ImmoToolUtils.showQuestionDialog((String)this.resourceMap.getString("question.reallyDeleteEstateEntries", new Object[0]), (Component)((Object)this));
        if (!bl) {
            return;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int n : this.estateTable.getSelectedRows()) {
            int n2 = this.estateTable.convertRowIndexToModel(n);
            arrayList.add(this.estateTableModel.getEstateIdAt(n2));
        }
        this.estateTable.setEnabled(false);
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            int n;
            Long l = (Long)object.next();
            if (l < 1L || (n = this.getRowForEstate(l)) < 0) continue;
            this.estateTableModel.removeRow(n);
            this.isModified = true;
        }
        this.estateTable.setEnabled(true);
    }

    @Action
    public void doSaveNotes() {
        if (this.estateTable.getSelectedRowCount() < 1) {
            return;
        }
        int n = this.estateTable.getSelectedRow();
        int n2 = this.estateTable.convertRowIndexToModel(n);
        String string = this.estateNotesField.getText().trim();
        ContactsEntryEstate contactsEntryEstate = this.estateTableModel.getEntryAt(n2);
        if (contactsEntryEstate != null) {
            contactsEntryEstate.setDescription(string);
            this.estateTableModel.setValueAt(string, n2, 6);
        }
    }

    @Action
    public void doView() {
        if (this.estateTable.getSelectedRowCount() < 1) {
            return;
        }
        int n = this.estateTable.getSelectedRow();
        int n2 = this.estateTable.convertRowIndexToModel(n);
        ContactsEntryEstate contactsEntryEstate = this.estateTableModel.getEntryAt(n2);
        ContactsEntryEstateDialog contactsEntryEstateDialog = null;
        try {
            contactsEntryEstateDialog = new ContactsEntryEstateDialog(1, ImmoToolApp.getApplication().getMainFrame(), true);
            contactsEntryEstateDialog.load(contactsEntryEstate);
            contactsEntryEstateDialog.loadEstate(contactsEntryEstate.getEstateId());
            contactsEntryEstateDialog.setVisible(true);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"cant open estate-dialog!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.cantOpenEstateDialog", new Object[0]), (Throwable)exception);
            return;
        }
        if (contactsEntryEstateDialog.getStatus() != 2) {
            return;
        }
        try {
            int n3;
            contactsEntryEstateDialog.save(contactsEntryEstate);
            int n4 = this.getRowForEstate(contactsEntryEstate.getEstateId());
            int n5 = n3 = n4 > -1 ? this.estateTable.convertRowIndexToModel(n4) : -1;
            if (n3 > -1 && n3 != n2) {
                LOGGER.warn((Object)"estate-entry already exists!");
                LOGGER.warn((Object)("> estate #" + contactsEntryEstate.getEstateId()));
                ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.estateEntryAlreadyExists", new Object[0]));
                return;
            }
            AgencyEstate.Row[] rowArray = AgencyEstate.loadEstateRows((Long[])new Long[]{contactsEntryEstate.getEstateId()}, null, null);
            if (rowArray != null && rowArray.length > 0) {
                this.estateTableModel.setEstateAt(n2, rowArray[0], contactsEntryEstate);
                this.isModified = true;
            }
        }
        catch (Exception exception) {
            LOGGER.error((Object)"cant put estate-entry!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.cantPutEstateEntry", new Object[0]), (Throwable)exception);
            return;
        }
    }

    @Action
    public Task doViewEstate() {
        if (this.estateTable.getSelectedRowCount() < 1) {
            return null;
        }
        int n = this.estateTable.getSelectedRow();
        int n2 = this.estateTable.convertRowIndexToModel(n);
        ContactsEntryEstate contactsEntryEstate = this.estateTableModel.getEntryAt(n2);
        return new AgencyEstateViewTask(contactsEntryEstate.getEstateId());
    }

    private int getRowForEstate(long l) {
        for (int i = 0; i < this.estateTable.getRowCount(); ++i) {
            if (this.estateTableModel.getEntryAt(i).getEstateId() != l) continue;
            return i;
        }
        return -1;
    }

    public String getTitle() {
        return this.resourceMap.getString("title", new Object[0]);
    }

    public boolean isFormEnabled() {
        return true;
    }

    public boolean isFormModified() {
        return this.isModified;
    }

    public boolean isFormUsable() {
        return ImmoToolApp.getApplication().getProject().getPlugin("OpenEstate-Agency") != null;
    }

    public boolean isLoadedInBackground() {
        return true;
    }

    public void load(ContactsEntry contactsEntry) throws ImmoToolException {
        this.selectedContact = contactsEntry;
        this.isModified = false;
    }

    public void save(ContactsEntry contactsEntry) throws ImmoToolException {
    }

    public void saveFinished(ContactsEntry contactsEntry) throws ImmoToolException {
        ArrayList<ContactsEntryEstate> arrayList = new ArrayList<ContactsEntryEstate>();
        for (int i = 0; i < this.estateTable.getRowCount(); ++i) {
            ContactsEntryEstate contactsEntryEstate = this.estateTableModel.getEntryAt(i);
            contactsEntryEstate.setContactGroupId(contactsEntry.getGroupId());
            contactsEntryEstate.setContactEntryId(contactsEntry.getId());
            arrayList.add(contactsEntryEstate);
        }
        ContactsEntryEstate.setContactEntryEstates(contactsEntry, arrayList.toArray(new ContactsEntryEstate[arrayList.size()]));
        contactsEntry.save();
    }

    private void initComponents() {
        this.titleLabel = ImmoToolUtils.createHead2Separator((String)"");
        this.refreshButton = new JButton();
        this.addButton = new JButton();
        this.actionButton = new JButton();
        this.estateTableScroller = new JScrollPane();
        this.estateTable = new JXTable();
        this.estateNotesPanel = new JPanel();
        this.estateNotesTitleLabel = ImmoToolUtils.createHead2Separator((String)"");
        this.estateNotesButton = new JButton();
        this.estateNotesScroller = new JScrollPane();
        this.estateNotesField = new RTextArea();
        this.setName("Form");
        this.titleLabel.setName("titleLabel");
        ApplicationActionMap applicationActionMap = Application.getInstance().getContext().getActionMap(ContactsEntryEstateTablePanel.class, (Object)this);
        this.refreshButton.setAction(applicationActionMap.get("doRefresh"));
        this.refreshButton.setName("refreshButton");
        this.addButton.setAction(applicationActionMap.get("doAdd"));
        this.addButton.setName("addButton");
        this.actionButton.setAction(applicationActionMap.get("doAction"));
        this.actionButton.setName("actionButton");
        this.estateTableScroller.setName("estateTableScroller");
        this.estateTable.setColumnControlVisible(true);
        this.estateTable.setEditable(false);
        this.estateTable.setName("estateTable");
        this.estateTableScroller.setViewportView((Component)this.estateTable);
        this.estateNotesPanel.setName("estateNotesPanel");
        this.estateNotesTitleLabel.setName("estateNotesTitleLabel");
        this.estateNotesButton.setAction(applicationActionMap.get("doSaveNotes"));
        this.estateNotesButton.setName("estateNotesButton");
        this.estateNotesScroller.setName("estateNotesScroller");
        this.estateNotesField.setColumns(20);
        this.estateNotesField.setLineWrap(true);
        this.estateNotesField.setRows(5);
        this.estateNotesField.setWrapStyleWord(true);
        this.estateNotesField.setName("estateNotesField");
        this.estateNotesScroller.setViewportView(this.estateNotesField);
        GroupLayout groupLayout = new GroupLayout(this.estateNotesPanel);
        this.estateNotesPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent((Component)this.estateNotesTitleLabel, -1, 573, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.estateNotesButton)).addComponent(this.estateNotesScroller, GroupLayout.Alignment.TRAILING, -1, 634, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.estateNotesButton).addComponent((Component)this.estateNotesTitleLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.estateNotesScroller, -2, -1, -2)));
        GroupLayout groupLayout2 = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.estateTableScroller, GroupLayout.Alignment.TRAILING, -1, 634, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addComponent((Component)this.titleLabel, -1, 445, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.refreshButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.actionButton)).addComponent(this.estateNotesPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.titleLabel, -2, -1, -2).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.actionButton).addComponent(this.addButton).addComponent(this.refreshButton))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.estateTableScroller, -1, 239, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.estateNotesPanel, -2, -1, -2).addContainerGap()));
        ResourceMap resourceMap = Application.getInstance().getContext().getResourceMap(ContactsEntryEstateTablePanel.class);
        resourceMap.injectComponents((Component)((Object)this));
    }
}

