/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.net.URISyntaxException;
import net.fortuna.ical4j.model.AbstractContentFactory;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterFactory;
import net.fortuna.ical4j.model.parameter.Abbrev;
import net.fortuna.ical4j.model.parameter.AltRep;
import net.fortuna.ical4j.model.parameter.Cn;
import net.fortuna.ical4j.model.parameter.CuType;
import net.fortuna.ical4j.model.parameter.DelegatedFrom;
import net.fortuna.ical4j.model.parameter.DelegatedTo;
import net.fortuna.ical4j.model.parameter.Dir;
import net.fortuna.ical4j.model.parameter.Encoding;
import net.fortuna.ical4j.model.parameter.FbType;
import net.fortuna.ical4j.model.parameter.FmtType;
import net.fortuna.ical4j.model.parameter.Language;
import net.fortuna.ical4j.model.parameter.Member;
import net.fortuna.ical4j.model.parameter.PartStat;
import net.fortuna.ical4j.model.parameter.Range;
import net.fortuna.ical4j.model.parameter.RelType;
import net.fortuna.ical4j.model.parameter.Related;
import net.fortuna.ical4j.model.parameter.Role;
import net.fortuna.ical4j.model.parameter.Rsvp;
import net.fortuna.ical4j.model.parameter.ScheduleAgent;
import net.fortuna.ical4j.model.parameter.ScheduleStatus;
import net.fortuna.ical4j.model.parameter.SentBy;
import net.fortuna.ical4j.model.parameter.Type;
import net.fortuna.ical4j.model.parameter.TzId;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.parameter.Vvenue;
import net.fortuna.ical4j.model.parameter.XParameter;
import net.fortuna.ical4j.util.Strings;

public class ParameterFactoryImpl
extends AbstractContentFactory
implements ParameterFactory {
    private static final long serialVersionUID = -4034423507432249165L;
    private static ParameterFactoryImpl instance = new ParameterFactoryImpl();

    protected ParameterFactoryImpl() {
        this.registerDefaultFactory("ABBREV", new AbbrevFactory());
        this.registerDefaultFactory("ALTREP", new AltRepFactory());
        this.registerDefaultFactory("CN", new CnFactory());
        this.registerDefaultFactory("CUTYPE", new CuTypeFactory());
        this.registerDefaultFactory("DELEGATED-FROM", new DelegatedFromFactory());
        this.registerDefaultFactory("DELEGATED-TO", new DelegatedToFactory());
        this.registerDefaultFactory("DIR", new DirFactory());
        this.registerDefaultFactory("ENCODING", new EncodingFactory());
        this.registerDefaultFactory("FMTTYPE", new FmtTypeFactory());
        this.registerDefaultFactory("FBTYPE", new FbTypeFactory());
        this.registerDefaultFactory("LANGUAGE", new LanguageFactory());
        this.registerDefaultFactory("MEMBER", new MemberFactory());
        this.registerDefaultFactory("PARTSTAT", new PartStatFactory());
        this.registerDefaultFactory("RANGE", new RangeFactory());
        this.registerDefaultFactory("RELATED", new RelatedFactory());
        this.registerDefaultFactory("RELTYPE", new RelTypeFactory());
        this.registerDefaultFactory("ROLE", new RoleFactory());
        this.registerDefaultFactory("RSVP", new RsvpFactory());
        this.registerDefaultFactory("SCHEDULE-AGENT", new ScheduleAgentFactory());
        this.registerDefaultFactory("SCHEDULE-STATUS", new ScheduleStatusFactory());
        this.registerDefaultFactory("SENT-BY", new SentByFactory());
        this.registerDefaultFactory("TYPE", new TypeFactory());
        this.registerDefaultFactory("TZID", new TzIdFactory());
        this.registerDefaultFactory("VALUE", new ValueFactory());
        this.registerDefaultFactory("VVENUE", new VvenueFactory());
    }

    public static ParameterFactoryImpl getInstance() {
        return instance;
    }

    public Parameter createParameter(String name, String value) throws URISyntaxException {
        ParameterFactory factory = (ParameterFactory)this.getFactory(name);
        Parameter parameter = null;
        if (factory != null) {
            parameter = factory.createParameter(name, value);
        } else if (this.isExperimentalName(name)) {
            parameter = new XParameter(name, value);
        } else if (this.allowIllegalNames()) {
            parameter = new XParameter(name, value);
        } else {
            throw new IllegalArgumentException("Invalid parameter name: " + name);
        }
        return parameter;
    }

    private boolean isExperimentalName(String name) {
        return name.startsWith("X-") && name.length() > "X-".length();
    }

    private static class AbbrevFactory
    implements ParameterFactory {
        private static final long serialVersionUID = 1L;

        private AbbrevFactory() {
        }

        public Parameter createParameter(String name, String value) throws URISyntaxException {
            return new Abbrev(value);
        }
    }

    private static class AltRepFactory
    implements ParameterFactory {
        private static final long serialVersionUID = 1L;

        private AltRepFactory() {
        }

        public Parameter createParameter(String name, String value) throws URISyntaxException {
            return new AltRep(value);
        }
    }

    private static class CnFactory
    implements ParameterFactory {
        private static final long serialVersionUID = 1L;

        private CnFactory() {
        }

        public Parameter createParameter(String name, String value) throws URISyntaxException {
            return new Cn(value);
        }
    }

    private static class CuTypeFactory
    implements ParameterFactory {
        private static final long serialVersionUID = 1L;

        private CuTypeFactory() {
        }

        public Parameter createParameter(String name, String value) throws URISyntaxException {
            CuType parameter = new CuType(value);
            if (CuType.INDIVIDUAL.equals(parameter)) {
                parameter = CuType.INDIVIDUAL;
            } else if (CuType.GROUP.equals(parameter)) {
                parameter = CuType.GROUP;
            } else if (CuType.RESOURCE.equals(parameter)) {
                parameter = CuType.RESOURCE;
            } else if (CuType.ROOM.equals(parameter)) {
                parameter = CuType.ROOM;
            } else if (CuType.UNKNOWN.equals(parameter)) {
                parameter = CuType.UNKNOWN;
            }
            return parameter;
        }
    }

    private static class DelegatedFromFactory
    implements ParameterFactory {
        private static final long serialVersionUID = 1L;

        private DelegatedFromFactory() {
        }

        public Parameter createParameter(String name, String value) throws URISyntaxException {
            return new DelegatedFrom(value);
        }
    }

    private static class DelegatedToFactory
    implements ParameterFactory {
        private static final long serialVersionUID = 1L;

        private DelegatedToFactory() {
        }

        public Parameter createParameter(String name, String value) throws URISyntaxException {
            return new DelegatedTo(value);
        }
    }

    private static class DirFactory
    implements ParameterFactory {
        private static final long serialVersionUID = 1L;

        private DirFactory() {
        }

        public Parameter createParameter(String name, String value) throws URISyntaxException {
            return new Dir(value);
        }
    }

    private static class EncodingFactory
    implements ParameterFactory {
        private static final long serialVersionUID = 1L;

        private EncodingFactory() {
        }

        public Parameter createParameter(String name, String value) throws URISyntaxException {
            Encoding parameter = new Encoding(value);
            if (Encoding.EIGHT_BIT.equals(parameter)) {
                parameter = Encoding.EIGHT_BIT;
            } else if (Encoding.BASE64.equals(parameter)) {
                parameter = Encoding.BASE64;
            }
            return parameter;
        }
    }

    private static class FbTypeFactory
    implements ParameterFactory {
        private static final long serialVersionUID = 1L;

        private FbTypeFactory() {
        }

        public Parameter createParameter(String name, String value) throws URISyntaxException {
            FbType parameter = new FbType(value);
            if (FbType.FREE.equals(parameter)) {
                parameter = FbType.FREE;
            } else if (FbType.BUSY.equals(parameter)) {
                parameter = FbType.BUSY;
            } else if (FbType.BUSY_TENTATIVE.equals(parameter)) {
                parameter = FbType.BUSY_TENTATIVE;
            } else if (FbType.BUSY_UNAVAILABLE.equals(parameter)) {
                parameter = FbType.BUSY_UNAVAILABLE;
            }
            return parameter;
        }
    }

    private static class FmtTypeFactory
    implements ParameterFactory {
        private static final long serialVersionUID = 1L;

        private FmtTypeFactory() {
        }

        public Parameter createParameter(String name, String value) throws URISyntaxException {
            return new FmtType(value);
        }
    }

    private static class LanguageFactory
    implements ParameterFactory {
        private static final long serialVersionUID = 1L;

        private LanguageFactory() {
        }

        public Parameter createParameter(String name, String value) throws URISyntaxException {
            return new Language(value);
        }
    }

    private static class MemberFactory
    implements ParameterFactory {
        private static final long serialVersionUID = 1L;

        private MemberFactory() {
        }

        public Parameter createParameter(String name, String value) throws URISyntaxException {
            return new Member(value);
        }
    }

    private static class PartStatFactory
    implements ParameterFactory {
        private static final long serialVersionUID = 1L;

        private PartStatFactory() {
        }

        public Parameter createParameter(String name, String value) throws URISyntaxException {
            PartStat parameter = new PartStat(value);
            if (PartStat.NEEDS_ACTION.equals(parameter)) {
                parameter = PartStat.NEEDS_ACTION;
            } else if (PartStat.ACCEPTED.equals(parameter)) {
                parameter = PartStat.ACCEPTED;
            } else if (PartStat.DECLINED.equals(parameter)) {
                parameter = PartStat.DECLINED;
            } else if (PartStat.TENTATIVE.equals(parameter)) {
                parameter = PartStat.TENTATIVE;
            } else if (PartStat.DELEGATED.equals(parameter)) {
                parameter = PartStat.DELEGATED;
            } else if (PartStat.COMPLETED.equals(parameter)) {
                parameter = PartStat.COMPLETED;
            } else if (PartStat.IN_PROCESS.equals(parameter)) {
                parameter = PartStat.IN_PROCESS;
            }
            return parameter;
        }
    }

    private static class RangeFactory
    implements ParameterFactory {
        private static final long serialVersionUID = 1L;

        private RangeFactory() {
        }

        public Parameter createParameter(String name, String value) throws URISyntaxException {
            Range parameter = new Range(value);
            if (Range.THISANDFUTURE.equals(parameter)) {
                parameter = Range.THISANDFUTURE;
            } else if (Range.THISANDPRIOR.equals(parameter)) {
                parameter = Range.THISANDPRIOR;
            }
            return parameter;
        }
    }

    private static class RelTypeFactory
    implements ParameterFactory {
        private static final long serialVersionUID = 1L;

        private RelTypeFactory() {
        }

        public Parameter createParameter(String name, String value) throws URISyntaxException {
            RelType parameter = new RelType(value);
            if (RelType.PARENT.equals(parameter)) {
                parameter = RelType.PARENT;
            } else if (RelType.CHILD.equals(parameter)) {
                parameter = RelType.CHILD;
            }
            if (RelType.SIBLING.equals(parameter)) {
                parameter = RelType.SIBLING;
            }
            return parameter;
        }
    }

    private static class RelatedFactory
    implements ParameterFactory {
        private static final long serialVersionUID = 1L;

        private RelatedFactory() {
        }

        public Parameter createParameter(String name, String value) throws URISyntaxException {
            Related parameter = new Related(value);
            if (Related.START.equals(parameter)) {
                parameter = Related.START;
            } else if (Related.END.equals(parameter)) {
                parameter = Related.END;
            }
            return parameter;
        }
    }

    private static class RoleFactory
    implements ParameterFactory {
        private static final long serialVersionUID = 1L;

        private RoleFactory() {
        }

        public Parameter createParameter(String name, String value) throws URISyntaxException {
            Role parameter = new Role(value);
            if (Role.CHAIR.equals(parameter)) {
                parameter = Role.CHAIR;
            } else if (Role.REQ_PARTICIPANT.equals(parameter)) {
                parameter = Role.REQ_PARTICIPANT;
            } else if (Role.OPT_PARTICIPANT.equals(parameter)) {
                parameter = Role.OPT_PARTICIPANT;
            } else if (Role.NON_PARTICIPANT.equals(parameter)) {
                parameter = Role.NON_PARTICIPANT;
            }
            return parameter;
        }
    }

    private static class RsvpFactory
    implements ParameterFactory {
        private static final long serialVersionUID = 1L;

        private RsvpFactory() {
        }

        public Parameter createParameter(String name, String value) throws URISyntaxException {
            Rsvp parameter = new Rsvp(value);
            if (Rsvp.TRUE.equals(parameter)) {
                parameter = Rsvp.TRUE;
            } else if (Rsvp.FALSE.equals(parameter)) {
                parameter = Rsvp.FALSE;
            }
            return parameter;
        }
    }

    private static class ScheduleAgentFactory
    implements ParameterFactory {
        private ScheduleAgentFactory() {
        }

        public Parameter createParameter(String name, String value) throws URISyntaxException {
            ScheduleAgent parameter = new ScheduleAgent(value);
            if (ScheduleAgent.SERVER.equals(parameter)) {
                return ScheduleAgent.SERVER;
            }
            if (ScheduleAgent.CLIENT.equals(parameter)) {
                return ScheduleAgent.CLIENT;
            }
            if (ScheduleAgent.NONE.equals(parameter)) {
                return ScheduleAgent.NONE;
            }
            return parameter;
        }
    }

    private static class ScheduleStatusFactory
    implements ParameterFactory {
        private ScheduleStatusFactory() {
        }

        public Parameter createParameter(String name, String value) throws URISyntaxException {
            return new ScheduleStatus(value);
        }
    }

    private static class SentByFactory
    implements ParameterFactory {
        private static final long serialVersionUID = 1L;

        private SentByFactory() {
        }

        public Parameter createParameter(String name, String value) throws URISyntaxException {
            return new SentBy(value);
        }
    }

    private static class TypeFactory
    implements ParameterFactory {
        private static final long serialVersionUID = 1L;

        private TypeFactory() {
        }

        public Parameter createParameter(String name, String value) throws URISyntaxException {
            return new Type(value);
        }
    }

    private static class TzIdFactory
    implements ParameterFactory {
        private static final long serialVersionUID = 1L;

        private TzIdFactory() {
        }

        public Parameter createParameter(String name, String value) throws URISyntaxException {
            return new TzId(Strings.unescape(value));
        }
    }

    private static class ValueFactory
    implements ParameterFactory {
        private static final long serialVersionUID = 1L;

        private ValueFactory() {
        }

        public Parameter createParameter(String name, String value) throws URISyntaxException {
            Value parameter = new Value(value);
            if (Value.BINARY.equals(parameter)) {
                parameter = Value.BINARY;
            } else if (Value.BOOLEAN.equals(parameter)) {
                parameter = Value.BOOLEAN;
            } else if (Value.CAL_ADDRESS.equals(parameter)) {
                parameter = Value.CAL_ADDRESS;
            } else if (Value.DATE.equals(parameter)) {
                parameter = Value.DATE;
            } else if (Value.DATE_TIME.equals(parameter)) {
                parameter = Value.DATE_TIME;
            } else if (Value.DURATION.equals(parameter)) {
                parameter = Value.DURATION;
            } else if (Value.FLOAT.equals(parameter)) {
                parameter = Value.FLOAT;
            } else if (Value.INTEGER.equals(parameter)) {
                parameter = Value.INTEGER;
            } else if (Value.PERIOD.equals(parameter)) {
                parameter = Value.PERIOD;
            } else if (Value.RECUR.equals(parameter)) {
                parameter = Value.RECUR;
            } else if (Value.TEXT.equals(parameter)) {
                parameter = Value.TEXT;
            } else if (Value.TIME.equals(parameter)) {
                parameter = Value.TIME;
            } else if (Value.URI.equals(parameter)) {
                parameter = Value.URI;
            } else if (Value.UTC_OFFSET.equals(parameter)) {
                parameter = Value.UTC_OFFSET;
            }
            return parameter;
        }
    }

    private static class VvenueFactory
    implements ParameterFactory {
        private static final long serialVersionUID = 1L;

        private VvenueFactory() {
        }

        public Parameter createParameter(String name, String value) throws URISyntaxException {
            return new Vvenue(value);
        }
    }
}

