/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.util.Calendar;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.component.Daylight;
import net.fortuna.ical4j.model.component.Observance;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.property.TzId;
import net.fortuna.ical4j.model.property.TzOffsetTo;

public class TimeZone
extends java.util.TimeZone {
    private static final long serialVersionUID = -5620979316746547234L;
    private final VTimeZone vTimeZone;
    private final int rawOffset;

    public TimeZone(VTimeZone vTimeZone) {
        this.vTimeZone = vTimeZone;
        TzId tzId = (TzId)vTimeZone.getProperty("TZID");
        this.setID(tzId.getValue());
        this.rawOffset = TimeZone.getRawOffset(vTimeZone);
    }

    public final int getOffset(int era, int year, int month, int day, int dayOfWeek, int milliseconds) {
        Calendar cal = Calendar.getInstance();
        cal.set(0, era);
        cal.set(1, year);
        cal.set(2, month);
        cal.set(6, day);
        cal.set(7, dayOfWeek);
        cal.set(14, milliseconds);
        Observance observance = this.vTimeZone.getApplicableObservance(new DateTime(cal.getTime()));
        if (observance != null) {
            TzOffsetTo offset = (TzOffsetTo)observance.getProperty("TZOFFSETTO");
            return (int)offset.getOffset().getOffset();
        }
        return 0;
    }

    public int getOffset(long date) {
        Observance observance = this.vTimeZone.getApplicableObservance(new DateTime(date));
        if (observance != null) {
            TzOffsetTo offset = (TzOffsetTo)observance.getProperty("TZOFFSETTO");
            if (offset.getOffset().getOffset() < (long)this.getRawOffset()) {
                return this.getRawOffset();
            }
            return (int)offset.getOffset().getOffset();
        }
        return 0;
    }

    public final int getRawOffset() {
        return this.rawOffset;
    }

    public final boolean inDaylightTime(java.util.Date date) {
        Observance observance = this.vTimeZone.getApplicableObservance(new DateTime(date));
        return observance != null && observance instanceof Daylight;
    }

    public final void setRawOffset(int offsetMillis) {
        throw new UnsupportedOperationException("Updates to the VTIMEZONE object must be performed directly");
    }

    public final boolean useDaylightTime() {
        ComponentList daylights = this.vTimeZone.getObservances().getComponents("DAYLIGHT");
        return !daylights.isEmpty();
    }

    public final VTimeZone getVTimeZone() {
        return this.vTimeZone;
    }

    private static final int getRawOffset(VTimeZone vt) {
        TzOffsetTo offsetTo;
        ComponentList seasonalTimes = vt.getObservances().getComponents("STANDARD");
        if (seasonalTimes.isEmpty() && (seasonalTimes = vt.getObservances().getComponents("DAYLIGHT")).isEmpty()) {
            return 0;
        }
        Observance latestSeasonalTime = null;
        if (seasonalTimes.size() > 1) {
            DateTime now = new DateTime();
            Date latestOnset = null;
            int i = 0;
            while (i < seasonalTimes.size()) {
                Observance seasonalTime = (Observance)seasonalTimes.get(i);
                Date onset = seasonalTime.getLatestOnset(now);
                if (onset != null && (latestOnset == null || onset.after(latestOnset))) {
                    latestOnset = onset;
                    latestSeasonalTime = seasonalTime;
                }
                ++i;
            }
        } else {
            latestSeasonalTime = (Observance)seasonalTimes.get(0);
        }
        if (latestSeasonalTime != null && (offsetTo = (TzOffsetTo)latestSeasonalTime.getProperty("TZOFFSETTO")) != null) {
            return (int)offsetTo.getOffset().getOffset();
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeZone timeZone = (TimeZone)o;
        if (this.rawOffset != timeZone.rawOffset) {
            return false;
        }
        return !(this.vTimeZone != null ? !this.vTimeZone.equals(timeZone.vTimeZone) : timeZone.vTimeZone != null);
    }

    public int hashCode() {
        int result = this.vTimeZone != null ? this.vTimeZone.hashCode() : 0;
        result = 31 * result + this.rawOffset;
        return result;
    }
}

