/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.impl.AbstractImplItem;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.SerializableXmlElement;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolDb;
import com.openindex.openestate.tool.ImmoToolDbException;
import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyContact;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.imageio.ImageIO;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.exist.xmldb.EXistResource;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.BinaryResource;
import org.xmldb.api.modules.XMLResource;

public class AgencyAgent
extends AgentImpl {
    private static final Logger LOGGER = Logger.getLogger(AgencyAgent.class);
    public static final String VALUE_AUFSICHT = "agent.aufsicht";
    public static final String VALUE_GEWERBE = "agent.gewerbe";
    public static final String VALUE_HANDELSREGISTER = "agent.handelsregister";
    public static final String VALUE_USTID = "agent.ustid";
    public static final String VALUE_VERTRETUNG = "agent.vertretung";

    public AgencyAgent() {
    }

    public AgencyAgent(AgentImpl agentImpl) {
        this.merge((AbstractImplItem)agentImpl);
    }

    public AgencyAgent(Document document) throws DocumentException {
        super(document);
    }

    public static void createDefaultAgent(ImmoToolDb immoToolDb, Collection collection, ImmoToolProject immoToolProject) throws ImmoToolDbException, IOException, DocumentException, XMLDBException {
        AgencyAgent agencyAgent = new AgencyAgent();
        agencyAgent.setCompany(immoToolProject.getAdress());
        AgencyAgent.createDefaultAgent(immoToolDb, collection, agencyAgent);
    }

    private static void createDefaultAgent(ImmoToolDb immoToolDb, Collection collection, AgencyAgent agencyAgent) throws ImmoToolDbException, IOException, DocumentException, XMLDBException {
        StringWriter stringWriter = null;
        if (agencyAgent.getId() == null || !agencyAgent.getId().startsWith("Agent.")) {
            agencyAgent.setId("Agent." + immoToolDb.getNextSequence("OpenEstate-Agency.Agent"));
        }
        XMLResource xMLResource = ImmoToolDbUtils.createXmlResource((Collection)collection, (String)"Agent.xml");
        stringWriter = new StringWriter();
        OpenEstateUtils.serializeToXML((SerializableXmlElement)agencyAgent, (Writer)stringWriter, (boolean)true);
        xMLResource.setContent((Object)stringWriter.toString());
        ImmoToolDbUtils.storeResource((Collection)collection, (Resource)xMLResource);
        Document document = DocumentFactory.getInstance().createDocument();
        agencyAgent.getCompany().serializeToXml(document);
        AgencyContact agencyContact = new AgencyContact();
        agencyContact.readFromXml(document.getRootElement());
        AgencyContact.storeContact(agencyContact, collection.getChildCollection("/contacts".substring(1)), immoToolDb);
    }

    public String getAufsichtsBehoerde() {
        if (!this.getCustomValues().hasCustomValue(VALUE_AUFSICHT)) {
            return "";
        }
        String string = this.getCustomValues().getCustomValue(VALUE_AUFSICHT).isText() ? this.getCustomValues().getCustomValue(VALUE_AUFSICHT).getText() : this.getCustomValues().getCustomValue(VALUE_AUFSICHT).getString();
        return string.replaceAll("<br/>", SystemUtils.LINE_SEPARATOR);
    }

    public String getGewerbeErlaubnis() {
        if (!this.getCustomValues().hasCustomValue(VALUE_GEWERBE)) {
            return "";
        }
        String string = this.getCustomValues().getCustomValue(VALUE_GEWERBE).isText() ? this.getCustomValues().getCustomValue(VALUE_GEWERBE).getText() : this.getCustomValues().getCustomValue(VALUE_GEWERBE).getString();
        return string.replaceAll("<br/>", SystemUtils.LINE_SEPARATOR);
    }

    public String getHandelsRegister() {
        if (!this.getCustomValues().hasCustomValue(VALUE_HANDELSREGISTER)) {
            return "";
        }
        String string = this.getCustomValues().getCustomValue(VALUE_HANDELSREGISTER).isText() ? this.getCustomValues().getCustomValue(VALUE_HANDELSREGISTER).getText() : this.getCustomValues().getCustomValue(VALUE_HANDELSREGISTER).getString();
        return string.replaceAll("<br/>", SystemUtils.LINE_SEPARATOR);
    }

    public String getUstId() {
        if (!this.getCustomValues().hasCustomValue(VALUE_USTID)) {
            return "";
        }
        String string = this.getCustomValues().getCustomValue(VALUE_USTID).isText() ? this.getCustomValues().getCustomValue(VALUE_USTID).getText() : this.getCustomValues().getCustomValue(VALUE_USTID).getString();
        return string.replaceAll("<br/>", SystemUtils.LINE_SEPARATOR);
    }

    public String getVertretung() {
        if (!this.getCustomValues().hasCustomValue(VALUE_VERTRETUNG)) {
            return "";
        }
        String string = this.getCustomValues().getCustomValue(VALUE_VERTRETUNG).isText() ? this.getCustomValues().getCustomValue(VALUE_VERTRETUNG).getText() : this.getCustomValues().getCustomValue(VALUE_VERTRETUNG).getString();
        return string.replaceAll("<br/>", SystemUtils.LINE_SEPARATOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AgencyAgent loadAgent() throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("");
            AgencyAgent agencyAgent = AgencyAgent.loadAgent(collection);
            return agencyAgent;
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static AgencyAgent loadAgent(Collection collection) throws ImmoToolDbException {
        if (collection == null) {
            throw new ImmoToolDbException("no collection provided!");
        }
        ImmoToolApp immoToolApp = ImmoToolApp.getApplication();
        try {
            AgencyAgent agencyAgent;
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Agency")) {
                throw new ImmoToolDbException("wrong collection provided!");
            }
            if (!ImmoToolDbUtils.hasResource((Collection)collection, (String)"Agent.xml")) {
                agencyAgent = new AgencyAgent();
                agencyAgent.setCompany(immoToolApp.getProject().getAdress());
                AgencyAgent.createDefaultAgent(immoToolApp.getDatabase(), collection, agencyAgent);
            }
            if ((agencyAgent = ImmoToolDbUtils.loadXMLResource((Collection)collection, (String)"Agent.xml")) == null) {
                throw new Exception("agent-resource not found!");
            }
            Document document = OpenEstateUtils.loadDocumentFromXmlString((String)agencyAgent.getContent().toString());
            return new AgencyAgent(document);
        }
        catch (ImmoToolDbException immoToolDbException) {
            LOGGER.error((Object)"could not load agent!");
            LOGGER.error((Object)("> " + immoToolDbException.getLocalizedMessage()));
            throw immoToolDbException;
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not load agent!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()));
            throw new ImmoToolDbException("Agent-Error: " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage loadLogo() throws ImmoToolDbException, IOException {
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("");
            BufferedImage bufferedImage = AgencyAgent.loadLogo(collection);
            return bufferedImage;
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static BufferedImage loadLogo(Collection collection) throws ImmoToolDbException, IOException {
        InputStream inputStream = AgencyAgent.loadLogoAsStream(collection);
        return inputStream != null ? ImageIO.read(inputStream) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream loadLogoAsStream() throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("");
            InputStream inputStream = AgencyAgent.loadLogoAsStream(collection);
            return inputStream;
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static InputStream loadLogoAsStream(Collection collection) throws ImmoToolDbException {
        if (collection == null) {
            throw new ImmoToolDbException("no collection provided!");
        }
        try {
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Agency")) {
                throw new ImmoToolDbException("wrong collection provided!");
            }
            if (!ImmoToolDbUtils.hasResource((Collection)collection, (String)"AgentLogo.png")) {
                return null;
            }
            BinaryResource binaryResource = ImmoToolDbUtils.loadBinaryResource((Collection)collection, (String)"AgentLogo.png");
            if (binaryResource == null) {
                throw new Exception("resource not found!");
            }
            return new ByteArrayInputStream((byte[])binaryResource.getContent());
        }
        catch (ImmoToolDbException immoToolDbException) {
            LOGGER.error((Object)"could not load agent-logo!");
            LOGGER.error((Object)("> " + immoToolDbException.getLocalizedMessage()));
            throw immoToolDbException;
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not load agent-logo!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()));
            throw new ImmoToolDbException("Agent-Error: " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public void setAufsichtsBehoerde(String string) {
        this.getCustomValues().putCustomValue(VALUE_AUFSICHT, (Object)string, 5);
    }

    public void setGewerbeErlaubnis(String string) {
        this.getCustomValues().putCustomValue(VALUE_GEWERBE, (Object)string, 6);
    }

    public void setHandelsRegister(String string) {
        this.getCustomValues().putCustomValue(VALUE_HANDELSREGISTER, (Object)string, 5);
    }

    public void setUstId(String string) {
        this.getCustomValues().putCustomValue(VALUE_USTID, (Object)string, 5);
    }

    public void setVertretung(String string) {
        this.getCustomValues().putCustomValue(VALUE_VERTRETUNG, (Object)string, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String storeAgent(AgencyAgent agencyAgent) throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("");
            String string = AgencyAgent.storeAgent(agencyAgent, collection);
            return string;
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static String storeAgent(AgencyAgent agencyAgent, Collection collection) throws ImmoToolDbException {
        if (collection == null) {
            throw new ImmoToolDbException("no collection provided!");
        }
        ImmoToolApp immoToolApp = ImmoToolApp.getApplication();
        try {
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Agency")) {
                throw new ImmoToolDbException("wrong collection provided!");
            }
            if (!ImmoToolDbUtils.hasResource((Collection)collection, (String)"Agent.xml")) {
                AgencyAgent.createDefaultAgent(immoToolApp.getDatabase(), collection, agencyAgent);
            } else {
                XMLResource xMLResource = ImmoToolDbUtils.loadXMLResource((Collection)collection, (String)"Agent.xml");
                if (xMLResource == null) {
                    throw new ImmoToolDbException("agent-resource not found!");
                }
                StringWriter stringWriter = new StringWriter();
                OpenEstateUtils.serializeToXML((SerializableXmlElement)agencyAgent, (Writer)stringWriter, (boolean)false);
                xMLResource.setContent((Object)stringWriter.toString());
                ImmoToolDbUtils.storeResource((Collection)collection, (Resource)xMLResource);
            }
            immoToolApp.getProject().setAdress(agencyAgent.getCompany());
            immoToolApp.getFrameView().setProjectCompany(agencyAgent.getCompany());
            return agencyAgent.getId();
        }
        catch (ImmoToolDbException immoToolDbException) {
            LOGGER.error((Object)"could not store agent!");
            LOGGER.error((Object)("> " + immoToolDbException.getLocalizedMessage()));
            throw immoToolDbException;
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not store agent!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()));
            throw new ImmoToolDbException("Agent-Error: " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeLogo(File file) throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("");
            AgencyAgent.storeLogo(file, collection);
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static void storeLogo(File file, Collection collection) throws ImmoToolDbException {
        if (collection == null) {
            throw new ImmoToolDbException("no collection provided!");
        }
        ImmoToolApp immoToolApp = ImmoToolApp.getApplication();
        try {
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Agency")) {
                throw new ImmoToolDbException("wrong collection provided!");
            }
            BinaryResource binaryResource = null;
            if (ImmoToolDbUtils.hasResource((Collection)collection, (String)"AgentLogo.png")) {
                binaryResource = ImmoToolDbUtils.loadBinaryResource((Collection)collection, (String)"AgentLogo.png");
            }
            if (file != null) {
                if (binaryResource == null && (binaryResource = ImmoToolDbUtils.createBinaryResource((Collection)collection, (String)"AgentLogo.png")) == null) {
                    throw new Exception("could not create logo-resource!");
                }
                binaryResource.setContent((Object)ImmoToolUtils.loadFileContent((File)file));
                ((EXistResource)binaryResource).setMimeType("image/png");
                ImmoToolDbUtils.storeResource((Collection)collection, (Resource)binaryResource);
            } else if (binaryResource != null) {
                collection.removeResource((Resource)binaryResource);
            }
            BufferedImage bufferedImage = file != null ? ImageIO.read(file) : null;
            immoToolApp.getFrameView().setProjectCompanyLogo(bufferedImage != null ? bufferedImage : null);
        }
        catch (ImmoToolDbException immoToolDbException) {
            LOGGER.error((Object)"Can't store agent-logo!");
            LOGGER.error((Object)("> " + immoToolDbException.getLocalizedMessage()));
            throw immoToolDbException;
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Can't store agent-logo!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()));
            throw new ImmoToolDbException("agent-logo-error: " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }
}

