/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.impl.AbstractImplItem;
import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.SerializableXmlElement;
import com.openindex.openestate.impl.SimpleAdressImpl;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolDb;
import com.openindex.openestate.tool.ImmoToolDbException;
import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.w3c.dom.Node;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.modules.XMLResource;

public class AgencyContact
extends AgentContactImpl {
    private static final Logger LOGGER = Logger.getLogger(AgencyContact.class);
    public static final String VALUE_NOTES = "notes";

    public AgencyContact() {
    }

    public AgencyContact(AgentContactImpl agentContactImpl) {
        this.merge((AbstractImplItem)agentContactImpl);
    }

    public AgencyContact(Document document) throws DocumentException {
        super(document);
    }

    public Row createRow() {
        Row row = new Row();
        row.id = this.getIdNr();
        row.adressCity = this.getCity();
        row.adressCountry = this.getCountry();
        row.adressPostalCode = this.getPostalCode();
        row.adressStreet = this.getStreet();
        row.adressStreetNr = this.getStreetNr();
        row.email = this.getPersonMail();
        row.fax = this.getPersonFax();
        row.firstName = this.getPersonFirstName();
        row.lastName = this.getPersonLastName();
        row.phone = this.getPersonPhone();
        return row;
    }

    public Long getIdNr() {
        if (this.getId() == null) {
            return 0L;
        }
        String[] stringArray = this.getId().split("\\.");
        return Long.valueOf(stringArray[stringArray.length - 1]);
    }

    public String getNotes() {
        return this.getCustomValues().hasCustomValue(VALUE_NOTES) ? this.getCustomValues().getCustomValue(VALUE_NOTES).getText() : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AgencyContact loadContact(long l) throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/contacts");
            AgencyContact agencyContact = AgencyContact.loadContact(l, collection);
            return agencyContact;
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static AgencyContact loadContact(long l, Collection collection) throws ImmoToolDbException {
        if (collection == null) {
            throw new ImmoToolDbException("no collection provided!");
        }
        try {
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Agency/contacts")) {
                throw new ImmoToolDbException("wrong collection provided!");
            }
            String string = "AgentContact." + l + ".xml";
            if (!ImmoToolDbUtils.hasResource((Collection)collection, (String)string)) {
                return null;
            }
            XMLResource xMLResource = ImmoToolDbUtils.loadXMLResource((Collection)collection, (String)string);
            if (xMLResource == null) {
                throw new Exception("contact-resource #" + l + " not found!");
            }
            return new AgencyContact(OpenEstateUtils.loadDocumentFromXmlString((String)xMLResource.getContent().toString()));
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException("Agent-Error: " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Row[] loadContactRows(Long[] longArray, String string, String string2) throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/contacts");
            Row[] rowArray = AgencyContact.loadContactRows(longArray, string, string2, collection);
            return rowArray;
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static Row[] loadContactRows(Long[] longArray, String string, String string2, Collection collection) throws ImmoToolDbException {
        if (collection == null) {
            throw new ImmoToolDbException("no collection provided!");
        }
        try {
            StringBuilder stringBuilder;
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Agency/contacts")) {
                throw new ImmoToolDbException("wrong collection provided!");
            }
            String string3 = "declare namespace xmldb=\"http://exist-db.org/xquery/xmldb\";\ndeclare namespace openestate=\"http://www.openestate.org/1.0/\";\ndeclare namespace util=\"http://exist-db.org/xquery/util\";\nfor $x in xmldb:xcollection('ImmoTool/OpenEstate-Agency/contacts')/openestate:AgentContact\n";
            string3 = string3 + "let $doc := util:document-name($x)\n";
            string3 = string3 + "let $id := $x/@Id\n";
            string3 = string3 + "let $adressStreet := $x/@Street\n";
            string3 = string3 + "let $adressStreetNr := $x/@StreetNr\n";
            string3 = string3 + "let $adressPostalCode := $x/@PostalCode\n";
            string3 = string3 + "let $adressCity := $x/@City\n";
            string3 = string3 + "let $adressCountry := $x/@Country\n";
            string3 = string3 + "let $email := $x/@PersonMail\n";
            string3 = string3 + "let $fax := $x/@PersonFax\n";
            string3 = string3 + "let $firstName := $x/@PersonFirstName\n";
            string3 = string3 + "let $lastName := $x/@PersonLastName\n";
            string3 = string3 + "let $lastName_lowercase := lower-case($lastName)\n";
            string3 = string3 + "let $phone := $x/@PersonPhone\n";
            StringBuilder stringBuilder2 = new StringBuilder();
            if (longArray != null && longArray.length > 0) {
                stringBuilder = new StringBuilder();
                for (Long l : longArray) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(" or ");
                    }
                    stringBuilder.append("$x/@Id='AgentContact.").append(l).append("'");
                }
                stringBuilder2.append("(").append(stringBuilder.toString()).append(")");
            }
            if (string != null && string.trim().length() > 0) {
                if (stringBuilder2.length() > 0) {
                    stringBuilder2.append(" and ");
                }
                stringBuilder2.append("(").append(string).append(")");
            }
            if (stringBuilder2.length() > 0) {
                string3 = string3 + "where (" + stringBuilder2.toString() + ")\n";
            }
            string3 = string2 != null && string2.trim().length() > 0 ? string3 + "order by " + string2 + "\n" : string3 + "order by $lastName_lowercase\n";
            stringBuilder = ImmoToolDbUtils.executeXQuery((Collection)collection, (String)(string3 = string3 + "return <row id=\"{$id}\" adressStreet=\"{$adressStreet}\" adressStreetNr=\"{$adressStreetNr}\" adressPostalCode=\"{$adressPostalCode}\" adressCity=\"{$adressCity}\" adressCountry=\"{$adressCountry}\" email=\"{$email}\" fax=\"{$fax}\" firstName=\"{$firstName}\" lastName=\"{$lastName}\" phone=\"{$phone}\" />"));
            if (stringBuilder.getSize() <= 0L) {
                return null;
            }
            ArrayList arrayList = new ArrayList();
            for (long i = 0L; i < stringBuilder.getSize(); ++i) {
                Long l;
                l = (XMLResource)stringBuilder.getResource(i);
                Node node = l.getContentAsDOM();
                Row row = new Row();
                try {
                    String[] stringArray = node.getAttributes().getNamedItem("id").getNodeValue().split("\\.");
                    row.id = stringArray != null && stringArray.length > 1 ? Long.valueOf(stringArray[1]) : 0L;
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"ID konnte nicht ermittelt werden!");
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
                row.adressCity = node.getAttributes().getNamedItem("adressCity").getNodeValue().trim();
                row.adressCountry = node.getAttributes().getNamedItem("adressCountry").getNodeValue().trim();
                row.adressPostalCode = node.getAttributes().getNamedItem("adressPostalCode").getNodeValue().trim();
                row.adressStreet = node.getAttributes().getNamedItem("adressStreet").getNodeValue().trim();
                row.adressStreetNr = node.getAttributes().getNamedItem("adressStreetNr").getNodeValue().trim();
                row.email = node.getAttributes().getNamedItem("email").getNodeValue().trim();
                row.fax = node.getAttributes().getNamedItem("fax").getNodeValue().trim();
                row.firstName = node.getAttributes().getNamedItem("firstName").getNodeValue();
                row.lastName = node.getAttributes().getNamedItem("lastName").getNodeValue();
                row.phone = node.getAttributes().getNamedItem("phone").getNodeValue().trim();
                arrayList.add(row);
            }
            return arrayList.toArray(new Row[arrayList.size()]);
        }
        catch (ImmoToolDbException immoToolDbException) {
            LOGGER.error((Object)"could not load contact-rows!");
            LOGGER.error((Object)("> " + immoToolDbException.getLocalizedMessage()));
            throw immoToolDbException;
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not load contact-rows!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()));
            throw new ImmoToolDbException("contact-row-error: " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long[] loadEstateIds(long l) throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/estates");
            Long[] longArray = AgencyContact.loadEstateIds(l, collection);
            return longArray;
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static Long[] loadEstateIds(long l, Collection collection) throws ImmoToolDbException {
        if (collection == null) {
            throw new ImmoToolDbException("no collection provided!");
        }
        try {
            AgencyEstate.Row[] rowArray;
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Agency/estates")) {
                throw new ImmoToolDbException("wrong collection provided!");
            }
            ArrayList<Long> arrayList = new ArrayList<Long>();
            for (AgencyEstate.Row row : rowArray = AgencyContact.loadEstateRows(l, collection)) {
                if (arrayList.contains(row.id)) continue;
                arrayList.add(row.id);
            }
            return arrayList.toArray(new Long[arrayList.size()]);
        }
        catch (ImmoToolDbException immoToolDbException) {
            LOGGER.error((Object)("could not load estate-ids for contact #" + l + "!"));
            LOGGER.error((Object)("> " + immoToolDbException.getLocalizedMessage()));
            throw immoToolDbException;
        }
        catch (Exception exception) {
            LOGGER.error((Object)("could not load estate-ids for contact #" + l + "!"));
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()));
            throw new ImmoToolDbException("estate-id-error: " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AgencyEstate.Row[] loadEstateRows(long l) throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/estates");
            AgencyEstate.Row[] rowArray = AgencyContact.loadEstateRows(l, collection);
            return rowArray;
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static AgencyEstate.Row[] loadEstateRows(long l, Collection collection) throws ImmoToolDbException {
        if (collection == null) {
            throw new ImmoToolDbException("no collection provided!");
        }
        try {
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Agency/estates")) {
                throw new ImmoToolDbException("wrong collection provided!");
            }
            return AgencyEstate.loadEstateRows(null, "$x/@ContactId='AgentContact." + l + "'", null);
        }
        catch (ImmoToolDbException immoToolDbException) {
            LOGGER.error((Object)"could not load contact-rows!");
            LOGGER.error((Object)("> " + immoToolDbException.getLocalizedMessage()));
            throw immoToolDbException;
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not load contact-rows!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()));
            throw new ImmoToolDbException("contact-error: " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeContact(long l) throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/contacts");
            AgencyContact.removeContact(l, collection);
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static void removeContact(long l, Collection collection) throws ImmoToolDbException {
        if (collection == null) {
            throw new ImmoToolDbException("no collection provided!");
        }
        try {
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Agency/contacts")) {
                throw new ImmoToolDbException("wrong collection provided!");
            }
            String string = "AgentContact." + l + ".xml";
            if (!ImmoToolDbUtils.hasResource((Collection)collection, (String)string)) {
                throw new Exception(string + " not found!");
            }
            XMLResource xMLResource = ImmoToolDbUtils.loadXMLResource((Collection)collection, (String)string);
            ImmoToolDbUtils.removeResource((Collection)collection, (Resource)xMLResource);
        }
        catch (ImmoToolDbException immoToolDbException) {
            LOGGER.error((Object)("could not remove contact #" + l + "!"));
            LOGGER.error((Object)("> " + immoToolDbException.getLocalizedMessage()));
            throw immoToolDbException;
        }
        catch (Exception exception) {
            LOGGER.error((Object)("could not remove contact #" + l + "!"));
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()));
            throw new ImmoToolDbException("contact-error: " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public void setNotes(String string) {
        this.getCustomValues().putCustomValue(VALUE_NOTES, (Object)string, 6);
    }

    public String store() throws ImmoToolDbException {
        return AgencyContact.storeContact(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String storeContact(AgencyContact agencyContact) throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/contacts");
            String string = AgencyContact.storeContact(agencyContact, collection);
            return string;
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static String storeContact(AgencyContact agencyContact, Collection collection) throws ImmoToolDbException {
        return AgencyContact.storeContact(agencyContact, collection, ImmoToolApp.getApplication().getDatabase());
    }

    public static String storeContact(AgencyContact agencyContact, Collection collection, ImmoToolDb immoToolDb) throws ImmoToolDbException {
        if (collection == null) {
            throw new ImmoToolDbException("no collection provided!");
        }
        try {
            Object object;
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Agency/contacts")) {
                throw new ImmoToolDbException("wrong collection provided!");
            }
            if (agencyContact.getId() == null || !agencyContact.getId().startsWith("AgentContact.")) {
                object = immoToolDb.getNextSequence("OpenEstate-Agency.AgentContact");
                agencyContact.setId("AgentContact." + object);
            }
            object = agencyContact.getId() + ".xml";
            XMLResource xMLResource = null;
            xMLResource = !ImmoToolDbUtils.hasResource((Collection)collection, (String)object) ? ImmoToolDbUtils.createXmlResource((Collection)collection, (String)object) : ImmoToolDbUtils.loadXMLResource((Collection)collection, (String)object);
            StringWriter stringWriter = new StringWriter();
            OpenEstateUtils.serializeToXML((SerializableXmlElement)agencyContact, (Writer)stringWriter, (boolean)false);
            xMLResource.setContent((Object)stringWriter.toString());
            ImmoToolDbUtils.storeResource((Collection)collection, (Resource)xMLResource);
            return agencyContact.getId();
        }
        catch (ImmoToolDbException immoToolDbException) {
            LOGGER.error((Object)"could not store contact!");
            LOGGER.error((Object)("> " + immoToolDbException.getLocalizedMessage()));
            throw immoToolDbException;
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not store contact!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()));
            throw new ImmoToolDbException("contact-store-error: " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public static class Row {
        public long id = 0L;
        public String firstName = null;
        public String lastName = null;
        public String email = null;
        public String fax = null;
        public String phone = null;
        public String adressStreet = null;
        public String adressStreetNr = null;
        public String adressPostalCode = null;
        public String adressCity = null;
        public String adressCountry = null;

        public String writeAdressLine1() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.adressStreet != null) {
                stringBuilder.append(this.adressStreet.trim());
                if (this.adressStreetNr != null) {
                    stringBuilder.append(" ").append(this.adressStreetNr.trim());
                }
            }
            return stringBuilder.toString();
        }

        public String writeAdressLine2() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.adressPostalCode != null) {
                stringBuilder.append(this.adressPostalCode.trim());
            }
            if (this.adressCity != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(this.adressCity.trim());
            }
            return stringBuilder.toString();
        }

        public String writeAdressLine2WithCountry() {
            if (this.adressCountry != null) {
                return this.adressCountry + "-" + this.writeAdressLine2();
            }
            return this.writeAdressLine2();
        }

        public String writeCountry() {
            String string = SimpleAdressImpl.writeCountry((String)this.adressCountry);
            return string != null && string.trim().length() > 0 ? string : this.adressCountry;
        }

        public String writePerson() {
            String string = "";
            if (this.lastName != null) {
                string = string + this.lastName;
            }
            if (this.firstName != null) {
                if (string.length() > 0) {
                    string = string + ", ";
                }
                string = string + this.firstName;
            }
            return string.trim();
        }

        public String writeToolTip() {
            return "<html><div style=\"margin:5px;\"><h2 style=\"margin:0;\">Mitarbeiter #" + this.id + "</h2>" + "<hr>" + StringEscapeUtils.escapeHtml((String)this.writePerson()) + "<hr>" + StringEscapeUtils.escapeHtml((String)this.writeAdressLine1()) + "<br>" + StringEscapeUtils.escapeHtml((String)this.writeAdressLine2()) + "<br>" + this.writeCountry() + (this.email != null && this.email.trim().length() > 0 ? "<br>" + StringEscapeUtils.escapeHtml((String)this.email) : "") + (this.phone != null && this.phone.trim().length() > 0 ? "<br>Tel: " + StringEscapeUtils.escapeHtml((String)this.phone) : "") + (this.fax != null && this.fax.trim().length() > 0 ? "<br>Fax: " + StringEscapeUtils.escapeHtml((String)this.fax) : "") + "</div></html>";
        }
    }
}

