/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.tool.ImmoToolDbException;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyContact;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import org.apache.commons.lang.SystemUtils;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTitledSeparator;

public class AgencyContactDialog
extends JDialog {
    public static final int OPENED = 0;
    public static final int CANCELLED = 1;
    public static final int APPROVED = 2;
    private int status = 0;
    private ResourceMap resourceMap;
    private JButton cancelButton;
    private JComboBox contactBox;
    private JLabel messageLabel;
    private JButton submitButton;
    private JXTitledSeparator titleLabel;

    public AgencyContactDialog(Frame frame) {
        super(frame, true);
        this.build();
        this.setLocationRelativeTo(frame);
    }

    public AgencyContactDialog(Dialog dialog) {
        super(dialog, true);
        this.build();
        this.setLocationRelativeTo(dialog);
    }

    private void build() {
        this.resourceMap = ImmoToolUtils.getResourceMap(AgencyContactDialog.class);
        this.setContentPane((Container)new JXPanel());
        this.initComponents();
        this.setMessage(null);
        if (SystemUtils.IS_OS_MAC_OSX) {
            this.cancelButton.setOpaque(false);
            this.submitButton.setOpaque(false);
        }
        this.resourceMap.injectComponents((Component)this);
        ImmoToolUtils.configureDialog((JDialog)this, (JXPanel)((JXPanel)this.getContentPane()));
    }

    public Long getContactId() {
        AgencyContact.Row row = (AgencyContact.Row)this.contactBox.getSelectedItem();
        return row != null ? Long.valueOf(row.id) : null;
    }

    public int getStatus() {
        return this.status;
    }

    public void load() throws ImmoToolDbException {
        DefaultComboBoxModel<AgencyContact.Row> defaultComboBoxModel = new DefaultComboBoxModel<AgencyContact.Row>();
        defaultComboBoxModel.addElement(null);
        for (AgencyContact.Row row : AgencyContact.loadContactRows(null, null, null)) {
            if (!this.loadContactToSelection(row)) continue;
            defaultComboBoxModel.addElement(row);
        }
        this.contactBox.setModel(defaultComboBoxModel);
    }

    protected boolean loadContactToSelection(AgencyContact.Row row) {
        return true;
    }

    public void setMessage(String string) {
        this.messageLabel.setText(string != null && string.trim().length() > 0 ? string.trim() : "");
        this.messageLabel.setVisible(string != null && string.trim().length() > 0);
    }

    private void initComponents() {
        this.titleLabel = ImmoToolUtils.createHead1Separator((String)"");
        this.messageLabel = new JLabel();
        this.contactBox = new JComboBox();
        this.submitButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.titleLabel.setName("titleLabel");
        this.messageLabel.setText("...message...");
        this.messageLabel.setName("messageLabel");
        this.contactBox.setName("contactBox");
        this.contactBox.setRenderer(new AgentContactRenderer());
        ApplicationActionMap applicationActionMap = Application.getInstance().getContext().getActionMap(AgencyContactDialog.class, (Object)this);
        this.submitButton.setAction(applicationActionMap.get("doSubmit"));
        this.submitButton.setName("submitButton");
        this.cancelButton.setAction(applicationActionMap.get("doCancel"));
        this.cancelButton.setName("cancelButton");
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addComponent(this.submitButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.titleLabel, -1, 376, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGap(24, 24, 24).addComponent(this.messageLabel, -1, 364, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGap(24, 24, 24).addComponent(this.contactBox, 0, 364, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.titleLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.messageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.contactBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 164, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.submitButton)).addContainerGap()));
        this.pack();
    }

    @Action
    public void doCancel() {
        this.status = 1;
        this.setVisible(false);
    }

    @Action
    public void doSubmit() {
        this.status = 2;
        this.setVisible(false);
    }

    private class AgentContactRenderer
    extends JLabel
    implements ListCellRenderer {
        private AgentContactRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            AgencyContact.Row row = object != null ? (AgencyContact.Row)object : null;
            AgencyPluginUtils.prepareListCellRenderer((JLabel)this, jList, row, n, bl, bl2, AgencyContactDialog.this.resourceMap.getString("label.emptySelection", new Object[0]));
            return this;
        }
    }
}

