/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyContact;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.application.ResourceMap;

public class AgencyContactTableModel
extends DefaultTableModel {
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_LASTNAME = 1;
    public static final int COLUMN_FIRSTNAME = 2;
    public static final int COLUMN_STREET = 3;
    public static final int COLUMN_POSTALCODE = 4;
    public static final int COLUMN_CITY = 5;
    public static final int COLUMN_COUNTRY = 6;
    public static final int COLUMN_MAIL = 7;
    public static final int COLUMN_PHONE = 8;
    public static final int COLUMN_FAX = 9;
    private static final Map<Integer, String> COLUMN_NAMES = new HashMap<Integer, String>();
    private static final Map<Integer, Class> COLUMN_CLASSES;
    private final ResourceMap resourceMap;

    public AgencyContactTableModel() {
        this.setColumnCount(COLUMN_NAMES.size());
        this.resourceMap = ImmoToolUtils.getResourceMap(AgencyContactTableModel.class);
    }

    public void addContact(AgencyContact.Row row) {
        this.addRow(this.buildRow(row));
    }

    private Object[] buildRow(AgencyContact.Row row) {
        TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
        treeMap.put(0, row.id);
        treeMap.put(5, row.adressCity != null ? row.adressCity.trim() : "");
        treeMap.put(6, row.adressCountry != null ? row.writeCountry() : "");
        treeMap.put(9, row.fax != null ? row.fax.trim() : "");
        treeMap.put(7, row.email != null ? row.email.trim() : "");
        treeMap.put(1, row.lastName != null ? row.lastName.trim() : "");
        treeMap.put(2, row.firstName != null ? row.firstName.trim() : "");
        treeMap.put(8, row.phone != null ? row.phone.trim() : "");
        treeMap.put(4, row.adressPostalCode != null ? row.adressPostalCode : "");
        String string = "";
        if (row.adressStreet != null) {
            string = row.adressStreet.trim();
            if (row.adressStreetNr != null) {
                string = string + " " + row.adressStreetNr.trim();
            }
        }
        treeMap.put(3, string);
        return treeMap.values().toArray(new Object[treeMap.size()]);
    }

    public void clear() {
        while (this.getRowCount() > 0) {
            this.removeRow(0);
        }
    }

    public Class getColumnClass(int n) {
        return COLUMN_CLASSES.containsKey(n) ? COLUMN_CLASSES.get(n) : null;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES.containsKey(n) ? this.resourceMap.getString(COLUMN_NAMES.get(n), new Object[0]) : null;
    }

    public Long getContactIdAt(int n) {
        int n2 = n;
        return (Long)this.getValueAt(n2, 0);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    static {
        COLUMN_NAMES.put(0, "col.id");
        COLUMN_NAMES.put(1, "col.lastName");
        COLUMN_NAMES.put(2, "col.firstName");
        COLUMN_NAMES.put(3, "col.street");
        COLUMN_NAMES.put(4, "col.postalCode");
        COLUMN_NAMES.put(5, "col.city");
        COLUMN_NAMES.put(6, "col.country");
        COLUMN_NAMES.put(7, "col.email");
        COLUMN_NAMES.put(8, "col.phone");
        COLUMN_NAMES.put(9, "col.fax");
        COLUMN_CLASSES = new HashMap<Integer, Class>();
        COLUMN_CLASSES.put(0, Long.class);
        COLUMN_CLASSES.put(1, String.class);
        COLUMN_CLASSES.put(2, String.class);
        COLUMN_CLASSES.put(3, String.class);
        COLUMN_CLASSES.put(4, String.class);
        COLUMN_CLASSES.put(5, String.class);
        COLUMN_CLASSES.put(6, String.class);
        COLUMN_CLASSES.put(7, String.class);
        COLUMN_CLASSES.put(8, String.class);
        COLUMN_CLASSES.put(9, String.class);
    }
}

