/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.ImmoToolTabPanel;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolTaskContainer;
import com.openindex.openestate.tool.ImmoToolTaskDialog;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyContact;
import com.openindex.openestate.tool.agency.AgencyContactDialog;
import com.openindex.openestate.tool.agency.AgencyContactTableModel;
import com.openindex.openestate.tool.agency.AgencyContactViewPanel;
import com.openindex.openestate.tool.agency.AgencyContactViewTask;
import com.openindex.openestate.tool.agency.AgencyEstateContactTask;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.utils.QuickTableExport;
import com.openindex.openestate.tool.utils.TabComponent;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.ActionMap;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledSeparator;
import org.xmldb.api.base.Collection;
import org.xmldb.api.modules.XMLResource;

public class AgencyContactTablePanel
extends ImmoToolTabPanel {
    private static final Logger LOGGER = Logger.getLogger(AgencyContactTablePanel.class);
    private static final int FILTER_CONTACTS_WITH_ESTATE = 1;
    private static final int FILTER_CONTACTS_WITHOUT_ESTATE = 2;
    private ActionMap actionMap;
    private ResourceMap resourceMap;
    private JFormattedTextField personIdField;
    private JTextField personNameField;
    private JTextField personAdressField;
    private JTextField personMailField;
    private JComboBox personFilterBox;
    private AgencyContactTableModel resultTableModel;
    private JPopupMenu actionsMenu;
    private boolean isSearching = false;
    private JButton actionButton;
    private JButton closeButton;
    private JButton createButton;
    private JPanel formPanel;
    private JButton helpButton;
    private JXTitledSeparator resultLabel;
    private JScrollPane resultScroller;
    private JXTable resultTable;
    private JButton searchButton;
    private JXTitledSeparator titleLabel;

    public AgencyContactTablePanel() {
        this.build();
    }

    private void build() {
        this.actionMap = ImmoToolUtils.getActionMap(AgencyContactTablePanel.class, (Object)((Object)this));
        this.resourceMap = ImmoToolUtils.getResourceMap(AgencyContactTablePanel.class);
        this.initComponents();
        this.buildFormPanel();
        this.resourceMap.injectComponents((Component)((Object)this));
        this.actionsMenu = new JPopupMenu();
        this.actionsMenu.add(new JMenuItem(this.actionMap.get("doView")));
        this.actionsMenu.add(new JMenuItem(this.actionMap.get("doRemove")));
        this.resultTableModel = new AgencyContactTableModel();
        this.resultTable.setModel((TableModel)this.resultTableModel);
        this.resultTable.setSortable(true);
        this.resultTable.setColumnControl((JComponent)QuickTableExport.createColumnControl((JXTable)this.resultTable));
        ImmoToolUtils.configureTable((JXTable)this.resultTable);
        this.resultTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                    AgencyContactTablePanel.this.doView();
                } else if (mouseEvent.getButton() == 3 && mouseEvent.getClickCount() == 1) {
                    if (AgencyContactTablePanel.this.resultTable.getSelectedRow() < 0) {
                        int n = AgencyContactTablePanel.this.resultTable.rowAtPoint(mouseEvent.getPoint());
                        if (n < 0) {
                            return;
                        }
                        AgencyContactTablePanel.this.resultTable.getSelectionModel().setSelectionInterval(n, n);
                    }
                    AgencyContactTablePanel.this.actionsMenu.show((Component)AgencyContactTablePanel.this.resultTable, ((AgencyContactTablePanel)AgencyContactTablePanel.this).resultTable.getMousePosition().x, ((AgencyContactTablePanel)AgencyContactTablePanel.this).resultTable.getMousePosition().y);
                }
            }
        });
        this.resultTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                AgencyContactTablePanel.this.actionButton.setEnabled(AgencyContactTablePanel.this.resultTable.getSelectedRow() >= 0);
            }
        });
        this.closeButton.setAction(this.actionMap.get(this.closeButton.getText()));
        this.createButton.setAction(this.actionMap.get(this.createButton.getText()));
        this.searchButton.setAction(this.actionMap.get(this.searchButton.getText()));
        this.helpButton.setAction(this.actionMap.get(this.helpButton.getText()));
        this.actionButton.setAction(this.actionMap.get(this.actionButton.getText()));
        this.actionButton.setEnabled(false);
    }

    private void buildFormPanel() {
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10 && !AgencyContactTablePanel.this.isSearching) {
                    ImmoToolUtils.executeTask((Task)AgencyContactTablePanel.this.doSearch());
                }
            }
        };
        this.personIdField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.personIdField.setName("personIdField");
        this.personIdField.addKeyListener(keyAdapter);
        this.personIdField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!AgencyContactTablePanel.this.personIdField.isEditValid()) {
                    AgencyContactTablePanel.this.personIdField.setValue(null);
                }
            }
        });
        this.personNameField = new JTextField();
        this.personNameField.setName("personNameField");
        this.personNameField.addKeyListener(keyAdapter);
        this.personAdressField = new JTextField();
        this.personAdressField.setName("personAdressField");
        this.personAdressField.addKeyListener(keyAdapter);
        this.personMailField = new JTextField();
        this.personMailField.setName("personMailField");
        this.personMailField.addKeyListener(keyAdapter);
        this.personFilterBox = new JComboBox<String>(new String[]{" " + this.resourceMap.getString("label.personFilterBox.empty", new Object[0]), " " + this.resourceMap.getString("label.personFilterBox.contactsWithEstateRelation", new Object[0]), " " + this.resourceMap.getString("label.personFilterBox.contactsWithoutEstateRelation", new Object[0])});
        this.personFilterBox.setName("personFilterBox");
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:pref, 3dlu, 20dlu, 3dlu, right:pref, 3dlu, 20dlu:grow, 3dlu, right:pref, 3dlu, 20dlu:grow", (JPanel)this.formPanel);
        defaultFormBuilder.append(this.resourceMap.getString("label.personIdField", new Object[0]), (Component)this.personIdField);
        defaultFormBuilder.append(this.resourceMap.getString("label.personNameField", new Object[0]), (Component)this.personNameField);
        defaultFormBuilder.append(this.resourceMap.getString("label.personMailField", new Object[0]), (Component)this.personMailField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(" ", (Component)new JLabel(""));
        defaultFormBuilder.append(this.resourceMap.getString("label.personAdressField", new Object[0]), (Component)this.personAdressField);
        defaultFormBuilder.append(this.resourceMap.getString("label.personFilterBox", new Object[0]), (Component)this.personFilterBox);
        defaultFormBuilder.nextLine();
        this.formPanel.revalidate();
        this.formPanel.repaint();
    }

    @Action
    public void doAction() {
        if (this.resultTable.getSelectedRowCount() < 1) {
            return;
        }
        this.actionsMenu.show(this.actionButton, 0, this.actionButton.getSize().height);
    }

    @Action
    public void doClose() {
        ImmoToolUtils.removePanel((String)this.getTabTitle());
    }

    @Action
    public void doCreate() {
        String string = AgencyContactViewPanel.getInstanceTabTitle(null);
        if (ImmoToolUtils.selectPanel((String)string)) {
            return;
        }
        ImmoToolUtils.showPanel((TabComponent)new AgencyContactViewPanel());
    }

    @Action
    public void doHelp() {
        ImmoToolUtils.showHelpDialog((String)"agency.contacts");
    }

    @Action
    public void doRemove() {
        if (this.resultTable.getSelectedRowCount() < 1) {
            return;
        }
        final ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int n : this.resultTable.getSelectedRows()) {
            int n2 = this.resultTable.convertRowIndexToModel(n);
            arrayList.add(this.resultTableModel.getContactIdAt(n2));
        }
        boolean bl = ImmoToolUtils.showQuestionDialog((String)this.resourceMap.getString("question.reallyDeleteContact", new Object[0]), (Component)((Object)this));
        if (!bl) {
            return;
        }
        this.setButtonsEnabled(false);
        final AgencyContactTablePanel agencyContactTablePanel = this;
        ImmoToolTaskContainer immoToolTaskContainer = new ImmoToolTaskContainer(this.resourceMap.getString("doRemove.Action.text", new Object[0])){
            private int count;
            {
                super(string);
                this.count = -1;
            }

            protected Boolean executeTask() throws Exception {
                this.count = 0;
                for (Long l : arrayList) {
                    AgencyContact agencyContact = AgencyContact.loadContact(l);
                    if (agencyContact == null) {
                        LOGGER.warn((Object)("contact #" + l + " not found!"));
                        continue;
                    }
                    this.setMessage("#" + agencyContact.getIdNr());
                    Long[] longArray = AgencyContact.loadEstateIds(l);
                    if (longArray.length > 0) {
                        AgencyContactDialog agencyContactDialog = new AgencyContactDialog(ImmoToolApp.getApplication().getMainFrame()){

                            @Override
                            protected boolean loadContactToSelection(AgencyContact.Row row) {
                                return !arrayList.contains(row.id);
                            }
                        };
                        agencyContactDialog.setMessage(AgencyContactTablePanel.this.resourceMap.getString("message.newContactBeforeDelete", new Object[]{agencyContact.writePersonFullName(), longArray.length}));
                        agencyContactDialog.load();
                        agencyContactDialog.setVisible(true);
                        if (agencyContactDialog.getStatus() != 2) {
                            this.setMessage(AgencyContactTablePanel.this.resourceMap.getString("error.contactHasEstateRelations", new Object[]{longArray.length}));
                            continue;
                        }
                        this.add(new AgencyEstateContactTask(longArray, (long)agencyContactDialog.getContactId()));
                    }
                    AgencyContact.removeContact(l);
                    ++this.count;
                }
                return super.executeTask();
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)AgencyContactTablePanel.this.resourceMap.getString("error.cantDeleteContact", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                AgencyContactTablePanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(Boolean bl) {
                super.succeeded((Object)bl);
                if (!Boolean.TRUE.equals(bl)) {
                    return;
                }
                ImmoToolUtils.executeTask((Task)AgencyContactTablePanel.this.doSearch());
                ImmoToolUtils.showMessageInfoDialog((String)AgencyContactTablePanel.this.resourceMap.getString("message.contactsDeleted", new Object[]{this.count}), (Component)((Object)agencyContactTablePanel));
            }
        };
        ImmoToolTaskDialog.execute((ImmoToolTask)immoToolTaskContainer);
    }

    @Action
    public Task doSearch() {
        this.isSearching = true;
        this.resultTable.setVisible(false);
        this.resultTableModel.clear();
        this.setButtonsEnabled(false);
        return new ImmoToolTask<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Integer executeTask() throws Exception {
                int n = AgencyContactTablePanel.this.personFilterBox.getSelectedIndex();
                Collection collection = null;
                try {
                    AgencyContact.Row[] rowArray;
                    String string;
                    CharSequence charSequence;
                    Object object2;
                    Object object3;
                    Long[] longArray;
                    collection = AgencyPluginUtils.openPluginCollection("");
                    ArrayList<Long> arrayList = new ArrayList<Long>();
                    if (n == 2 || n == 1) {
                        longArray = "declare namespace openestate=\"http://www.openestate.org/1.0/\";\ndeclare namespace xmldb=\"http://exist-db.org/xquery/xmldb\";\nfor $x in xmldb:xcollection( 'ImmoTool/OpenEstate-Agency/estates' )/openestate:Estate\nlet $ContactId := $x/@ContactId\nreturn <result ContactId=\"{$ContactId}\"/>";
                        object3 = ImmoToolDbUtils.executeXQuery((Collection)collection, (String)longArray);
                        for (long i = 0L; i < object3.getSize(); ++i) {
                            Object object4;
                            Long object5;
                            object2 = (XMLResource)object3.getResource(i);
                            charSequence = object2.getContentAsDOM().getAttributes().getNamedItem("ContactId").getNodeValue();
                            if (charSequence == null || ((String)charSequence).trim().length() == 0 || (object5 = Long.valueOf((object4 = ((String)charSequence).split("\\."))[((String[])object4).length - 1])) == null || arrayList.contains(object5)) continue;
                            arrayList.add(object5);
                        }
                        if (n == 1 && arrayList.isEmpty()) {
                            Integer n2 = 0;
                            return n2;
                        }
                    }
                    longArray = null;
                    if (AgencyContactTablePanel.this.personIdField.getValue() != null && AgencyContactTablePanel.this.personIdField.isEditValid()) {
                        longArray = new Long[]{Long.valueOf(AgencyContactTablePanel.this.personIdField.getValue().toString())};
                    }
                    object3 = new ArrayList();
                    String string2 = AgencyContactTablePanel.this.personNameField.getText().trim();
                    if (string2.trim().length() > 0) {
                        ((ArrayList)object3).add("(contains(upper-case($x/@PersonFirstName),upper-case('" + StringEscapeUtils.escapeSql((String)string2) + "')) " + "or contains(upper-case($x/@" + "PersonLastName" + "),upper-case('" + StringEscapeUtils.escapeSql((String)string2) + "')) " + ")");
                    }
                    if ((string = AgencyContactTablePanel.this.personAdressField.getText().trim()).trim().length() > 0) {
                        ((ArrayList)object3).add("(contains(upper-case($x/@Street),upper-case('" + StringEscapeUtils.escapeSql((String)string) + "')) " + "or contains(upper-case($x/@" + "StreetNr" + "),upper-case('" + StringEscapeUtils.escapeSql((String)string) + "')) " + ")");
                    }
                    if (((String)(object2 = AgencyContactTablePanel.this.personMailField.getText().trim())).trim().length() > 0) {
                        ((ArrayList)object3).add("(contains(upper-case($x/@PersonMail),upper-case('" + StringEscapeUtils.escapeSql((String)object2) + "')) " + ")");
                    }
                    if (n == 2 || n == 1) {
                        charSequence = new StringBuilder();
                        for (Long l : arrayList) {
                            String string3 = "";
                            if (n == 2) {
                                if (((StringBuilder)charSequence).length() > 0) {
                                    string3 = string3 + "\n  and ";
                                }
                                string3 = string3 + "$doc!='AgentContact." + l + ".xml'";
                            } else if (n == 1) {
                                if (((StringBuilder)charSequence).length() > 0) {
                                    string3 = string3 + "\n  or ";
                                }
                                string3 = string3 + "$doc='AgentContact." + l + ".xml'";
                            }
                            if (string3.trim().length() <= 0) continue;
                            ((StringBuilder)charSequence).append(string3);
                        }
                        if (((StringBuilder)charSequence).length() > 0) {
                            ((ArrayList)object3).add(((StringBuilder)charSequence).toString());
                        }
                    }
                    charSequence = new StringBuilder();
                    if (!((ArrayList)object3).isEmpty()) {
                        for (int i = 0; i < ((ArrayList)object3).size(); ++i) {
                            if (i > 0) {
                                ((StringBuilder)charSequence).append(" and ");
                            }
                            ((StringBuilder)charSequence).append("(").append((String)((ArrayList)object3).get(i)).append(")");
                        }
                    }
                    if ((rowArray = AgencyContact.loadContactRows(longArray, ((StringBuilder)charSequence).toString(), null)) != null) {
                        for (AgencyContact.Row row : rowArray) {
                            AgencyContactTablePanel.this.resultTableModel.addContact(row);
                        }
                    }
                    Integer n2 = AgencyContactTablePanel.this.resultTableModel.getRowCount();
                    return n2;
                }
                finally {
                    ImmoToolDbUtils.close((Collection)collection);
                }
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                this.setMessage(AgencyContactTablePanel.this.resourceMap.getString("error.cantSearchContacts", new Object[0]));
            }

            protected void finished() {
                super.finished();
                AgencyContactTablePanel.this.setButtonsEnabled(true);
                AgencyContactTablePanel.this.resultTable.setVisible(true);
                AgencyContactTablePanel.this.isSearching = false;
            }

            protected void succeeded(Integer n) {
                super.succeeded((Object)n);
                AgencyContactTablePanel.this.resultLabel.setTitle(AgencyContactTablePanel.this.resourceMap.getString("resultLabel.title", new Object[0]) + " / " + AgencyContactTablePanel.this.resourceMap.getString("message.resultCount", new Object[]{NumberFormat.getIntegerInstance().format(n)}));
                AgencyContactTablePanel.this.resultTable.packAll();
            }
        };
    }

    @Action
    public void doView() {
        int n;
        int n2;
        if (this.resultTable.getSelectedRowCount() < 1) {
            return;
        }
        int n3 = n2 = this.resultTable.getSelectedRowCount() < 10 ? this.resultTable.getSelectedRowCount() : 10;
        if (n2 > 1 && (n = ImmoToolUtils.showQuestionDialog((String)this.resourceMap.getString("question.openMultipleObjects", new Object[]{n2}), (Component)((Object)this))) == 0) {
            return;
        }
        n = 0;
        for (int n4 : this.resultTable.getSelectedRows()) {
            int n5 = this.resultTable.convertRowIndexToModel(n4);
            long l = this.resultTableModel.getContactIdAt(n5);
            ImmoToolUtils.executeTask((Task)new AgencyContactViewTask(l, n2 == 1));
            if (++n >= 10) break;
        }
    }

    public static String getInstanceTabTitle() {
        return ImmoToolUtils.getResourceMap(AgencyContactTablePanel.class).getString("tabTitle", new Object[0]);
    }

    public String getTabInfo() {
        return this.resourceMap.getString("tabInfo", new Object[0]);
    }

    public String getTabTitle() {
        return AgencyContactTablePanel.getInstanceTabTitle();
    }

    public void refreshTab() {
        ImmoToolUtils.executeTask((Task)this.doSearch());
    }

    private void setButtonsEnabled(boolean bl) {
        this.createButton.setEnabled(bl);
        this.searchButton.setEnabled(bl);
        if (!bl) {
            this.actionButton.setEnabled(false);
        } else {
            this.actionButton.setEnabled(this.resultTable.getSelectedRow() >= 0);
        }
    }

    private void initComponents() {
        this.titleLabel = ImmoToolUtils.createHead1Separator((String)"");
        this.searchButton = new JButton();
        this.createButton = new JButton();
        this.actionButton = new JButton();
        this.helpButton = new JButton();
        this.closeButton = new JButton();
        this.formPanel = new JPanel();
        this.resultLabel = ImmoToolUtils.createHead2Separator((String)"");
        this.resultScroller = new JScrollPane();
        this.resultTable = new JXTable();
        this.titleLabel.setName("titleLabel");
        this.titleLabel.setTitle("titleLabel");
        this.searchButton.setText("doSearch");
        this.searchButton.setName("searchButton");
        this.createButton.setText("doCreate");
        this.createButton.setName("createButton");
        this.actionButton.setText("doAction");
        this.actionButton.setName("actionButton");
        this.helpButton.setText("doHelp");
        this.helpButton.setEnabled(false);
        this.helpButton.setName("helpButton");
        this.closeButton.setText("doClose");
        this.closeButton.setEnabled(false);
        this.closeButton.setName("closeButton");
        this.formPanel.setName("formPanel");
        GroupLayout groupLayout = new GroupLayout(this.formPanel);
        this.formPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 866, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 39, Short.MAX_VALUE));
        this.resultLabel.setName("resultLabel");
        this.resultLabel.setTitle("resultLabel");
        this.resultScroller.setName("resultScroller");
        this.resultTable.setColumnControlVisible(true);
        this.resultTable.setName("resultTable");
        this.resultScroller.setViewportView((Component)this.resultTable);
        GroupLayout groupLayout2 = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.resultScroller, GroupLayout.Alignment.LEADING, -1, 866, Short.MAX_VALUE).addComponent(this.formPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addComponent((Component)this.titleLabel, -1, 358, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.searchButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.createButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.actionButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.helpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton)).addComponent((Component)this.resultLabel, GroupLayout.Alignment.LEADING, -1, 866, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeButton).addComponent(this.helpButton).addComponent(this.actionButton).addComponent(this.createButton).addComponent(this.searchButton)).addComponent((Component)this.titleLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.formPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.resultLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resultScroller, -1, 387, Short.MAX_VALUE).addContainerGap()));
    }
}

