/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.factories.Borders;
import com.openindex.openestate.impl.SimpleAdressImpl;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.ImmoToolTabPanel;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolTaskContainer;
import com.openindex.openestate.tool.ImmoToolTaskDialog;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyContact;
import com.openindex.openestate.tool.agency.AgencyContactDialog;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.AgencyEstateContactTask;
import com.openindex.openestate.tool.agency.AgencyEstateStatusTask;
import com.openindex.openestate.tool.agency.AgencyEstateTableModel;
import com.openindex.openestate.tool.agency.AgencyEstateViewTask;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.utils.JAdressPanel;
import com.openindex.openestate.tool.utils.ModificationHandler;
import com.openindex.openestate.tool.utils.QuickTableExport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.Printable;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.fife.ui.rtextarea.RTextArea;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledSeparator;
import org.w3c.dom.Node;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.modules.XMLResource;

public class AgencyContactViewPanel
extends ImmoToolTabPanel {
    private static final Logger LOGGER = Logger.getLogger(AgencyContactViewPanel.class);
    private ActionMap actionMap;
    private ResourceMap resourceMap;
    private ModificationHandler modifications;
    private JAdressPanel personAdressPanel;
    private RTextArea personNotesField;
    private AgencyEstateTableModel estateTableModel;
    private JPopupMenu actionsMenu;
    private JPopupMenu estateActionsMenu;
    private AgencyContact modifiedContact = null;
    private boolean newContact = false;
    private long nextContactId = 0L;
    private long prevContactId = 0L;
    private JButton actionButton;
    private JButton closeButton;
    private JButton estateActionButton;
    private JPanel estatePanel;
    private JXTable estateTable;
    private JScrollPane estateTableScroller;
    private JXTitledSeparator estateTableTitleLabel;
    private JButton helpButton;
    private JButton nextButton;
    private JPanel personPanel;
    private JButton prevButton;
    private JButton submitButton;
    private JTabbedPane tabPanel;
    private JXTitledSeparator titleLabel;

    public AgencyContactViewPanel() {
        this(null);
    }

    public AgencyContactViewPanel(AgencyContact agencyContact) {
        this.build();
        this.newContact = agencyContact == null || agencyContact.getId() == null;
        this.loadContact(this.newContact ? new AgencyContact() : agencyContact);
        if (this.newContact) {
            this.personAdressPanel.initInputs();
        } else {
            this.personAdressPanel.validateInputs();
        }
        this.setButtonsEnabled(true);
    }

    private void build() {
        this.modifications = ImmoToolUtils.createModificationHandler();
        this.actionMap = ImmoToolUtils.getActionMap(AgencyContactViewPanel.class, (Object)((Object)this));
        this.resourceMap = ImmoToolUtils.getResourceMap(AgencyContactViewPanel.class);
        this.initComponents();
        this.buildAdressPanel();
        this.tabPanel.setTitleAt(0, this.resourceMap.getString("label.tab.person", new Object[0]));
        this.tabPanel.setTitleAt(1, this.resourceMap.getString("label.tab.estates", new Object[0]));
        this.tabPanel.add(this.resourceMap.getString("label.tab.notes", new Object[0]), this.buildDescriptionPanel());
        this.resourceMap.injectComponents((Component)((Object)this));
        JMenu jMenu = new JMenu();
        jMenu.setName("estateActionStatusMenu");
        for (final String string : AgencyEstate.getStatusList()) {
            JMenuItem jMenuItem = new JMenuItem(AgencyEstate.writeStatus(string));
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AgencyContactViewPanel.this.doChangeEstateStatus(string);
                }
            });
            jMenu.add(jMenuItem);
        }
        this.resourceMap.injectComponent((Component)jMenu);
        this.estateActionsMenu = new JPopupMenu();
        this.estateActionsMenu.add(this.actionMap.get("doShowEstate"));
        this.estateActionsMenu.add(jMenu);
        this.actionsMenu = new JPopupMenu();
        this.actionsMenu.add(new JMenuItem(this.actionMap.get("doCopy")));
        this.actionsMenu.add(new JMenuItem(this.actionMap.get("doRemove")));
        this.actionsMenu.addSeparator();
        this.actionsMenu.add(new JMenuItem(this.actionMap.get("doPrintNotes")));
        this.getActionMap().put("doViewNext", this.actionMap.get("doViewNext"));
        this.getInputMap().put(KeyStroke.getKeyStroke("alt pressed PAGE_UP"), "doViewNext");
        this.getInputMap().put(KeyStroke.getKeyStroke("ctrl pressed RIGHT"), "doViewNext");
        this.getActionMap().put("doViewPrevious", this.actionMap.get("doViewPrevious"));
        this.getInputMap().put(KeyStroke.getKeyStroke("alt pressed PAGE_DOWN"), "doViewPrevious");
        this.getInputMap().put(KeyStroke.getKeyStroke("ctrl pressed LEFT"), "doViewPrevious");
        if (SystemUtils.IS_OS_MAC_OSX) {
            this.tabPanel.setTabPlacement(1);
        }
        this.estateTableModel = new AgencyEstateTableModel();
        this.estateTable.setModel((TableModel)this.estateTableModel);
        this.estateTable.setSortable(true);
        this.estateTable.getColumnExt(14).setVisible(false);
        this.estateTable.getSelectionModel().setSelectionMode(2);
        this.estateTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                    ImmoToolUtils.executeTask((Task)AgencyContactViewPanel.this.doShowEstate());
                } else if (mouseEvent.getButton() == 3 && mouseEvent.getClickCount() == 1) {
                    if (AgencyContactViewPanel.this.estateTable.getSelectedRow() < 0) {
                        int n = AgencyContactViewPanel.this.estateTable.rowAtPoint(mouseEvent.getPoint());
                        if (n < 0) {
                            return;
                        }
                        AgencyContactViewPanel.this.estateTable.getSelectionModel().setSelectionInterval(n, n);
                    }
                    AgencyContactViewPanel.this.estateActionsMenu.show((Component)AgencyContactViewPanel.this.estateTable, ((AgencyContactViewPanel)AgencyContactViewPanel.this).estateTable.getMousePosition().x, ((AgencyContactViewPanel)AgencyContactViewPanel.this).estateTable.getMousePosition().y);
                }
            }
        });
        this.estateTable.getActionMap().put("doShowEstate", this.actionMap.get("doShowEstate"));
        this.estateTable.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "doShowEstate");
        this.estateTable.setColumnControl((JComponent)QuickTableExport.createColumnControl((JXTable)this.estateTable));
        ImmoToolUtils.configureTable((JXTable)this.estateTable);
    }

    private void buildAdressPanel() {
        this.personAdressPanel = new JAdressPanel(){

            protected void init() {
                this.registerValidation(this.personFirstNameField);
                this.registerValidation(this.personLastNameField);
                this.registerValidation(this.personMailField);
                this.registerValidation(this.personPhoneField);
            }
        };
        JScrollPane jScrollPane = new JScrollPane((Component)this.personAdressPanel);
        jScrollPane.setBorder(Borders.EMPTY);
        this.personPanel.setBorder(Borders.DIALOG);
        this.personPanel.setLayout(new BorderLayout());
        this.personPanel.add((Component)jScrollPane, "Center");
        this.personPanel.revalidate();
        this.personPanel.repaint();
    }

    private JPanel buildDescriptionPanel() {
        JXTitledSeparator jXTitledSeparator = ImmoToolUtils.createHead2Separator((String)"notesTitleLabel");
        jXTitledSeparator.setName("notesTitleLabel");
        jXTitledSeparator.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.personNotesField = new RTextArea();
        this.personNotesField.setName("personNotesField");
        this.personNotesField.setLineWrap(true);
        this.personNotesField.setWrapStyleWord(true);
        if (this.personNotesField.getPopupMenu() != null) {
            this.personNotesField.getPopupMenu().add(new JMenuItem(this.actionMap.get("doPrintNotes")));
        }
        JScrollPane jScrollPane = new JScrollPane((Component)this.personNotesField);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(11, 13, 11, 13));
        jPanel.add((Component)jXTitledSeparator, "North");
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.revalidate();
        jPanel.repaint();
        return jPanel;
    }

    public static String getInstanceTabTitle(Long l) {
        if (l == null || l <= 0L) {
            return ImmoToolUtils.getResourceMap(AgencyContactViewPanel.class).getString("tabTitle.new", new Object[0]);
        }
        return ImmoToolUtils.getResourceMap(AgencyContactViewPanel.class).getString("tabTitle.edit", new Object[]{l});
    }

    public String getTabInfo() {
        if (this.newContact || this.modifiedContact == null) {
            return this.resourceMap.getString("tabInfo.new", new Object[0]);
        }
        return this.modifiedContact.writePersonFullName() + "<br>" + this.modifiedContact.writeFullAdress("<br>");
    }

    public String getTabTitle() {
        if (this.newContact) {
            return AgencyContactViewPanel.getInstanceTabTitle(null);
        }
        String[] stringArray = this.modifiedContact.getId().split("\\.");
        return AgencyContactViewPanel.getInstanceTabTitle(Long.valueOf(stringArray[stringArray.length - 1]));
    }

    public boolean isTabModified() {
        return this.modifications.isModified() || this.personAdressPanel.isModifiedInput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadContact(AgencyContact agencyContact) {
        this.nextContactId = 0L;
        this.prevContactId = 0L;
        this.estateTableModel.clear();
        this.modifiedContact = agencyContact;
        this.tabPanel.setSelectedIndex(0);
        if (this.modifiedContact.getId() == null || this.modifiedContact.getId().trim().length() == 0) {
            this.tabPanel.setEnabledAt(1, false);
            this.titleLabel.setTitle(this.resourceMap.getString("label.newContact", new Object[0]));
            this.personNotesField.setText("");
        } else {
            Collection collection;
            Long l = this.modifiedContact.getIdNr();
            this.tabPanel.setEnabledAt(1, true);
            this.personNotesField.setText(this.modifiedContact.getNotes());
            this.personNotesField.setCaretPosition(0);
            try {
                this.titleLabel.setTitle(this.resourceMap.getString("label.editContact", new Object[]{l}));
                collection = AgencyContact.loadEstateRows(l);
                if (collection != null && ((AgencyEstate.Row[])collection).length > 0) {
                    for (Collection collection2 : collection) {
                        this.estateTableModel.addEstate((AgencyEstate.Row)collection2);
                    }
                }
            }
            catch (Exception exception) {
                LOGGER.error((Object)"could not load connected estates!");
                LOGGER.error((Object)("> for contact: " + agencyContact.getId()));
                LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
            collection = null;
            try {
                collection = AgencyPluginUtils.openPluginCollection("/contacts");
                String exception = "declare namespace xmldb=\"http://exist-db.org/xquery/xmldb\";\ndeclare namespace openestate=\"http://www.openestate.org/1.0/\";\nfor $x in xmldb:xcollection('ImmoTool/OpenEstate-Agency/contacts')/openestate:AgentContact\nreturn <row id=\"{$x/@Id}\" />";
                ResourceSet resourceSet = ImmoToolDbUtils.executeXQuery((Collection)collection, (String)exception);
                for (long i = 0L; i < resourceSet.getSize(); ++i) {
                    try {
                        XMLResource exception2 = (XMLResource)resourceSet.getResource(i);
                        Node node = exception2.getContentAsDOM();
                        String[] stringArray = node.getAttributes().getNamedItem("id").getNodeValue().split("\\.");
                        Long l2 = Long.valueOf(stringArray[1]);
                        if (l2 > l && (l2 < this.nextContactId || this.nextContactId <= 0L)) {
                            this.nextContactId = l2;
                        }
                        if (l2 >= l || l2 <= this.prevContactId && this.prevContactId > 0L) continue;
                        this.prevContactId = l2;
                        continue;
                    }
                    catch (Exception exception3) {
                        LOGGER.warn((Object)"Can't extract id!");
                        LOGGER.warn((Object)("> " + exception3.getLocalizedMessage()), (Throwable)exception3);
                    }
                }
            }
            catch (Exception exception) {
                this.nextContactId = 0L;
                this.prevContactId = 0L;
                LOGGER.warn((Object)"Can't load previous and next entry!");
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
            finally {
                ImmoToolDbUtils.close((Collection)collection);
            }
        }
        this.personAdressPanel.loadAdress((SimpleAdressImpl)agencyContact);
        this.modifications.putValue((JComponent)this.personNotesField);
        this.estateTableTitleLabel.setTitle(this.resourceMap.getString("estateTableTitleLabel.title", new Object[0]) + " / " + this.resourceMap.getString("message.resultCount", new Object[]{NumberFormat.getIntegerInstance().format(this.estateTable.getRowCount())}));
    }

    public void refreshTab() {
        if (this.newContact || this.modifiedContact == null) {
            return;
        }
        ImmoToolTask<Boolean> immoToolTask = new ImmoToolTask<Boolean>(){

            protected Boolean executeTask() throws Exception {
                AgencyContactViewPanel.this.loadContact(AgencyContact.loadContact(AgencyContactViewPanel.this.modifiedContact.getIdNr()));
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)AgencyContactViewPanel.this.resourceMap.getString("error.cantRefresh", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                AgencyContactViewPanel.this.setButtonsEnabled(true);
            }
        };
        this.setButtonsEnabled(false);
        ImmoToolUtils.executeTask((Task)immoToolTask);
    }

    public ImmoToolTask saveModifications() {
        return (ImmoToolTask)this.doSubmit();
    }

    private void setButtonsEnabled(boolean bl) {
        this.submitButton.setEnabled(bl);
        this.closeButton.setEnabled(bl);
        this.actionButton.setEnabled(bl);
        this.nextButton.setEnabled(bl && this.modifiedContact.getIdNr() > 0L && this.nextContactId > 0L);
        this.prevButton.setEnabled(bl && this.modifiedContact.getIdNr() > 0L && this.prevContactId > 0L);
    }

    private void initComponents() {
        this.titleLabel = ImmoToolUtils.createHead1Separator((String)"");
        this.prevButton = new JButton();
        this.nextButton = new JButton();
        this.submitButton = new JButton();
        this.actionButton = new JButton();
        this.helpButton = new JButton();
        this.closeButton = new JButton();
        this.tabPanel = new JTabbedPane();
        this.personPanel = new JPanel();
        this.estatePanel = new JPanel();
        this.estateTableTitleLabel = ImmoToolUtils.createHead2Separator((String)"");
        this.estateActionButton = new JButton();
        this.estateTableScroller = new JScrollPane();
        this.estateTable = new JXTable();
        this.setName("Form");
        this.titleLabel.setName("titleLabel");
        ApplicationActionMap applicationActionMap = Application.getInstance().getContext().getActionMap(AgencyContactViewPanel.class, (Object)this);
        this.prevButton.setAction(applicationActionMap.get("doViewPrevious"));
        this.prevButton.setName("prevButton");
        this.nextButton.setAction(applicationActionMap.get("doViewNext"));
        this.nextButton.setName("nextButton");
        this.submitButton.setAction(applicationActionMap.get("doSubmit"));
        this.submitButton.setName("submitButton");
        this.actionButton.setAction(applicationActionMap.get("doAction"));
        this.actionButton.setName("actionButton");
        this.helpButton.setAction(applicationActionMap.get("doHelp"));
        this.helpButton.setName("helpButton");
        this.closeButton.setAction(applicationActionMap.get("doClose"));
        this.closeButton.setName("closeButton");
        this.tabPanel.setTabPlacement(2);
        this.tabPanel.setName("tabPanel");
        this.personPanel.setName("personPanel");
        GroupLayout groupLayout = new GroupLayout(this.personPanel);
        this.personPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 593, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 401, Short.MAX_VALUE));
        this.tabPanel.addTab("person", this.personPanel);
        this.estatePanel.setName("estatePanel");
        this.estateTableTitleLabel.setName("estateTableTitleLabel");
        this.estateActionButton.setAction(applicationActionMap.get("doEstateAction"));
        this.estateActionButton.setName("estateActionButton");
        this.estateTableScroller.setName("estateTableScroller");
        this.estateTable.setModel((TableModel)new DefaultTableModel(new Object[0][], new String[0]));
        this.estateTable.setColumnControlVisible(true);
        this.estateTable.setName("estateTable");
        this.estateTableScroller.setViewportView((Component)this.estateTable);
        GroupLayout groupLayout2 = new GroupLayout(this.estatePanel);
        this.estatePanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.estateTableScroller, GroupLayout.Alignment.LEADING, -1, 569, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addComponent((Component)this.estateTableTitleLabel, -1, 488, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.estateActionButton))).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.estateActionButton).addComponent((Component)this.estateTableTitleLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.estateTableScroller, -1, 345, Short.MAX_VALUE).addContainerGap()));
        this.tabPanel.addTab("estates", this.estatePanel);
        GroupLayout groupLayout3 = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.tabPanel, GroupLayout.Alignment.LEADING, -1, 676, Short.MAX_VALUE).addGroup(groupLayout3.createSequentialGroup().addComponent((Component)this.titleLabel, -1, 332, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.prevButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nextButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.submitButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.actionButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.helpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton))).addContainerGap()));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeButton).addComponent(this.helpButton).addComponent(this.actionButton).addComponent(this.submitButton).addComponent(this.nextButton)).addComponent(this.prevButton).addComponent((Component)this.titleLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tabPanel, -1, 408, Short.MAX_VALUE).addContainerGap()));
        ResourceMap resourceMap = Application.getInstance().getContext().getResourceMap(AgencyContactViewPanel.class);
        resourceMap.injectComponents((Component)((Object)this));
    }

    @Action
    public void doAction() {
        this.actionsMenu.show(this.actionButton, 0, this.actionButton.getSize().height);
    }

    @Action
    public void doClose() {
        ImmoToolUtils.removePanel((String)this.getTabTitle());
    }

    private void doChangeEstateStatus(final String string) {
        if (this.estateTable.getSelectedRowCount() < 1) {
            return;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int n : this.estateTable.getSelectedRows()) {
            int n2 = this.estateTable.convertRowIndexToModel(n);
            arrayList.add(this.estateTableModel.getEstateIdAt(n2));
        }
        boolean bl = ImmoToolUtils.showQuestionDialog((String)this.resourceMap.getString("question.reallyChangeEstateStatus", new Object[]{AgencyEstate.writeStatus(string)}), (Component)((Object)this));
        if (!bl) {
            return;
        }
        this.setButtonsEnabled(false);
        ImmoToolTaskDialog.execute((ImmoToolTask)new AgencyEstateStatusTask(arrayList.toArray(new Long[arrayList.size()]), string){
            {
                super(longArray, string3);
                this.setTitle(AgencyContactViewPanel.this.resourceMap.getString("estateActionStatusMenu.text", new Object[0]));
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)AgencyContactViewPanel.this.resourceMap.getString("error.cantChangeEstateStatus", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                AgencyContactViewPanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(Boolean bl) {
                super.succeeded((Object)bl);
                if (!Boolean.TRUE.equals(bl)) {
                    return;
                }
                for (int n : AgencyContactViewPanel.this.estateTable.getSelectedRows()) {
                    int n2 = AgencyContactViewPanel.this.estateTable.convertRowIndexToModel(n);
                    AgencyContactViewPanel.this.estateTableModel.setValueAt(AgencyEstate.writeStatus(string), n2, 13);
                }
            }
        });
    }

    @Action
    public Task doCopy() {
        if (this.newContact) {
            return null;
        }
        this.personAdressPanel.validateInputs();
        if (!this.personAdressPanel.isValidInput()) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.invalidPerson", new Object[0]), (Component)((Object)this));
            return null;
        }
        return new ImmoToolTask<Boolean>(this.resourceMap.getString("doCopy.Action.text", new Object[0])){

            protected Boolean executeTask() throws Exception {
                AgencyContactViewPanel.this.personAdressPanel.saveAdress((SimpleAdressImpl)AgencyContactViewPanel.this.modifiedContact);
                AgencyContactViewPanel.this.modifiedContact.setNotes(AgencyContactViewPanel.this.personNotesField.getText().trim());
                AgencyContactViewPanel.this.modifiedContact.setId(null);
                AgencyContact.storeContact(AgencyContactViewPanel.this.modifiedContact);
                AgencyContactViewPanel.this.loadContact(AgencyContactViewPanel.this.modifiedContact);
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)AgencyContactViewPanel.this.resourceMap.getString("error.cantSavePerson", new Object[0]), (String)throwable.getLocalizedMessage());
            }

            protected void succeeded(Boolean bl) {
                super.succeeded((Object)bl);
                AgencyContactViewPanel.this.newContact = false;
                ImmoToolUtils.updateTabs();
            }
        };
    }

    @Action
    public void doHelp() {
        ImmoToolUtils.showHelpDialog((String)"agency.contacts.form");
    }

    @Action
    public void doEstateAction() {
        this.estateActionsMenu.show(this.estateActionButton, 0, this.estateActionButton.getSize().height);
    }

    @Action
    public void doPrintNotes() {
        try {
            ImmoToolUtils.print((Printable)this.personNotesField);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Printing failed!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)"Printing failed!", (Throwable)exception);
        }
    }

    @Action
    public Task doRemove() {
        if (this.newContact) {
            return null;
        }
        final long l = this.modifiedContact.getIdNr();
        if (!ImmoToolUtils.showQuestionDialog((String)this.resourceMap.getString("question.reallyDeleteContact", new Object[]{l}), (Component)((Object)this))) {
            return null;
        }
        this.setButtonsEnabled(false);
        return new ImmoToolTaskContainer(this.resourceMap.getString("doRemove.Action.text", new Object[0])){

            protected Boolean executeTask() throws Exception {
                AgencyContact agencyContact = AgencyContact.loadContact(l);
                if (agencyContact == null) {
                    throw new Exception("Can't find contact #" + l + "!");
                }
                Long[] longArray = AgencyContact.loadEstateIds(l);
                if (longArray.length > 0) {
                    AgencyContactDialog agencyContactDialog = new AgencyContactDialog(ImmoToolApp.getApplication().getMainFrame()){

                        @Override
                        protected boolean loadContactToSelection(AgencyContact.Row row) {
                            return row.id != l;
                        }
                    };
                    agencyContactDialog.setMessage(AgencyContactViewPanel.this.resourceMap.getString("message.newContactBeforeDelete", new Object[]{agencyContact.writePersonFullName(), longArray.length}));
                    agencyContactDialog.load();
                    agencyContactDialog.setVisible(true);
                    if (agencyContactDialog.getStatus() != 2) {
                        this.setMessage(AgencyContactViewPanel.this.resourceMap.getString("error.contactHasEstateRelations", new Object[]{longArray.length}));
                        return false;
                    }
                    this.add(new AgencyEstateContactTask(longArray, (long)agencyContactDialog.getContactId()));
                }
                AgencyContact.removeContact(l);
                return super.executeTask();
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)AgencyContactViewPanel.this.resourceMap.getString("error.cantDeleteContact", new Object[]{l}), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                AgencyContactViewPanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(Boolean bl) {
                super.succeeded((Object)bl);
                if (!Boolean.TRUE.equals(bl)) {
                    return;
                }
                ImmoToolUtils.removePanel((String)AgencyContactViewPanel.this.getTabTitle(), (boolean)true);
            }
        };
    }

    @Action
    public Task doShowEstate() {
        int n = this.estateTable.getSelectedRow();
        if (n < 0) {
            return null;
        }
        int n2 = this.estateTable.convertRowIndexToModel(n);
        return new AgencyEstateViewTask(this.estateTableModel.getEstateIdAt(n2));
    }

    @Action
    public Task doSubmit() {
        this.personAdressPanel.validateInputs();
        if (!this.personAdressPanel.isValidInput()) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.invalidPerson", new Object[0]), (Component)((Object)this));
            return null;
        }
        this.setButtonsEnabled(false);
        return new ImmoToolTask<Boolean>(this.resourceMap.getString("doSubmit.Action.text", new Object[0])){

            protected Boolean executeTask() throws Exception {
                AgencyContactViewPanel.this.personAdressPanel.saveAdress((SimpleAdressImpl)AgencyContactViewPanel.this.modifiedContact);
                AgencyContactViewPanel.this.modifiedContact.setNotes(AgencyContactViewPanel.this.personNotesField.getText().trim());
                AgencyContact.storeContact(AgencyContactViewPanel.this.modifiedContact);
                AgencyContactViewPanel.this.loadContact(AgencyContactViewPanel.this.modifiedContact);
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)AgencyContactViewPanel.this.resourceMap.getString("error.cantSavePerson", new Object[0]), (String)throwable.getLocalizedMessage());
            }

            protected void finished() {
                super.finished();
                AgencyContactViewPanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(Boolean bl) {
                super.succeeded((Object)bl);
                AgencyContactViewPanel.this.newContact = false;
                ImmoToolUtils.updateTabs();
            }
        };
    }

    @Action
    public Task doViewNext() {
        if (this.nextContactId <= 0L) {
            return null;
        }
        if (!this.checkForModifications()) {
            return null;
        }
        this.setButtonsEnabled(false);
        return new ImmoToolTask<AgencyContact>(){

            protected AgencyContact executeTask() throws Exception {
                AgencyContact agencyContact = AgencyContact.loadContact(AgencyContactViewPanel.this.nextContactId);
                if (agencyContact == null) {
                    throw new Exception("Contact #" + AgencyContactViewPanel.this.nextContactId + " not found!");
                }
                AgencyContactViewPanel.this.loadContact(agencyContact);
                return agencyContact;
            }

            protected void finished() {
                super.finished();
                AgencyContactViewPanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(AgencyContact agencyContact) {
                super.succeeded((Object)agencyContact);
                AgencyContactViewPanel.this.newContact = false;
                ImmoToolUtils.updateTabs();
                AgencyContactViewPanel.this.requestFocus();
            }
        };
    }

    @Action
    public Task doViewPrevious() {
        if (this.prevContactId <= 0L) {
            return null;
        }
        if (!this.checkForModifications()) {
            return null;
        }
        this.setButtonsEnabled(false);
        return new ImmoToolTask<AgencyContact>(){

            protected AgencyContact executeTask() throws Exception {
                AgencyContact agencyContact = AgencyContact.loadContact(AgencyContactViewPanel.this.prevContactId);
                if (agencyContact == null) {
                    throw new Exception("Contact #" + AgencyContactViewPanel.this.prevContactId + " not found!");
                }
                AgencyContactViewPanel.this.loadContact(agencyContact);
                return agencyContact;
            }

            protected void finished() {
                super.finished();
                AgencyContactViewPanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(AgencyContact agencyContact) {
                super.succeeded((Object)agencyContact);
                AgencyContactViewPanel.this.newContact = false;
                ImmoToolUtils.updateTabs();
                AgencyContactViewPanel.this.requestFocus();
            }
        };
    }
}

