/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyContact;
import com.openindex.openestate.tool.agency.AgencyContactViewPanel;
import com.openindex.openestate.tool.utils.TabComponent;
import org.jdesktop.application.ResourceMap;

public class AgencyContactViewTask
extends ImmoToolTask<AgencyContactViewPanel> {
    private ResourceMap resourceMap;
    private long agentContactId;
    private boolean selectTab;

    public AgencyContactViewTask(long l) {
        this(l, true);
    }

    public AgencyContactViewTask(long l, boolean bl) {
        this.agentContactId = l;
        this.selectTab = bl;
        this.resourceMap = ImmoToolUtils.getResourceMap(AgencyContactViewTask.class);
        this.setTitle(this.resourceMap.getString("title", new Object[]{this.agentContactId}));
    }

    protected AgencyContactViewPanel executeTask() throws Exception {
        if (this.agentContactId <= 0L) {
            throw new Exception(this.resourceMap.getString("error.contactIsInvalid", new Object[]{this.agentContactId}));
        }
        String string = AgencyContactViewPanel.getInstanceTabTitle(this.agentContactId);
        if (ImmoToolUtils.hasPanel((String)string)) {
            if (this.selectTab) {
                ImmoToolUtils.selectPanel((String)string);
            }
            return null;
        }
        AgencyContact agencyContact = AgencyContact.loadContact(this.agentContactId);
        if (agencyContact == null) {
            throw new Exception(this.resourceMap.getString("error.contactNotFound", new Object[]{this.agentContactId}));
        }
        return new AgencyContactViewPanel(agencyContact);
    }

    protected void failed(Throwable throwable) {
        super.failed(throwable);
        ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.cantLoadProfile", new Object[0]), (Throwable)throwable);
    }

    protected void succeeded(AgencyContactViewPanel agencyContactViewPanel) {
        super.succeeded((Object)agencyContactViewPanel);
        if (agencyContactViewPanel != null) {
            ImmoToolUtils.showPanel((TabComponent)agencyContactViewPanel, (boolean)this.selectTab);
        }
    }
}

