/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.impl.AbstractImplItem;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.SerializableXmlElement;
import com.openindex.openestate.impl.SimpleAdressImpl;
import com.openindex.openestate.impl.ValueImpl;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolDbException;
import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.exist.xmldb.EXistResource;
import org.w3c.dom.Node;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.modules.BinaryResource;
import org.xmldb.api.modules.XMLResource;

public class AgencyEstate
extends EstateImpl {
    private static final Logger LOGGER = Logger.getLogger(AgencyEstate.class);
    @Deprecated
    public static final String VALUE_NR = "nr";
    @Deprecated
    public static final String VALUE_KEYWORDS = "keywords";
    public static final String VALUE_GEODB = "geodb";
    public static final String VALUE_GROUP = "group";
    public static final String VALUE_NR_INTERN = "nr_intern";
    public static final String VALUE_NOTES = "notes";
    public static final String VALUE_STATUS = "status";
    public static final String VALUE_EXPORT_ALWAYS = "export.always";
    public static final String VALUE_EXPORT_ENABLED = "export.enabled";
    public static final String VALUE_EXPORT_INTERFACE = "export.interface";
    public static final String STATUS_ENTWURF = "ENTWURF";
    public static final String STATUS_NICHT_VERMITTELT = "NICHT_VERMITTELT";
    public static final String STATUS_PRUEFUNG = "PRUEFUNG";
    public static final String STATUS_VERMITTELT = "VERMITTELT";
    public static final String STATUS_VERMITTLUNG = "VERMITTLUNG";
    public static final String STATUS_ABLAGE = "ABLAGE";

    public AgencyEstate() {
    }

    public AgencyEstate(EstateImpl estateImpl) {
        this.merge((AbstractImplItem)estateImpl);
    }

    public AgencyEstate(Document document) throws DocumentException {
        super(document);
    }

    public Long[] getExportIntefaces() {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (String string : this.getCustomValues().getValueMap().keySet()) {
            if (!string.startsWith("export.interface.")) continue;
            long l = this.getCustomValues().getCustomValue(string).getInteger().longValue();
            arrayList.add(l);
        }
        return arrayList.toArray(new Long[arrayList.size()]);
    }

    public String getFallbackTitle() {
        return this.getFallbackTitle(Locale.getDefault());
    }

    public String getFallbackTitle(Locale locale) {
        OpenEstateType openEstateType = this.getType();
        if (openEstateType == null) {
            return "";
        }
        String string = OpenEstateUtils.translateEstate((String)openEstateType.getName(), (Locale)locale);
        if (this.getAction() == null || this.getAction().trim().length() == 0) {
            return string;
        }
        string = string + " / " + OpenEstateUtils.translateAction((String)this.getAction(), (Locale)locale);
        return string;
    }

    public String[] getGeoDbIds(String string) {
        String string2 = "geodb." + string;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (this.getCustomValues().hasCustomValue(string2 + "." + n)) {
            arrayList.add(this.getCustomValues().getCustomValue(string2 + "." + n).getString());
            ++n;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public Long getGroupNr() {
        return this.getCustomValues().hasCustomValue(VALUE_GROUP) ? Long.valueOf(this.getCustomValues().getCustomValue(VALUE_GROUP).getInteger().longValue()) : null;
    }

    public long getIdNr() {
        if (this.getId() == null) {
            return 0L;
        }
        String[] stringArray = this.getId().split("\\.");
        return Long.valueOf(stringArray[stringArray.length - 1]);
    }

    public String getNotes() {
        return this.getCustomValues().hasCustomValue(VALUE_NOTES) ? this.getCustomValues().getCustomValue(VALUE_NOTES).getText() : "";
    }

    @Deprecated
    public String getNr() {
        return this.getPublicId();
    }

    public String getNrIntern() {
        return this.getCustomValues().hasCustomValue(VALUE_NR_INTERN) ? this.getCustomValues().getCustomValue(VALUE_NR_INTERN).getString() : "";
    }

    public String getStatus() {
        return this.getCustomValues().hasCustomValue(VALUE_STATUS) ? this.getCustomValues().getCustomValue(VALUE_STATUS).getString() : "";
    }

    public static String[] getStatusList() {
        return new String[]{STATUS_ENTWURF, STATUS_PRUEFUNG, STATUS_VERMITTLUNG, STATUS_VERMITTELT, STATUS_NICHT_VERMITTELT, STATUS_ABLAGE};
    }

    public boolean hasExportInteface(long l) {
        if (this.isExportAlways()) {
            return true;
        }
        for (String string : this.getCustomValues().getValueMap().keySet()) {
            long l2;
            if (!string.startsWith("export.interface.") || (l2 = this.getCustomValues().getCustomValue(string).getInteger().longValue()) != l) continue;
            return true;
        }
        return false;
    }

    public boolean isExportAlways() {
        Boolean bl = this.getCustomValues().hasCustomValue(VALUE_EXPORT_ALWAYS) ? this.getCustomValues().getCustomValue(VALUE_EXPORT_ALWAYS).getBoolean() : null;
        return bl == null || bl != false;
    }

    public boolean isExportEnabled() {
        Boolean bl = this.getCustomValues().hasCustomValue(VALUE_EXPORT_ENABLED) ? this.getCustomValues().getCustomValue(VALUE_EXPORT_ENABLED).getBoolean() : null;
        return bl == null || bl != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BinaryResource loadAttachment(long l, String string) throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/estates/files");
            BinaryResource binaryResource = AgencyEstate.loadAttachment(l, string, collection);
            return binaryResource;
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static BinaryResource loadAttachment(long l, String string, Collection collection) throws ImmoToolDbException {
        Collection collection2;
        block11: {
            block9: {
                block10: {
                    if (collection == null) {
                        throw new ImmoToolDbException("no collection provided!");
                    }
                    collection2 = null;
                    if (!collection.getName().endsWith("ImmoTool/OpenEstate-Agency/estates/files")) break block9;
                    collection2 = collection.getChildCollection(String.valueOf(l));
                    if (collection2 != null) break block10;
                    BinaryResource binaryResource = null;
                    ImmoToolDbUtils.close((Collection)collection2);
                    return binaryResource;
                }
                BinaryResource binaryResource = ImmoToolDbUtils.createBinaryResource((Collection)collection2, (String)string);
                ImmoToolDbUtils.close((Collection)collection2);
                return binaryResource;
            }
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Agency/estates/files/" + l)) break block11;
            BinaryResource binaryResource = ImmoToolDbUtils.createBinaryResource((Collection)collection, (String)string);
            ImmoToolDbUtils.close((Collection)collection2);
            return binaryResource;
        }
        try {
            try {
                throw new ImmoToolDbException("wrong collection provided!");
            }
            catch (ImmoToolDbException immoToolDbException) {
                throw immoToolDbException;
            }
            catch (Exception exception) {
                throw new ImmoToolDbException(exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            ImmoToolDbUtils.close(collection2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File loadAttachmentAsTempFile(long l, String string) throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/estates/files");
            File file = AgencyEstate.loadAttachmentAsTempFile(l, string, collection);
            return file;
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static File loadAttachmentAsTempFile(long l, String string, Collection collection) throws ImmoToolDbException {
        File file = null;
        try {
            file = File.createTempFile("attachment.", ".tmp");
            FileUtils.forceDeleteOnExit((File)file);
            AgencyEstate.loadAttachmentIntoFile(file, l, string, collection);
            return file;
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Can't store attachment into temp-file!");
            LOGGER.error((Object)("> " + file.getAbsolutePath()));
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            FileUtils.deleteQuietly((File)file);
            throw new ImmoToolDbException("Can't store attachment temporarily!", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadAttachmentIntoFile(File file, long l, String string) throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/estates/files");
            AgencyEstate.loadAttachmentIntoFile(file, l, string, collection);
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static void loadAttachmentIntoFile(File file, long l, String string, Collection collection) throws ImmoToolDbException {
        BinaryResource binaryResource = AgencyEstate.loadAttachment(l, string, collection);
        if (binaryResource == null) {
            return;
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            IOUtils.write((byte[])((byte[])binaryResource.getContent()), (OutputStream)fileOutputStream);
        }
        catch (Exception exception) {
            try {
                LOGGER.error((Object)"Can't store attachment into file!");
                LOGGER.error((Object)("> " + file.getAbsolutePath()));
                LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                throw new ImmoToolDbException("Can't store attachment into file!", (Throwable)exception);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileOutputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)fileOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AgencyEstate loadEstate(long l) throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/estates");
            AgencyEstate agencyEstate = AgencyEstate.loadEstate(l, collection);
            return agencyEstate;
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static AgencyEstate loadEstate(long l, Collection collection) throws ImmoToolDbException {
        if (collection == null) {
            throw new ImmoToolDbException("no collection provided!");
        }
        try {
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Agency/estates")) {
                throw new ImmoToolDbException("wrong collection provided!");
            }
            String string = "Estate." + l + ".xml";
            if (!ImmoToolDbUtils.hasResource((Collection)collection, (String)string)) {
                return null;
            }
            XMLResource xMLResource = ImmoToolDbUtils.loadXMLResource((Collection)collection, (String)string);
            if (xMLResource == null) {
                throw new Exception("estate-resource #" + l + " not found!");
            }
            return new AgencyEstate(OpenEstateUtils.loadDocumentFromXmlString((String)xMLResource.getContent().toString()));
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException("Estate-Error: " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AgencyEstate loadEstateByCustomValue(String string, String string2) throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/estates");
            AgencyEstate agencyEstate = AgencyEstate.loadEstateByCustomValue(string, string2, collection);
            return agencyEstate;
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static AgencyEstate loadEstateByCustomValue(String string, String string2, Collection collection) throws ImmoToolDbException {
        if (collection == null) {
            throw new ImmoToolDbException("no collection provided!");
        }
        try {
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Agency/estates")) {
                throw new ImmoToolDbException("wrong collection provided!");
            }
            String string3 = "declare namespace xmldb=\"http://exist-db.org/xquery/xmldb\";\ndeclare namespace openestate=\"http://www.openestate.org/1.0/\";\nfor $x in xmldb:xcollection('ImmoTool/OpenEstate-Agency/estates')/openestate:Estate\nwhere ($x/openestate:CustomValues/openestate:CustomValue[@Key='" + StringEscapeUtils.escapeSql((String)string) + "']/openestate:String/text()='" + StringEscapeUtils.escapeSql((String)string2) + "')\n" + "return $x";
            ResourceSet resourceSet = ImmoToolDbUtils.executeXQuery((Collection)collection, (String)string3);
            if (resourceSet.getSize() <= 0L) {
                return null;
            }
            XMLResource xMLResource = (XMLResource)resourceSet.getResource(0L);
            return new AgencyEstate(OpenEstateUtils.loadDocumentFromXmlString((String)xMLResource.getContent().toString()));
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException("Estate-Error: " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public static AgencyEstate loadEstateByNrIntern(String string) throws ImmoToolDbException {
        return AgencyEstate.loadEstateByCustomValue(VALUE_NR_INTERN, string);
    }

    public static AgencyEstate loadEstateByNrIntern(String string, Collection collection) throws ImmoToolDbException {
        return AgencyEstate.loadEstateByCustomValue(VALUE_NR_INTERN, string, collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AgencyEstate loadEstateByPublicId(String string) throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/estates");
            AgencyEstate agencyEstate = AgencyEstate.loadEstateByPublicId(string, collection);
            return agencyEstate;
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static AgencyEstate loadEstateByPublicId(String string, Collection collection) throws ImmoToolDbException {
        if (collection == null) {
            throw new ImmoToolDbException("no collection provided!");
        }
        try {
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Agency/estates")) {
                throw new ImmoToolDbException("wrong collection provided!");
            }
            String string2 = "declare namespace xmldb=\"http://exist-db.org/xquery/xmldb\";\ndeclare namespace openestate=\"http://www.openestate.org/1.0/\";\nfor $x in xmldb:xcollection('ImmoTool/OpenEstate-Agency/estates')/openestate:Estate\nwhere ($x/@PublicId='" + StringEscapeUtils.escapeSql((String)string) + "')\n" + "return $x";
            ResourceSet resourceSet = ImmoToolDbUtils.executeXQuery((Collection)collection, (String)string2);
            if (resourceSet.getSize() <= 0L) {
                return AgencyEstate.loadEstateByCustomValue(VALUE_NR, string, collection);
            }
            XMLResource xMLResource = (XMLResource)resourceSet.getResource(0L);
            return new AgencyEstate(OpenEstateUtils.loadDocumentFromXmlString((String)xMLResource.getContent().toString()));
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException("Estate-Error: " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Row[] loadEstateRows(Long[] longArray, String string, String string2) throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/estates");
            Row[] rowArray = AgencyEstate.loadEstateRows(longArray, string, string2, collection);
            return rowArray;
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static Row[] loadEstateRows(Long[] longArray, String string, String string2, Collection collection) throws ImmoToolDbException {
        if (collection == null) {
            throw new ImmoToolDbException("no collection provided!");
        }
        try {
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Agency/estates")) {
                throw new ImmoToolDbException("wrong collection provided!");
            }
            String string3 = Locale.getDefault().getLanguage();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            ArrayList<Row> arrayList = new ArrayList<Row>();
            int n = longArray != null && longArray.length > 0 ? (int)Math.ceil((double)longArray.length / 100.0) : 1;
            for (int i = 0; i < n; ++i) {
                StringBuilder stringBuilder;
                String string4 = "declare namespace xmldb=\"http://exist-db.org/xquery/xmldb\";\ndeclare namespace util=\"http://exist-db.org/xquery/util\";\ndeclare namespace openestate=\"http://www.openestate.org/1.0/\";\nfor $x in xmldb:xcollection('ImmoTool/OpenEstate-Agency/estates')/openestate:Estate\n";
                string4 = string4 + "let $id := $x/@Id\n";
                string4 = string4 + "let $publicId := $x/@PublicId\n";
                string4 = string4 + "let $action := local-name($x/*/openestate:Action/*[1])\n";
                string4 = string4 + "let $type := local-name($x/*/openestate:Action/..)\n";
                string4 = string4 + "let $adressCity := $x/openestate:Adress/@City\n";
                string4 = string4 + "let $adressCityPart := $x/openestate:Adress/@CityPart\n";
                string4 = string4 + "let $adressCountry := $x/openestate:Adress/@Country\n";
                string4 = string4 + "let $adressPostalCode := $x/openestate:Adress/@PostalCode\n";
                string4 = string4 + "let $adressStreet := $x/openestate:Adress/@Street\n";
                string4 = string4 + "let $adressStreetNr := $x/openestate:Adress/@StreetNr\n";
                string4 = string4 + "let $areaGesamt := $x/*/openestate:Attributes/openestate:Flaechen_Gesamtflaeche/text()\n";
                string4 = string4 + "let $areaWohnen := $x/*/openestate:Attributes/openestate:Flaechen_Wohnflaeche/text()\n";
                string4 = string4 + "let $areaGrund := $x/*/openestate:Attributes/openestate:Flaechen_Grundstuecksflaeche/text()\n";
                string4 = string4 + "let $areaGewerbe := $x/*/openestate:Attributes/openestate:Flaechen_Gewerbeflaeche/text()\n";
                string4 = string4 + "let $areaParken := $x/*/openestate:Attributes/openestate:Flaechen_Stellplatzflaeche/text()\n";
                string4 = string4 + "let $priceKauf := $x/*/openestate:Action/openestate:Kauf/openestate:Preise_Kaufpreis/text()\n";
                string4 = string4 + "let $priceMiete := $x/*/openestate:Action/openestate:Miete/openestate:Preise_Kaltmiete/text()\n";
                string4 = string4 + "let $priceWaz := $x/*/openestate:Action/openestate:Waz/openestate:Preise_Pauschalmiete/text()\n";
                string4 = string4 + "let $pricePacht := $x/*/openestate:Action/openestate:Pacht/openestate:Preise_Pacht/text()\n";
                string4 = string4 + "let $priceErbpacht := $x/*/openestate:Action/openestate:Erbpacht/openestate:Preise_ErbpachtZins/text()\n";
                string4 = string4 + "let $konventioniert := $x/*/openestate:Attributes/openestate:Preise_Konventioniert/text()\n";
                string4 = string4 + "let $rooms := $x/*/openestate:Attributes/openestate:Flaechen_AnzZimmer/text()\n";
                string4 = string4 + "let $title := $x/openestate:Title/openestate:Text[@Language='" + string3 + "']/text()\n";
                string4 = string4 + "let $title_old := $x/@Title\n";
                string4 = string4 + "let $status := $x/openestate:CustomValues/openestate:CustomValue[@Key='status']/openestate:String/text()\n";
                string4 = string4 + "let $currency := $x/@Currency\n";
                string4 = string4 + "let $changeTime := xmldb:last-modified( util:collection-name($x), util:document-name($x) )\n";
                StringBuilder stringBuilder2 = new StringBuilder();
                if (longArray != null && longArray.length > 0) {
                    stringBuilder = new StringBuilder();
                    int n2 = i * 100;
                    if (longArray.length <= n2) break;
                    for (int j = n2; j < n2 + 100 && j < longArray.length; ++j) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append("\n  or ");
                        }
                        stringBuilder.append("$x/@Id='Estate.").append(longArray[j]).append("'");
                    }
                    stringBuilder2.append("(").append(stringBuilder.toString()).append(")");
                }
                if (string != null && string.trim().length() > 0) {
                    if (stringBuilder2.length() > 0) {
                        stringBuilder2.append("\n  and ");
                    }
                    stringBuilder2.append("(").append(string).append(")");
                }
                if (stringBuilder2.length() > 0) {
                    string4 = string4 + "where (" + stringBuilder2.toString() + ")\n";
                }
                if (string2 != null && string2.trim().length() > 0) {
                    string4 = string4 + "order by " + string2 + "\n";
                }
                if ((stringBuilder = ImmoToolDbUtils.executeXQuery((Collection)collection, (String)(string4 = string4 + "return <row id=\"{$id}\" publicId=\"{$publicId}\" action=\"{$action}\" type=\"{$type}\" adressCity=\"{$adressCity}\" adressCityPart=\"{$adressCityPart}\" adressCountry=\"{$adressCountry}\" adressPostalCode=\"{$adressPostalCode}\" adressStreet=\"{$adressStreet}\" adressStreetNr=\"{$adressStreetNr}\" areaGesamt=\"{$areaGesamt}\" areaWohnen=\"{$areaWohnen}\" areaGrund=\"{$areaGrund}\" areaGewerbe=\"{$areaGewerbe}\" areaParken=\"{$areaParken}\" priceKauf=\"{$priceKauf}\" priceMiete=\"{$priceMiete}\" priceWaz=\"{$priceWaz}\" pricePacht=\"{$pricePacht}\" priceErbpacht=\"{$priceErbpacht}\" rooms=\"{$rooms}\" konventioniert=\"{$konventioniert}\" title=\"{$title}\" title_old=\"{$title_old}\" status=\"{$status}\" currency=\"{$currency}\" changeTime=\"{$changeTime}\" />"))).getSize() <= 0L) continue;
                for (long j = 0L; j < stringBuilder.getSize(); ++j) {
                    List<String> list;
                    String string5;
                    Object object;
                    XMLResource xMLResource = (XMLResource)stringBuilder.getResource(j);
                    Node node = xMLResource.getContentAsDOM();
                    Row row = new Row();
                    try {
                        object = node.getAttributes().getNamedItem("id").getNodeValue().split("\\.");
                        row.id = object != null && ((String[])object).length > 1 ? Long.valueOf(object[1]) : 0L;
                    }
                    catch (Exception exception) {
                        LOGGER.warn((Object)"could not extract estate-id!");
                        LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    }
                    row.action = OpenEstateUtils.makeUnCamelCase((String)node.getAttributes().getNamedItem("action").getNodeValue());
                    row.adressCity = node.getAttributes().getNamedItem("adressCity").getNodeValue();
                    row.adressCityPart = node.getAttributes().getNamedItem("adressCityPart").getNodeValue();
                    row.adressCountry = node.getAttributes().getNamedItem("adressCountry").getNodeValue();
                    row.adressPostalCode = node.getAttributes().getNamedItem("adressPostalCode").getNodeValue();
                    row.adressStreet = node.getAttributes().getNamedItem("adressStreet").getNodeValue();
                    row.adressStreetNr = node.getAttributes().getNamedItem("adressStreetNr").getNodeValue();
                    row.publicId = node.getAttributes().getNamedItem("publicId").getNodeValue();
                    row.title = node.getAttributes().getNamedItem("title").getNodeValue();
                    if (row.title == null || row.title.trim().length() == 0) {
                        row.title = node.getAttributes().getNamedItem("title_old").getNodeValue();
                    }
                    row.type = OpenEstateUtils.makeUnCamelCase((String)node.getAttributes().getNamedItem("type").getNodeValue());
                    row.status = node.getAttributes().getNamedItem(VALUE_STATUS).getNodeValue();
                    row.attribKonventioniert = node.getAttributes().getNamedItem("konventioniert").getNodeValue();
                    object = node.getAttributes().getNamedItem("currency").getNodeValue();
                    if (object != null && ((String)object).trim().length() > 0) {
                        try {
                            row.currency = Currency.getInstance(((String)object).trim());
                        }
                        catch (Exception exception) {
                            row.currency = null;
                            LOGGER.warn((Object)("Can't read currency for estate #" + row.id));
                            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                        }
                    }
                    if ((string5 = node.getAttributes().getNamedItem("rooms").getNodeValue()) != null && string5.trim().length() > 0) {
                        try {
                            row.attribRooms = Float.valueOf(string5.trim());
                        }
                        catch (Exception exception) {
                            row.attribRooms = null;
                            LOGGER.warn((Object)("Can't read rooms for estate #" + row.id));
                            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                        }
                    }
                    String string6 = null;
                    if ("KAUF".equals(row.action)) {
                        string6 = node.getAttributes().getNamedItem("priceKauf").getNodeValue();
                    } else if ("MIETE".equals(row.action)) {
                        string6 = node.getAttributes().getNamedItem("priceMiete").getNodeValue();
                    } else if ("WAZ".equals(row.action)) {
                        string6 = node.getAttributes().getNamedItem("priceWaz").getNodeValue();
                    } else if ("PACHT".equals(row.action)) {
                        string6 = node.getAttributes().getNamedItem("pricePacht").getNodeValue();
                    } else if ("ERBPACHT".equals(row.action)) {
                        string6 = node.getAttributes().getNamedItem("priceErbpacht").getNodeValue();
                    }
                    if (string6 != null && string6.trim().length() > 0) {
                        try {
                            row.attribPrice = Float.valueOf(string6.trim());
                        }
                        catch (Exception exception) {
                            row.attribPrice = null;
                            LOGGER.warn((Object)("Can't read price for estate #" + row.id));
                            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                        }
                    }
                    String string7 = null;
                    OpenEstateType openEstateType = OpenEstateType.newInstance((String)row.type);
                    if (openEstateType != null) {
                        list = Arrays.asList(OpenEstateUtils.getEstateTypePath((OpenEstateType)openEstateType));
                        if (list.contains("MAIN_GEWERBE")) {
                            string7 = node.getAttributes().getNamedItem("areaGewerbe").getNodeValue();
                        } else if (list.contains("MAIN_GRUND")) {
                            string7 = node.getAttributes().getNamedItem("areaGrund").getNodeValue();
                        } else if (list.contains("MAIN_LANDWIRTSCHAFT")) {
                            string7 = node.getAttributes().getNamedItem("areaGesamt").getNodeValue();
                        } else if (list.contains("MAIN_STELLPLATZ")) {
                            string7 = node.getAttributes().getNamedItem("areaParken").getNodeValue();
                        } else if (list.contains("MAIN_WOHNEN")) {
                            string7 = node.getAttributes().getNamedItem("areaWohnen").getNodeValue();
                        }
                        if (string7 == null || string7.trim().length() == 0) {
                            string7 = node.getAttributes().getNamedItem("areaGesamt").getNodeValue();
                        }
                    }
                    if (string7 != null && string7.trim().length() > 0) {
                        try {
                            row.attribArea = Float.valueOf(string7.trim());
                        }
                        catch (Exception exception) {
                            row.attribArea = null;
                            LOGGER.warn((Object)("Can't read area for estate #" + row.id));
                            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                        }
                    }
                    if ((list = node.getAttributes().getNamedItem("changeTime").getNodeValue()) != null && ((String)((Object)list)).trim().length() > 0) {
                        int n3 = ((String)((Object)list)).lastIndexOf(":");
                        if (n3 > 0) {
                            list = ((String)((Object)list)).substring(0, n3) + ((String)((Object)list)).substring(n3 + 1);
                        }
                        try {
                            row.changeTime = simpleDateFormat.parse((String)((Object)list));
                        }
                        catch (Exception exception) {
                            row.changeTime = null;
                            LOGGER.warn((Object)("Can't parse date: " + exception.getLocalizedMessage()));
                        }
                    }
                    arrayList.add(row);
                }
            }
            return arrayList.toArray(new Row[arrayList.size()]);
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException("Estate-Error: " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AgencyEstate[] loadEstates() throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/estates");
            AgencyEstate[] agencyEstateArray = AgencyEstate.loadEstates(collection);
            return agencyEstateArray;
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static AgencyEstate[] loadEstates(Collection collection) throws ImmoToolDbException {
        try {
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Agency/estates")) {
                throw new ImmoToolDbException("wrong collection provided!");
            }
            ArrayList<AgencyEstate> arrayList = new ArrayList<AgencyEstate>();
            for (String string : collection.listResources()) {
                String[] stringArray = string.split("\\.");
                if (stringArray.length != 3 || !stringArray[0].equals("Estate") || !stringArray[2].equals("xml")) continue;
                AgencyEstate agencyEstate = AgencyEstate.loadEstate(Long.valueOf(stringArray[1]), collection);
                if (agencyEstate == null) {
                    LOGGER.warn((Object)("could not load estate from " + string));
                    continue;
                }
                arrayList.add(agencyEstate);
            }
            return arrayList.toArray(new AgencyEstate[arrayList.size()]);
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long[] loadEstateIds() throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/estates");
            Long[] longArray = AgencyEstate.loadEstateIds(collection);
            return longArray;
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static Long[] loadEstateIds(Collection collection) throws ImmoToolDbException {
        try {
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Agency/estates")) {
                throw new ImmoToolDbException("wrong collection provided!");
            }
            ArrayList<Long> arrayList = new ArrayList<Long>();
            for (String string : collection.listResources()) {
                String[] stringArray = string.split("\\.");
                if (stringArray.length != 3 || !stringArray[0].equals("Estate") || !stringArray[2].equals("xml")) continue;
                arrayList.add(Long.valueOf(stringArray[1]));
            }
            return arrayList.toArray(new Long[arrayList.size()]);
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public void readFromXml(Element element) throws DocumentException {
        super.readFromXml(element);
        if (this.getCustomValues().hasCustomValue(VALUE_NR)) {
            this.setPublicId(this.getCustomValues().getCustomValue(VALUE_NR).getString());
            this.getCustomValues().getValueMap().remove(VALUE_NR);
        }
        if (this.getCustomValues().hasCustomValue(VALUE_KEYWORDS)) {
            String string = "FREITEXTE.KEYWORDS";
            OpenEstateAttrib openEstateAttrib = OpenEstateUtils.getAvailableAttribute((String)string);
            ValueImpl valueImpl = openEstateAttrib.createValue();
            if (this.getLanguages().isEmpty()) {
                valueImpl.setValue((Object)this.getCustomValues().getCustomValue(VALUE_KEYWORDS).getString(), new Locale("de"));
            } else {
                for (String string2 : this.getLanguages()) {
                    valueImpl.setValue((Object)this.getCustomValues().getCustomValue(VALUE_KEYWORDS).getString(), new Locale(string2));
                }
            }
            this.putAttribute(openEstateAttrib, valueImpl);
            this.getCustomValues().getValueMap().remove(VALUE_KEYWORDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeEstate(long l) throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/estates");
            AgencyEstate.removeEstate(l, collection);
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static void removeEstate(long l, Collection collection) throws ImmoToolDbException {
        if (collection == null) {
            throw new ImmoToolDbException("no collection provided!");
        }
        try {
            Object object;
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Agency/estates")) {
                throw new ImmoToolDbException("wrong collection provided!");
            }
            String string = "Estate." + l + ".xml";
            if (!ImmoToolDbUtils.hasResource((Collection)collection, (String)string)) {
                throw new Exception(string + " not found!");
            }
            Collection collection2 = AgencyPluginUtils.openPluginCollection("/estates/files/" + l);
            if (collection2 != null) {
                collection2.close();
                object = "ImmoTool/OpenEstate-Agency/estates/files/" + l;
                ImmoToolApp.getApplication().getDatabase().removeCollection((String)object);
            }
            object = ImmoToolDbUtils.loadXMLResource((Collection)collection, (String)string);
            ImmoToolDbUtils.removeResource((Collection)collection, (Resource)object);
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException("Estate-Error: " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeUnusedAttachments(AgencyEstate agencyEstate) throws ImmoToolDbException {
        Collection collection;
        block3: {
            collection = null;
            try {
                String[] stringArray = agencyEstate.getId().split("\\.");
                collection = AgencyPluginUtils.openPluginCollection("/estates/files/" + stringArray[stringArray.length - 1]);
                if (collection != null) break block3;
            }
            catch (Throwable throwable) {
                ImmoToolDbUtils.close(collection);
                throw throwable;
            }
            ImmoToolDbUtils.close((Collection)collection);
            return;
        }
        AgencyEstate.removeUnusedAttachments(agencyEstate, collection);
        ImmoToolDbUtils.close((Collection)collection);
    }

    public static void removeUnusedAttachments(AgencyEstate agencyEstate, Collection collection) throws ImmoToolDbException {
        try {
            String[] stringArray = agencyEstate.getId().split("\\.");
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Agency/estates/files/" + stringArray[stringArray.length - 1])) {
                throw new ImmoToolDbException("wrong collection provided!");
            }
            HashMap<String, EstateAttachmentImpl> hashMap = new HashMap<String, EstateAttachmentImpl>();
            for (EstateAttachmentImpl estateAttachmentImpl : agencyEstate.getAttachments()) {
                if (!estateAttachmentImpl.isName()) continue;
                hashMap.put(estateAttachmentImpl.getFileAsName(), estateAttachmentImpl);
            }
            for (String string : collection.listResources()) {
                if (hashMap.containsKey(string)) continue;
                Resource resource = collection.getResource(string);
                ImmoToolDbUtils.removeResource((Collection)collection, (Resource)resource);
            }
            boolean bl = false;
            for (Map.Entry entry : hashMap.entrySet()) {
                if (ImmoToolDbUtils.hasResource((Collection)collection, (String)((String)entry.getKey()))) continue;
                bl = true;
                agencyEstate.getAttachments().remove(entry.getValue());
            }
            if (bl) {
                AgencyEstate.storeEstate(agencyEstate);
            }
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public void setExportAlways(Boolean bl) {
        this.getCustomValues().putCustomValue(VALUE_EXPORT_ALWAYS, (Object)bl, 0);
    }

    public void setExportEnabled(Boolean bl) {
        this.getCustomValues().putCustomValue(VALUE_EXPORT_ENABLED, (Object)bl, 0);
    }

    public void setExportInterfaces(List<Long> list) {
        if (list == null) {
            this.setExportInterfaces((Long[])null);
        } else {
            this.setExportInterfaces(list.toArray(new Long[list.size()]));
        }
    }

    public void setExportInterfaces(Long[] longArray) {
        String[] stringArray;
        for (String string : stringArray = this.getCustomValues().getValueMap().keySet().toArray(new String[this.getCustomValues().getValueMap().size()])) {
            if (!string.startsWith("export.interface.")) continue;
            this.getCustomValues().putCustomValue(string, null, 4);
        }
        if (longArray == null) {
            return;
        }
        for (int i = 0; i < longArray.length; ++i) {
            this.getCustomValues().putCustomValue("export.interface." + (i + 1), (Object)BigInteger.valueOf(longArray[i]), 4);
        }
    }

    public void setGeoDbIds(String string, String[] stringArray) {
        String[] stringArray2;
        String string2 = "geodb." + string;
        for (String string3 : stringArray2 = this.getCustomValues().getValueMap().keySet().toArray(new String[this.getCustomValues().getValueMap().size()])) {
            if (!string3.startsWith(string2 + ".")) continue;
            this.getCustomValues().getValueMap().remove(string3);
        }
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.getCustomValues().putCustomValue(string2 + "." + i, (Object)stringArray[i], 5);
        }
    }

    public void setGroupNr(Long l) {
        this.getCustomValues().putCustomValue(VALUE_GROUP, (Object)(l != null ? BigInteger.valueOf(l) : null), 4);
    }

    public void setNotes(String string) {
        this.getCustomValues().putCustomValue(VALUE_NOTES, (Object)string, 6);
    }

    @Deprecated
    public void setNr(String string) {
        this.setPublicId(string);
    }

    public void setNrIntern(String string) {
        this.getCustomValues().putCustomValue(VALUE_NR_INTERN, (Object)string, 5);
    }

    public void setStatus(String string) {
        this.getCustomValues().putCustomValue(VALUE_STATUS, (Object)string, 5);
    }

    public Long store() throws ImmoToolDbException {
        return AgencyEstate.storeEstate(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String storeAttachment(long l, InputStream inputStream, String string, String string2) throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/estates/files");
            String string3 = AgencyEstate.storeAttachment(l, inputStream, string, string2, collection);
            return string3;
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String storeAttachment(long l, InputStream inputStream, String string, String string2, Collection collection) throws ImmoToolDbException {
        String string3;
        if (collection == null) {
            throw new ImmoToolDbException("no collection provided!");
        }
        ImmoToolApp immoToolApp = ImmoToolApp.getApplication();
        Collection collection2 = null;
        try {
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Agency/estates/files")) {
                throw new ImmoToolDbException("wrong collection provided!");
            }
            collection2 = collection.getChildCollection(String.valueOf(l));
            if (collection2 == null) {
                collection2 = immoToolApp.getDatabase().createCollection(collection.getName() + "/" + l);
            }
            String string4 = string;
            string4 = string4.replaceAll("[^\\w\\-\\.]", "_");
            while (string4.contains("__")) {
                string4 = string4.replace("__", "_");
            }
            String string5 = l + "/" + string4;
            BinaryResource binaryResource = null;
            binaryResource = !ImmoToolDbUtils.hasResource((Collection)collection2, (String)string5) ? ImmoToolDbUtils.createBinaryResource((Collection)collection2, (String)string5) : ImmoToolDbUtils.loadBinaryResource((Collection)collection2, (String)string5);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            byte[] byArray = new byte[1024];
            int n = 0;
            while ((n = bufferedInputStream.read(byArray, 0, byArray.length)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byteArrayOutputStream.flush();
            bufferedInputStream.close();
            binaryResource.setContent((Object)byteArrayOutputStream.toByteArray());
            ((EXistResource)binaryResource).setMimeType(string2);
            ImmoToolDbUtils.storeResource((Collection)collection2, (Resource)binaryResource);
            string3 = string4;
        }
        catch (ImmoToolDbException immoToolDbException) {
            try {
                throw immoToolDbException;
                catch (Exception exception) {
                    throw new ImmoToolDbException("Attachment-Error: " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
            catch (Throwable throwable) {
                ImmoToolDbUtils.close(collection2);
                throw throwable;
            }
        }
        ImmoToolDbUtils.close((Collection)collection2);
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long storeEstate(AgencyEstate agencyEstate) throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/estates");
            Long l = AgencyEstate.storeEstate(agencyEstate, collection);
            return l;
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static Long storeEstate(AgencyEstate agencyEstate, Collection collection) throws ImmoToolDbException {
        if (collection == null) {
            throw new ImmoToolDbException("no collection provided!");
        }
        ImmoToolApp immoToolApp = ImmoToolApp.getApplication();
        try {
            Object object;
            String string;
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Agency/estates")) {
                throw new ImmoToolDbException("wrong collection provided!");
            }
            String string2 = string = agencyEstate.getPublicId() != null ? agencyEstate.getPublicId().trim() : "";
            if (string.length() > 0 && (object = AgencyEstate.loadEstateByPublicId(string, collection)) != null && !object.getId().equals(agencyEstate.getId())) {
                throw new ImmoToolDbException(ImmoToolUtils.getResourceMap(AgencyEstate.class).getString("error.externalNrAlreadyUsed", new Object[]{string}));
            }
            String string3 = string = agencyEstate.getNrIntern() != null ? agencyEstate.getNrIntern().trim() : "";
            if (string.length() > 0 && (object = AgencyEstate.loadEstateByNrIntern(string, collection)) != null && !object.getId().equals(agencyEstate.getId())) {
                throw new ImmoToolDbException(ImmoToolUtils.getResourceMap(AgencyEstate.class).getString("error.internalNrAlreadyUsed", new Object[]{string}));
            }
            if (agencyEstate.getId() == null || !agencyEstate.getId().startsWith("Estate.")) {
                object = immoToolApp.getDatabase().getNextSequence("OpenEstate-Agency.Estate");
                agencyEstate.setId("Estate." + (Object)object);
            }
            object = agencyEstate.getId() + ".xml";
            XMLResource xMLResource = null;
            xMLResource = !ImmoToolDbUtils.hasResource((Collection)collection, (String)object) ? ImmoToolDbUtils.createXmlResource((Collection)collection, (String)object) : ImmoToolDbUtils.loadXMLResource((Collection)collection, (String)object);
            StringWriter stringWriter = new StringWriter();
            OpenEstateUtils.serializeToXML((SerializableXmlElement)agencyEstate, (Writer)stringWriter, (boolean)false);
            xMLResource.setContent((Object)stringWriter.toString());
            ImmoToolDbUtils.storeResource((Collection)collection, (Resource)xMLResource);
            return agencyEstate.getIdNr();
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public String writeStatus() {
        return AgencyEstate.writeStatus(this.getStatus());
    }

    public static String writeStatus(String string) {
        if (STATUS_ENTWURF.equals(string)) {
            return ImmoToolUtils.getResourceMap(AgencyEstate.class).getString("status.inDraft", new Object[0]);
        }
        if (STATUS_PRUEFUNG.equals(string)) {
            return ImmoToolUtils.getResourceMap(AgencyEstate.class).getString("status.inReview", new Object[0]);
        }
        if (STATUS_VERMITTLUNG.equals(string)) {
            return ImmoToolUtils.getResourceMap(AgencyEstate.class).getString("status.isPublished", new Object[0]);
        }
        if (STATUS_VERMITTELT.equals(string)) {
            return ImmoToolUtils.getResourceMap(AgencyEstate.class).getString("status.isPublishedWithSuccess", new Object[0]);
        }
        if (STATUS_NICHT_VERMITTELT.equals(string)) {
            return ImmoToolUtils.getResourceMap(AgencyEstate.class).getString("status.isPublishedWithoutSuccess", new Object[0]);
        }
        if (STATUS_ABLAGE.equals(string)) {
            return ImmoToolUtils.getResourceMap(AgencyEstate.class).getString("status.inTray", new Object[0]);
        }
        return "";
    }

    public String writeValue(ValueImpl valueImpl, Locale locale) {
        String string = null;
        if ("VERWALTUNG".equals(valueImpl.getGroupName()) && "VERFUEGBAR_ABDATE".equals(valueImpl.getAttribName())) {
            long l = -1L;
            Object object = valueImpl.getValueObject();
            if (object instanceof Date) {
                l = ((Date)object).getTime();
            } else if (object instanceof Calendar) {
                l = ((Calendar)object).getTimeInMillis();
            } else if (object instanceof Number) {
                l = ((Number)object).longValue();
            }
            if (l > -1L && l <= System.currentTimeMillis()) {
                string = OpenEstateUtils.translateConst((String)"FROM_NOW_ON", (Locale)locale);
            }
        }
        if (this.isHiddenPrices()) {
            String string2 = valueImpl.getAttribName();
            if ("PREISE".equals(valueImpl.getGroupName()) && ("KALTMIETE".equals(string2) || "KALTMIETE_NETTO".equals(string2) || "KALTMIETE_QM".equals(string2) || "KAUFPREIS".equals(string2) || "KAUFPREIS_QM".equals(string2) || "PACHT".equals(string2) || "PACHT_QM".equals(string2) || "PAUSCHALMIETE".equals(string2) || "WARMMIETE".equals(string2) || "WARMMIETE_QM".equals(string2) || "UNKONVENTIONIERTER_PREIS".equals(string2))) {
                string = OpenEstateUtils.translateConst((String)"ON_REQUEST", (Locale)locale);
            }
            if ("FREITEXTE".equals(valueImpl.getGroupName()) && "PREIS_BESCHR".equals(string2)) {
                return null;
            }
        }
        return StringUtils.isBlank(string) ? valueImpl.writeValue(locale, this.getCurrency()) : string.trim();
    }

    public static class Row {
        public long id = 0L;
        public String publicId = null;
        public String title = null;
        public String type = null;
        public String action = null;
        public String status = null;
        public String adressStreet = null;
        public String adressStreetNr = null;
        public String adressPostalCode = null;
        public String adressCity = null;
        public String adressCityPart = null;
        public String adressCountry = null;
        public Number attribPrice = null;
        public Number attribArea = null;
        public Number attribRooms = null;
        public String attribKonventioniert = null;
        public Date changeTime = null;
        public Currency currency = null;

        public String writeAction() {
            if (this.action == null) {
                return null;
            }
            String string = OpenEstateUtils.translateAction((String)this.action);
            return string != null && string.trim().length() > 0 ? string : this.action;
        }

        public String writeCountry() {
            if (this.adressCountry == null) {
                return null;
            }
            String string = SimpleAdressImpl.writeCountry((String)this.adressCountry);
            return string != null && string.trim().length() > 0 ? string : this.adressCountry;
        }

        public String writeToolTip() {
            String string = "<h2 style=\"margin:0;\">" + ImmoToolUtils.getResourceMap(AgencyEstate.class).getString("tooltip.head", new Object[]{this.id}) + "</h2>";
            if (this.publicId != null && this.publicId.trim().length() > 0) {
                string = string + "<b>" + this.publicId + "</b>";
            }
            String string2 = "";
            if (this.title != null) {
                string2 = string2 + "<i>" + StringEscapeUtils.escapeHtml((String)this.title) + "</i>";
            }
            if (this.type != null || this.action != null) {
                string2 = string2 + "<br>";
                if (this.type != null) {
                    string2 = string2 + "<i>" + this.writeType() + "</i>";
                }
                if (this.action != null) {
                    if (this.type != null) {
                        string2 = string2 + " / ";
                    }
                    string2 = string2 + "<i>" + this.writeAction() + "</i>";
                }
            }
            if (string2.length() > 0) {
                string = string + "<hr>" + string2;
            }
            string2 = "";
            if (this.adressStreet != null) {
                string2 = this.adressStreet;
                if (this.adressStreetNr != null) {
                    string2 = string2 + " " + this.adressStreetNr;
                }
            }
            if (this.adressPostalCode != null || this.adressCity != null) {
                if (string2.length() > 0) {
                    string2 = string2 + "<br>";
                }
                if (this.adressPostalCode != null) {
                    string2 = string2 + this.adressPostalCode;
                }
                if (this.adressCity != null) {
                    if (this.adressPostalCode != null) {
                        string2 = string2 + " ";
                    }
                    string2 = string2 + this.adressCity;
                }
                if (this.adressCityPart != null) {
                    if (this.adressPostalCode != null || this.adressCity != null) {
                        string2 = string2 + " ";
                    }
                    string2 = string2 + this.adressCityPart;
                }
            }
            if (this.adressCountry != null) {
                if (string2.length() > 0) {
                    string2 = string2 + "<br>";
                }
                string2 = string2 + this.writeCountry();
            }
            if (string2.length() > 0) {
                string = string + "<hr>" + string2;
            }
            return "<html><div style=\"margin:5px;\">" + string + "</div></html>";
        }

        public String writeType() {
            if (this.type == null) {
                return null;
            }
            String string = OpenEstateUtils.translateEstate((String)this.type);
            return string != null && string.trim().length() > 0 ? string : this.type;
        }
    }
}

