/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.tool.ImmoToolDbException;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.AgencyExportList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;

public class AgencyEstateContactTask
extends ImmoToolTask<Boolean> {
    private final Long[] estateIds;
    private final AgencyEstate[] estates;
    private long contactId;

    public AgencyEstateContactTask(Long[] longArray, long l) {
        this.contactId = l;
        this.estates = null;
        this.estateIds = (Long[])ArrayUtils.clone((Object[])longArray);
    }

    public AgencyEstateContactTask(AgencyEstate[] agencyEstateArray, long l) {
        this.contactId = l;
        this.estates = (AgencyEstate[])ArrayUtils.clone((Object[])agencyEstateArray);
        this.estateIds = null;
    }

    private List<AgencyEstate> getEstates() throws ImmoToolDbException {
        ArrayList<AgencyEstate> arrayList = new ArrayList<AgencyEstate>();
        if (this.estates != null) {
            arrayList.addAll(Arrays.asList(this.estates));
        } else if (this.estateIds != null) {
            for (Long l : this.estateIds) {
                AgencyEstate agencyEstate = AgencyEstate.loadEstate(l);
                if (agencyEstate == null) continue;
                arrayList.add(agencyEstate);
            }
        }
        return arrayList;
    }

    protected Boolean executeTask() throws Exception {
        for (AgencyEstate agencyEstate : this.getEstates()) {
            this.setMessage("#" + agencyEstate.getIdNr());
            if (this.contactId > 0L) {
                agencyEstate.setContactId("AgentContact." + this.contactId);
            } else {
                agencyEstate.setContactId(null);
            }
            agencyEstate.store();
            if (!agencyEstate.isExportEnabled() || !"VERMITTLUNG".equalsIgnoreCase(agencyEstate.getStatus())) continue;
            AgencyExportList.registerChanges(agencyEstate, "update");
        }
        return true;
    }

    protected void setContactId(long l) {
        this.contactId = l;
    }
}

