/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.impl.OpenEstateException;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.ValueImpl;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.AgencyEstateExportFields;
import com.openindex.openestate.tool.utils.CsvExportTask;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jdesktop.application.ResourceMap;

public class AgencyEstateExportCsvTask
extends CsvExportTask<AgencyEstate>
implements AgencyEstateExportFields {
    private static final Logger LOGGER = Logger.getLogger(AgencyEstateExportCsvTask.class);
    private final ResourceMap resourceMap = ImmoToolUtils.getResourceMap(AgencyEstateExportCsvTask.class);
    private final String estateAction;
    private final OpenEstateType estateType;
    private final String estateStatus;
    private final Locale locale;
    private final List<String> dynamicFields;
    private int fieldCount;

    public AgencyEstateExportCsvTask(File file, Charset charset, OpenEstateType openEstateType, String string, String string2, Locale locale) {
        super(file, charset);
        this.estateAction = string;
        this.estateType = openEstateType;
        this.estateStatus = string2;
        this.locale = locale;
        this.fieldCount = 15;
        this.dynamicFields = new ArrayList<String>();
        this.setTitle(this.resourceMap.getString("title", new Object[0]));
    }

    protected String getFieldTitle(int n) {
        switch (n) {
            case 4: {
                return this.resourceMap.getString("field.estateAction", new Object[0]);
            }
            case 0: {
                return this.resourceMap.getString("field.estateId", new Object[0]);
            }
            case 1: {
                return this.resourceMap.getString("field.estateNr", new Object[0]);
            }
            case 5: {
                return this.resourceMap.getString("field.estateStatus", new Object[0]);
            }
            case 2: {
                return this.resourceMap.getString("field.estateTitle", new Object[0]);
            }
            case 3: {
                return this.resourceMap.getString("field.estateType", new Object[0]);
            }
            case 9: {
                return this.resourceMap.getString("field.adressCity", new Object[0]);
            }
            case 10: {
                return this.resourceMap.getString("field.adressCityPart", new Object[0]);
            }
            case 11: {
                return this.resourceMap.getString("field.adressCountry", new Object[0]);
            }
            case 13: {
                return this.resourceMap.getString("field.adressLatitude", new Object[0]);
            }
            case 14: {
                return this.resourceMap.getString("field.adressLongitude", new Object[0]);
            }
            case 8: {
                return this.resourceMap.getString("field.adressPostalCode", new Object[0]);
            }
            case 12: {
                return this.resourceMap.getString("field.adressCountryArea", new Object[0]);
            }
            case 6: {
                return this.resourceMap.getString("field.adressStreet", new Object[0]);
            }
            case 7: {
                return this.resourceMap.getString("field.adressStreetNr", new Object[0]);
            }
        }
        if (n >= 15) {
            int n2 = n - 15;
            if (!this.dynamicFields.isEmpty() && n2 >= 0 && this.dynamicFields.size() > n2) {
                String[] stringArray = this.dynamicFields.get(n2).split("\\.");
                return OpenEstateUtils.translateAttribute((String)stringArray[0]) + "-" + OpenEstateUtils.translateAttribute((String)stringArray[0], (String)stringArray[1]);
            }
        }
        return null;
    }

    protected AgencyEstate[] loadCsvObjects() throws ImmoToolException {
        ArrayList<AgencyEstate> arrayList = new ArrayList<AgencyEstate>();
        for (Object object : AgencyEstate.loadEstates()) {
            if (object.getType() == null || object.getAction() == null || this.estateAction != null && !this.estateAction.equalsIgnoreCase(object.getAction()) || this.estateStatus != null && !this.estateStatus.equalsIgnoreCase(object.getStatus())) continue;
            if (this.estateType == null) {
                arrayList.add((AgencyEstate)((Object)object));
                continue;
            }
            if (object.getType().getName().equalsIgnoreCase(this.estateType.getName())) {
                arrayList.add((AgencyEstate)((Object)object));
                continue;
            }
            try {
                String[] stringArray = OpenEstateUtils.getEstateTypePath((OpenEstateType)object.getType());
                if (stringArray == null || !ArrayUtils.contains((Object[])stringArray, (Object)this.estateType.getName())) continue;
                arrayList.add((AgencyEstate)((Object)object));
            }
            catch (OpenEstateException openEstateException) {
                LOGGER.warn((Object)("Can't load parent types for: " + object.getType().getName()));
                LOGGER.warn((Object)("> " + openEstateException.getLocalizedMessage()), (Throwable)openEstateException);
            }
        }
        TreeMap treeMap = new TreeMap();
        HashMap hashMap = new HashMap();
        for (Object object : arrayList) {
            for (Object object2 : object.getAttributes()) {
                String string;
                String string2;
                if (object2.getValueObject() == null || StringUtils.isEmpty((String)(string2 = object2.writeValue(this.locale, object.getCurrency())))) continue;
                String string3 = object2.getGroupName();
                String string4 = object2.getAttribName();
                if (!"FREITEXTE".equals(string3) && !treeMap.containsValue(string3)) {
                    string = OpenEstateUtils.translateAttribute((String)string3);
                    if (StringUtils.isEmpty((String)string)) continue;
                    treeMap.put(string, string3);
                }
                if (!hashMap.containsKey(string3)) {
                    hashMap.put(string3, new TreeMap());
                }
                if (((Map)hashMap.get(string3)).containsValue(string4) || StringUtils.isEmpty((String)(string = OpenEstateUtils.translateAttribute((String)string3, (String)string4)))) continue;
                ((Map)hashMap.get(string3)).put(string, string4);
            }
        }
        this.dynamicFields.clear();
        this.fieldCount = 15;
        for (Object object : treeMap.values()) {
            for (Object object2 : ((Map)hashMap.get(object)).values()) {
                this.dynamicFields.add((String)object + "." + (String)object2);
                ++this.fieldCount;
            }
        }
        if (hashMap.containsKey("FREITEXTE")) {
            for (Object object : ((Map)hashMap.get("FREITEXTE")).values()) {
                this.dynamicFields.add("FREITEXTE." + (String)object);
                ++this.fieldCount;
            }
        }
        return arrayList.toArray(new AgencyEstate[arrayList.size()]);
    }

    protected String[] loadEmptyContainer() {
        return new String[this.fieldCount];
    }

    protected void writeValues(AgencyEstate agencyEstate, String[] stringArray) {
        stringArray[4] = OpenEstateUtils.translateAction((String)agencyEstate.getAction(), (Locale)this.locale);
        if (agencyEstate.getIdNr() > 0L) {
            stringArray[0] = String.valueOf(agencyEstate.getIdNr());
        }
        stringArray[1] = agencyEstate.getPublicId();
        stringArray[5] = agencyEstate.writeStatus();
        stringArray[2] = agencyEstate.getTitle(this.locale);
        stringArray[3] = OpenEstateUtils.translateEstate((String)agencyEstate.getType().getName(), (Locale)this.locale);
        stringArray[9] = agencyEstate.getAdress().getCity();
        stringArray[10] = agencyEstate.getAdress().getCityPart();
        stringArray[11] = agencyEstate.getAdress().getCountry();
        if (agencyEstate.getAdress().getLatitude() != null) {
            stringArray[13] = agencyEstate.getAdress().getLatitude().toString();
        }
        if (agencyEstate.getAdress().getLongitude() != null) {
            stringArray[14] = agencyEstate.getAdress().getLongitude().toString();
        }
        stringArray[8] = agencyEstate.getAdress().getPostalCode();
        stringArray[12] = agencyEstate.getAdress().getRegion();
        stringArray[6] = agencyEstate.getAdress().getStreet();
        stringArray[7] = agencyEstate.getAdress().getStreetNr();
        for (int i = 15; i < this.fieldCount; ++i) {
            String string;
            ValueImpl valueImpl;
            int n = i - 15;
            if (this.dynamicFields.isEmpty() || n < 0 || this.dynamicFields.size() <= n) continue;
            String string2 = this.dynamicFields.get(n);
            ValueImpl valueImpl2 = valueImpl = agencyEstate.hasAttribute(string2) ? agencyEstate.getAttribute(string2) : null;
            if (valueImpl == null || StringUtils.isEmpty((String)(string = valueImpl.writeValue(this.locale, agencyEstate.getCurrency())))) continue;
            stringArray[i] = string.replaceAll("\\r\\n|\\r|\\n", "<br>");
        }
    }
}

