/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.impl.OpenEstateException;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.utils.OpenEstateLocaleComboBox;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import javax.swing.ActionMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import org.apache.commons.lang.SystemUtils;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTitledSeparator;

public class AgencyEstateExportDialog
extends JDialog {
    public static final int OPENED = 0;
    public static final int CANCELLED = 1;
    public static final int APPROVED = 2;
    private int status = 0;
    private ActionMap actionMap = null;
    private ResourceMap resourceMap = null;
    private String selectedEstateAction = null;
    private OpenEstateType selectedEstateType = null;
    private JComboBox actionBox;
    private JLabel actionLabel;
    private JButton cancelButton;
    private JComboBox charsetBox;
    private JLabel charsetLabel;
    private JComboBox formatBox;
    private JLabel formatLabel;
    private JButton helpButton;
    private JComboBox languageBox;
    private JLabel languageLabel;
    private JComboBox statusBox;
    private JLabel statusLabel;
    private JButton submitButton;
    private JXTitledSeparator titleLabel;
    private JComboBox typeBox;
    private JLabel typeLabel;

    public AgencyEstateExportDialog() throws OpenEstateException {
        this((Frame)ImmoToolApp.getApplication().getMainFrame(), true);
    }

    public AgencyEstateExportDialog(Frame frame, boolean bl) throws OpenEstateException {
        super(frame, bl);
        this.build();
    }

    private void build() throws OpenEstateException {
        this.actionMap = ImmoToolUtils.getActionMap(AgencyEstateExportDialog.class, (Object)this);
        this.resourceMap = ImmoToolUtils.getResourceMap(AgencyEstateExportDialog.class);
        this.setContentPane((Container)new JXPanel());
        this.initComponents();
        this.resourceMap.injectComponents((Component)this);
        this.charsetBox.setModel(new DefaultComboBoxModel());
        this.charsetBox.setSelectedIndex(-1);
        for (Charset object2 : Charset.availableCharsets().values()) {
            ((DefaultComboBoxModel)this.charsetBox.getModel()).addElement(object2);
            if (!Charset.defaultCharset().equals(object2)) continue;
            this.charsetBox.setSelectedIndex(this.charsetBox.getModel().getSize() - 1);
        }
        this.formatBox.setModel(new DefaultComboBoxModel());
        this.formatBox.addItem(this.resourceMap.getString("label.format.csv", new Object[0]));
        this.formatBox.addItem(this.resourceMap.getString("label.format.xls", new Object[0]));
        this.formatBox.setSelectedIndex(0);
        ((OpenEstateLocaleComboBox)this.languageBox).setSelectedLocale(Locale.getDefault());
        this.updateActionBox(null, null);
        this.statusBox.setModel(new DefaultComboBoxModel());
        this.statusBox.addItem("[ " + this.resourceMap.getString("label.status.all", new Object[0]) + " ]");
        this.statusBox.addItem(new EstateStatusItem("ENTWURF"));
        this.statusBox.addItem(new EstateStatusItem("PRUEFUNG"));
        this.statusBox.addItem(new EstateStatusItem("VERMITTLUNG"));
        this.statusBox.addItem(new EstateStatusItem("VERMITTELT"));
        this.statusBox.addItem(new EstateStatusItem("NICHT_VERMITTELT"));
        this.statusBox.addItem(new EstateStatusItem("ABLAGE"));
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        this.typeBox.setModel(defaultComboBoxModel);
        defaultComboBoxModel.addElement("[ " + this.resourceMap.getString("label.type.all", new Object[0]) + " ]");
        TreeMap treeMap = new TreeMap();
        for (Object object : OpenEstateUtils.getEstateTypesOnRoot()) {
            String string = OpenEstateUtils.translateEstate((String)object.getName());
            treeMap.put(string, new ArrayList());
            ((List)treeMap.get(string)).add(new EstateTypeItem((OpenEstateType)object));
            TreeMap<String, EstateTypeItem> treeMap2 = new TreeMap<String, EstateTypeItem>();
            for (String string2 : object.getChildren()) {
                OpenEstateType openEstateType = OpenEstateType.newInstance((String)string2);
                treeMap2.put(OpenEstateUtils.translateEstate((String)openEstateType.getName()), new EstateTypeItem(openEstateType, " > "));
            }
            if (treeMap2.isEmpty()) continue;
            ((List)treeMap.get(string)).addAll(treeMap2.values());
        }
        for (List list : treeMap.values()) {
            for (Object object : list) {
                defaultComboBoxModel.addElement(object);
            }
        }
        this.cancelButton.setAction(this.actionMap.get(this.cancelButton.getText()));
        this.submitButton.setAction(this.actionMap.get(this.submitButton.getText()));
        this.helpButton.setAction(this.actionMap.get(this.helpButton.getText()));
        this.helpButton.setEnabled(false);
        this.typeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AgencyEstateExportDialog.this.updateActionBox(AgencyEstateExportDialog.this.getSelectedEstateType(), AgencyEstateExportDialog.this.getSelectedEstateAction());
            }
        });
        if (SystemUtils.IS_OS_MAC_OSX) {
            this.cancelButton.setOpaque(false);
            this.submitButton.setOpaque(false);
            this.helpButton.setOpaque(false);
        }
        ImmoToolUtils.configureDialog((JDialog)this, (JXPanel)((JXPanel)this.getContentPane()));
    }

    @Action
    public void doCancel() {
        this.status = 1;
        this.setVisible(false);
    }

    @Action
    public void doHelp() {
    }

    @Action
    public void doSubmit() {
        this.status = 2;
        this.setVisible(false);
    }

    public Charset getSelectedCharset() {
        return (Charset)this.charsetBox.getSelectedItem();
    }

    public String getSelectedEstateAction() {
        return this.actionBox.getSelectedIndex() > 0 ? ((EstateActionItem)this.actionBox.getSelectedItem()).getAction() : null;
    }

    public String getSelectedEstateStatus() {
        return this.statusBox.getSelectedIndex() > 0 ? ((EstateStatusItem)this.statusBox.getSelectedItem()).getStatus() : null;
    }

    public OpenEstateType getSelectedEstateType() {
        return this.typeBox.getSelectedIndex() > 0 ? ((EstateTypeItem)this.typeBox.getSelectedItem()).getType() : null;
    }

    public Locale getSelectedLanguage() {
        return (Locale)this.languageBox.getSelectedItem();
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isCsvExportSelected() {
        return this.formatBox.getSelectedIndex() == 0;
    }

    public boolean isXlsExportSelected() {
        return this.formatBox.getSelectedIndex() == 1;
    }

    private void updateActionBox(OpenEstateType openEstateType, String string) {
        this.selectedEstateType = openEstateType;
        this.selectedEstateAction = string;
        this.actionBox.setEnabled(false);
        this.actionBox.removeAllItems();
        this.actionBox.addItem("[ " + this.resourceMap.getString("label.action.all", new Object[0]) + " ]");
        this.actionBox.setSelectedIndex(0);
        String[] stringArray = null;
        stringArray = this.selectedEstateType != null ? this.selectedEstateType.getActions() : new String[]{"ERBPACHT", "KAUF", "MIETE", "PACHT"};
        for (String string2 : stringArray) {
            EstateActionItem estateActionItem = new EstateActionItem(string2);
            this.actionBox.addItem(estateActionItem);
            if (!string2.equals(this.selectedEstateAction)) continue;
            this.actionBox.setSelectedItem(estateActionItem);
        }
        this.actionBox.setEnabled(true);
    }

    private void initComponents() {
        this.titleLabel = ImmoToolUtils.createHead1Separator((String)"");
        this.charsetLabel = new JLabel();
        this.charsetBox = new JComboBox();
        this.formatLabel = new JLabel();
        this.formatBox = new JComboBox();
        this.typeLabel = new JLabel();
        this.typeBox = new JComboBox();
        this.actionLabel = new JLabel();
        this.actionBox = new JComboBox();
        this.statusLabel = new JLabel();
        this.statusBox = new JComboBox();
        this.languageLabel = new JLabel();
        this.languageBox = new OpenEstateLocaleComboBox(false, AgencyPlugin.getLocales());
        this.helpButton = new JButton();
        this.submitButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setName("Form");
        this.titleLabel.setName("titleLabel");
        this.titleLabel.setTitle("titleLabel");
        this.charsetLabel.setHorizontalAlignment(4);
        this.charsetLabel.setText("charsetLabel");
        this.charsetLabel.setName("charsetLabel");
        this.charsetBox.setName("charsetBox");
        this.formatLabel.setHorizontalAlignment(4);
        this.formatLabel.setText("formatLabel");
        this.formatLabel.setName("formatLabel");
        this.formatBox.setName("formatBox");
        this.typeLabel.setHorizontalAlignment(4);
        this.typeLabel.setText("typeLabel");
        this.typeLabel.setName("typeLabel");
        this.typeBox.setName("typeBox");
        this.actionLabel.setHorizontalAlignment(4);
        this.actionLabel.setText("actionLabel");
        this.actionLabel.setName("actionLabel");
        this.actionBox.setName("actionBox");
        this.statusLabel.setText("statusLabel");
        this.statusLabel.setName("statusLabel");
        this.statusBox.setName("statusBox");
        this.languageLabel.setHorizontalAlignment(4);
        this.languageLabel.setText("languageLabel");
        this.languageLabel.setName("languageLabel");
        this.languageBox.setName("languageBox");
        this.helpButton.setText("doHelp");
        this.helpButton.setName("helpButton");
        this.submitButton.setText("doSubmit");
        this.submitButton.setName("submitButton");
        this.cancelButton.setText("doCancel");
        this.cancelButton.setName("cancelButton");
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.titleLabel, -1, 448, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.helpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 158, Short.MAX_VALUE).addComponent(this.submitButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.languageLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addGap(13, 13, 13).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.formatLabel).addComponent(this.typeLabel).addComponent(this.actionLabel).addComponent(this.charsetLabel).addComponent(this.statusLabel)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.languageBox, 0, 330, Short.MAX_VALUE).addComponent(this.formatBox, 0, 330, Short.MAX_VALUE).addComponent(this.actionBox, 0, 330, Short.MAX_VALUE).addComponent(this.typeBox, 0, 330, Short.MAX_VALUE).addComponent(this.charsetBox, GroupLayout.Alignment.TRAILING, 0, 330, Short.MAX_VALUE).addComponent(this.statusBox, 0, 330, Short.MAX_VALUE)))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.titleLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.charsetLabel).addComponent(this.charsetBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.formatLabel).addComponent(this.formatBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.typeBox, -2, -1, -2).addComponent(this.typeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.actionLabel).addComponent(this.actionBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.statusLabel).addComponent(this.statusBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.languageLabel).addComponent(this.languageBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 69, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.helpButton).addComponent(this.cancelButton).addComponent(this.submitButton)).addContainerGap()));
        this.pack();
    }

    private static final class EstateTypeItem {
        private OpenEstateType estateType;
        private String estatePrefix = null;

        public EstateTypeItem(OpenEstateType openEstateType) {
            this(openEstateType, " ");
        }

        public EstateTypeItem(OpenEstateType openEstateType, String string) {
            this.estateType = openEstateType;
            this.estatePrefix = string;
        }

        public String getName() {
            return this.estateType.getName();
        }

        public OpenEstateType getType() {
            return this.estateType;
        }

        public String toString() {
            String string = OpenEstateUtils.translateEstate((String)this.estateType.getName());
            return string != null ? this.estatePrefix + string : this.estatePrefix + this.estateType.getName();
        }
    }

    private static final class EstateStatusItem {
        private String estateStatus;

        public EstateStatusItem(String string) {
            this.estateStatus = string;
        }

        public String getStatus() {
            return this.estateStatus;
        }

        public String toString() {
            String string = AgencyEstate.writeStatus(this.estateStatus);
            return string != null ? string : this.estateStatus;
        }
    }

    private static final class EstateActionItem {
        private String estateAction;

        public EstateActionItem(String string) {
            this.estateAction = string;
        }

        public String getAction() {
            return this.estateAction;
        }

        public String toString() {
            String string = OpenEstateUtils.translateAction((String)this.estateAction);
            return string != null ? string : this.estateAction;
        }
    }
}

